/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.ovopark.api.DepartmentApi;
import com.ovopark.api.UserApi;
import com.ovopark.builder.InspectionTaskBuilder;
import com.ovopark.constants.CommonConstants;
import com.ovopark.constants.LogConstant;
import com.ovopark.constants.MessageConstant;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.ResultCodeInfo;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.InspectionAuditReasonMapper;
import com.ovopark.mapper.InspectionDeptTagMapper;
import com.ovopark.mapper.InspectionOperatorLogMapper;
import com.ovopark.mapper.InspectionTagMapper;
import com.ovopark.mapper.InspectionTaskExpandMapper;
import com.ovopark.mapper.InspectionTaskMapper;
import com.ovopark.mapper.IsInspectionDeptTemplateMapper;
import com.ovopark.model.base.EntityBase;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.dto.InspectionPlanDto;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.DeleteEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.ExpireStatusEnum;
import com.ovopark.model.enums.GroupBy;
import com.ovopark.model.enums.InspectionPlanExpressionEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.enums.MessageObjectEnum;
import com.ovopark.model.enums.OpenEnum;
import com.ovopark.model.enums.ReleateTypeEnum;
import com.ovopark.model.enums.StorePlanOrderDescEnum;
import com.ovopark.model.enums.StorePlanOrderWebColumnEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.CheckTemplateVoReq;
import com.ovopark.model.req.GetFinishPerByOrganizeIdsReq;
import com.ovopark.model.req.GetPlanByRelatedIdReq;
import com.ovopark.model.req.InspectionConfigReq;
import com.ovopark.model.req.InspectionPlanAppExpandReq;
import com.ovopark.model.req.InspectionPlanExpandAddReq;
import com.ovopark.model.req.InspectionPlanTagAddReq;
import com.ovopark.model.req.InspectionPlanTaskAddReq;
import com.ovopark.model.req.InspectionPlanTaskAppListReq;
import com.ovopark.model.req.InspectionPlanTaskAppLogListReq;
import com.ovopark.model.req.InspectionPlanTaskAuditReq;
import com.ovopark.model.req.InspectionPlanTaskCallBackReq;
import com.ovopark.model.req.InspectionPlanTaskDeleteReq;
import com.ovopark.model.req.InspectionPlanTaskDetailReq;
import com.ovopark.model.req.InspectionPlanTaskExpireReq;
import com.ovopark.model.req.InspectionPlanTaskPartionWebListReq;
import com.ovopark.model.req.InspectionPlanTaskSecondOpenReq;
import com.ovopark.model.req.InspectionPlanTaskSecondReq;
import com.ovopark.model.req.InspectionPlanTaskUpdateReq;
import com.ovopark.model.req.InspectionPlanTaskUrgedReq;
import com.ovopark.model.req.InspectionPlanTaskWebListReq;
import com.ovopark.model.req.InspectionPlanWebExpandReq;
import com.ovopark.model.req.InspectionTashFinishPerTop;
import com.ovopark.model.req.InspectionTaskCountReq;
import com.ovopark.model.req.InspectionTaskWillOutTimeReq;
import com.ovopark.model.req.PageReq;
import com.ovopark.model.req.StorePlanDescReq;
import com.ovopark.model.resp.CheckGetPlanResp;
import com.ovopark.model.resp.GetFinishPerByOrganizeIdsResp;
import com.ovopark.model.resp.GetInspectionPlanByRelatedIdResp;
import com.ovopark.model.resp.InspectionPlanDtoResp;
import com.ovopark.model.resp.InspectionPlanExpandDetailResp;
import com.ovopark.model.resp.InspectionPlanPersonlyResp;
import com.ovopark.model.resp.InspectionPlanTagDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskAppListResp;
import com.ovopark.model.resp.InspectionPlanTaskAppLogListResp;
import com.ovopark.model.resp.InspectionPlanTaskAuditReasonResp;
import com.ovopark.model.resp.InspectionPlanTaskDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListCountResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListInnerResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebListResp;
import com.ovopark.model.resp.InspectionPlanTemplateDetailResp;
import com.ovopark.model.resp.InspectionTaskByGroupResp;
import com.ovopark.model.resp.InspectionTaskCountResp;
import com.ovopark.model.resp.InspectionTaskPerByGroupId;
import com.ovopark.model.resp.InspectionTaskWillOutTimeResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.model.utilsModel.DepartmentsExpect;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.SimpleUserMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import com.ovopark.po.DeleteMessagesByObject;
import com.ovopark.po.DeleteMessagesByObjectBuilder;
import com.ovopark.po.InspectionAuditReason;
import com.ovopark.po.InspectionDeptTag;
import com.ovopark.po.InspectionOperatorLog;
import com.ovopark.po.InspectionTag;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskCcModel;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.po.IsCheckTemplate;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.pojo.DepartmentPojo;
import com.ovopark.proxy.DepartProxy;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.proxy.OrganizeProxy;
import com.ovopark.proxy.XxlJobProxy;
import com.ovopark.service.CheckTaskRelateService;
import com.ovopark.service.EnterpriseConfigService;
import com.ovopark.service.InspectionConfigService;
import com.ovopark.service.InspectionDeptTagService;
import com.ovopark.service.InspectionPlanProxyService;
import com.ovopark.service.InspectionTagService;
import com.ovopark.service.InspectionTaskCcService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsCheckTemplateService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.BigDecimalUtils;
import com.ovopark.utils.ClazzConverterUtils;
import com.ovopark.utils.DaoUtils;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.ListUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionTaskServiceImpl<planPersonly>
extends ServiceImpl<InspectionTaskMapper, InspectionTask>
implements InspectionTaskService {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskServiceImpl.class);
    @Autowired
    private CheckTaskRelateService checkTaskRelateService;
    @Autowired
    private InspectionPlanProxyService inspectionPlanProxyService;
    @Autowired
    private InspectionTaskMapper inspectionTaskMapper;
    @Autowired
    InspectionTaskExpandMapper inspectionTaskExpandMapper;
    @Autowired
    InspectionDeptTagMapper inspectionDeptTagMapper;
    @Autowired
    IsInspectionDeptTemplateMapper isInspectionDeptTemplateMapper;
    @Autowired
    IsCheckTemplateService isCheckTemplateService;
    @Autowired
    InspectionTagMapper inspectionTagMapper;
    @Autowired
    InspectionTagService inspectionTagService;
    @Autowired
    private IsInspectionDeptTemplateService isInspectionDeptTemplateService;
    @Autowired
    InspectionAuditReasonMapper inspectionAuditReasonMapper;
    @Autowired
    InspectionOperatorLogMapper inspectionOperatorLogMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private IsInspectionDeptTemplateService inspectionDeptTemplateService;
    @Autowired
    private UserDepartmentApi userDepartmentApi;
    @Autowired
    private InspectionDeptTagService inspectionDeptTagService;
    @Autowired
    private InspectionTaskExpandService inspectionTaskExpandService;
    @Autowired
    private InspectionConfigService inspectionConfigService;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private InspectionTaskCcService inspectionTaskCcService;
    @Autowired
    XxlJobProxy xxlJobProxy;
    @Autowired
    DepartProxy departProxy;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    OrganizeProxy organizeProxy;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseConfigService enterpriseConfigService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> add(InspectionPlanTaskAddReq req, Users user) {
        Date date = new Date();
        Integer uuid = 1;
        InspectionTaskBuilder builder = new InspectionTaskBuilder();
        Integer groupId = user.getGroupId();
        List inspectionExpandList = req.getInspectionExpandList();
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        int size = 0;
        for (InspectionPlanExpandAddReq expandAddReq : inspectionExpandList) {
            size += expandAddReq.getDeptModels().size();
        }
        InspectionTask task = builder.groupId(groupId).name(req.getName()).operatorId(user.getId()).operatorName(user.getShowName()).auditId(req.getAuditId()).auditName(req.getAuditName()).status(InspectionTaskStatusEnum.AUDIT.getCode()).completeExpandCount(0).totalExpandCount(size).startTime(req.getStartTime()).endTime(req.getEndTime()).remark(req.getRemark()).build();
        EntityBase.setCreateParams((Object)task, (Users)user);
        if (result.getData() != null) {
            task.setDepChose(((EnterpriseConfigPojo)result.getData()).getDepChose());
        }
        this.inspectionTaskMapper.insert((Object)task);
        if (CollectionUtils.isNotEmpty((Collection)req.getCcUserIds())) {
            this.saveTaskCopy(req.getCcUserIds(), user, date, task);
        }
        ArrayList<InspectionTaskExpand> expandList = new ArrayList<InspectionTaskExpand>();
        ArrayList<InspectionDeptTag> targetTagList = new ArrayList<InspectionDeptTag>();
        ArrayList<IsInspectionDeptTemplate> templateVos = new ArrayList<IsInspectionDeptTemplate>();
        for (InspectionPlanExpandAddReq expandReq : inspectionExpandList) {
            this.assembleInspectionTaskExpand(expandReq, task, user, expandList, targetTagList, templateVos, uuid, req.getStartTime(), req.getEndTime());
            uuid = uuid + 1;
        }
        Date endTime = task.getEndTime();
        String cron = DateUtil.dateToCron((Date)endTime);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", task.getId());
        Integer jobId = this.xxlJobProxy.sendCronToJob("inspectionTaskJobHandler", JSON.toJSONString(param), cron, user.getId(), String.format("\u9648\u5217\u4e2d\u5fc3\u4efb\u52a1,%s \u81ea\u52a8\u901a\u8fc7 ", task.getName()));
        this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.ADD_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), endTime);
        this.inspectionTaskMapper.updateJobIdById(jobId, task.getId());
        this.insertLog(user, task.getId(), LogConstant.CREATE, user.getShowName());
        return JsonNewResult.success();
    }

    private void saveTaskCopy(List<Integer> req, Users user, Date date, InspectionTask task) {
        ArrayList<InspectionTaskCcModel> models = new ArrayList<InspectionTaskCcModel>();
        for (Integer ccId : req) {
            InspectionTaskCcModel model = new InspectionTaskCcModel();
            model.setCcId(ccId).setCreateId(user.getId()).setGroupId(user.getGroupId()).setCreateTime(date).setTaskId(task.getId());
            models.add(model);
        }
        this.inspectionTaskCcService.saveBatch(models);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> udpate(InspectionPlanTaskUpdateReq req, Users user) {
        List collect;
        InspectionTask orgTask = this.inspectionTaskMapper.selectbyPrimaryId(req.getId());
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        if (orgTask.getUpdateTimes() > CommonConstants.UPDATE_TIMES) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_UPDATE_TIMES_OVER, new Object[0]);
        }
        EnterpriseConfigPojo pojo = this.enterpriseConfigService.selectOne(user.getGroupId());
        if (pojo.getAllowEditingApproval().equals(DefaultEnum.DEFAULT_FALSE.getCode())) {
            ResultCodeInfo resultCodeInfo = new ResultCodeInfo();
            resultCodeInfo.setCode(ResultCode.CAN_NOT_UPDATE.getCode());
            if (ExpireStatusEnum.DEFAULT_TRUE.getCode().equals(orgTask.getExpireStatus())) {
                resultCodeInfo.setDesc(String.format(ResultCode.CAN_NOT_UPDATE.getDesc(), ExpireStatusEnum.format((Integer)orgTask.getExpireStatus()).getDesc()));
                throw new SysErrorException(resultCodeInfo, new Object[0]);
            }
            if (InspectionTaskStatusEnum.canotUpdate().contains(orgTask.getStatus())) {
                resultCodeInfo.setDesc(String.format(ResultCode.CAN_NOT_UPDATE.getDesc(), InspectionTaskStatusEnum.format((Integer)orgTask.getStatus()).getDesc()));
                throw new SysErrorException(resultCodeInfo, new Object[0]);
            }
        }
        List orgExpandList = this.inspectionTaskExpandMapper.selectExpandListByTaskId(orgTask.getId(), user.getGroupId());
        Set expandIds = orgExpandList.stream().map(InspectionTaskExpand::getId).collect(Collectors.toSet());
        Map<Integer, Integer> expandIdDeptMap = orgExpandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getId, InspectionTaskExpand::getDeptId, (e1, e2) -> e2));
        ArrayList<Integer> retainDeptList = new ArrayList<Integer>();
        for (Integer expandId : req.getRetainList()) {
            Integer retainDeptId = expandIdDeptMap.get(expandId);
            if (retainDeptId == null) continue;
            retainDeptList.add(retainDeptId);
        }
        Set<Object> finishExpandIds = new HashSet();
        List inspectionExpandList = req.getInspectionExpandList();
        if (CollectionUtils.isNotEmpty((Collection)inspectionExpandList)) {
            for (InspectionPlanExpandAddReq inspectionPlanExpandAddReq : inspectionExpandList) {
                List expands = inspectionPlanExpandAddReq.getDeptModels().stream().filter(i -> i.getId() != null).collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(expands)) continue;
                finishExpandIds = expands.stream().map(InspectionPlanExpandDetailResp::getId).collect(Collectors.toSet());
            }
        }
        List deleteExpandIds = (List)CollectionUtils.subtract(expandIds, finishExpandIds);
        ArrayList<InspectionTaskExpand> expandList = new ArrayList<InspectionTaskExpand>();
        ArrayList<InspectionDeptTag> targetTagList = new ArrayList<InspectionDeptTag>();
        ArrayList<IsInspectionDeptTemplate> templateModels = new ArrayList<IsInspectionDeptTemplate>();
        LambdaQueryWrapper deptTemplateLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getTaskId, (Object)orgTask.getId())).eq(IsInspectionDeptTemplate::getIsRead, (Object)0);
        LambdaQueryWrapper deptTagLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionDeptTag::getTaskId, (Object)orgTask.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deleteExpandIds)) {
            LambdaQueryWrapper expandLambdaQueryWrapper = new LambdaQueryWrapper();
            Set<Object> collect2 = new HashSet();
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)orgTask.getId())).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
                collect2 = list.stream().map(IsInspectionDeptTemplate::getExpandId).collect(Collectors.toSet());
                expandLambdaQueryWrapper.notIn(InspectionTaskExpand::getId, collect2);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(retainDeptList)) {
                if (!org.springframework.util.CollectionUtils.isEmpty(collect2)) {
                    HashSet finalCollect = collect2;
                    ((LambdaQueryWrapper)expandLambdaQueryWrapper.and(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(InspectionTaskExpand::getDeptId, (Collection)retainDeptList)).ne(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).notIn(InspectionTaskExpand::getId, (Collection)finalCollect))).or(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.notIn(InspectionTaskExpand::getDeptId, (Collection)retainDeptList)).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).notIn(InspectionTaskExpand::getId, (Collection)finalCollect));
                } else {
                    ((LambdaQueryWrapper)expandLambdaQueryWrapper.and(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(InspectionTaskExpand::getDeptId, (Collection)retainDeptList)).ne(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId()))).or(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)i.notIn(InspectionTaskExpand::getDeptId, (Collection)retainDeptList)).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId()));
                }
            } else if (!org.springframework.util.CollectionUtils.isEmpty(collect2)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)expandLambdaQueryWrapper.eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).in(InspectionTaskExpand::getId, (Collection)deleteExpandIds)).notIn(InspectionTaskExpand::getId, collect2);
            } else {
                ((LambdaQueryWrapper)expandLambdaQueryWrapper.eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).in(InspectionTaskExpand::getId, (Collection)deleteExpandIds);
            }
            this.inspectionTaskExpandService.remove((Wrapper)expandLambdaQueryWrapper);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getRetainList())) {
            deptTemplateLambdaQueryWrapper.notIn(IsInspectionDeptTemplate::getExpandId, (Collection)req.getRetainList());
            deptTagLambdaQueryWrapper.notIn(InspectionDeptTag::getExpandId, (Collection)req.getRetainList());
        }
        this.inspectionDeptTemplateService.remove((Wrapper)deptTemplateLambdaQueryWrapper);
        this.inspectionDeptTagService.remove((Wrapper)deptTagLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)req.getCcUserIds())) {
            this.inspectionTaskCcService.remove((Wrapper)new LambdaQueryWrapper().eq(InspectionTaskCcModel::getTaskId, (Object)req.getId()));
            this.saveTaskCopy(req.getCcUserIds(), user, new Date(), orgTask);
        }
        Integer uuid = 0;
        List collect1 = req.getInspectionExpandList().stream().filter(i -> i.getExpandGroup() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect1)) {
            uuid = ((InspectionPlanExpandAddReq)collect1.stream().max((s1, s2) -> s1.getExpandGroup().compareTo(s2.getExpandGroup())).get()).getExpandGroup();
            uuid = uuid + 1;
        }
        for (InspectionPlanExpandAddReq expandReq : inspectionExpandList) {
            uuid = expandReq.getExpandGroup() != null ? expandReq.getExpandGroup() : uuid;
            this.assembleInspectionTaskExpand(expandReq, orgTask, user, expandList, targetTagList, templateModels, uuid, req.getStartTime(), req.getEndTime());
            uuid = uuid + 1;
        }
        Integer totalExpandCount = expandList.size() + retainDeptList.size();
        List<ExpandCountDto> expandCountDtoList = this.inspectionDeptTemplateService.haveNoFinish(orgTask.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty(expandCountDtoList) && !org.springframework.util.CollectionUtils.isEmpty(collect = expandCountDtoList.stream().filter(expandCountDto -> expandCountDto.getFinishNum().equals(expandCountDto.getTotalNum())).collect(Collectors.toList()))) {
            Set integers = collect.stream().map(ExpandCountDto::getExpandId).collect(Collectors.toSet());
            this.inspectionTaskExpandService.update(new InspectionTaskExpand().setStatus(InspectionTaskExpandStatusEnum.PASS.getCode()), (Wrapper)new LambdaQueryWrapper().in(InspectionTaskExpand::getId, integers));
        }
        if (!orgTask.getEndTime().equals(req.getEndTime())) {
            this.xxlJobProxy.stopJob(orgTask.getJobId());
            String cron = DateUtil.dateToCron((Date)req.getEndTime());
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("id", orgTask.getId());
            Integer jobId = this.xxlJobProxy.sendCronToJob("inspectionTaskJobHandler", JSON.toJSONString(param), cron, user.getId(), String.format("\u9648\u5217\u4e2d\u5fc3\u4efb\u52a1,%s \u81ea\u52a8\u901a\u8fc7 ", orgTask.getName()));
            orgTask.setJobId(jobId);
        }
        Integer completeExpandCount = this.inspectionTaskExpandService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getStatus, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).eq(InspectionTaskExpand::getExecuteExpire, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)totalExpandCount, (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        orgTask.setUpdateTimes(Integer.valueOf(orgTask.getUpdateTimes() + 1)).setName(req.getName()).setAuditId(req.getAuditId()).setAuditName(req.getAuditName()).setTotalExpandCount(totalExpandCount).setCompletePercent(percent).setCompleteExpandCount(completeExpandCount).setStartTime(req.getStartTime()).setEndTime(req.getEndTime()).setRemark(req.getRemark()).setStatus(InspectionTaskStatusEnum.AUDIT.getCode());
        EntityBase.setUpdateParams((Object)orgTask, (Users)user);
        int isOk = this.inspectionTaskMapper.updateByPrimaryId(orgTask);
        DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getOperatorId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
        this.messageProxy.deleteMessagesByObject(build);
        DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
        this.messageProxy.deleteMessagesByObject(audit);
        this.messageProxy.sendWebSocketAndJpush(orgTask.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.UPDATE_MESSAGE, user.getShowName(), orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), req.getEndTime());
        this.insertLog(user, orgTask.getId(), LogConstant.UPDATE, user.getShowName());
        return JsonNewResult.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> audit(InspectionPlanTaskAuditReq req, Users user) {
        InspectionTask inspectionTask;
        DeleteMessagesByObject build;
        InspectionAuditReason inspectionAuditReason;
        InspectionTask orgTask = this.inspectionTaskMapper.selectbyPrimaryId(req.getId());
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        if (!InspectionTaskStatusEnum.AUDIT.getCode().equals(orgTask.getStatus())) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_WAIT_STATUS, new Object[0]);
        }
        Date audtiTime = new Date();
        Integer status = req.getStatus();
        if (orgTask.getCompleteExpandCount() != orgTask.getTotalExpandCount()) {
            this.inspectionTaskMapper.updateStatusById(status, req.getId(), audtiTime);
            inspectionAuditReason = new InspectionAuditReason(user.getGroupId(), orgTask.getId(), status, req.getReason());
            EntityBase.setCreateParams((Object)inspectionAuditReason, (Users)user);
            this.inspectionAuditReasonMapper.insert(inspectionAuditReason);
        } else {
            this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.FINISH.getCode(), req.getId(), audtiTime);
            inspectionAuditReason = new InspectionAuditReason(user.getGroupId(), orgTask.getId(), InspectionTaskStatusEnum.FINISH.getCode(), req.getReason());
            EntityBase.setCreateParams((Object)inspectionAuditReason, (Users)user);
            this.inspectionAuditReasonMapper.insert(inspectionAuditReason);
        }
        if (InspectionTaskStatusEnum.PASS.getCode().equals(status)) {
            this.insertLog(user, orgTask.getId(), LogConstant.PASS, user.getShowName());
            build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
            this.messageProxy.deleteMessagesByObject(build);
            int count = this.inspectionTaskExpandService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getOperatorId, (Object)orgTask.getOperatorId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.WAIT)).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
            this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.PASS_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.DETAIL.getCode(), count > 0 ? IsExecutorEnum.EXECUTOR.getCode() : null, count > 0 ? IsTodoMessageEnum.IS_TODO_MESSAGE.getCode() : null, count > 0 ? orgTask.getEndTime() : null);
        } else if (InspectionTaskStatusEnum.REFUSE.getCode().equals(status)) {
            this.insertLog(user, orgTask.getId(), LogConstant.REFUSE, user.getShowName());
            build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
            this.messageProxy.deleteMessagesByObject(build);
            this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.REFUSE_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.DETAIL.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), orgTask.getEndTime());
        }
        if (orgTask.getCompleteExpandCount() == orgTask.getTotalExpandCount()) {
            this.insertLog(user, orgTask.getId(), LogConstant.COMPELATE, orgTask.getName());
        }
        Integer expireCompleteExpandCount = 0;
        log.info("\u4efb\u52a1\u8fc7\u671f\u6267\u884c\uff0c\u67e5\u8be2\u5b8c\u6210\u60c5\u51b5");
        expireCompleteExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).count();
        log.info("\u4efb\u52a1\u5b8c\u6210\uff1a" + expireCompleteExpandCount);
        if (expireCompleteExpandCount.equals(orgTask.getTotalExpandCount())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)orgTask.getId())).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode())).update();
        }
        if ((inspectionTask = this.inspectionTaskMapper.selectbyPrimaryId(orgTask.getId())).getStatus().equals(InspectionTaskStatusEnum.FINISH.getCode())) {
            this.xxlJobProxy.stopJob(orgTask.getJobId());
        }
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> expire(InspectionPlanTaskExpireReq req, Users user) {
        List expireExecutes;
        BaseResult result;
        Integer id = req.getId();
        InspectionTask inspectionTask = this.inspectionTaskMapper.selectbyPrimaryId(id);
        if (inspectionTask != null && inspectionTask.getStatus() != 5) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)req.getId())).set(InspectionTask::getExpireStatus, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).update();
        }
        if ((result = this.enterpriseGroupsApi.getEnterpriseConfig(inspectionTask.getGroupId())).getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute()) && (expireExecutes = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())).contains(MainTypeEnum.INSPECTION.getCode())) {
            return JsonNewResult.success();
        }
        DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(req.getId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
        this.messageProxy.deleteMessagesByObject(build);
        return JsonNewResult.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> callBack(InspectionPlanTaskCallBackReq req, Users users) {
        Date now = new Date();
        log.info("\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)req.toString());
        Integer taskId = req.getTaskId();
        InspectionTask orgTask = (InspectionTask)this.getById(taskId);
        if (Objects.isNull(orgTask)) {
            return JsonNewResult.success();
        }
        InspectionTaskExpand one = (InspectionTaskExpand)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getId, (Object)req.getExpandId())).one();
        Integer expandId = req.getExpandId();
        int i = this.isInspectionDeptTemplateMapper.planeFinish(req.getTemplateId(), taskId, one.getDeptId(), one.getGroupId(), req.getExpandId());
        Integer executeExpire = ExpandExecuteExpireEnum.NOT.getCode();
        if (orgTask.getEndTime().before(now)) {
            executeExpire = ExpandExecuteExpireEnum.YES.getCode();
        }
        if (i > 0) {
            boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.inspectionTaskExpandService.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)expandId)).eq(InspectionTaskExpand::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).update();
            List templates = this.isInspectionDeptTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getIsRead, (Object)0)).eq(IsInspectionDeptTemplate::getExpandId, (Object)req.getExpandId())).eq(IsInspectionDeptTemplate::getDeptId, (Object)one.getDeptId())).eq(IsInspectionDeptTemplate::getGroupId, (Object)orgTask.getGroupId())).eq(IsInspectionDeptTemplate::getTaskId, (Object)req.getTaskId()));
            log.info("\u672a\u8bfb\u6a21\u7248\u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)templates.size());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)templates)) {
                return JsonNewResult.success();
            }
        }
        log.info("\u6ca1\u6709\u672a\u8bfb\u6a21\u7248\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        Integer expireCompleteExpandCount = 0;
        boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.inspectionTaskExpandService.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)expandId)).isNull(InspectionTaskExpand::getFinishTime)).eq(InspectionTaskExpand::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).set(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).set(InspectionTaskExpand::getFinishTime, (Object)now)).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).update();
        Integer completeExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)taskId)).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getExecuteExpire, (Object)ExpandExecuteExpireEnum.NOT.getCode())).count();
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)orgTask.getTotalExpandCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        this.inspectionTaskMapper.updateCompleteExpandCount(taskId, completeExpandCount > orgTask.getTotalExpandCount() ? orgTask.getTotalExpandCount() : completeExpandCount, percent);
        Users user = this.usersRemoteService.getById(orgTask.getOperatorId());
        DepartmentPojo department = this.departProxy.getDepartment(one.getDeptId());
        this.insertLog(user, taskId, LogConstant.CALLBACK, user.getShowName(), department.getName());
        if (completeExpandCount.equals(orgTask.getTotalExpandCount())) {
            int isFinish = this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.FINISH.getCode(), taskId, null);
            this.insertLog(user, taskId, LogConstant.COMPELATE, orgTask.getName());
            DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(taskId).objectType(MessageObjectEnum.DEFAULT.getDesc()).build();
            this.messageProxy.deleteMessagesByObject(build);
            this.messageProxy.sendWebSocketAndJpush(orgTask.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.COMPELETE_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.APP.getCode(), null, null, null);
        } else if (completeExpandCount < orgTask.getTotalExpandCount()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)taskId)).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.INSPECT.getCode())).update();
        }
        if (executeExpire.equals(ExpandExecuteExpireEnum.YES.getCode())) {
            log.info("\u4efb\u52a1\u8fc7\u671f\u6267\u884c\uff0c\u67e5\u8be2\u5b8c\u6210\u60c5\u51b5");
            expireCompleteExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)taskId)).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).count();
            log.info("\u4efb\u52a1\u5b8c\u6210\uff1a" + expireCompleteExpandCount);
            if (expireCompleteExpandCount.equals(orgTask.getTotalExpandCount())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)taskId)).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode())).update();
            }
        }
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<com.ovopark.model.page.Page<InspectionPlanTaskExpandListResp>> expandList(InspectionPlanAppExpandReq req, Users user) throws IOException {
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List<Object> depIds = new ArrayList();
        if (StringUtils.isNotBlank((String)req.getDepName())) {
            com.ovopark.pojo.BaseResult result = this.departmentApi.findDeptListByGroupIdAndName(user.getGroupId(), req.getDepName());
            if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
                depIds = ((List)result.getData()).stream().map(DepartmentPojo::getId).distinct().collect(Collectors.toList());
            } else {
                com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
                BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
                return JsonNewResult.success((Object)pageResult);
            }
        }
        if (req.getExpandGroup() != null) {
            req.setStatus(null);
        }
        List list = this.inspectionTaskExpandMapper.queryExpandListByTaskIdByPage(pageTemp, req.getId(), req.getStatus(), req.getExpandGroup(), depIds);
        Map<Object, Object> deptNameMap = new HashMap();
        HashMap tagMap = new HashMap();
        Map<Object, Object> taskIdTomap = new HashMap();
        Map<Object, Object> collect = new HashMap();
        List result = new ArrayList();
        List<Integer> deptIdList = new ArrayList<Integer>();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            List<IsCheckTemplate> templateModels = this.isCheckTemplateService.getListByGroupId(user.getGroupId());
            if (!org.springframework.util.CollectionUtils.isEmpty(templateModels)) {
                collect = templateModels.stream().collect(Collectors.toMap(IsCheckTemplate::getId, IsCheckTemplate::getName));
            }
            result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskExpandListResp.class);
            deptIdList = result.stream().map(InspectionPlanTaskExpandListResp::getDeptId).collect(Collectors.toList());
            deptNameMap = this.departProxy.getDeptNameMap(deptIdList);
            List inspectionDeptTemplateModels = this.isInspectionDeptTemplateMapper.listByDeptIds(deptIdList, user.getGroupId(), req.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionDeptTemplateModels)) {
                taskIdTomap = inspectionDeptTemplateModels.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId));
            }
        }
        Map<Integer, DepartmentPojo> map = this.departProxy.getDepartments(deptIdList);
        for (InspectionPlanTaskExpandListResp resp : result) {
            resp.setLatitude(map.get(resp.getDeptId()).getLatitude());
            resp.setLongitude(map.get(resp.getDeptId()).getLongitude());
            resp.setExpectTimeStr(DateUtil.format((Date)resp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            resp.setDeptName((String)deptNameMap.get(resp.getDeptId()));
            List templateModels = (List)taskIdTomap.get(resp.getId());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)templateModels)) continue;
            List<Object> templateDetails = new ArrayList<InspectionPlanTemplateDetailResp>();
            for (IsInspectionDeptTemplate model : templateModels) {
                if (model.getIsRead() == 0) {
                    resp.setStatus(Integer.valueOf(0));
                }
                InspectionPlanTemplateDetailResp detailResp = new InspectionPlanTemplateDetailResp(model.getId(), model.getTemplateId(), (String)collect.get(model.getTemplateId()), model.getIsRead(), model.getDeptId());
                templateDetails.add(detailResp);
                templateDetails = templateDetails.stream().sorted(Comparator.comparing(InspectionPlanTemplateDetailResp::getIsRead)).collect(Collectors.toList());
            }
            resp.setTemplateDetails(templateDetails);
        }
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        pageResult.setContent(result);
        return JsonNewResult.success((Object)pageResult);
    }

    @Override
    public JsonNewResult<InspectionPlanTaskExpandListCountResp> expandCountList(InspectionPlanAppExpandReq req, Users user) {
        Integer waitCount = this.inspectionTaskExpandMapper.queryExpandListCountByTaskId(req.getId(), InspectionTaskExpandStatusEnum.WAIT.getCode());
        Integer passCount = this.inspectionTaskExpandMapper.queryExpandListCountByTaskId(req.getId(), InspectionTaskExpandStatusEnum.PASS.getCode());
        return JsonNewResult.success((Object)new InspectionPlanTaskExpandListCountResp(waitCount, passCount));
    }

    public void assembleInspectionTaskExpand(InspectionPlanExpandAddReq req, InspectionTask task, Users user, List<InspectionTaskExpand> list, List<InspectionDeptTag> targetTagList, List<IsInspectionDeptTemplate> templateVos, Integer uuid, Date startTime, Date endTime) {
        if (CollectionUtils.isNotEmpty((Collection)req.getDeptModels())) {
            req.getDeptModels().forEach(model -> {
                InspectionTaskExpand expand = new InspectionTaskExpand();
                expand.setExpandGroup(uuid);
                expand.setGroupId(user.getGroupId());
                expand.setTaskId(task.getId());
                expand.setDeptId(model.getDeptId());
                expand.setDescription(StringUtils.isNotBlank((String)req.getDescription()) ? req.getDescription() : null);
                expand.setOperatorId(user.getId());
                expand.setStatus(model.getStatus() != null ? model.getStatus() : InspectionTaskExpandStatusEnum.WAIT.getCode());
                if (model.getId() != null) {
                    expand.setId(model.getId());
                    EntityBase.setUpdateParams((Object)expand, (Users)user);
                } else {
                    EntityBase.setCreateParams((Object)expand, (Users)user);
                }
                if (StringUtils.isNotBlank((String)model.getExpectTimeStr())) {
                    expand.setExpectTime(DateUtil.parse((String)model.getExpectTimeStr(), (String)DateUtil.FORMAT_LONG));
                    if (expand.getExpectTime().before(startTime) || expand.getExpectTime().after(endTime)) {
                        throw new SysErrorException(ResultCode.EXPECTTIME_OUT_START_END, new Object[0]);
                    }
                }
                this.inspectionTaskExpandService.saveOrUpdate(expand);
                list.add(expand);
                this.assembleInspectionDeptTagAndTemplate(targetTagList, req.getTagList(), task.getId(), model.getDeptId(), user, templateVos, req.getTemplateVos(), expand.getId());
            });
        }
    }

    public void assembleInspectionDeptTagAndTemplate(List<InspectionDeptTag> targetTagList, List<InspectionPlanTagAddReq> sourceTagList, Integer taskId, Integer depId, Users user, List<IsInspectionDeptTemplate> templateVos, List<CheckTemplateVoReq> vos, Integer expandId) {
        if (CollectionUtils.isNotEmpty(sourceTagList)) {
            for (InspectionPlanTagAddReq tagAddReq : sourceTagList) {
                InspectionDeptTag inspectionDeptTag = new InspectionDeptTag();
                if (expandId != null) {
                    inspectionDeptTag.setExpandId(expandId);
                }
                if (tagAddReq.getId() != null) {
                    inspectionDeptTag.setId(tagAddReq.getId());
                }
                inspectionDeptTag.setGroupId(user.getGroupId());
                inspectionDeptTag.setTaskId(taskId);
                inspectionDeptTag.setDeptId(depId);
                inspectionDeptTag.setTagId(tagAddReq.getTagId());
                EntityBase.setCreateParams((Object)inspectionDeptTag, (Users)user);
                this.inspectionDeptTagService.saveOrUpdate(inspectionDeptTag);
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(vos)) {
            List<Object> finishTemplateId = new ArrayList();
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.isInspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
            this.isInspectionDeptTemplateService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                finishTemplateId = list.stream().map(IsInspectionDeptTemplate::getTemplateId).collect(Collectors.toList());
            }
            for (CheckTemplateVoReq templateVoReq : vos) {
                if (finishTemplateId.contains(templateVoReq.getTemplateId())) continue;
                IsInspectionDeptTemplate checkTemplateVoReq = new IsInspectionDeptTemplate();
                checkTemplateVoReq.setGroupId(user.getGroupId());
                checkTemplateVoReq.setExpandId(expandId);
                checkTemplateVoReq.setTaskId(taskId);
                checkTemplateVoReq.setDeptId(depId);
                checkTemplateVoReq.setTemplateId(templateVoReq.getTemplateId());
                EntityBase.setCreateParams((Object)checkTemplateVoReq, (Users)user);
                this.inspectionDeptTemplateService.saveOrUpdate(checkTemplateVoReq);
            }
        }
    }

    @Override
    public com.ovopark.model.page.Page<InspectionPlanTaskAppListResp> appList(InspectionPlanTaskAppListReq req, Users user) {
        List collect;
        List ccModels;
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return new com.ovopark.model.page.Page();
        }
        EnterpriseConfigPojo configPojo = new EnterpriseConfigPojo();
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        if (baseResult.getData() != null) {
            configPojo = (EnterpriseConfigPojo)baseResult.getData();
        }
        List list = new ArrayList();
        if (req.getReleateType() != null && req.getReleateType().equals(ReleateTypeEnum.THREE.getCode()) && CollectionUtils.isNotEmpty((Collection)(ccModels = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getCcId, (Object)user.getId())).eq(InspectionTaskCcModel::getGroupId, (Object)user.getGroupId())).list()))) {
            collect = ccModels.stream().map(InspectionTaskCcModel::getTaskId).collect(Collectors.toList());
            list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, ReleateTypeEnum.THREE.getCode(), null, groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), collect, req.getEffectiveTime(), req.getCreateId());
        }
        if (req.getReleateType() != null && !req.getReleateType().equals(ReleateTypeEnum.THREE.getCode())) {
            list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
        }
        if (req.getReleateType() == null) {
            if (configPojo.getAddCopy().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
                ccModels = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getCcId, (Object)user.getId())).eq(InspectionTaskCcModel::getGroupId, (Object)user.getGroupId())).list();
                if (CollectionUtils.isNotEmpty((Collection)ccModels)) {
                    collect = ccModels.stream().map(InspectionTaskCcModel::getTaskId).collect(Collectors.toList());
                    taskIdList.addAll(collect);
                    taskIdList.addAll(this.inspectionTaskMapper.queryAppList(req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), null, req.getEffectiveTime(), req.getCreateId()));
                    list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, ReleateTypeEnum.THREE.getCode(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
                } else {
                    list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
                }
            } else {
                list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
            }
        }
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return pageResult;
        }
        InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
        List collect2 = list.stream().map(InspectionTask::getId).collect(Collectors.toList());
        List result = ClazzConverterUtils.converterClass(list, InspectionPlanTaskAppListResp.class);
        List inspectionDeptTagsList = new ArrayList();
        if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, collect2);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            pageResult.setContent(result);
        }
        Map<Object, Object> tagMap = new HashMap();
        HashMap taskTagMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
                Set<Integer> tagIdSet;
                Integer taskId = inspectionDeptTag.getTaskId();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                    tagIdSet = new HashSet<Integer>();
                    ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                    taskTagMap.put(taskId, tagIdSet);
                    continue;
                }
                tagIdSet = (Set)taskTagMap.get(taskId);
                tagIdSet.add(inspectionDeptTag.getTagId());
            }
            Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
            ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
            List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
                tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
            }
        }
        for (InspectionPlanTaskAppListResp inspectionPlanTaskAppListResp : result) {
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = inspectionPlanTaskAppListResp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            inspectionPlanTaskAppListResp.setTagList(eachTaskTagList);
            inspectionPlanTaskAppListResp.setStartTimeStr(DateUtil.format((Date)inspectionPlanTaskAppListResp.getStartTime(), (String)DateUtil.FORMAT_SHORT));
            inspectionPlanTaskAppListResp.setEndTimeStr(DateUtil.format((Date)inspectionPlanTaskAppListResp.getEndTime(), (String)DateUtil.FORMAT_SHORT));
        }
        pageResult.setContent(result);
        return pageResult;
    }

    @Override
    public Integer appCount(InspectionPlanTaskAppListReq req, Users user) {
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        pageResult.setPageNumber(req.getPageNo().intValue());
        pageResult.setPageSize(req.getPageSize().intValue());
        return this.inspectionTaskMapper.queryAppListByRelateTypeCount(pageResult, null, user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), null, req.getEffectiveTime());
    }

    @Override
    public JsonNewResult<com.ovopark.model.page.Page<InspectionPlanTaskWebListResp>> webList(InspectionPlanTaskWebListReq req, Users user) {
        List distinctTagIdList;
        List tagList;
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return JsonNewResult.success((Object)new com.ovopark.model.page.Page());
        }
        StringBuilder sqlDescBuilder = new StringBuilder();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrderList())) {
            List orderList = req.getOrderList();
            for (int i = 0; i < orderList.size(); ++i) {
                StorePlanDescReq descOrder = (StorePlanDescReq)orderList.get(i);
                if (descOrder.getDescColumn() == null || descOrder.getDescOrder() == null) continue;
                String columnExpression = StorePlanOrderWebColumnEnum.format((Integer)descOrder.getDescColumn()).getExpression();
                String orderExpression = StorePlanOrderDescEnum.format((Integer)descOrder.getDescOrder()).getDesc();
                sqlDescBuilder.append(columnExpression).append(orderExpression).append(",");
            }
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.ID.getExpression()).append(StorePlanOrderDescEnum.DESC.getDesc());
        } else {
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.WEB_DEFAULT.getExpression());
        }
        String sqlOrderExpression = sqlDescBuilder.toString();
        ArrayList organizeUserList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            ArrayList departmentMoList = new ArrayList();
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(req.getOrganizeIdList());
            mo.setUserId(user.getId());
            BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                    List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                    departmentMoList.addAll(departmentMoList1);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentAndOrganizeAndUserMo.getUserList())) {
                        organizeUserList.addAll(departmentAndOrganizeAndUserMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                    }
                });
                if (!org.springframework.util.CollectionUtils.isEmpty(departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            organizeUserList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
            organizeUserList.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
        }
        List list = this.inspectionTaskMapper.queryWebListByPage(pageTemp, groupId, req.getName(), req.getOperatorName(), req.getStatus(), req.getAuditName(), req.getStartTime(), req.getEndTime(), InspectionPlanExpressionEnum.formatOrNull((String)req.getCompletePercentExpression()).getExpression(), req.getCompletePercent(), taskIdList, organizeUserList, sqlOrderExpression);
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return JsonNewResult.success((Object)pageResult);
        }
        List collect = list.stream().map(InspectionTask::getId).collect(Collectors.toList());
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        List inspectionDeptTagsList = new ArrayList();
        InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
        if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, collect);
        }
        HashMap taskTagMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
                Set<Integer> tagIdSet;
                Integer taskId = inspectionDeptTag.getTaskId();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                    tagIdSet = new HashSet<Integer>();
                    ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                    taskTagMap.put(taskId, tagIdSet);
                    continue;
                }
                tagIdSet = (Set)taskTagMap.get(taskId);
                tagIdSet.add(inspectionDeptTag.getTagId());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).distinct().collect(Collectors.toList()))))) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        for (InspectionPlanTaskWebListResp resp : result) {
            resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_TIME));
            resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_TIME));
            List taskExpandList = (List)expandMap.get(resp.getId());
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)taskExpandList) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        pageResult.setContent(result);
        return JsonNewResult.success((Object)pageResult);
    }

    @Override
    public JsonNewResult<List<InspectionPlanTaskWebListResp>> allList(InspectionPlanTaskWebListReq req, Users user) {
        List inspectionDeptTagsList;
        List list;
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return JsonNewResult.success(new ArrayList());
        }
        StringBuilder sqlDescBuilder = new StringBuilder();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrderList())) {
            List orderList = req.getOrderList();
            for (int i = 0; i < orderList.size(); ++i) {
                StorePlanDescReq descOrder = (StorePlanDescReq)orderList.get(i);
                if (descOrder.getDescColumn() == null || descOrder.getDescOrder() == null) continue;
                String columnExpression = StorePlanOrderWebColumnEnum.format((Integer)descOrder.getDescColumn()).getExpression();
                String orderExpression = StorePlanOrderDescEnum.format((Integer)descOrder.getDescOrder()).getDesc();
                sqlDescBuilder.append(columnExpression).append(orderExpression).append(",");
            }
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.ID.getExpression()).append(StorePlanOrderDescEnum.DESC.getDesc());
        } else {
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.WEB_DEFAULT.getExpression());
        }
        String sqlOrderExpression = sqlDescBuilder.toString();
        ArrayList organizeUserList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            ArrayList departmentMoList = new ArrayList();
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(req.getOrganizeIdList());
            mo.setUserId(user.getId());
            BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                    List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                    departmentMoList.addAll(departmentMoList1);
                });
                if (!org.springframework.util.CollectionUtils.isEmpty(departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            organizeUserList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
            organizeUserList.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(list = this.inspectionTaskMapper.queryWebList(groupId, req.getName(), req.getOperatorName(), req.getStatus(), req.getAuditName(), req.getStartTime(), req.getEndTime(), InspectionPlanExpressionEnum.formatOrNull((String)req.getCompletePercentExpression()).getExpression(), req.getCompletePercent(), taskIdList, organizeUserList, sqlOrderExpression)))) {
            return JsonNewResult.success(new ArrayList());
        }
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, null)))) {
            return JsonNewResult.success((Object)result);
        }
        HashMap taskTagMap = new HashMap();
        for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
            Set<Integer> tagIdSet;
            Integer taskId = inspectionDeptTag.getTaskId();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                tagIdSet = new HashSet<Integer>();
                ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                taskTagMap.put(taskId, tagIdSet);
                continue;
            }
            tagIdSet = (Set)taskTagMap.get(taskId);
            tagIdSet.add(inspectionDeptTag.getTagId());
        }
        Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
        ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
        Map<Object, Object> tagMap = new HashMap();
        List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        for (InspectionPlanTaskWebListResp resp : result) {
            resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_LONG));
            resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_LONG));
            List taskExpandList = (List)expandMap.get(resp.getId());
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)taskExpandList) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        return JsonNewResult.success((Object)result);
    }

    @Override
    public JsonNewResult<List<InspectionPlanTaskWebListResp>> partionList(InspectionPlanTaskPartionWebListReq req, Users user) {
        List inspectionDeptTagsList;
        List ids;
        Integer groupId = user.getGroupId();
        List list = this.inspectionTaskMapper.partionList(groupId, ids = req.getIds());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return JsonNewResult.success(new ArrayList());
        }
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, null)))) {
            return JsonNewResult.success((Object)result);
        }
        HashMap taskTagMap = new HashMap();
        for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
            Set<Integer> tagIdSet;
            Integer taskId = inspectionDeptTag.getTaskId();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                tagIdSet = new HashSet<Integer>();
                ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                taskTagMap.put(taskId, tagIdSet);
                continue;
            }
            tagIdSet = (Set)taskTagMap.get(taskId);
            tagIdSet.add(inspectionDeptTag.getTagId());
        }
        Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
        ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
        Map<Object, Object> tagMap = new HashMap();
        List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        for (InspectionPlanTaskWebListResp resp : result) {
            resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_LONG));
            resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_LONG));
            List taskExpandList = (List)expandMap.get(resp.getId());
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)taskExpandList) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, resp.getId()));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        return JsonNewResult.success((Object)result);
    }

    @Override
    public InspectionPlanPersonlyResp personly(Users user) {
        InspectionPlanPersonlyResp resp;
        Integer groiupTotalTask = 0;
        Integer groiupFinishTask = 0;
        double groupPer = 0.0;
        Map<Object, Object> personlyRespMap = new HashMap();
        List task = this.inspectionTaskMapper.getTaskByGroupIdAndOperatorId(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), null, null);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)task)) {
            personlyRespMap = task.stream().collect(Collectors.toMap(InspectionPlanPersonlyResp::getUserId, Function.identity()));
            groiupTotalTask = task.stream().collect(Collectors.summingInt(InspectionPlanPersonlyResp::getTaskNum));
            groiupFinishTask = task.stream().collect(Collectors.summingInt(InspectionPlanPersonlyResp::getFinishTaskNum));
            groupPer = (double)groiupFinishTask.intValue() / (double)groiupTotalTask.intValue();
        }
        if ((resp = (InspectionPlanPersonlyResp)personlyRespMap.get(user.getId())) != null) {
            double personFinishPer = (double)resp.getFinishTaskNum().intValue() / (double)resp.getTaskNum().intValue();
            resp.setPersonFinishPer(Double.valueOf(new BigDecimal(personFinishPer * 100.0).setScale(2, 4).doubleValue()));
            resp.setPersonFinishPerInGroup(Double.valueOf(new BigDecimal((personFinishPer - groupPer) * 100.0).setScale(2, 4).doubleValue()));
            InspectionPlanPersonlyResp personPosition = this.personPosition(user);
            resp.setUserTop(personPosition.getRank());
            resp.setTopSize(personPosition.getTopSize());
        }
        return resp;
    }

    @Override
    public InspectionPlanPersonlyResp personPosition(Users user) {
        DecimalFormat df1 = new DecimalFormat("#0.00%");
        Map<Object, Object> topMap = new HashMap();
        Date date = new Date();
        Date startTimeOfDay = DateUtil.getStartTimeOfDay((Date)date);
        List task = this.inspectionTaskMapper.getTaskByGroupIdAndTime(user.getGroupId(), DeleteEnum.NOT_DELETED, DateUtil.format((Date)date, (String)DateUtil.FORMAT_LONG));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)task)) {
            task.forEach(resp -> resp.setTopSize(Integer.valueOf(task.size())).setRank(resp.getUserTop()));
            topMap = task.stream().collect(Collectors.toMap(InspectionPlanPersonlyResp::getUserId, Function.identity()));
        }
        return (InspectionPlanPersonlyResp)topMap.get(user.getId());
    }

    @Override
    public InspectionTaskCountResp taskCount(InspectionTaskCountReq req, Users user) {
        InspectionTaskCountResp resp = new InspectionTaskCountResp();
        InspectionTaskCountResp taskCountResp = this.inspectionTaskMapper.taskCount(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), req.getStartTime(), req.getEndTime(), req.getDataType(), user.getId());
        if (taskCountResp != null) {
            resp.setOutTime(taskCountResp.getOutTime());
            resp.setFinish(taskCountResp.getFinish());
            resp.setDoing(taskCountResp.getDoing());
        }
        return resp;
    }

    @Override
    public List<InspectionPlanPersonlyResp> finishTop(Users user, InspectionTashFinishPerTop req) {
        Integer groiupTotalTask = 0;
        Integer groiupFinishTask = 0;
        double groupPer = 0.0;
        HashMap personlyRespMap = new HashMap();
        List task = this.inspectionTaskMapper.getTaskByGroupIdAndOperatorId(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), req.getStartTime(), req.getEndTime());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)task)) {
            task.forEach(resp -> resp.setTopSize(Integer.valueOf(task.size())).setRank(resp.getUserTop()));
        }
        return task;
    }

    @Override
    public List<InspectionTaskWillOutTimeResp> willOutTime(InspectionTaskWillOutTimeReq req, Users user) {
        ArrayList<InspectionTaskWillOutTimeResp> list = new ArrayList<InspectionTaskWillOutTimeResp>();
        Date date = new Date();
        Date endTime = DateUtil.getEndTimeOfDay((Date)DateUtil.addDay((Date)date, (int)2));
        Date startTime = DateUtil.getStartTimeOfDay((Date)date);
        Map<Object, Object> taskTagMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        List expands = new ArrayList();
        Map<Object, Object> expandMap = new HashMap();
        List inspectionTasks = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getOperatorId, (Object)user.getId())).between(InspectionTask::getEndTime, (Object)startTime, (Object)endTime)).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionTasks)) {
            List deptTags = this.inspectionDeptTagMapper.selectTagIdListByTaskList(user.getGroupId(), inspectionTasks.stream().map(InspectionTask::getId).collect(Collectors.toList()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTags)) {
                taskTagMap = deptTags.stream().collect(Collectors.groupingBy(InspectionDeptTag::getTaskId));
                List tags = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), deptTags.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList()));
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tags)) {
                    tagMap = tags.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
                }
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(expands = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(inspectionTasks.stream().map(InspectionTask::getId).collect(Collectors.toList()), user.getGroupId()))) {
                expandMap = expands.stream().collect(Collectors.groupingBy(InspectionTaskExpand::getTaskId, Collectors.groupingBy(InspectionTaskExpand::getStatus)));
            }
        }
        for (InspectionTask task : inspectionTasks) {
            InspectionTaskWillOutTimeResp resp = new InspectionTaskWillOutTimeResp();
            List deptTags = (List)taskTagMap.get(task.getId());
            HashSet<String> tagNames = new HashSet<String>();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTags)) {
                for (InspectionDeptTag deptTag : deptTags) {
                    String tagName = (String)tagMap.get(deptTag.getTagId());
                    if (tagName == null) continue;
                    tagNames.add(tagName);
                }
                resp.setInspectionTagName(tagNames);
            }
            if (expandMap.get(task.getId()) != null) {
                int finishNum = 0;
                List inspectionTaskExpands = (List)((Map)expandMap.get(task.getId())).get(InspectionTaskExpandStatusEnum.PASS.getCode());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionTaskExpands)) {
                    finishNum = inspectionTaskExpands.size();
                }
                int allSize = ((Map)expandMap.get(task.getId())).size();
                resp.setFinishNum(Integer.valueOf(finishNum));
                resp.setTaskNum(Integer.valueOf(allSize));
            }
            resp.setStartTime(task.getStartTime());
            resp.setEndTime(task.getEndTime());
            resp.setInspectionTaskId(task.getId());
            resp.setInspectionTaskName(task.getName());
            resp.setStatus(task.getStatus());
            list.add(resp);
        }
        list.sort(Comparator.comparing(InspectionTaskWillOutTimeResp::getEndTime));
        return list;
    }

    @Override
    public InspectionTaskByGroupResp getTaskByGroupId(InspectionTaskCountReq req, Users user) {
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)DateUtil.parse((String)req.getStartTime(), (String)DateUtil.FORMAT_LONG));
        String startTime = DateUtil.format((Date)firstDayOfMonth, (String)DateUtil.FORMAT_LONG);
        InspectionTaskByGroupResp resp = this.inspectionTaskMapper.getTaskByGroupId(user.getGroupId(), startTime, req.getEndTime());
        if (resp.getTaskNum() > 1) {
            double per = (double)resp.getFinishTaskNum().intValue() / (double)resp.getTaskNum().intValue();
            resp.setFinishPer(Double.valueOf(new BigDecimal(per * 100.0).setScale(2, 4).doubleValue()));
        }
        return resp;
    }

    @Override
    public List<InspectionTaskPerByGroupId> getFinishPerByGroupId(InspectionTaskCountReq req, Users user) {
        ArrayList<InspectionTaskPerByGroupId> result = new ArrayList<InspectionTaskPerByGroupId>();
        List resps = new ArrayList();
        String name = GroupBy.getName((Integer)req.getDataType());
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)DateUtil.parse((String)req.getStartTime(), (String)DateUtil.FORMAT_LONG));
        String startTime = DateUtil.format((Date)firstDayOfMonth, (String)DateUtil.FORMAT_LONG);
        DaoUtils daoUtils = new DaoUtils();
        Map mapMonth = new HashMap();
        switch (req.getDataType()) {
            case 1: {
                mapMonth = daoUtils.setMapMonth(req.getStartTime(), req.getEndTime(), Integer.valueOf(1));
                resps = this.inspectionTaskMapper.getFinishPerByGroupId(user.getGroupId(), startTime, req.getEndTime());
                break;
            }
            case 2: {
                mapMonth = daoUtils.setMapQuarter(req.getStartTime(), req.getEndTime(), Integer.valueOf(3));
                resps = this.inspectionTaskMapper.getFinishPerByGroupIdQuarter(user.getGroupId(), startTime, req.getEndTime());
                break;
            }
            case 3: {
                mapMonth = daoUtils.setMapYear(req.getStartTime(), req.getEndTime(), Integer.valueOf(1));
                resps = this.inspectionTaskMapper.getFinishPerByGroupIdYear(user.getGroupId(), startTime, req.getEndTime());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(resps)) {
            Map listMap = resps.stream().collect(Collectors.toMap(InspectionTaskPerByGroupId::getDateTime, Function.identity()));
            for (String s : mapMonth.keySet()) {
                InspectionTaskPerByGroupId resp = new InspectionTaskPerByGroupId();
                resp.setDateTime(s);
                if (listMap.containsKey(s) && listMap.get(s) != null) {
                    int totalNum = ((InspectionTaskPerByGroupId)listMap.get(s)).getTaskNum();
                    int finishNum = ((InspectionTaskPerByGroupId)listMap.get(s)).getFinishTaskNum();
                    double l = (double)finishNum / (double)totalNum;
                    resp.setFinishPer(Double.valueOf(new BigDecimal(l * 100.0).setScale(2, 4).doubleValue()));
                }
                result.add(resp);
            }
        }
        return result;
    }

    @Override
    public List<GetFinishPerByOrganizeIdsResp> getFinishPerByOrganizeIds(GetFinishPerByOrganizeIdsReq req, Users user) {
        ArrayList respList = new ArrayList();
        List<Object> collect = new ArrayList<GetFinishPerByOrganizeIdsResp>();
        ArrayList departmentMoList = new ArrayList();
        ArrayList orgUserIdList = new ArrayList();
        ArrayList userIds = new ArrayList();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setOrganizeIds(req.getOrganizeId());
        mo.setUserId(user.getId());
        BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            List resps;
            ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                InspectionPlanPersonlyResp personlyResp;
                List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentAndOrganizeAndUserMo.getUserList())) {
                    orgUserIdList.addAll(departmentAndOrganizeAndUserMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                }
                departmentMoList.addAll(departmentMoList1);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            orgUserIdList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgUserIdList) && (personlyResp = this.inspectionTaskMapper.getFinishPerByOrganizeIds(user.getGroupId(), orgUserIdList, req.getStartTime(), req.getEndTime())) != null) {
                    GetFinishPerByOrganizeIdsResp resp = new GetFinishPerByOrganizeIdsResp();
                    resp.setId(departmentAndOrganizeAndUserMo.getOrganizeId());
                    resp.setName(departmentAndOrganizeAndUserMo.getOrganizeName());
                    resp.setTaskNum(personlyResp.getTaskNum());
                    resp.setFinishTaskNum(personlyResp.getFinishTaskNum());
                    resp.setPersonFinishPer(personlyResp.getPersonFinishPer());
                    respList.add(resp);
                }
            });
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
                userIds.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(userIds) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(resps = this.inspectionTaskMapper.getFinishPerByUserIds(user.getGroupId(), userIds, req.getStartTime(), req.getEndTime())))) {
                resps.forEach(inspectionPlanPersonlyResp -> {
                    GetFinishPerByOrganizeIdsResp resp = new GetFinishPerByOrganizeIdsResp();
                    resp.setId(inspectionPlanPersonlyResp.getUserId());
                    resp.setName(inspectionPlanPersonlyResp.getUserName());
                    resp.setTaskNum(inspectionPlanPersonlyResp.getTaskNum());
                    resp.setFinishTaskNum(inspectionPlanPersonlyResp.getFinishTaskNum());
                    resp.setPersonFinishPer(inspectionPlanPersonlyResp.getPersonFinishPer());
                    respList.add(resp);
                });
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(respList)) {
            collect = respList.stream().filter(resp -> resp.getPersonFinishPer() != null).collect(Collectors.toList());
            String[] sortNameArr = new String[]{"personFinishPer", "id"};
            boolean[] isAscArr = new boolean[]{req.getOrderType().equals(0), true};
            ListUtils.sort(collect, (String[])sortNameArr, (boolean[])isAscArr);
        }
        return collect;
    }

    @Override
    public JsonNewResult<InspectionPlanTaskDetailResp> detail(InspectionPlanTaskDetailReq req, Users user) throws IOException {
        List uIds;
        com.ovopark.pojo.BaseResult result;
        List<Integer> tempIds;
        List<IsCheckTemplate> checkTemplates;
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        Map<Object, Object> tempMap = new HashMap();
        List templates = this.isInspectionDeptTemplateMapper.getTemplateByTaskId(taskId);
        if (CollectionUtils.isNotEmpty((Collection)templates) && CollectionUtils.isNotEmpty(checkTemplates = this.isCheckTemplateService.getListByIds(tempIds = templates.stream().map(InspectionPlanTemplateDetailResp::getTemplateId).distinct().collect(Collectors.toList())))) {
            tempMap = checkTemplates.stream().collect(Collectors.toMap(IsCheckTemplate::getId, IsCheckTemplate::getName));
        }
        if (task == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        Set<Object> notDeleteExpandIds = new HashSet();
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskId(taskId, user.getGroupId());
        List list1 = this.inspectionDeptTemplateService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).eq(IsInspectionDeptTemplate::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list1)) {
            notDeleteExpandIds = list1.stream().map(IsInspectionDeptTemplate::getExpandId).collect(Collectors.toSet());
        }
        InspectionPlanTaskDetailResp resp = (InspectionPlanTaskDetailResp)ClazzConverterUtils.converterClass((Object)task, InspectionPlanTaskDetailResp.class);
        Date now = new Date();
        resp.setIsExpire(resp.getEndTime().before(now) ? DefaultEnum.DEFAULT_TRUE.getCode() : DefaultEnum.DEFAULT_FALSE.getCode());
        if (task.getOperatorId().equals(user.getId()) && Arrays.asList(InspectionTaskStatusEnum.PASS.getCode(), InspectionTaskStatusEnum.INSPECT.getCode()).contains(task.getStatus()) && now.after(task.getStartTime())) {
            resp.setIsOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId())) {
            resp.setIsExecuter(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId()) && InspectionTaskStatusEnum.AUDIT.getCode().equals(task.getStatus())) {
            boolean contains;
            EnterpriseConfigPojo pojo;
            if (!resp.getIsExpire().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
                resp.setIsUrged(DefaultEnum.DEFAULT_TRUE.getCode());
            }
            if ((pojo = (EnterpriseConfigPojo)this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId()).getData()) != null && StringUtils.isNotBlank((String)pojo.getExpireExecute()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)Stream.of(pojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())) && (contains = Stream.of(pojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode()))) {
                resp.setIsUrged(DefaultEnum.DEFAULT_TRUE.getCode());
            }
            resp.setIsOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getAuditId().equals(user.getId()) && InspectionTaskStatusEnum.AUDIT.getCode().equals(task.getStatus())) {
            resp.setIsAudit(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId())) {
            resp.setSameWithOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        List expandRespList = new ArrayList();
        Map<Object, Object> deptNameMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        Map<Object, Object> groupByDeptIdTagMap = new HashMap();
        ArrayList<InspectionPlanExpandDetailResp> resps = new ArrayList<InspectionPlanExpandDetailResp>();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            List deptTagList;
            expandRespList = ClazzConverterUtils.converterClass((Collection)expandList, InspectionPlanExpandDetailResp.class);
            List<Integer> deptIdList = expandList.stream().map(InspectionTaskExpand::getDeptId).collect(Collectors.toList());
            deptNameMap = this.departProxy.getDeptNameMap(deptIdList);
            InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
            if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(deptTagList = this.inspectionDeptTagMapper.selectTagIdListByTaskAndDeptList(taskId, user.getGroupId(), deptIdList)))) {
                List tagIdList = deptTagList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList());
                groupByDeptIdTagMap = deptTagList.stream().collect(Collectors.groupingBy(InspectionDeptTag::getExpandId));
                List tagList = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), tagIdList);
                tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
            }
            Integer undoNum = 0;
            Integer alreadyDoNum = 0;
            for (Object inspectionPlanExpandDetailResp : expandRespList) {
                Integer n = inspectionPlanExpandDetailResp.getDeptId();
                if (!org.springframework.util.CollectionUtils.isEmpty(notDeleteExpandIds) && notDeleteExpandIds.contains(inspectionPlanExpandDetailResp.getId())) {
                    inspectionPlanExpandDetailResp.setNotDeleted(Integer.valueOf(1));
                }
                if (inspectionPlanExpandDetailResp.getStatus().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
                    inspectionPlanExpandDetailResp.setNotDeleted(Integer.valueOf(1));
                }
                if (InspectionTaskExpandStatusEnum.PASS.getCode().equals(inspectionPlanExpandDetailResp.getStatus())) {
                    alreadyDoNum = alreadyDoNum + 1;
                }
                if (InspectionTaskExpandStatusEnum.WAIT.getCode().equals(inspectionPlanExpandDetailResp.getStatus())) {
                    undoNum = undoNum + 1;
                }
                inspectionPlanExpandDetailResp.setDeptName((String)deptNameMap.get(n));
                inspectionPlanExpandDetailResp.setExpectTimeStr(DateUtil.format((Date)inspectionPlanExpandDetailResp.getExpectTime(), (String)DateUtil.FORMAT_LONG));
            }
            Map<Object, Object> expandMap = new HashMap();
            expandMap = task.getDepChose().equals(DefaultEnum.DEFAULT_TRUE.getCode()) ? expandRespList.stream().collect(Collectors.groupingBy(InspectionPlanExpandDetailResp::getExpandGroup)) : expandRespList.stream().collect(Collectors.groupingBy(InspectionPlanExpandDetailResp::getId));
            for (Integer n : expandMap.keySet()) {
                Stream<InspectionPlanExpandDetailResp> respStream;
                Map<Integer, Long> collect1;
                InspectionPlanExpandDetailResp inspectionPlanExpandDetailResp;
                InspectionPlanExpandDetailResp mo = new InspectionPlanExpandDetailResp();
                mo.setDeptModels((List)expandMap.get(n));
                List collect2 = ((List)expandMap.get(n)).stream().map(InspectionPlanExpandDetailResp::getId).collect(Collectors.toList());
                List templateVos = this.isInspectionDeptTemplateMapper.getByExpandId(collect2);
                if (CollectionUtils.isNotEmpty((Collection)templateVos)) {
                    for (InspectionPlanTemplateDetailResp vo : templateVos) {
                        vo.setTemplateName((String)tempMap.get(vo.getTemplateId()));
                    }
                    mo.setTemplateVos(templateVos);
                }
                mo.setDescription((inspectionPlanExpandDetailResp = (InspectionPlanExpandDetailResp)((List)expandMap.get(n)).get(0)).getDescription() != null ? inspectionPlanExpandDetailResp.getDescription() : null);
                mo.setExpandGroup(inspectionPlanExpandDetailResp.getExpandGroup());
                List eachDeptTagList = (List)groupByDeptIdTagMap.get(inspectionPlanExpandDetailResp.getId());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eachDeptTagList)) {
                    List tagList = mo.getTagList();
                    for (InspectionDeptTag inspectionDeptTag : eachDeptTagList) {
                        Integer tagId = inspectionDeptTag.getTagId();
                        InspectionPlanTagDetailResp tagResp = new InspectionPlanTagDetailResp(tagId, (String)tagMap.get(tagId), inspectionPlanExpandDetailResp.getId());
                        tagList.add(tagResp);
                    }
                }
                if ((collect1 = ((List)expandMap.get(n)).stream().collect(Collectors.groupingBy(i -> i.getNotDeleted().equals(DefaultEnum.DEFAULT_TRUE.getCode()) ? DefaultEnum.DEFAULT_TRUE.getCode() : DefaultEnum.DEFAULT_FALSE.getCode(), Collectors.counting()))).get(DefaultEnum.DEFAULT_TRUE.getCode()) != null && collect1.get(DefaultEnum.DEFAULT_TRUE.getCode()).intValue() > DefaultEnum.DEFAULT_TRUE.getCode()) {
                    mo.setNotDeleted(DefaultEnum.DEFAULT_TRUE.getCode());
                }
                if ((respStream = ((List)expandMap.get(n)).stream().filter(e -> e.getNotDeleted().equals(DefaultEnum.DEFAULT_TRUE.getCode()))).count() > 0L) {
                    mo.setNotDeleted(DefaultEnum.DEFAULT_TRUE.getCode());
                }
                resps.add(mo);
            }
            String inspectResult = String.format(CommonConstants.INSPECTION_RESULT, expandRespList.size(), alreadyDoNum, undoNum);
            resp.setInspectionResult(inspectResult);
        }
        resp.setInspectionExpandList(resps);
        List list = this.inspectionAuditReasonMapper.selectAudiReasonListByTaskId(taskId);
        List reasonList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            reasonList = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskAuditReasonResp.class);
        }
        resp.setReason(reasonList);
        List ccUsers = ((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getTaskId, (Object)task.getId())).list();
        if (CollectionUtils.isNotEmpty((Collection)ccUsers) && !org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)(result = this.userApi.getUserPojosByIdList(uIds = ccUsers.stream().map(InspectionTaskCcModel::getCcId).distinct().collect(Collectors.toList()))).getData()))) {
            resp.setCcUsers((List)result.getData());
        }
        return JsonNewResult.success((Object)resp);
    }

    @Override
    public JsonNewResult<InspectionPlanTaskWebExpandListResp> webExpandList(InspectionPlanWebExpandReq req, Users user) {
        Integer taskId = req.getTaskId();
        InspectionTask orgTask = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        List list = this.inspectionTaskExpandMapper.selectExpandListByTaskIdNew(taskId, user.getGroupId());
        Map<Object, Object> tagMap = new HashMap();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return JsonNewResult.success((Object)new InspectionPlanTaskWebExpandListResp());
        }
        List deptIdList = list.stream().map(InspectionTaskExpand::getDeptId).collect(Collectors.toList());
        Map<Object, Object> groupByDeptIdTagMap = new HashMap();
        List deptTagList = this.inspectionDeptTagMapper.selectTagIdListByTaskAndDeptListNew(taskId, user.getGroupId(), deptIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTagList)) {
            List tagIdList = deptTagList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList());
            groupByDeptIdTagMap = deptTagList.stream().collect(Collectors.groupingBy(InspectionDeptTag::getExpandId));
            List tagList = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), tagIdList);
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        HashMap<Integer, InspectionPlanTaskWebExpandListInnerResp> resultMap = new HashMap<Integer, InspectionPlanTaskWebExpandListInnerResp>();
        for (InspectionTaskExpand expand : list) {
            InspectionTaskExpandStatusEnum expandStatusEnum = InspectionTaskExpandStatusEnum.formatOrNull((Integer)expand.getStatus());
            InspectionPlanTaskWebExpandListInnerResp innerResp = new InspectionPlanTaskWebExpandListInnerResp(expand.getStatus(), expandStatusEnum == null ? "" : expandStatusEnum.getDesc(), expand.getDescription());
            Integer deptId = expand.getDeptId();
            List eachDeptTagList = (List)groupByDeptIdTagMap.get(expand.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eachDeptTagList)) {
                for (InspectionDeptTag inspectionDeptTag : eachDeptTagList) {
                    Set tagNameList = innerResp.getTagNameList();
                    Integer tagId = inspectionDeptTag.getTagId();
                    String tagName = (String)tagMap.get(tagId);
                    tagNameList.add(tagName);
                }
            }
            resultMap.put(expand.getId(), innerResp);
        }
        return JsonNewResult.success((Object)new InspectionPlanTaskWebExpandListResp(resultMap));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> delete(InspectionPlanTaskDeleteReq req, Users user) {
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (task == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        Integer jobId = task.getJobId();
        this.inspectionTaskMapper.deleteByPrimaryId(taskId);
        this.inspectionTaskExpandMapper.deleteByTaskIdWithOutExpandList(taskId, new ArrayList());
        this.inspectionDeptTagMapper.deleteByTaskIdWithOutDeptIdList(taskId, new ArrayList());
        this.inspectionAuditReasonMapper.deleteByTaskId(taskId);
        Date now = new Date();
        if (now.before(task.getEndTime())) {
            this.xxlJobProxy.stopJob(jobId);
        }
        DeleteMessagesByObjectBuilder builder = new DeleteMessagesByObjectBuilder();
        this.messageProxy.deleteMessagesByObject(builder.objectType(InspectionPlanMainTypeEnum.INSPECTION.getDesc()).subId(task.getId()).isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).build());
        this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.DELETE_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.LIST.getCode(), null, null, null);
        this.messageProxy.sendWebSocketAndJpush(task.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.DELETE_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.LIST.getCode(), null, null, null);
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> batchDelete(InspectionPlanTaskDeleteReq req, Users user) {
        List taskIdList = req.getIdList();
        List taskList = this.inspectionTaskMapper.selectTaskByIdList(taskIdList, user.getGroupId());
        Date now = new Date();
        List jobIdList = taskList.stream().filter(t1 -> now.before(t1.getEndTime())).map(InspectionTask::getJobId).collect(Collectors.toList());
        this.inspectionTaskMapper.deleteByIdList(taskIdList, user.getGroupId());
        this.inspectionTaskExpandMapper.deleteByTaskIdListWithOutExpandList(taskIdList, new ArrayList(), user.getGroupId());
        this.inspectionDeptTagMapper.deleteByTaskIdListWithOutDeptIdList(taskIdList, new ArrayList(), user.getGroupId());
        for (Integer jobId : jobIdList) {
            this.xxlJobProxy.stopJob(jobId);
        }
        for (Integer integer : taskIdList) {
            DeleteMessagesByObjectBuilder builder = new DeleteMessagesByObjectBuilder();
            this.messageProxy.deleteMessagesByObject(builder.objectType(InspectionPlanMainTypeEnum.INSPECTION.getDesc()).subId(integer).isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).build());
        }
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<List<InspectionPlanTaskAppLogListResp>> appLogList(InspectionPlanTaskAppLogListReq req, Users user) {
        Integer groupId = user.getGroupId();
        Integer taskId = req.getTaskId();
        List<Integer> taskIdList = Arrays.asList(taskId);
        List result = new ArrayList();
        List logList = this.inspectionOperatorLogMapper.selectLogListByGroupAndTaskIdList(taskIdList, groupId);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)logList)) {
            return JsonNewResult.success(result);
        }
        result = ClazzConverterUtils.converterClass((Collection)logList, InspectionPlanTaskAppLogListResp.class);
        for (InspectionPlanTaskAppLogListResp resp : result) {
            resp.setCreateTimeStr(DateUtil.format((Date)resp.getCreateTime(), (String)DateUtil.FORMAT_SHORT));
        }
        return JsonNewResult.success(result);
    }

    @Override
    public JsonNewResult<Void> urged(InspectionPlanTaskUrgedReq req, Users user) {
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (task == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        this.insertLog(user, task.getId(), LogConstant.URGED, user.getShowName());
        this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.URGED_AUDIT, task.getOperatorName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), null, null, null);
        return JsonNewResult.success();
    }

    @Override
    public void insertLog(Users user, Integer taskId, String operatorType, String ... param) {
        String content = String.format(operatorType, param);
        InspectionOperatorLog log = new InspectionOperatorLog(user.getGroupId(), taskId, user.getId(), user.getShowName(), content);
        EntityBase.setCreateParams((Object)log, (Users)user);
        this.inspectionOperatorLogMapper.insertSelective(log);
    }

    @Override
    public IPage<InspectionPlanDtoResp> secondWebList(InspectionPlanTaskSecondReq req, Users user) throws IOException {
        IPage page;
        InspectionPlanDtoResp planDto = null;
        List respList = new ArrayList();
        InspectionTask task = (InspectionTask)this.getById(req.getTaskId());
        Optional.ofNullable(task).orElseThrow(() -> new SysErrorException(ResultCode.NO_CORRESPONDING_ENTITY, new Object[0]));
        List<Object> depIds = new ArrayList();
        Map<Object, Object> deptNameMap = new HashMap();
        if (StringUtils.isNotBlank((String)req.getDepName())) {
            com.ovopark.pojo.BaseResult baseResult = this.departmentApi.findDeptListByGroupIdAndName(user.getGroupId(), req.getDepName());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                depIds = ((List)baseResult.getData()).stream().map(DepartmentPojo::getId).collect(Collectors.toList());
            }
            if (org.springframework.util.CollectionUtils.isEmpty(depIds)) {
                return new Page();
            }
        }
        List<Object> expandIds = new ArrayList();
        Map<Object, Object> expandMap = new HashMap();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(Optional.ofNullable(req.getExpectStartTime()).isPresent() && Optional.ofNullable(req.getExpectEndTime()).isPresent(), InspectionTaskExpand::getExpectTime, (Object)req.getExpectStartTime(), (Object)req.getExpectEndTime())).eq(InspectionTaskExpand::getTaskId, (Object)req.getTaskId())).in(!org.springframework.util.CollectionUtils.isEmpty(depIds), InspectionTaskExpand::getDeptId, depIds)).eq(req.getStatus() != null, InspectionTaskExpand::getStatus, (Object)req.getStatus())).between(Optional.ofNullable(req.getStartTime()).isPresent() && Optional.ofNullable(req.getEndTime()).isPresent(), InspectionTaskExpand::getFinishTime, (Object)req.getStartTime(), (Object)req.getEndTime());
        if (Optional.ofNullable(req.getExpireExcute()).isPresent()) {
            wrapper.eq(InspectionTaskExpand::getExecuteExpire, (Object)req.getExpireExcute());
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(page = this.inspectionTaskExpandService.page((IPage)new Page((long)req.getPageNumber().intValue(), (long)req.getPageSize().intValue()), (Wrapper)wrapper)).getRecords())) {
            return new Page();
        }
        respList = ClazzConverterUtils.converterClass((Collection)page.getRecords(), InspectionPlanDtoResp.class);
        expandMap = page.getRecords().stream().collect(Collectors.toMap(InspectionTaskExpand::getId, Function.identity()));
        List<Integer> collect = page.getRecords().stream().map(InspectionTaskExpand::getDeptId).distinct().collect(Collectors.toList());
        deptNameMap = this.departProxy.getDeptNameMap(collect);
        expandIds = expandMap.keySet().stream().collect(Collectors.toList());
        Map<Object, Object> tagMap = new HashMap();
        List tagDtos = this.inspectionTagMapper.getListByTaskId(req.getTaskId(), user.getGroupId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagDtos)) {
            tagMap = tagDtos.stream().collect(Collectors.groupingBy(InspectionTagDto::getExpandId));
        }
        Map<Object, Object> tempMap = new HashMap();
        List list1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)req.getTaskId())).eq(IsInspectionDeptTemplate::getGroupId, (Object)user.getGroupId())).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list1)) {
            tempMap = list1.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.toMap(IsInspectionDeptTemplate::getTemplateId, Function.identity())));
        }
        InspectionPlanTaskSecondOpenReq secondOpenReq = new InspectionPlanTaskSecondOpenReq();
        secondOpenReq.setDetailIds(expandIds);
        secondOpenReq.setPageSize(null);
        secondOpenReq.setPageNumber(null);
        planDto = this.inspectionPlanProxyService.secondWebList(secondOpenReq);
        Map<Object, Object> collect2 = new HashMap();
        Map<Object, Object> liveSecondsTotal = new HashMap();
        if (planDto != null) {
            for (InspectionPlanDto dto : planDto.getData()) {
                InspectionTaskExpand expand = (InspectionTaskExpand)expandMap.get((int)dto.getDetailId());
                if (tempMap.get(expand.getId()) != null && ((Map)tempMap.get(expand.getId())).get(dto.getTemplateId()) != null) {
                    dto.setExecuteExpire(dto.getFinishTime().after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode());
                    dto.setStatus(((IsInspectionDeptTemplate)((Map)tempMap.get(expand.getId())).get(dto.getTemplateId())).getIsRead());
                    dto.setReason(((IsInspectionDeptTemplate)((Map)tempMap.get(expand.getId())).get(dto.getTemplateId())).getReason());
                    dto.setExpectTimeStr(DateUtil.format((Date)expand.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
                    continue;
                }
                dto.setExecuteExpire(expand.getExecuteExpire());
                dto.setStatus(expand.getStatus());
                dto.setExpectTimeStr(DateUtil.format((Date)expand.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            }
            collect2 = planDto.getData().stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId));
            liveSecondsTotal = planDto.getData().stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId, Collectors.summingLong(InspectionPlanDto::getLiveSeconds)));
        }
        for (InspectionPlanDtoResp resp : respList) {
            resp.setData((List)collect2.get(resp.getId()));
            resp.setLiveSeconds(liveSecondsTotal.get(resp.getId()) != null ? ((Long)liveSecondsTotal.get(resp.getId())).intValue() : 0);
            resp.setTags((List)tagMap.get(resp.getId()));
            resp.setDeptName((String)deptNameMap.get(resp.getDeptId()));
            resp.setStatusDesc(InspectionTaskExpandStatusEnum.formatOrNull((Integer)resp.getStatus()).getDesc());
            resp.setExecuteExpire(resp.getLiveSeconds() > 0 ? resp.getExecuteExpire() : null);
            resp.setExpectTimeStr(DateUtil.format((Date)resp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
        }
        Page respIPage = new Page();
        BeanUtils.copyProperties((Object)page, (Object)respIPage);
        respIPage.setRecords(respList);
        return respIPage;
    }

    @Override
    public Object getPlanList(Users user, PageReq req) {
        Map<Object, Object> tagNames = new HashMap();
        Boolean flag = false;
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        if (result.getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute())) {
            List collect = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList());
            flag = collect.contains(MainTypeEnum.INSPECTION.getCode());
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getOperatorId, (Object)user.getId())).lt(InspectionTask::getStartTime, (Object)new Date())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).in(InspectionTask::getStatus, Arrays.asList(InspectionTaskStatusEnum.PASS.getCode(), InspectionTaskStatusEnum.INSPECT.getCode()))).orderByDesc(InspectionTask::getEndTime);
        if (!flag.booleanValue()) {
            wrapper.eq(InspectionTask::getExpireStatus, (Object)ExpandExecuteExpireEnum.NOT.getCode());
        }
        IPage taskIPage = this.page((IPage)new Page((long)req.getPage().intValue(), (long)req.getPageSize().intValue()), (Wrapper)wrapper);
        Map<Object, Object> finishMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)taskIPage.getRecords())) {
            List<Integer> taskIds = taskIPage.getRecords().stream().map(InspectionTask::getId).collect(Collectors.toList());
            tagNames = this.inspectionTagService.getNameMapByTaskIds(taskIds, user.getGroupId());
            List<ExpandCountDto> dtos = this.inspectionTaskExpandService.countFinish(taskIds);
            finishMap = dtos.stream().collect(Collectors.toMap(ExpandCountDto::getExpandId, ExpandCountDto::getFinishNum));
        }
        CheckGetPlanResp resp = null;
        ArrayList<CheckGetPlanResp> resps = new ArrayList<CheckGetPlanResp>();
        for (InspectionTask record : taskIPage.getRecords()) {
            resp = new CheckGetPlanResp();
            resp.setStatus(record.getStatus());
            resp.setEndTime(record.getEndTime());
            resp.setId(record.getId());
            resp.setName(record.getName());
            resp.setStartTime(record.getStartTime());
            resp.setDepTotal(record.getTotalExpandCount());
            resp.setFinishDepTotal((Integer)finishMap.get(record.getId()));
            resp.setUnFinishDepTotal(Integer.valueOf(record.getTotalExpandCount() - resp.getFinishDepTotal()));
            resp.setTagName(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)tagNames.get(record.getId()))) ? (String)tagNames.get(record.getId()) : "");
            resps.add(resp);
        }
        Page page = new Page();
        page.setRecords(resps);
        page.setTotal(taskIPage.getTotal());
        page.setSize(taskIPage.getSize());
        page.setCurrent(taskIPage.getCurrent());
        page.setPages(taskIPage.getTotal());
        return page;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void check(List<DepartmentsExpect> list, Users user) {
        Map<Integer, String> map = this.departProxy.getDepartmentByGroupId(user.getGroupId());
        for (DepartmentsExpect expect : list) {
            boolean validDate;
            if (StringUtils.isBlank((String)expect.getDepName()) || expect.getDepId() == null) {
                throw new SysErrorException(ResultCode.DATA_ERROR, new Object[0]);
            }
            if (!map.containsKey(expect.getDepId()) || !map.containsValue(StringUtils.trim((String)expect.getDepName()))) {
                ResultCodeInfo depError = new ResultCodeInfo();
                depError.setCode(ResultCode.DEP_ERROR.getCode());
                depError.setDesc(String.format(ResultCode.DEP_ERROR.getDesc(), expect.getDepName()));
                throw new SysErrorException(depError, new Object[0]);
            }
            if (expect.getExpectTime() == null || (validDate = DateUtil.isLegalDate((int)expect.getExpectTime().length(), (String)expect.getExpectTime(), (String)DateUtil.FORMAT_SHORT))) continue;
            ResultCodeInfo depError = new ResultCodeInfo();
            depError.setCode(ResultCode.EXPECTTIME_ERROR.getCode());
            depError.setDesc(String.format(ResultCode.EXPECTTIME_ERROR.getDesc(), expect.getDepName()));
            throw new SysErrorException(depError, new Object[0]);
        }
    }

    @Override
    public GetInspectionPlanByRelatedIdResp getPlanByRelatedId(GetPlanByRelatedIdReq req) {
        InspectionTaskExpand expand = null;
        if (Objects.nonNull(req.getExpandId())) {
            expand = (InspectionTaskExpand)this.inspectionTaskExpandMapper.selectById((Serializable)req.getExpandId());
        }
        GetInspectionPlanByRelatedIdResp resp = new GetInspectionPlanByRelatedIdResp();
        if (Objects.isNull(expand)) {
            return resp;
        }
        InspectionTask inspectionTask = (InspectionTask)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getId, (Object)expand.getTaskId())).one();
        if (Objects.isNull(inspectionTask)) {
            return resp;
        }
        resp.setInspectionPlanName(inspectionTask.getName());
        return resp;
    }
}

