/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartProxy {
    private static final Logger log = LoggerFactory.getLogger(DepartProxy.class);
    @Autowired
    private DepartmentApi orgDepApi;

    public Map<Integer, String> getDeptNameMap(List<Integer> deptIdList) {
        BaseResult baseResult = this.orgDepApi.getDepartmentByIds(deptIdList);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        List data = (List)baseResult.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new HashMap<Integer, String>();
        }
        Map<Integer, String> result = data.stream().collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
        return result;
    }

    public DepartmentPojo getDepartment(Integer deptId) {
        BaseResult baseResult = this.orgDepApi.getDepartmentById(deptId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        DepartmentPojo pojo = (DepartmentPojo)baseResult.getData();
        if (pojo == null) {
            return new DepartmentPojo();
        }
        return pojo;
    }

    public List<Integer> getDeletedDepIds(Integer groupId) {
        List data = (List)this.orgDepApi.getDeletedDepListByEnterpriseId(groupId).getData();
        return data;
    }

    public Map<Integer, String> getDepartmentByGroupId(Integer groupId) {
        Map<Integer, String> map = new HashMap<Integer, String>();
        BaseResult baseResult = this.orgDepApi.getDepByEnterpriseId(groupId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            map = ((List)baseResult.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, p -> StringUtils.trim((String)p.getName())));
        }
        return map;
    }

    public Map<Integer, DepartmentPojo> getDepartments(List<Integer> deptIdList) {
        Map<Integer, Object> collect = new HashMap<Integer, DepartmentPojo>();
        log.info("\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(deptIdList));
        List pojos = (List)this.orgDepApi.getDepartmentByIds(deptIdList).getData();
        if (CollectionUtils.isEmpty((Collection)pojos)) {
            return collect;
        }
        collect = pojos.stream().collect(Collectors.toMap(DepartmentPojo::getId, Function.identity()));
        return collect;
    }

    public List<Integer> findDeptListByGroupIdAndName(Integer groupId, String depName) {
        List<Integer> depIds = new ArrayList<Integer>();
        BaseResult baseResult = this.orgDepApi.getDeptListByGroupIdAndName(groupId, depName);
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            depIds = ((List)baseResult.getData()).stream().map(DepartmentPojo::getId).collect(Collectors.toList());
        }
        return depIds;
    }
}

