/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.resp.organize.OrganzieUserResp;
import com.ovopark.utils.OkHttp3Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrganizeProxy {
    private static Logger logger = LoggerFactory.getLogger(OrganizeProxy.class);
    @Value(value="${organize.url}")
    private String organizeUrl;

    public List<Integer> getOrganzieUserIdList(List<Integer> organizeIdList, Integer groupId, Integer tokenType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("organizedIds", organizeIdList);
        logger.info("\u8bf7\u6c42\u7ec4\u7ec7\u67b6\u6784:" + JSON.toJSONString(map) + "tokenType" + tokenType + "token\u503c" + HttpContext.getContextInfoToken());
        String result = OkHttp3Util.doPost((String)this.organizeUrl, map, (String)HttpContext.getContextInfoToken(), (Integer)tokenType);
        if (result == null) {
            throw new SysErrorException(ResultCode.ORGANZIE_PROXY_ERROR, new Object[0]);
        }
        OrganzieUserResp organzieUserResp = (OrganzieUserResp)JSON.parseObject((String)result, OrganzieUserResp.class);
        if (organzieUserResp == null || organzieUserResp.isError()) {
            throw new SysErrorException(ResultCode.ORGANZIE_PROXY_ERROR, new Object[0]);
        }
        List userIdList = organzieUserResp.getData();
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return new ArrayList<Integer>();
        }
        return userIdList;
    }
}

