/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.ovopark.model.login.Users;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.api.UserApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.UsersRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userRemoteServiceImpl")
public class UsersRemoteServiceImpl
implements UsersRemoteService {
    @Resource
    private UserApi userApi;
    @Autowired
    private RoleApi roleApi;

    @Override
    public Users getById(Integer userId) {
        Users user = new Users();
        BaseResult baseResult = this.userApi.getUsersById(userId);
        if (!Objects.nonNull(baseResult.getData())) {
            return null;
        }
        UsersPojo users = (UsersPojo)baseResult.getData();
        user.setId(users.getId());
        user.setGroupId(users.getGroupId());
        user.setShowName(users.getShowName());
        user.setpId(users.getpId());
        return user;
    }

    @Override
    public List<Users> getByIds(String userIds) {
        ArrayList<Users> userList = new ArrayList<Users>();
        BaseResult result = this.userApi.getUsersListByIds(userIds);
        if (!CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return userList;
        }
        List users = (List)result.getData();
        Users user = null;
        for (UsersPojo usersPojo : users) {
            user = new Users();
            user.setId(usersPojo.getId());
            user.setGroupId(usersPojo.getGroupId());
            user.setShowName(usersPojo.getShowName());
            userList.add(user);
        }
        return userList;
    }

    @Override
    public List<RolePojo> getRoleIds(List<Integer> roles) {
        BaseResult result = this.roleApi.getRolePojoByIdList(roles);
        return (List)result.getData();
    }

    @Override
    public List<Integer> getUserIdsByRole(String roleIds, Integer groupId) {
        List<Integer> userIds = new ArrayList<Integer>();
        BaseResult result = this.userApi.getUserByRoleIds(roleIds, groupId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            userIds = ((List)result.getData()).stream().map(UsersPojo::getId).collect(Collectors.toList());
        }
        return userIds;
    }

    @Override
    public List<Users> getUserByRole(String roleIds, Integer groupId) {
        ArrayList<Users> usersPojos = new ArrayList<Users>();
        Users usersPojo = null;
        BaseResult result = this.userApi.getUserByRoleIds(roleIds, groupId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            for (UsersPojo pojo : (List)result.getData()) {
                usersPojo = new Users();
                usersPojo.setId(pojo.getId());
                usersPojo.setShowName(pojo.getShowName());
                usersPojos.add(usersPojo);
            }
        }
        return usersPojos;
    }
}

