/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.factory;

import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.service.NotificationSenderService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class NotificationSenderFactory {
    private static final Map<NotificationTypeEnum, NotificationSenderService> senders = new HashMap<NotificationTypeEnum, NotificationSenderService>();
    private final List<NotificationSenderService> senderServices;

    public NotificationSenderFactory(List<NotificationSenderService> senderServices) {
        this.senderServices = senderServices;
    }

    public static void registerSender(NotificationTypeEnum type, NotificationSenderService sender) {
        senders.put(type, sender);
    }

    public NotificationSenderService createSender(NotificationTypeEnum type) {
        NotificationSenderService sender = senders.get((Object)type);
        if (sender == null) {
            throw new IllegalArgumentException("No sender found for type: " + (Object)((Object)type));
        }
        return sender;
    }

    public NotificationSenderService getSupportedSender(BaseMessageDTO baseMessageDTO) {
        return this.senderServices.stream().filter(sender -> sender.supports(baseMessageDTO)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching sender found for message type: " + baseMessageDTO.getClass().getName()));
    }

    public <T> T invokeBuildMethod(NotificationSenderService sender, String methodName, Object messageDTO) throws Exception {
        System.out.println("Attempting to invoke method on class: " + sender.getClass().getName());
        System.out.println("MessageDTO class: " + messageDTO.getClass().getName());
        Method method = sender.getClass().getDeclaredMethod(methodName, Object.class);
        method.setAccessible(true);
        return (T)method.invoke((Object)sender, messageDTO);
    }
}

