/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.JPushMessageDTO;
import com.ovopark.service.Impl.AbstractNotificationSender;
import java.util.Collections;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JPushNotificationSenderImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(JPushNotificationSenderImpl.class);

    protected JPushNotificationSenderImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.JPUSH;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
        log.info("Start sending notification for message by JPush: {}", (Object)baseMessageDTO);
        try {
            this.validate(baseMessageDTO);
            MessageRequest message = this.buildMessage(baseMessageDTO);
            log.info("MessageRequest built successfully : {}", (Object)message);
            super.preSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            super.doSend(message);
            log.info("Message sent successfully for message DTO:{} with MessageRequest: {}", (Object)JSON.toJSONString((Object)baseMessageDTO), (Object)JSON.toJSONString((Object)message));
            super.postSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            this.handleResult(baseMessageDTO);
        }
        catch (Exception e) {
            log.error("Error sending notification", (Throwable)e);
        }
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        log.info("Validating JPush request: {}", (Object)JSON.toJSONString((Object)request));
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
    }

    @Override
    protected <T> MessageRequest buildMessage(T t) {
        log.info("Start building MessageRequest for object: {}", t);
        JPushMessageDTO jPushMessageDTO = (JPushMessageDTO)t;
        MessageRequest messageRequest = ((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)SubsBuilders.jg((String)jPushMessageDTO.getObjectType()).toUserIdList(Collections.singletonList(jPushMessageDTO.getTargetUserId()))).tagList(jPushMessageDTO.getTagList())).messageBody(jPushMessageDTO.buildMessageBody()).content(new ParamContext().plainText(jPushMessageDTO.getMessage())).mcContent(new ParamContext().plainText(jPushMessageDTO.getMessage()))).mcTitle(new ParamContext().plainText(jPushMessageDTO.getTitle()))).title(new ParamContext().plainText(jPushMessageDTO.getTitle())).mcHidden(true)).locale(Locale.CHINA)).build();
        log.info("MessageRequest built successfully: {}", (Object)JSON.toJSONString((Object)messageRequest));
        return messageRequest;
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
        log.info("Handling result for JPush request: {}", (Object)JSON.toJSONString((Object)request));
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return baseMessageDTO instanceof JPushMessageDTO;
    }
}

