/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.factory.NotificationSenderFactory;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MCRequest;
import com.ovopark.messagehub.sdk.model.MCRequestResponse;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.service.NotificationSenderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractNotificationSender
implements NotificationSenderService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractNotificationSender.class);
    private final MessageHubV2Api messageHubV2Api;

    protected AbstractNotificationSender(MessageHubV2Api messageHubV2Api) {
        this.messageHubV2Api = messageHubV2Api;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
    }

    public void afterPropertiesSet() {
        NotificationSenderFactory.registerSender(this.getType(), this);
        log.info("NotificationSender of type {} registered successfully", (Object)this.getType());
    }

    protected abstract NotificationTypeEnum getType();

    protected abstract void validate(BaseMessageDTO var1);

    protected <T> MCRequest buildMCMessage(T t) {
        throw new UnsupportedOperationException("buildMCMessage not implemented");
    }

    protected <T> MessageRequest buildMessage(T t) {
        throw new UnsupportedOperationException("buildMessage not implemented");
    }

    protected String doSend(MessageRequest request) {
        log.info("Start sending message with request: {}", (Object)request);
        BaseResult result = this.messageHubV2Api.send(request);
        if (result.getIsError().booleanValue()) {
            log.error("{},send message error: {}", (Object)this.getClass().getName(), (Object)result.getMessage());
            throw new RuntimeException("send message error");
        }
        log.info("Message sent successfully with result data: {}", result.getData());
        return (String)result.getData();
    }

    public <T> String sendMCMessage(T t, boolean async, int batchSize) {
        MCRequest mcRequest = (MCRequest)t;
        List mcRequests = mcRequest.getMessageRequestList();
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < mcRequests.size(); i += batchSize) {
            List subList = mcRequests.subList(i, Math.min(i + batchSize, mcRequests.size()));
            MCRequest mcRequestOfSub = new MCRequest();
            mcRequestOfSub.setMessageRequestList(subList);
            resultList.add(this.sendBatch(mcRequestOfSub, async));
        }
        log.info("Batch processing resultList: {}", resultList);
        return String.join((CharSequence)",", resultList);
    }

    private <T> String sendBatch(MCRequest mcRequest, boolean async) {
        if (async) {
            log.info("Sending MC message asynchronously with request: {}", (Object)mcRequest);
            BaseResult asyncResult = this.messageHubV2Api.saveMCAsync(mcRequest);
            if (asyncResult.getIsError().booleanValue()) {
                log.error("{},send sendMCMessage async error: {}", (Object)this.getClass().getName(), (Object)asyncResult.getMessage());
                throw new RuntimeException("send sendMCMessage async error");
            }
            log.info("Async MC message sent successfully with result data: {}", asyncResult.getData());
            return (String)asyncResult.getData();
        }
        log.info("Sending MC message synchronously with request: {}", (Object)mcRequest);
        BaseResult syncResult = this.messageHubV2Api.saveMCSync(mcRequest);
        if (syncResult == null || syncResult.getIsError().booleanValue() || CollectionUtil.isNotEmpty((Map)((MCRequestResponse)syncResult.getData()).getFail())) {
            log.error("Sync MC message sending failed with request: {}, error: {}", (Object)mcRequest, (Object)(syncResult != null ? syncResult.getMessage() : "Sync result is null"));
            throw new RuntimeException("send sendMCMessage sync error");
        }
        MCRequestResponse mcRequestResponse = (MCRequestResponse)syncResult.getData();
        log.info("Sync MC message sent successfully with result data: {}", syncResult.getData());
        Map success = mcRequestResponse.getSuccess();
        return Optional.ofNullable(success).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getValue() != null && ((MCRequestResponse.ID)entry.getValue()).getNumId() != null).map(entry -> entry.getKey() + "=" + ((MCRequestResponse.ID)entry.getValue()).getNumId()).collect(Collectors.joining(", "))).map(ids -> {
            log.info("Concatenated key=value pairs: {}", ids);
            return ids;
        }).orElseGet(() -> {
            log.warn("Map is empty or null");
            return "";
        });
    }

    protected void preSendLog(BaseMessageDTO request, String message) {
        log.info("Pre-send log for {}: {}", (Object)request, (Object)message);
    }

    protected void postSendLog(BaseMessageDTO request, String message) {
        log.info("Post-send log for {}: {}", (Object)request, (Object)message);
    }

    protected abstract void handleResult(BaseMessageDTO var1);
}

