/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ovopark.factory.NotificationSenderFactory;
import com.ovopark.messagehub.sdk.model.MCRequest;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.TodoMessageSaveRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageTrait;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.JPushMessageDTO;
import com.ovopark.model.dto.message.MCMessageDTO;
import com.ovopark.model.dto.message.WebSocketMessageDTO;
import com.ovopark.model.pojo.MsgToUserPojo;
import com.ovopark.service.NotificationSenderService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CompositeMessageAssembler {
    private static final Logger log = LoggerFactory.getLogger(CompositeMessageAssembler.class);
    private final NotificationSenderFactory senderFactory;

    public CompositeMessageAssembler(NotificationSenderFactory senderFactory) {
        this.senderFactory = senderFactory;
    }

    public <T> T assembleMessageRequest(List<BaseMessageDTO> messageDTOs, Boolean bulkFlag, Class<T> returnType) {
        CompositeMessage compositeMessage = this.assembleMessage(messageDTOs);
        MsgToUserPojo msgToUserPojo = this.getMsgTouserPojo(messageDTOs);
        Integer userId = msgToUserPojo.getUserId();
        MessageRequest messageRequest = this.convertToMessageRequest(compositeMessage, msgToUserPojo, userId);
        TodoMessageSaveRequest todoMessageSaveRequest = this.buildMsgSaveRequest(messageRequest, msgToUserPojo);
        return returnType.cast(todoMessageSaveRequest);
    }

    private TodoMessageSaveRequest buildMsgSaveRequest(MessageRequest messageRequest, MsgToUserPojo msgToUserPojo) {
        TodoMessageSaveRequest todoMessageSaveRequest = new TodoMessageSaveRequest();
        todoMessageSaveRequest.setMessageRequest(messageRequest);
        todoMessageSaveRequest.setTodoMsgRequestModel(this.buildRequestModel(msgToUserPojo, msgToUserPojo.getUserId()));
        return todoMessageSaveRequest;
    }

    private TodoMessageTrait.TodoMsgRequestModel buildRequestModel(MsgToUserPojo msgToUserPojo, Integer userId) {
        TodoMessageTrait.TodoMsgRequestModel todoMsgRequestModel = this.createBaseRequestModel(msgToUserPojo);
        todoMsgRequestModel.setTargetUserIdList(Collections.singletonList(userId));
        return todoMsgRequestModel;
    }

    private TodoMessageTrait.TodoMsgRequestModel createBaseRequestModel(MsgToUserPojo msgToUserPojo) {
        Date now = new Date();
        TodoMessageTrait.TodoMsgRequestModel todoMsgRequestModel = new TodoMessageTrait.TodoMsgRequestModel();
        todoMsgRequestModel.setEnterpriseId(msgToUserPojo.getGroupId());
        todoMsgRequestModel.setContent(msgToUserPojo.getMessage());
        todoMsgRequestModel.setObjectType(msgToUserPojo.getObjectType());
        todoMsgRequestModel.setCategory(msgToUserPojo.getCategory());
        todoMsgRequestModel.setObjectId(msgToUserPojo.getObjectId());
        todoMsgRequestModel.setSubId(msgToUserPojo.getSubId());
        todoMsgRequestModel.setEndTime((LocalDateTime)Optional.ofNullable(msgToUserPojo.getEndTime()).map(endTime -> LocalDateTime.ofInstant(endTime.toInstant(), ZoneId.systemDefault())).orElse(null));
        todoMsgRequestModel.setDetails(msgToUserPojo.getDetails());
        todoMsgRequestModel.setSrcUserId(msgToUserPojo.getSrcUserId());
        return todoMsgRequestModel;
    }

    private CompositeMessage assembleMessage(List<BaseMessageDTO> messageDTOs) {
        try {
            HashMap<Class, BiFunction<NotificationSenderService, BaseMessageDTO, MessageRequest>> messageTypeHandlers = new HashMap<Class, BiFunction<NotificationSenderService, BaseMessageDTO, MessageRequest>>();
            messageTypeHandlers.put(JPushMessageDTO.class, this::buildMessage);
            messageTypeHandlers.put(WebSocketMessageDTO.class, this::buildMessage);
            CompositeMessage compositeMessage = new CompositeMessage();
            for (BaseMessageDTO messageDTO : messageDTOs) {
                try {
                    NotificationSenderService sender = this.senderFactory.getSupportedSender(messageDTO);
                    if (messageTypeHandlers.containsKey(messageDTO.getClass())) {
                        MessageRequest message = (MessageRequest)((BiFunction)messageTypeHandlers.get(messageDTO.getClass())).apply(sender, messageDTO);
                        compositeMessage.addMessage(messageDTO.getClass().getSimpleName(), message);
                    } else if (messageDTO instanceof MCMessageDTO) {
                        MCRequest mcMessage = (MCRequest)this.senderFactory.invokeBuildMethod(sender, "buildMCMessage", messageDTO);
                        compositeMessage.addMessage("MCMessageDTO", mcMessage);
                    }
                    log.info("CompositeMessage built successfully: {}", (Object)compositeMessage);
                }
                catch (Exception e) {
                    log.error("Error building composite message for messageDTO: {}", (Object)messageDTO, (Object)e);
                    throw new RuntimeException("Error building composite message", e);
                }
            }
            return compositeMessage;
        }
        catch (Exception e) {
            log.error("Error building composite messages", (Throwable)e);
            throw new RuntimeException("Error building composite messages", e);
        }
    }

    private MessageRequest buildMessage(NotificationSenderService sender, BaseMessageDTO messageDTO) {
        try {
            return (MessageRequest)this.senderFactory.invokeBuildMethod(sender, "buildMessage", messageDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MessageRequest convertToMessageRequest(CompositeMessage compositeMessage, MsgToUserPojo msgToUserPojo, Integer userId) {
        log.info("Start converting CompositeMessage to MessageRequest for compositeMessage: {}", (Object)JSON.toJSONString((Object)compositeMessage));
        MessageRequest jPushMessageDTO = (MessageRequest)compositeMessage.getMessage("JPushMessageDTO");
        SubsBuilders.CompositeBuilder requestBuilder = SubsBuilders.composite((String)jPushMessageDTO.getRuleId());
        requestBuilder.toUserIdList((List)Lists.newArrayList((Object[])new Integer[]{userId}));
        compositeMessage.getMessageParts().forEach((type, messagePart) -> {
            if ("JPushMessageDTO".equals(type)) {
                log.info("Appending JPush part to MessageRequest for JPush: {}", (Object)JSON.toJSONString((Object)compositeMessage.getMessage("JPushMessageDTO")));
                MessageRequest jPushMessage = (MessageRequest)messagePart;
                ((SubsBuilders.CompositeBuilder.JGBuilder)((SubsBuilders.CompositeBuilder.JGBuilder)((SubsBuilders.CompositeBuilder.JGBuilder)((SubsBuilders.CompositeBuilder.JGBuilder)requestBuilder.jg().messageBody(jPushMessage.getJgAttach().getMessageBody())).title(jPushMessage.getJgAttach().getTitle())).content(jPushMessage.getJgAttach().getContent())).overrideToUserIdList(jPushMessage.getJgAttach().getToUserIdList())).ok();
            } else if ("WebSocketMessageDTO".equals(type)) {
                log.info("Appending WebSocket part to MessageRequest for WebSocket: {}", (Object)JSON.toJSONString((Object)compositeMessage.getMessage("WebSocketDTO")));
                MessageRequest webSocketMessage = (MessageRequest)messagePart;
                ((SubsBuilders.CompositeBuilder.WBSBuilder)((SubsBuilders.CompositeBuilder.WBSBuilder)((SubsBuilders.CompositeBuilder.WBSBuilder)((SubsBuilders.CompositeBuilder.WBSBuilder)requestBuilder.wbs().client(new String[]{"iOS", "Android"})).messageType(webSocketMessage.getWbsAttach().getMessageType())).group(new String[]{String.valueOf(webSocketMessage.getWbsAttach())})).content(webSocketMessage.getWbsAttach().getContent())).ok();
            } else if ("MCMessageDTO".equals(type)) {
                log.info("Appending MC part to MessageRequest for MC: {}", (Object)JSON.toJSONString((Object)compositeMessage.getMessage("MCMessageDTO")));
                MCRequest mcRequest = (MCRequest)messagePart;
                MessageRequest messageRequest = (MessageRequest)mcRequest.getMessageRequestList().get(0);
                ((SubsBuilders.CompositeBuilder)requestBuilder.mc().ok().mcTitle(messageRequest.getMcAttach().getTitle())).mcContent(messageRequest.getMcAttach().getContent());
            } else {
                log.warn("Unknown message type found in CompositeMessage: {}", type);
            }
        });
        ThirdMessage thirdMessage = this.buildThirdMessage(msgToUserPojo);
        ((SubsBuilders.CompositeBuilder.ThirdBuilder)requestBuilder.third().thirdMessage(thirdMessage)).ok();
        MessageRequest finalRequest = requestBuilder.build();
        log.info("Final MessageRequest built: {}", (Object)JSON.toJSONString((Object)finalRequest));
        return finalRequest;
    }

    private ThirdMessage buildThirdMessage(MsgToUserPojo msgToUserPojo) {
        ThirdMessage thirdMessage = new ThirdMessage();
        thirdMessage.setObjectType(msgToUserPojo.getObjectType());
        thirdMessage.setObjectId(msgToUserPojo.getObjectId());
        thirdMessage.setSubId(msgToUserPojo.getSubId());
        thirdMessage.setEnterpriseId(msgToUserPojo.getGroupId());
        thirdMessage.setEndTime(LocalDateTime.ofInstant(msgToUserPojo.getEndTime().toInstant(), ZoneId.systemDefault()));
        thirdMessage.setDetails(msgToUserPojo.getDetails());
        thirdMessage.setMainType(msgToUserPojo.getMainType());
        thirdMessage.setTargetUserId(msgToUserPojo.getUserId());
        thirdMessage.setCategory(msgToUserPojo.getCategory());
        thirdMessage.setDescription(msgToUserPojo.getMessage());
        thirdMessage.setJsonText(msgToUserPojo.getJsonText());
        return thirdMessage;
    }

    private MsgToUserPojo getMsgTouserPojo(List<BaseMessageDTO> messageDTOs) {
        MsgToUserPojo msgToUserPojo = messageDTOs.stream().filter(messageDTO -> messageDTO instanceof JPushMessageDTO).map(messageDTO -> ((JPushMessageDTO)messageDTO).getMsgToUserPojo()).findFirst().orElseGet(() -> messageDTOs.stream().filter(messageDTO -> messageDTO instanceof MCMessageDTO).map(messageDTO -> ((MCMessageDTO)messageDTO).getMsgToUserPojo()).findFirst().orElse(null));
        return msgToUserPojo;
    }

    public static class CompositeMessage {
        private final Map<String, Object> messageParts = new HashMap<String, Object>();

        public void addMessage(String type, Object messageRequest) {
            this.messageParts.put(type, messageRequest);
        }

        public Object getMessage(String type) {
            return this.messageParts.get(type);
        }

        public Map<String, Object> getMessageParts() {
            return this.messageParts;
        }

        public void merge(CompositeMessage other) {
            this.messageParts.putAll(other.messageParts);
        }

        public String toString() {
            return "CompositeMessage{messageParts=" + this.messageParts + '}';
        }
    }
}

