/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.constants.CommonConstants;
import com.ovopark.model.dto.ExportTaskDO;
import com.ovopark.model.dto.InspectionPlanDto;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.dto.WebDetailDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.ExportTaskStatusEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.enums.OpenEnum;
import com.ovopark.model.enums.YesEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.proxy.OssUploadMo;
import com.ovopark.model.req.InspectionConfigReq;
import com.ovopark.model.resp.InspectionPlanDtoResp;
import com.ovopark.model.resp.InspectionPlanTagDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskWebListResp;
import com.ovopark.model.resp.WebDetailResp;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.ExportTaskApi;
import com.ovopark.service.ExportService;
import com.ovopark.service.InspectionConfigService;
import com.ovopark.service.OssService;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.ExcelUtils;
import com.ovopark.utils.PoiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private ExportTaskApi exportTaskApi;
    @Autowired
    private EnterpriseGroupsApi enterpriseConfigApi;
    @Autowired
    private InspectionConfigService inspectionConfigService;

    @Override
    public void exportSecondWebList(List<InspectionPlanDtoResp> records, Users user, String fileName, Integer exportTaskId) throws Exception {
        ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
        EnterpriseConfigPojo configPojo = (EnterpriseConfigPojo)this.enterpriseConfigApi.getEnterpriseConfig(user.getGroupId()).getData();
        ExcelExportEntity colEntity = new ExcelExportEntity("\u95e8\u5e97\u540d\u79f0", (Object)"depName");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u68c0\u67e5\u65b9\u5f0f", (Object)"mainType");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        if (configPojo.getQuestionTag().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u6807\u7b7e", (Object)"tags");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        if (configPojo.getQuestionDes().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"description");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        colEntity = new ExcelExportEntity("\u95e8\u5e97\u5b8c\u6210\u72b6\u6001", (Object)"status");
        colEntity.setNeedMerge(true);
        colEntity.setWidth(20.0);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u4efb\u52a1\u6267\u884c\u603b\u65f6\u957f", (Object)"LiveSecondsTotal");
        colEntity.setNeedMerge(true);
        colEntity.setWidth(20.0);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u9884\u8ba1\u5de1\u68c0\u65e5\u671f", (Object)"expectTime");
        colEntity.setNeedMerge(true);
        colEntity.setWidth(20.0);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5b9e\u9645\u5b8c\u6210\u5de1\u68c0\u65e5\u671f", (Object)"finishTime");
        colEntity.setNeedMerge(true);
        colEntity.setWidth(20.0);
        colList.add(colEntity);
        if (StringUtils.isNotBlank((CharSequence)configPojo.getExpireExecute()) && Stream.of(configPojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode())) {
            colEntity = new ExcelExportEntity("\u95e8\u5e97\u8fc7\u671f\u6267\u884c", (Object)"executeExpire");
            colEntity.setNeedMerge(true);
            colEntity.setWidth(20.0);
            colList.add(colEntity);
        }
        ExcelExportEntity deliColGroup = new ExcelExportEntity("", (Object)"moban");
        ArrayList<ExcelExportEntity> deliColList = new ArrayList<ExcelExportEntity>();
        deliColList.add(new ExcelExportEntity("\u70b9\u68c0\u9879\u6a21\u677f", (Object)"templateName", 20));
        deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (Object)"templateStatus", 20));
        deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u6267\u884c\u65f6\u957f", (Object)"liveSeconds", 20));
        deliColList.add(new ExcelExportEntity("\u53d1\u73b0\u95ee\u9898\u6570", (Object)"totalProblemNum", 20));
        deliColList.add(new ExcelExportEntity("\u672a\u89e3\u51b3\u95ee\u9898\u6570", (Object)"problemNum", 20));
        deliColList.add(new ExcelExportEntity("\u5df2\u8fc7\u671f\u95ee\u9898\u6570", (Object)"invalidProblemNum", 20));
        deliColList.add(new ExcelExportEntity("\u5de1\u5e97\u5f00\u59cb\u65f6\u95f4", (Object)"startTime", 20));
        deliColList.add(new ExcelExportEntity("\u5de1\u5e97\u7ed3\u675f\u65f6\u95f4", (Object)"finishTime", 20));
        deliColList.add(new ExcelExportEntity("\u5de1\u5e97\u5907\u6ce8", (Object)"reason"));
        if (StringUtils.isNotBlank((CharSequence)configPojo.getExpireExecute()) && Stream.of(configPojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode())) {
            deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u8fc7\u671f\u6267\u884c", (Object)"templateExecuteExpire", 20));
        }
        deliColGroup.setList(deliColList);
        colList.add(deliColGroup);
        ArrayList list = new ArrayList();
        for (InspectionPlanDtoResp record : records) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("depName", record.getDeptName());
            valMap.put("mainType", InspectionPlanMainTypeEnum.formatOrNull((Integer)record.getMainType()).getDesc());
            valMap.put("tags", !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)record.getTags()) ? record.getTags().stream().map(InspectionTagDto::getTagName).collect(Collectors.joining(",")) : "--");
            valMap.put("description", record.getDescription());
            valMap.put("status", InspectionTaskExpandStatusEnum.PASS.getCode().equals(record.getStatus()) ? InspectionTaskExpandStatusEnum.FINISH.getDesc() : InspectionTaskExpandStatusEnum.WAIT.getDesc());
            valMap.put("LiveSecondsTotal", record.getLiveSeconds() > 0 ? DateUtil.secondsConvertToDateStr((int)record.getLiveSeconds()) : "--");
            valMap.put("expectTime", StringUtils.isNotBlank((CharSequence)record.getExpectTimeStr()) ? record.getExpectTimeStr() : "--");
            valMap.put("finishTime", record.getFinishTime() != null ? DateUtils.format((Date)record.getFinishTime(), (String)DateUtils.FORMAT_LONG) : "--");
            valMap.put("executeExpire", record.getExecuteExpire() == null ? "--" : ExpandExecuteExpireEnum.formatOrNull((Integer)record.getExecuteExpire()).getDesc());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)record.getData())) {
                ArrayList deliDetailList = new ArrayList();
                for (InspectionPlanDto recordDatum : record.getData()) {
                    HashMap<String, Object> deliValMap = new HashMap<String, Object>();
                    deliValMap.put("templateName", recordDatum.getTemplateName() != null ? recordDatum.getTemplateName() : "--");
                    deliValMap.put("templateStatus", InspectionTaskExpandStatusEnum.PASS.getCode().equals(recordDatum.getStatus()) ? InspectionTaskExpandStatusEnum.FINISH.getDesc() : InspectionTaskExpandStatusEnum.UN_FINISH.getDesc());
                    deliValMap.put("liveSeconds", recordDatum.getLiveSeconds() > 0 ? DateUtil.secondsConvertToDateStr((int)recordDatum.getLiveSeconds()) : "--");
                    deliValMap.put("totalProblemNum", recordDatum.getTotalProblemNum());
                    deliValMap.put("problemNum", recordDatum.getProblemNum());
                    deliValMap.put("invalidProblemNum", recordDatum.getInvalidProblemNum());
                    deliValMap.put("startTime", recordDatum.getStartTime() != null ? DateUtils.format((Date)recordDatum.getStartTime(), (String)DateUtils.FORMAT_LONG) : "--");
                    deliValMap.put("finishTime", recordDatum.getFinishTime() != null ? DateUtils.format((Date)recordDatum.getFinishTime(), (String)DateUtils.FORMAT_LONG) : "--");
                    deliValMap.put("templateExecuteExpire", recordDatum.getExecuteExpire() != null ? ExpandExecuteExpireEnum.formatOrNull((Integer)recordDatum.getExecuteExpire()).getDesc() : "--");
                    deliValMap.put("reason", recordDatum.getReason() != null ? recordDatum.getReason() : "--");
                    deliDetailList.add(deliValMap);
                }
                valMap.put("moban", deliDetailList);
            }
            list.add(valMap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u8be6\u60c5\u5217\u8868", "\u6570\u636e", ExcelType.HSSF), colList, list);
        this.exportReturn(workbook, fileName, exportTaskId, user.getGroupId());
    }

    @Override
    public void webList(List<InspectionPlanTaskWebListResp> records, Users user, String fileName, Integer exportTaskId) throws Exception {
        InspectionConfigReq config = this.inspectionConfigService.getInspectionConfig(user);
        ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity colEntity = new ExcelExportEntity("\u4efb\u52a1\u540d\u79f0", (Object)"NAME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u6267\u884c\u4eba", (Object)"OPERATOR");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5ba1\u6838\u4eba", (Object)"AUDIT");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        if (config.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u6807\u7b7e", (Object)"TAG");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        colEntity = new ExcelExportEntity("\u95e8\u5e97\u6570\u91cf", (Object)"DEPT_NUM");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"START_TIME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"END_TIME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u72b6\u6001", (Object)"STATUS");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5b8c\u6210\u8fdb\u5ea6", (Object)"PERCENT");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5907\u6ce8", (Object)"REMARK");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        ArrayList list = new ArrayList();
        log.info("records:{}", (Object)JSON.toJSONString(records));
        for (InspectionPlanTaskWebListResp record : records) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("NAME", record.getName());
            valMap.put("OPERATOR", record.getOperatorName());
            if (config.getQuestionTag().equals(OpenEnum.OPEN.getCode()) && CollectionUtils.isNotEmpty((Collection)record.getTagList())) {
                ArrayList<String> tagNameList = new ArrayList<String>();
                for (InspectionPlanTagDetailResp inspectionPlanTagDetailResp : record.getTagList()) {
                    tagNameList.add(inspectionPlanTagDetailResp.getTagName());
                }
                valMap.put("TAG", StringUtils.join(tagNameList, (String)","));
            }
            valMap.put("DEPT_NUM", record.getDeptNum());
            valMap.put("START_TIME", record.getStartTimeStr());
            valMap.put("END_TIME", record.getEndTimeStr());
            valMap.put("AUDIT", record.getAuditName());
            if (record.getExpireStatus().equals(YesEnum.DELETED.getCode())) {
                valMap.put("STATUS", InspectionTaskStatusEnum.EXPIRE.getDesc());
            } else {
                valMap.put("STATUS", InspectionTaskStatusEnum.format((Integer)record.getStatus()) == null ? "" : InspectionTaskStatusEnum.format((Integer)record.getStatus()).getDesc());
            }
            valMap.put("PERCENT", record.getCompletePercent());
            valMap.put("REMARK", record.getRemark());
            list.add(valMap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(CommonConstants.TASK_EXCEL_FILE_NAME, "\u6570\u636e"), colList, list);
        this.exportReturn(workbook, fileName, exportTaskId, user.getGroupId());
    }

    public void exportReturn(Workbook workbook, Integer exportTaskId, Integer groupId) throws Exception {
        String randomName = RandomUtil.randomString((int)32) + ".xls";
        String tempPath = "/extend/" + randomName;
        PoiUtil.downLoadExcelToLocalPath((Workbook)workbook, (String)tempPath);
        log.info("\u751f\u6210\u672c\u5730excel{}", (Object)tempPath);
        File file = FileUtils.getFile((String[])new String[]{tempPath});
        String url = this.ossService.uploadFile(OssUploadMo.builder().businessCode("inspection").enterprisePath(groupId).build(), file);
        ExportTaskPojo data = (ExportTaskPojo)this.exportTaskApi.getTaskById(exportTaskId).getData();
        data.setUrl(url);
        data.setStatus(ExportTaskStatusEnum.FINISH.getCode());
        log.info("\u4e0b\u8f7d\u6587\u4ef6\u4fdd\u5b58\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
        BaseResult result = this.exportTaskApi.saveExportTask(data);
        log.info("\u4e0b\u8f7d\u6587\u4ef6\u4fdd\u5b58\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{tempPath}));
    }

    private void exportReturn(Workbook workbook, String filename, Integer exportTaskId, Integer groupId) throws Exception {
        String randomName = RandomUtil.randomString((int)32) + ".xls";
        String tempPath = "./" + randomName;
        PoiUtil.downLoadExcelToLocalPath((Workbook)workbook, (String)tempPath);
        log.info("\u751f\u6210\u672c\u5730excel{}", (Object)tempPath);
        File file = FileUtils.getFile((String[])new String[]{tempPath});
        String url = this.ossService.uploadFile(OssUploadMo.builder().businessCode("inspection").enterprisePath(groupId).build(), file);
        ExportTaskPojo exportTaskPojo = (ExportTaskPojo)this.exportTaskApi.getTaskById(exportTaskId).getData();
        exportTaskPojo.setUrl(url);
        exportTaskPojo.setStatus(ExportTaskStatusEnum.FINISH.getCode());
        this.exportTaskApi.saveExportTask(exportTaskPojo);
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{tempPath}));
    }

    @Override
    public ExportTaskDO getTaskById(Integer exportTaskId) {
        ExportTaskDO taskDO = new ExportTaskDO();
        ExportTaskPojo data = (ExportTaskPojo)this.exportTaskApi.getTaskById(exportTaskId).getData();
        BeanUtils.copyProperties((Object)data, (Object)taskDO);
        return taskDO;
    }

    @Override
    public void exportWebDetails(List<WebDetailResp> records, Users user, String fileName, Integer exportTaskId) {
        SXSSFWorkbook workbook = null;
        ExportParams params = new ExportParams(CommonConstants.TASK_DETAIL_EXCEL_FILE_NAME, CommonConstants.TASK_DETAIL_EXCEL_FILE_NAME, ExcelType.XSSF);
        ArrayList<WebDetailDto> dtos = new ArrayList<WebDetailDto>();
        for (WebDetailResp record : records) {
            WebDetailDto webDetailDto = new WebDetailDto();
            webDetailDto.setOperatorName(record.getOperatorName());
            webDetailDto.setOperatorRole(record.getOperatorRole());
            webDetailDto.setOrgName(record.getOrgName());
            webDetailDto.setOperatorParentName(record.getOperatorParentName());
            webDetailDto.setTaskName(record.getTaskName());
            webDetailDto.setDepName(record.getDepName());
            webDetailDto.setShopId(record.getShopId());
            webDetailDto.setMainType(InspectionPlanMainTypeEnum.formatOrNull((Integer)record.getMainType()).getDesc());
            webDetailDto.setStatus(record.getStatus() == 1 ? InspectionTaskExpandStatusEnum.FINISH.getDesc() : InspectionTaskExpandStatusEnum.WAIT.getDesc());
            if (record.getExpectTime() != null) {
                webDetailDto.setExpectTime(DateUtils.format((Date)record.getExpectTime(), (String)DateUtils.FORMAT_LONG));
            }
            if (record.getFinishTime() != null) {
                webDetailDto.setFinishTime(DateUtils.format((Date)record.getFinishTime(), (String)DateUtils.FORMAT_LONG));
            }
            if (record.getExpectTime() != null && record.getFinishTime() != null) {
                webDetailDto.setFinishInTime(record.getFinishInTime() == 1 ? "\u662f" : "\u5426");
            }
            if (record.getExecuteExpire() != -1) {
                webDetailDto.setExecuteExpire(ExpandExecuteExpireEnum.formatOrNull((Integer)record.getExecuteExpire()).getDesc());
            }
            webDetailDto.setCreateTime(DateUtils.format((Date)record.getCreateTime(), (String)DateUtils.FORMAT_LONG));
            dtos.add(webDetailDto);
        }
        workbook = org.springframework.util.CollectionUtils.isEmpty(records) ? ExcelUtils.exportExcel(new ArrayList(), (ExportParams)params, WebDetailDto.class, (Locale)Locale.CHINA, null, null) : ExcelUtils.exportExcel(dtos, (ExportParams)params, WebDetailDto.class, (Locale)Locale.CHINA, null, null);
        try {
            this.exportReturn((Workbook)workbook, fileName, exportTaskId, user.getGroupId());
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }
}

