/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.assembler.AuditConfigAssembler;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.InspectionAuditConfigMapper;
import com.ovopark.model.enums.AuditConfigEnum;
import com.ovopark.model.enums.DeleteEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.AddAuditConfigReq;
import com.ovopark.model.req.GetAuditReq;
import com.ovopark.model.req.UpdateAuditConfigReq;
import com.ovopark.model.resp.AuditConfigVo;
import com.ovopark.model.resp.GetAuditBo;
import com.ovopark.model.resp.GetAuditResp;
import com.ovopark.po.InspectionAuditConfigModel;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.service.InspectionAuditConfigService;
import com.ovopark.service.UsersRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InspectionAuditConfigServiceImpl
extends ServiceImpl<InspectionAuditConfigMapper, InspectionAuditConfigModel>
implements InspectionAuditConfigService {
    @Autowired
    private UsersRemoteService usersRemoteService;

    @Override
    public void add(Users user, AddAuditConfigReq req) {
        InspectionAuditConfigModel model = AuditConfigAssembler.toEntity((Users)user, (AddAuditConfigReq)req);
        this.save(model);
    }

    @Override
    public void update(Users user, UpdateAuditConfigReq req) {
        InspectionAuditConfigModel one = (InspectionAuditConfigModel)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionAuditConfigModel::getId, (Object)req.getId())).eq(InspectionAuditConfigModel::getGroupId, (Object)user.getGroupId())).one();
        Optional.ofNullable(one).orElseThrow(() -> new SysErrorException(ResultCode.AUDIT_NULL, new Object[0]));
        AuditConfigAssembler.toEntity((Users)user, (InspectionAuditConfigModel)one, (UpdateAuditConfigReq)req);
        this.updateById(one);
    }

    @Override
    public boolean delete(Integer id) {
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionAuditConfigModel::getId, (Object)id)).set(InspectionAuditConfigModel::getIsDeleted, (Object)DeleteEnum.DELETED.getCode())).update();
    }

    @Override
    public List<AuditConfigVo> get(Users user) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionAuditConfigModel::getGroupId, (Object)user.getGroupId())).eq(InspectionAuditConfigModel::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).orderByDesc(InspectionAuditConfigModel::getUpdateTime)).list();
        ArrayList<AuditConfigVo> vos = new ArrayList<AuditConfigVo>();
        AuditConfigVo vo = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (InspectionAuditConfigModel model : list) {
                vo = new AuditConfigVo();
                this.assembleAuditConfig(vo, model);
                vos.add(vo);
            }
        }
        return vos;
    }

    private void assembleAuditConfig(AuditConfigVo vo, InspectionAuditConfigModel model) {
        vo.setId(model.getId());
        vo.setAuditType(model.getAuditType());
        vo.setOperatorType(model.getOperatorType());
        AuditConfigEnum configEnum = AuditConfigEnum.formatOrNull((Integer)model.getOperatorType());
        switch (configEnum) {
            case APPOINT: {
                if (!StringUtils.isNotBlank((String)model.getOperatorId())) break;
                List<Users> users = this.usersRemoteService.getByIds(model.getOperatorId());
                vo.setOperators(users);
                break;
            }
            case ROLE: {
                if (!StringUtils.isNotBlank((String)model.getOperatorId())) break;
                List<Integer> roles = Stream.of(model.getOperatorId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                List<RolePojo> rolePojos = this.usersRemoteService.getRoleIds(roles);
                vo.setOperatorRoles(rolePojos);
            }
        }
        AuditConfigEnum auditConfigEnum = AuditConfigEnum.formatOrNull((Integer)model.getAuditType());
        switch (auditConfigEnum) {
            case APPOINT: {
                if (!StringUtils.isNotBlank((String)model.getAuditId())) break;
                List<Users> users = this.usersRemoteService.getByIds(model.getAuditId());
                vo.setAudits(users);
                break;
            }
            case ROLE: {
                if (!StringUtils.isNotBlank((String)model.getAuditId())) break;
                List<Integer> roles = Stream.of(model.getAuditId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                List<RolePojo> rolePojos = this.usersRemoteService.getRoleIds(roles);
                vo.setAuditRoles(rolePojos);
                break;
            }
        }
    }

    @Override
    public AuditConfigVo getDetail(Users user, Integer id) {
        AuditConfigVo vo = new AuditConfigVo();
        InspectionAuditConfigModel model = (InspectionAuditConfigModel)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionAuditConfigModel::getGroupId, (Object)user.getGroupId())).eq(InspectionAuditConfigModel::getId, (Object)id)).one();
        Optional.ofNullable(model).orElseThrow(() -> new SysErrorException(ResultCode.AUDIT_NULL, new Object[0]));
        this.assembleAuditConfig(vo, model);
        return vo;
    }

    @Override
    public GetAuditResp getAudit(Users user, GetAuditReq req) {
        GetAuditResp getAuditResp = new GetAuditResp();
        ArrayList<GetAuditBo> bos = new ArrayList<GetAuditBo>();
        GetAuditBo resp = null;
        InspectionAuditConfigModel one = (InspectionAuditConfigModel)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionAuditConfigModel::getId, (Object)req.getAuditConfigId())).one();
        Optional.ofNullable(one).orElseThrow(() -> new SysErrorException(ResultCode.AUDIT_NULL, new Object[0]));
        AuditConfigEnum configEnum = AuditConfigEnum.formatOrNull((Integer)one.getAuditType());
        switch (configEnum) {
            case ROLE: {
                if (!StringUtils.isNotBlank((String)one.getAuditId())) break;
                List<Users> pojos = this.usersRemoteService.getUserByRole(one.getAuditId(), user.getGroupId());
                if (CollectionUtils.isNotEmpty(pojos)) {
                    for (Users pojo : pojos) {
                        resp = new GetAuditBo();
                        resp.setId(pojo.getId());
                        resp.setName(pojo.getShowName());
                        bos.add(resp);
                    }
                }
                getAuditResp.setAuditIds(Stream.of(one.getAuditId().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
                break;
            }
            case APPOINT: {
                List<Users> usersList = this.usersRemoteService.getByIds(one.getAuditId());
                if (!CollectionUtils.isNotEmpty(usersList)) break;
                for (Users users1 : usersList) {
                    resp = new GetAuditBo();
                    resp.setId(users1.getId());
                    resp.setName(users1.getShowName());
                    bos.add(resp);
                }
                break;
            }
            case SUPERIOR: {
                Users users1 = this.usersRemoteService.getById(user.getpId());
                resp = new GetAuditBo();
                if (Objects.nonNull(users1)) {
                    resp.setName(users1.getShowName());
                    resp.setId(users1.getId());
                    bos.add(resp);
                    break;
                }
                resp.setId(user.getId());
                resp.setName(user.getShowName());
                bos.add(resp);
                break;
            }
            case SELF: {
                resp = new GetAuditBo();
                resp.setId(user.getId());
                resp.setName(user.getShowName());
                bos.add(resp);
                break;
            }
        }
        getAuditResp.setAuditType(one.getAuditType());
        getAuditResp.setList(bos);
        return getAuditResp;
    }

    @Override
    public Integer checkAudit(Users user, Integer operatorId) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionAuditConfigModel::getGroupId, (Object)user.getGroupId())).eq(InspectionAuditConfigModel::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).orderByDesc(InspectionAuditConfigModel::getUpdateTime)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (InspectionAuditConfigModel model : list) {
                AuditConfigEnum configEnum = AuditConfigEnum.formatOrNull((Integer)model.getOperatorType());
                switch (configEnum) {
                    case ALL: {
                        return model.getId();
                    }
                    case APPOINT: {
                        List operatorIds = Stream.of(model.getOperatorId().split(",")).map(Integer::parseInt).collect(Collectors.toList());
                        if (operatorIds.contains(operatorId)) {
                            return model.getId();
                        }
                    }
                    case ROLE: {
                        List<Integer> userIds = this.usersRemoteService.getUserIdsByRole(model.getOperatorId(), model.getGroupId());
                        if (!userIds.contains(operatorId)) break;
                        return model.getId();
                    }
                }
            }
        }
        return null;
    }
}

