/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.config;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class MdcThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(MdcThreadPoolTaskExecutor.class);

    public MdcThreadPoolTaskExecutor(int corePoolSize, int maxPoolSize, int keepAliveTime, int queueCapacity, String poolNamePrefix) {
        this.setCorePoolSize(corePoolSize);
        this.setMaxPoolSize(maxPoolSize);
        this.setKeepAliveSeconds(keepAliveTime);
        this.setQueueCapacity(queueCapacity);
        this.setThreadNamePrefix(poolNamePrefix);
        this.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        this.initialize();
    }

    public <T> Future<T> submit(Callable<T> task) {
        log.info("\u5b9a\u65f6\u89e6\u53d1\u7684\u5f02\u6b65\u591a\u7ebf\u7a0b...");
        Map<String, String> mdcContext = this.getMdcContext();
        return super.submit(() -> {
            try {
                this.setMdcContext(mdcContext);
                Object v = task.call();
                return v;
            }
            finally {
                this.clearMdcContext();
            }
        });
    }

    public Future<?> submit(Runnable task) {
        log.info("\u5b9a\u65f6\u89e6\u53d1\u7684\u5f02\u6b65\u591a\u7ebf\u7a0b...");
        Map<String, String> mdcContext = this.getMdcContext();
        return super.submit(() -> {
            try {
                this.setMdcContext(mdcContext);
                task.run();
            }
            finally {
                this.clearMdcContext();
            }
        });
    }

    private Map<String, String> getMdcContext() {
        return MDC.getCopyOfContextMap();
    }

    private void setMdcContext(Map<String, String> mdcContext) {
        if (mdcContext != null) {
            MDC.setContextMap(mdcContext);
        }
    }

    private void clearMdcContext() {
        MDC.clear();
    }
}

