/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.enums.OpenStatusEnum;
import com.ovopark.model.enums.ValidateStatusEnum;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.GetDepartmentManagerMapMo;
import com.ovopark.organize.common.model.mo.UserIdsAndDepIdsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartProxy {
    private static final Logger log = LoggerFactory.getLogger(DepartProxy.class);
    @Autowired
    private DepartmentApi orgDepApi;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Autowired
    private UserDepartmentApi userDepartmentApi;

    public Map<String, Integer> getDepByShopIds(List<String> shopIds, Integer groupId) {
        log.info("getDepByShopIds");
        UserIdsAndDepIdsMo mo = new UserIdsAndDepIdsMo();
        mo.setShopIds(shopIds);
        mo.setGroupId(groupId);
        BaseResult result = this.orgDepApi.getDepByShopIds(mo);
        log.info("getDepByShopIds\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ((List)result.getData()).stream().filter(e -> OpenStatusEnum.NORMAL.getCode().equals(e.getOpenStatus()) && !ValidateStatusEnum.EXPIRED.getCode().equals(e.getValidateStatus())).collect(Collectors.toMap(DepartmentPojo::getShopId, DepartmentPojo::getId));
        }
        return new HashMap<String, Integer>();
    }

    public List<Integer> getUserDeptId(Integer userId, Integer groupId) {
        List<Integer> list = new ArrayList<Integer>();
        log.info("\u83b7\u53d6\u5f53\u524d\u4eba\u6709\u6743\u9650\u7684\u95e8\u5e97\u96c6\u5408");
        BaseResult result = this.userDepPrivilegeApi.getDepIdByUserIdAndGroupId(userId, groupId);
        log.info("\u83b7\u53d6\u5f53\u524d\u4eba\u6709\u6743\u9650\u7684\u95e8\u5e97\u96c6\u5408\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            list = (List)result.getData();
        }
        return list;
    }

    public Map<Integer, String> getDeptNameMap(List<Integer> deptIdList) {
        BaseResult baseResult = this.orgDepApi.getDepartmentByIds(deptIdList);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        List data = (List)baseResult.getData();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)data)) {
            return new HashMap<Integer, String>();
        }
        Map<Integer, String> result = data.stream().collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
        return result;
    }

    public DepartmentPojo getDepartment(Integer deptId) {
        BaseResult baseResult = this.orgDepApi.getDepartmentById(deptId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        DepartmentPojo pojo = (DepartmentPojo)baseResult.getData();
        if (pojo == null) {
            return new DepartmentPojo();
        }
        return pojo;
    }

    public List<Integer> getDeletedDepIds(Integer groupId) {
        List data = (List)this.orgDepApi.getDeletedDepListByEnterpriseId(groupId).getData();
        return data;
    }

    public Map<Integer, String> getDepartmentByGroupId(Integer groupId) {
        Map<Integer, String> map = new HashMap<Integer, String>();
        BaseResult baseResult = this.orgDepApi.getDepByEnterpriseId(groupId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            map = ((List)baseResult.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, p -> StringUtils.trim((String)p.getName())));
        }
        return map;
    }

    public Map<Integer, DepartmentPojo> getDepartments(List<Integer> deptIdList) {
        Map<Integer, Object> collect = new HashMap<Integer, DepartmentPojo>();
        log.info("\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(deptIdList));
        List pojos = (List)this.orgDepApi.getDepartmentByIds(deptIdList).getData();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pojos)) {
            return collect;
        }
        collect = pojos.stream().collect(Collectors.toMap(DepartmentPojo::getId, Function.identity()));
        return collect;
    }

    public Map<Integer, String> getDepartmentsMap(List<Integer> deptIdList) {
        Map<Integer, String> collect = new HashMap<Integer, String>();
        log.info("\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(deptIdList));
        List pojos = (List)this.orgDepApi.getDepartmentByIds(deptIdList).getData();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pojos)) {
            return collect;
        }
        collect = pojos.stream().filter(e -> OpenStatusEnum.NORMAL.getCode().equals(e.getOpenStatus()) && !ValidateStatusEnum.EXPIRED.getCode().equals(e.getValidateStatus())).collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
        return collect;
    }

    public List<Integer> findDeptListByGroupIdAndName(Integer groupId, String depName) {
        List<Integer> depIds = new ArrayList<Integer>();
        BaseResult baseResult = this.orgDepApi.getDeptListByGroupIdAndName(groupId, depName);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            depIds = ((List)baseResult.getData()).stream().map(DepartmentPojo::getId).collect(Collectors.toList());
        }
        return depIds;
    }

    public Map<Integer, String> getDepNameMap(List<Integer> deptIdList) {
        Map<Integer, String> collect = new HashMap<Integer, String>();
        log.info("\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(deptIdList));
        List pojos = (List)this.orgDepApi.getDepartmentByIds(deptIdList).getData();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pojos)) {
            return collect;
        }
        collect = pojos.stream().collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
        return collect;
    }

    public Map<Integer, Map<String, String>> getManagerByDeptIds(List<Integer> depIds, Integer groupId) {
        HashMap<Integer, Map<String, String>> resultMap = new HashMap<Integer, Map<String, String>>();
        HashMap map = new HashMap();
        GetDepartmentManagerMapMo mo = new GetDepartmentManagerMapMo();
        mo.setRoleIds(Arrays.asList(3, 4));
        mo.setGroupId(groupId);
        List<List<Integer>> lists = this.splitListIntoChunks(depIds, 10);
        for (List<Integer> list : lists) {
            mo.setDeptIds(list);
            BaseResult result = this.userDepartmentApi.getManagerByDeptIds(mo);
            if (result.getIsError().booleanValue()) {
                throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
            }
            if (((Map)result.getData()).isEmpty()) continue;
            map.putAll((Map)result.getData());
        }
        for (Map.Entry entry : map.entrySet()) {
            HashMap managerMap = new HashMap();
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                List value = (List)entry1.getValue();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)value)) continue;
                managerMap.put(entry1.getKey(), value.stream().map(SimplePojo::getName).collect(Collectors.joining(",")));
            }
            resultMap.put((Integer)entry.getKey(), managerMap);
        }
        return resultMap;
    }

    private List<List<Integer>> splitListIntoChunks(List<Integer> list, int chunkSize) {
        ArrayList<List<Integer>> chunks = new ArrayList<List<Integer>>();
        for (int i = 0; i < list.size(); i += chunkSize) {
            int end = Math.min(list.size(), i + chunkSize);
            chunks.add(new ArrayList<Integer>(list.subList(i, end)));
        }
        return chunks;
    }
}

