/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.CheckInternalOpenApi;
import com.ovopark.check.R;
import com.ovopark.check.vos.ActivityTrackPeriodSum;
import com.ovopark.check.vos.ActivityTrackSearchInfo;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.proxy.UsersDeptTime;
import com.ovopark.service.CheckService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckServiceImpl
implements CheckService {
    private static final Logger log = LoggerFactory.getLogger(CheckServiceImpl.class);
    @Autowired
    private CheckInternalOpenApi checkInternalOpenApi;

    @Override
    public Map<UsersDeptTime, Integer> getUsersDeptTimeSummary(List<Integer> userIds, List<Integer> depIds, String startTime, String endTime, Integer groupId) {
        log.info("\u83b7\u53d6\u7528\u6237\u90e8\u95e8\u65f6\u95f4\u6c47\u603b");
        Map<UsersDeptTime, Integer> map = new HashMap<UsersDeptTime, Integer>();
        log.info("userIds:{},depIds:{},startTime:{},endTime:{}", new Object[]{userIds, depIds, startTime, endTime});
        if (CollectionUtils.isEmpty(userIds) || CollectionUtils.isEmpty(depIds) || startTime == null || endTime == null) {
            log.error("\u53c2\u6570\u9519\u8bef");
            return map;
        }
        try {
            ActivityTrackSearchInfo activityTrackSearchInfo = new ActivityTrackSearchInfo();
            activityTrackSearchInfo.setUserIds(userIds);
            activityTrackSearchInfo.setDeptIds(depIds);
            activityTrackSearchInfo.setStartDateTime(startTime);
            activityTrackSearchInfo.setEndDateTime(endTime);
            activityTrackSearchInfo.setEnterpriseId(groupId);
            R r = this.checkInternalOpenApi.getUsersDeptTimeSummary(activityTrackSearchInfo);
            log.info("\u83b7\u53d6\u7528\u6237\u90e8\u95e8\u65f6\u95f4\u6c47\u603b\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)r));
            if (r.getIsError().booleanValue()) {
                log.error("\u83b7\u53d6\u7528\u6237\u90e8\u95e8\u65f6\u95f4\u6c47\u603b\u5931\u8d25");
                throw new SysErrorException(ResultCode.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            map = ((List)r.getData()).stream().collect(Collectors.toMap(activityTrackPeriodSum -> UsersDeptTime.builder().userId(activityTrackPeriodSum.getUserId()).deptId(activityTrackPeriodSum.getDeptId()).date(activityTrackPeriodSum.getDate()).build(), ActivityTrackPeriodSum::getSeconds));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u90e8\u95e8\u65f6\u95f4\u6c47\u603b\u5f02\u5e38", (Throwable)e);
        }
        return map;
    }
}

