/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.CommonConfigMapper;
import com.ovopark.model.dto.CommonConfigDto;
import com.ovopark.model.enums.CommonConfigEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.LimitAuditConfigReq;
import com.ovopark.po.CommonConfig;
import com.ovopark.service.CommonConfigService;
import com.ovopark.service.EnterpriseConfigService;
import com.ovopark.strategy.ConfigStrategy;
import com.ovopark.strategy.ConfigStrategyFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonConfigServiceImpl
extends ServiceImpl<CommonConfigMapper, CommonConfig>
implements CommonConfigService {
    private static final Logger log = LoggerFactory.getLogger(CommonConfigServiceImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private EnterpriseConfigService enterpriseConfigService;

    @Override
    public void addCommonConfigReq(Users user, List<CommonConfigDto> list) {
        if (Objects.isNull(user)) {
            log.error("user is null");
            return;
        }
        Map configMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CommonConfig::getGroupId, (Object)user.getGroupId())).in(CommonConfig::getConfigKey, (Collection)list.stream().map(CommonConfigDto::getConfigKey).collect(Collectors.toList()))).list().stream().collect(Collectors.toMap(CommonConfig::getConfigKey, Function.identity()));
        for (CommonConfigDto dto : list) {
            CommonConfig config = Optional.ofNullable(configMap.get(dto.getConfigKey())).orElse(new CommonConfig());
            config.setGroupId(user.getGroupId());
            config.setConfigKey(dto.getConfigKey());
            config.setConfigValue(dto.getConfigValue());
            this.saveOrUpdate(config);
        }
    }

    @Override
    public Map<String, String> getAllCommonConfig(Integer groupId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CommonConfig::getGroupId, (Object)groupId)).list();
        ConfigStrategyFactory factory = new ConfigStrategyFactory();
        for (CommonConfig c : list) {
            if (CommonConfigEnum.LIMIT_AUDIT.getKey().equals(c.getConfigKey())) continue;
            map.put(c.getConfigKey(), c.getConfigValue());
        }
        map.putIfAbsent(CommonConfigEnum.REASON_MUST.getKey(), factory.getStrategy(CommonConfigEnum.REASON_MUST.getKey()).getConfigValue(null));
        map.putIfAbsent(CommonConfigEnum.TEMPLATE_MUST.getKey(), factory.getStrategy(CommonConfigEnum.TEMPLATE_MUST.getKey()).getConfigValue(null));
        map.putIfAbsent(CommonConfigEnum.UPDATE_TIME.getKey(), factory.getStrategy(CommonConfigEnum.UPDATE_TIME.getKey()).getConfigValue(null));
        return map;
    }

    @Override
    public String getEnterpriseConfig(Integer groupId, String configKey) {
        if (StringUtils.isBlank((CharSequence)configKey)) {
            throw new SysErrorException(ResultCode.PARAM_ERROR, new Object[0]);
        }
        CommonConfig config = (CommonConfig)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CommonConfig::getGroupId, (Object)groupId)).eq(CommonConfig::getConfigKey, (Object)configKey)).one();
        ConfigStrategyFactory factory = new ConfigStrategyFactory();
        ConfigStrategy strategy = factory.getStrategy(configKey);
        return strategy.getConfigValue(config);
    }

    @Override
    public void addLimitAuditConfig(Users user, LimitAuditConfigReq req) {
        if (Objects.isNull(user)) {
            log.error("user is null");
            return;
        }
        CommonConfig commonConfig = (CommonConfig)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CommonConfig::getGroupId, (Object)user.getGroupId())).eq(CommonConfig::getConfigKey, (Object)CommonConfigEnum.LIMIT_AUDIT.getKey())).one()).orElse(new CommonConfig());
        commonConfig.setGroupId(user.getGroupId());
        commonConfig.setUserId(user.getId());
        commonConfig.setConfigKey(CommonConfigEnum.LIMIT_AUDIT.getKey());
        try {
            if (Objects.nonNull(req)) {
                String configValue = OBJECT_MAPPER.writeValueAsString((Object)req);
                commonConfig.setConfigValue(configValue);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.saveOrUpdate(commonConfig);
    }
}

