/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.JPushMessageDTO;
import com.ovopark.model.dto.message.MCMessageDTO;
import com.ovopark.model.dto.message.ThirdMessageDTO;
import com.ovopark.model.dto.message.WebSocketMessageDTO;
import com.ovopark.service.Impl.JPushNotificationSenderImpl;
import com.ovopark.service.Impl.MCMessageServiceImpl;
import com.ovopark.service.Impl.ThirdMessageNotificationSenderImpl;
import com.ovopark.service.Impl.WebsocketNotificationSenderImpl;
import com.ovopark.service.NotificationSenderService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class CompositeNotificationSenderImpl {
    private static final Logger log = LoggerFactory.getLogger(CompositeNotificationSenderImpl.class);
    private List<NotificationSenderService> senders = new ArrayList<NotificationSenderService>();

    public void add(NotificationSenderService sender) {
        this.senders.add(sender);
    }

    public List<NotificationSenderService> getSenders() {
        return this.senders;
    }

    public void sendNotification(List<BaseMessageDTO> messageDTOList) {
        for (BaseMessageDTO messageDTO : messageDTOList) {
            for (NotificationSenderService sender : this.senders) {
                if (sender instanceof WebsocketNotificationSenderImpl && messageDTO instanceof WebSocketMessageDTO || sender instanceof JPushNotificationSenderImpl && messageDTO instanceof JPushMessageDTO || sender instanceof MCMessageServiceImpl && messageDTO instanceof MCMessageDTO || sender instanceof ThirdMessageNotificationSenderImpl && messageDTO instanceof ThirdMessageDTO) {
                    sender.sendNotification(messageDTO);
                    continue;
                }
                log.warn("No matching sender found for message type: {}", (Object)messageDTO.getClass().getName());
            }
        }
    }
}

