/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.ResultCodeInfo;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.login.Users;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigSavePojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.service.EnterpriseConfigService;
import com.ovopark.service.MenusPrivilegesService;
import com.ovopark.utils.ClazzConverterUtils;
import com.ovopark.utils.ListUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseConfigServiceImpl
implements EnterpriseConfigService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseConfigServiceImpl.class);
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private MenusPrivilegesService menusPrivilegesService;

    @Override
    public EnterpriseConfigPojo selectOne(Integer groupId) {
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfigByRedis(groupId);
        log.info("\u4e2a\u6027\u5316\u914d\u7f6e\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)result));
        if (result.getData() != null) {
            return (EnterpriseConfigPojo)result.getData();
        }
        return null;
    }

    @Override
    public List<EnterpriseConfigPojo> list() {
        BaseResult enterpriseConfig = this.enterpriseGroupsApi.getAllEnterpriseConfig();
        log.info("\u4e2a\u6027\u5316\u914d\u7f6e\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)enterpriseConfig));
        if (enterpriseConfig.getData() != null) {
            return (List)enterpriseConfig.getData();
        }
        return null;
    }

    @Override
    public void updateStorePlaneParam(EnterpriseConfigSavePojo enterpriseConfig) {
        this.enterpriseGroupsApi.saveEnterpriseConfigPojo(enterpriseConfig);
    }

    @Override
    public boolean CheckDate(Users user) {
        EnterpriseConfigPojo enterpriseConfigPojo = this.selectOne(user.getGroupId());
        if (enterpriseConfigPojo == null) {
            return true;
        }
        log.info("\u4e2a\u6027\u5316\u914d\u7f6e\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)enterpriseConfigPojo));
        if (enterpriseConfigPojo.getIsScheduledPlans() != null && enterpriseConfigPojo.getIsScheduledPlans().equals(DefaultEnum.DEFAULT_TRUE.getCode()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)enterpriseConfigPojo.getIsScheduledPlansDays()) && enterpriseConfigPojo.getIsScheduledPlansDays() != null && !Stream.of(enterpriseConfigPojo.getIsScheduledPlansDays().split(",")).map(Integer::parseInt).distinct().collect(Collectors.toList()).contains(new Date().getDate())) {
            String strings = Stream.of(enterpriseConfigPojo.getIsScheduledPlansDays().split(",")).map(Integer::parseInt).distinct().sorted().map(String::valueOf).collect(Collectors.joining("\u53f7,"));
            ResultCodeInfo error = new ResultCodeInfo(ResultCode.DATA_NOT_FOUND.getCode(), ResultCode.DATA_NOT_FOUND.getMessage(), String.format(ResultCode.DATA_NOT_FOUND.getDesc(), strings));
            throw new SysErrorException(error, new Object[0]);
        }
        this.menusPrivilegesService.checkPlanPrivilege(user);
        return true;
    }

    @Override
    public Boolean checkExpireExecute(Integer groupId, List<Integer> mainTypes) {
        Boolean pushFlag = false;
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfigByRedis(groupId);
        if (Objects.nonNull(result.getData())) {
            EnterpriseConfigPojo enterpriseConfig = (EnterpriseConfigPojo)ClazzConverterUtils.converterClass((Object)result.getData(), EnterpriseConfigPojo.class);
            log.info(groupId + ",\u4e2a\u6027\u5316\u914d\u7f6e\u8fd4\u56de:" + JSONObject.toJSONString((Object)enterpriseConfig));
            if (Objects.nonNull(enterpriseConfig) && StringUtils.isNotBlank((String)enterpriseConfig.getExpireExecute())) {
                List expireList = ListUtils.stringToList((String)enterpriseConfig.getExpireExecute());
                pushFlag = expireList.containsAll(mainTypes);
            }
        }
        return pushFlag;
    }
}

