/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.google.common.collect.Lists;
import com.ovopark.api.UserApi;
import com.ovopark.builder.InspectionTaskBuilder;
import com.ovopark.config.redis.DistributedDelayedQueue;
import com.ovopark.constants.LogConstant;
import com.ovopark.constants.MessageConstant;
import com.ovopark.delayqueue.RemindsTaskListener;
import com.ovopark.delayqueue.TaskEndLister;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.ResultCodeInfo;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.InspectionAuditConfigFirstVersionMapper;
import com.ovopark.mapper.InspectionAuditReasonMapper;
import com.ovopark.mapper.InspectionDeptTagMapper;
import com.ovopark.mapper.InspectionOperatorLogMapper;
import com.ovopark.mapper.InspectionTagMapper;
import com.ovopark.mapper.InspectionTaskExpandMapper;
import com.ovopark.mapper.InspectionTaskMapper;
import com.ovopark.mapper.IsInspectionDeptTemplateMapper;
import com.ovopark.model.base.EntityBase;
import com.ovopark.model.cache.CachedInspectionInfo;
import com.ovopark.model.dto.DepTemplateDto;
import com.ovopark.model.dto.DetailDto;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.dto.ExpandDepTemplateDto;
import com.ovopark.model.dto.ExpandDetailAddDto;
import com.ovopark.model.dto.ExplandExpectTime;
import com.ovopark.model.dto.GroupExpandDetailDto;
import com.ovopark.model.dto.InspectionPlanDto;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.dto.MainAndDesc;
import com.ovopark.model.dto.TaskAndAuditDto;
import com.ovopark.model.dto.UpdateTimesDto;
import com.ovopark.model.enums.CommonConfigEnum;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.DeleteEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.ExpireStatusEnum;
import com.ovopark.model.enums.GroupBy;
import com.ovopark.model.enums.InspectionPlanExpressionEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.enums.MessageObjectEnum;
import com.ovopark.model.enums.OpenEnum;
import com.ovopark.model.enums.OpenStatusEnum;
import com.ovopark.model.enums.OperatorActionEnum;
import com.ovopark.model.enums.OperatorTypeEnum;
import com.ovopark.model.enums.ReleateTypeEnum;
import com.ovopark.model.enums.StorePlanOrderDescEnum;
import com.ovopark.model.enums.StorePlanOrderWebColumnEnum;
import com.ovopark.model.enums.YesEnum;
import com.ovopark.model.event.TaskEndEvent;
import com.ovopark.model.login.Users;
import com.ovopark.model.proxy.UsersDeptTime;
import com.ovopark.model.req.CheckTemplateVoReq;
import com.ovopark.model.req.ExpandAddReq;
import com.ovopark.model.req.ExpandDetailDto;
import com.ovopark.model.req.ExpandUpdateReq;
import com.ovopark.model.req.GetFinishPerByOrganizeIdsReq;
import com.ovopark.model.req.GetPlanByRelatedIdReq;
import com.ovopark.model.req.InspectionConfigReq;
import com.ovopark.model.req.InspectionLastTimeReq;
import com.ovopark.model.req.InspectionPlanAppExpandReq;
import com.ovopark.model.req.InspectionPlanTagAddReq;
import com.ovopark.model.req.InspectionPlanTaskAddReq;
import com.ovopark.model.req.InspectionPlanTaskAppListReq;
import com.ovopark.model.req.InspectionPlanTaskAppLogListReq;
import com.ovopark.model.req.InspectionPlanTaskAuditReq;
import com.ovopark.model.req.InspectionPlanTaskCallBackReq;
import com.ovopark.model.req.InspectionPlanTaskDeleteReq;
import com.ovopark.model.req.InspectionPlanTaskDetailReq;
import com.ovopark.model.req.InspectionPlanTaskExpireReq;
import com.ovopark.model.req.InspectionPlanTaskPartionWebListReq;
import com.ovopark.model.req.InspectionPlanTaskSecondOpenReq;
import com.ovopark.model.req.InspectionPlanTaskSecondReq;
import com.ovopark.model.req.InspectionPlanTaskUpdateReq;
import com.ovopark.model.req.InspectionPlanTaskUrgedReq;
import com.ovopark.model.req.InspectionPlanTaskWebListReq;
import com.ovopark.model.req.InspectionPlanWebExpandReq;
import com.ovopark.model.req.InspectionTashFinishPerTop;
import com.ovopark.model.req.InspectionTaskCountReq;
import com.ovopark.model.req.InspectionTaskWillOutTimeReq;
import com.ovopark.model.req.LimitAuditConfigReq;
import com.ovopark.model.req.PageReq;
import com.ovopark.model.req.ShopInspectionInfo;
import com.ovopark.model.req.StorePlanDescReq;
import com.ovopark.model.req.TaskNameReq;
import com.ovopark.model.resp.AuditConfigVo;
import com.ovopark.model.resp.CalendarResp;
import com.ovopark.model.resp.CheckGetPlanResp;
import com.ovopark.model.resp.GetFinishPerByOrganizeIdsResp;
import com.ovopark.model.resp.GetInspectionPlanByRelatedIdResp;
import com.ovopark.model.resp.IdAndName;
import com.ovopark.model.resp.ImportDepartResp;
import com.ovopark.model.resp.InspectionPlanDtoResp;
import com.ovopark.model.resp.InspectionPlanPersonlyResp;
import com.ovopark.model.resp.InspectionPlanTagDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskAppListResp;
import com.ovopark.model.resp.InspectionPlanTaskAppLogListResp;
import com.ovopark.model.resp.InspectionPlanTaskAuditReasonResp;
import com.ovopark.model.resp.InspectionPlanTaskDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListCountResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListInnerResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebListResp;
import com.ovopark.model.resp.InspectionPlanTemplateDetailResp;
import com.ovopark.model.resp.InspectionTaskByGroupResp;
import com.ovopark.model.resp.InspectionTaskCountResp;
import com.ovopark.model.resp.InspectionTaskPerByGroupId;
import com.ovopark.model.resp.InspectionTaskWillOutTimeResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.model.resp.ShopInspectionInfoForMobile;
import com.ovopark.model.resp.StorePlanNameAndId;
import com.ovopark.model.resp.StorePlanNameAndIdDto;
import com.ovopark.model.utilsModel.DepartmentsExpect;
import com.ovopark.model.utilsModel.DepartmentsExport;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.SimpleUserMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import com.ovopark.po.CommonConfig;
import com.ovopark.po.DeleteMessagesByObject;
import com.ovopark.po.DeleteMessagesByObjectBuilder;
import com.ovopark.po.InspectionAuditConfigFirstVersionModel;
import com.ovopark.po.InspectionAuditReason;
import com.ovopark.po.InspectionDeptTag;
import com.ovopark.po.InspectionOperatorLog;
import com.ovopark.po.InspectionTag;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskCcModel;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.po.IsCheckTemplate;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.proxy.DepartProxy;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.proxy.OrganizeProxy;
import com.ovopark.proxy.XxlJobProxy;
import com.ovopark.service.CheckService;
import com.ovopark.service.CommonConfigService;
import com.ovopark.service.DeviceService;
import com.ovopark.service.EnterpriseConfigService;
import com.ovopark.service.InspectionAuditConfigService;
import com.ovopark.service.InspectionConfigService;
import com.ovopark.service.InspectionDeptTagService;
import com.ovopark.service.InspectionLastTimeCacheService;
import com.ovopark.service.InspectionPlanProxyService;
import com.ovopark.service.InspectionTagService;
import com.ovopark.service.InspectionTaskCcService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsCheckTemplateService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.service.MenusPrivilegesService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.si.client.R;
import com.ovopark.si.client.api.ShopInspectionApi;
import com.ovopark.si.client.cmd.DepLastInspDateQry;
import com.ovopark.strategy.ConfigStrategy;
import com.ovopark.strategy.ConfigStrategyFactory;
import com.ovopark.utils.BigDecimalUtils;
import com.ovopark.utils.ClazzConverterUtils;
import com.ovopark.utils.DaoUtils;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DiffUtil;
import com.ovopark.utils.InspectionUtils;
import com.ovopark.utils.ListUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionTaskServiceImpl<planPersonly>
extends ServiceImpl<InspectionTaskMapper, InspectionTask>
implements InspectionTaskService {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskServiceImpl.class);
    @Autowired
    private InspectionPlanProxyService inspectionPlanProxyService;
    @Autowired
    private InspectionTaskMapper inspectionTaskMapper;
    @Autowired
    InspectionTaskExpandMapper inspectionTaskExpandMapper;
    @Autowired
    InspectionDeptTagMapper inspectionDeptTagMapper;
    @Autowired
    IsInspectionDeptTemplateMapper isInspectionDeptTemplateMapper;
    @Autowired
    IsCheckTemplateService isCheckTemplateService;
    @Autowired
    InspectionTagMapper inspectionTagMapper;
    @Autowired
    InspectionTagService inspectionTagService;
    @Autowired
    private IsInspectionDeptTemplateService isInspectionDeptTemplateService;
    @Autowired
    InspectionAuditReasonMapper inspectionAuditReasonMapper;
    @Autowired
    InspectionAuditConfigFirstVersionMapper inspectionAuditConfigFirstVersionMapper;
    @Autowired
    InspectionOperatorLogMapper inspectionOperatorLogMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private IsInspectionDeptTemplateService inspectionDeptTemplateService;
    @Autowired
    private UserDepartmentApi userDepartmentApi;
    @Autowired
    private InspectionDeptTagService inspectionDeptTagService;
    @Autowired
    private InspectionTaskExpandService inspectionTaskExpandService;
    @Autowired
    private InspectionConfigService inspectionConfigService;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private InspectionTaskCcService inspectionTaskCcService;
    @Autowired
    private DistributedDelayedQueue distributedDelayedQueue;
    @Autowired
    XxlJobProxy xxlJobProxy;
    @Autowired
    DepartProxy departProxy;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    OrganizeProxy organizeProxy;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseConfigService enterpriseConfigService;
    @Autowired
    private MenusPrivilegesService menusPrivilegesService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private CommonConfigService commonConfigService;
    @Autowired
    private ShopInspectionApi shopInspectionApi;
    @Autowired
    private CheckService checkService;
    public static final String INSPECTION_PLAN = "inspection-plan";
    @Autowired
    private InspectionLastTimeCacheService cacheService;
    @Autowired
    private InspectionAuditConfigService auditConfigService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> add(InspectionPlanTaskAddReq req, Users user) {
        LimitAuditConfigReq limitAuditConfigReq;
        AuditConfigVo vo;
        Date date = new Date();
        if (req.getStatus() == 1 && req.getStartTime().before(DateUtil.getStartTimeOfDay((Date)date))) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_START_TIME_ERROR, new Object[0]);
        }
        Integer uuid = 1;
        InspectionTaskBuilder builder = new InspectionTaskBuilder();
        Integer groupId = user.getGroupId();
        ArrayList<InspectionTaskExpand> targetExpandlist = new ArrayList<InspectionTaskExpand>();
        List inspectionExpandList = req.getInspectionExpandList();
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        boolean checkPlanTime = result.getData() != null && OpenStatusEnum.NORMAL.getCode().equals(((EnterpriseConfigPojo)result.getData()).getIsStoreInspectionDate());
        HashMap<Integer, MainAndDesc> expandGroupMap = new HashMap<Integer, MainAndDesc>();
        int size = 0;
        int expandGroup = 1;
        ArrayList<Integer> depIds = new ArrayList<Integer>();
        for (ExpandAddReq expandAddReq : inspectionExpandList) {
            expandGroupMap.put(expandGroup, MainAndDesc.builder().description(expandAddReq.getDescription()).mainType(expandAddReq.getMainType()).templateVoList(expandAddReq.getTemplateVos()).build());
            size += expandAddReq.getDeptModels().stream().mapToInt(deptModel -> org.springframework.util.CollectionUtils.isEmpty((Collection)deptModel.getExpectTimeStrs()) ? 1 : deptModel.getExpectTimeStrs().size()).sum();
            for (ExpandDetailAddDto deptModel2 : expandAddReq.getDeptModels()) {
                depIds.add(deptModel2.getDeptId());
                ArrayList expectTimeStrs = new ArrayList();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)deptModel2.getExpectTimeStrs())) continue;
                for (String expectTimeStr : deptModel2.getExpectTimeStrs()) {
                    InspectionTaskExpand expandReq = new InspectionTaskExpand();
                    expandReq.setExpandGroup(Integer.valueOf(expandGroup));
                    expandReq.setDeptId(deptModel2.getDeptId());
                    expandReq.setExpectTime(DateUtil.parse((String)expectTimeStr));
                    targetExpandlist.add(expandReq);
                }
            }
            ++expandGroup;
            if (req.getStatus() == 0 || !checkPlanTime || !expandAddReq.getDeptModels().stream().anyMatch(e -> org.springframework.util.CollectionUtils.isEmpty((Collection)e.getExpectTimeStrs()))) continue;
            throw new SysErrorException(ResultCode.EXPECTTIME_IS_MUST, new Object[0]);
        }
        InspectionTask task = builder.groupId(groupId).status(req.getStatus()).name(req.getName()).operatorId(user.getId()).operatorName(user.getShowName()).auditId(req.getAuditId()).auditName(req.getAuditName()).completeExpandCount(0).totalExpandCount(size).startTime(req.getStartTime()).endTime(req.getEndTime()).createTime(date).remark(req.getRemark()).build();
        EntityBase.setCreateParams((Object)task, (Users)user);
        if (result.getData() != null) {
            task.setDepChose(((EnterpriseConfigPojo)result.getData()).getDepChose());
        }
        int id = this.inspectionTaskMapper.insert((Object)task);
        if (CollectionUtils.isNotEmpty((Collection)req.getCcUserIds())) {
            this.saveTaskCopy(req.getCcUserIds(), user, date, task);
        }
        ArrayList<InspectionTaskExpand> expandList = new ArrayList<InspectionTaskExpand>();
        ArrayList<InspectionDeptTag> targetTagList = new ArrayList<InspectionDeptTag>();
        for (ExpandAddReq expandReq : inspectionExpandList) {
            this.assembleInspectionTaskExpand(expandReq, task, user, expandList, targetTagList, uuid, req.getStartTime(), req.getEndTime());
            uuid = uuid + 1;
        }
        boolean waitAudit = InspectionTaskStatusEnum.AUDIT.getCode().equals(req.getStatus());
        if (waitAudit) {
            Date endTime = task.getEndTime();
            this.assemblerEndTimeAndDelayedQueue(endTime, task.getId());
            this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.ADD_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), endTime);
        }
        HashMap<Integer, String> departmentsMap = new HashMap();
        if (InspectionTaskStatusEnum.AUDIT.getCode().equals(req.getStatus())) {
            departmentsMap = this.departProxy.getDepartmentsMap(depIds);
        }
        this.insertLog(OperatorTypeEnum.OPERTOR.getCode(), waitAudit ? OperatorActionEnum.AUDIT.getCode() : OperatorActionEnum.SAVE_DRAFT.getCode(), user, task.getId(), waitAudit ? InspectionTaskServiceImpl.assemblerLog(new ArrayList<InspectionTaskExpand>(), targetExpandlist, task, expandGroupMap, departmentsMap, new HashMap<Integer, DetailDto>(), 0, false) : "", waitAudit ? req.getRemark() : "");
        if (req.getStatus() != InspectionTaskStatusEnum.DEFAULT.getCode() && Objects.nonNull(vo = this.auditConfigService.getDetail(user, req.getAuditConfigId())) && Objects.nonNull(limitAuditConfigReq = vo.getLimitAuditConfigReq()) && Boolean.TRUE.equals(limitAuditConfigReq.getLimitAuditDisabled())) {
            Date calculatedDate = this.getDateBasedOnTimePeriodAndType(limitAuditConfigReq.getTimePeriod(), limitAuditConfigReq.getAutoAuditTimeType());
            TaskAndAuditDto taskAndAuditDto = new TaskAndAuditDto();
            taskAndAuditDto.setTaskId(task.getId());
            taskAndAuditDto.setTaskName(task.getName());
            taskAndAuditDto.setTokenType(req.getTokenType());
            taskAndAuditDto.setEndTime(task.getEndTime());
            taskAndAuditDto.setNewAuditId(limitAuditConfigReq.getChooseAuditor());
            taskAndAuditDto.setNewAuditName(limitAuditConfigReq.getChooseAuditName());
            taskAndAuditDto.setOldAuditId(task.getAuditId());
            Users oldAuditor = new Users();
            oldAuditor.setId(task.getAuditId());
            oldAuditor.setShowName(task.getAuditName());
            oldAuditor.setGroupId(user.getGroupId());
            taskAndAuditDto.setOldAuditor(oldAuditor);
            taskAndAuditDto.setUser(user);
            taskAndAuditDto.setVersion(task.getVersion());
            taskAndAuditDto.setTriggerTime(calculatedDate);
            taskAndAuditDto.setLastNow(new Date());
            if (limitAuditConfigReq.getAutoPass().booleanValue()) {
                taskAndAuditDto.setNewAuditId(null);
                this.distributedDelayedQueue.addDelayedTask(JSON.toJSONString((Object)taskAndAuditDto), calculatedDate, RemindsTaskListener.class);
                this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.LIMIT_AUDIT_NO_IMPORTANT.getCode(), taskAndAuditDto.getUser(), taskAndAuditDto.getTaskId(), LogConstant.AUTO_PASS_CREATE, null, taskAndAuditDto.getTaskId().toString(), this.calculateTimeDifference(calculatedDate), req.getAuditName());
            } else {
                if (Objects.equals(task.getAuditId(), limitAuditConfigReq.getChooseAuditor())) {
                    return JsonNewResult.success();
                }
                taskAndAuditDto.setNewAuditId(limitAuditConfigReq.getChooseAuditor());
                this.distributedDelayedQueue.addDelayedTask(JSON.toJSONString((Object)taskAndAuditDto), calculatedDate, RemindsTaskListener.class);
                this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.LIMIT_AUDIT_NO_IMPORTANT.getCode(), taskAndAuditDto.getUser(), taskAndAuditDto.getTaskId(), LogConstant.AUTO_DISTRIBUTE_CREATE, null, taskAndAuditDto.getTaskId().toString(), this.calculateTimeDifference(calculatedDate), taskAndAuditDto.getNewAuditName(), req.getAuditName());
            }
        }
        return JsonNewResult.success();
    }

    private String calculateTimeDifference(Date calculatedDate) {
        Date now = new Date();
        long differenceInMillis = calculatedDate.getTime() - now.getTime();
        if (differenceInMillis <= 0L) {
            return "\u5df2\u8d85\u65f6";
        }
        long totalMinutes = Math.round((double)differenceInMillis / 60000.0);
        long days = totalMinutes / 1440L;
        long hours = totalMinutes % 1440L / 60L;
        long minutes = totalMinutes % 60L;
        StringBuilder timeDiff = new StringBuilder();
        if (days > 0L) {
            timeDiff.append(days).append("\u5929");
        }
        if (hours > 0L) {
            timeDiff.append(hours).append("\u5c0f\u65f6");
        }
        if (minutes > 0L || timeDiff.length() == 0) {
            timeDiff.append(minutes).append("\u5206\u949f");
        }
        return timeDiff.toString();
    }

    private Date getDateBasedOnTimePeriodAndType(Integer timePeriod, Integer autoAuditTimeType) {
        if (timePeriod == null || autoAuditTimeType == null) {
            throw new IllegalArgumentException("timePeriod and autoAuditTimeType must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        switch (autoAuditTimeType) {
            case 0: {
                calendar.add(12, timePeriod);
                break;
            }
            case 1: {
                calendar.add(10, timePeriod);
                break;
            }
            case 2: {
                calendar.add(6, timePeriod);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid autoAuditTimeType. Must be 0, 1, or 2");
            }
        }
        return calendar.getTime();
    }

    private void saveTaskCopy(List<Integer> req, Users user, Date date, InspectionTask task) {
        ArrayList<InspectionTaskCcModel> models = new ArrayList<InspectionTaskCcModel>();
        for (Integer ccId : req) {
            InspectionTaskCcModel model = new InspectionTaskCcModel();
            model.setCcId(ccId).setCreateId(user.getId()).setGroupId(user.getGroupId()).setCreateTime(date).setTaskId(task.getId());
            models.add(model);
        }
        this.inspectionTaskCcService.saveBatch(models);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> udpate(InspectionPlanTaskUpdateReq req, Users user) {
        LimitAuditConfigReq limitAuditConfigReq;
        AuditConfigVo vo;
        Collection<Object> collect;
        boolean changeTime;
        InspectionTask orgTask = (InspectionTask)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getId, (Object)req.getId())).eq(InspectionTask::getVersion, (Object)req.getVersion())).oneOpt().orElseThrow(() -> new SysErrorException(ResultCode.TASK_NULL_OR_VERSION_ERROR, new Object[0]));
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        if (!orgTask.getCreateId().equals(user.getId())) {
            throw new SysErrorException(ResultCode.STORE_PLAN_HAVE_NO_PRIVILEGE, new Object[0]);
        }
        if (req.getStatus() == 1 && orgTask.getStatus() == 0 && req.getStartTime().before(DateUtil.getStartTimeOfDay((Date)new Date()))) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_START_TIME_ERROR, new Object[0]);
        }
        Integer oldStatus = orgTask.getStatus();
        String oldRemark = orgTask.getRemark();
        Integer oldAuditId = orgTask.getAuditId();
        boolean bl = changeTime = !Objects.equals(req.getStartTime(), orgTask.getStartTime()) || !Objects.equals(req.getEndTime(), orgTask.getEndTime());
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        String config = this.commonConfigService.getEnterpriseConfig(user.getGroupId(), CommonConfigEnum.UPDATE_TIME.getKey());
        log.info("dto:{}", (Object)JSON.toJSONString((Object)config));
        if (orgTask.getUpdateTimes() >= Integer.valueOf(config)) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_UPDATE_TIMES_OVER, new Object[0]);
        }
        EnterpriseConfigPojo pojo = this.enterpriseConfigService.selectOne(user.getGroupId());
        boolean checkPlanTime = pojo != null && OpenStatusEnum.NORMAL.getCode().equals(pojo.getIsStoreInspectionDate());
        for (ExpandUpdateReq expandUpdateReq : req.getInspectionExpandList()) {
            if (req.getStatus() == 0 || !checkPlanTime || !expandUpdateReq.getDeptModels().stream().anyMatch(e -> org.springframework.util.CollectionUtils.isEmpty((Collection)e.getExpectTimeStrs()))) continue;
            throw new SysErrorException(ResultCode.EXPECTTIME_IS_MUST, new Object[0]);
        }
        if (pojo.getAllowEditingApproval().equals(DefaultEnum.DEFAULT_FALSE.getCode())) {
            ResultCodeInfo resultCodeInfo = new ResultCodeInfo();
            resultCodeInfo.setCode(ResultCode.CAN_NOT_UPDATE.getCode());
            if (ExpireStatusEnum.DEFAULT_TRUE.getCode().equals(orgTask.getExpireStatus())) {
                resultCodeInfo.setDesc(String.format(ResultCode.CAN_NOT_UPDATE.getDesc(), ExpireStatusEnum.format((Integer)orgTask.getExpireStatus()).getDesc()));
                throw new SysErrorException(resultCodeInfo, new Object[0]);
            }
            if (InspectionTaskStatusEnum.canotUpdate().contains(orgTask.getStatus())) {
                resultCodeInfo.setDesc(String.format(ResultCode.CAN_NOT_UPDATE.getDesc(), InspectionTaskStatusEnum.format((Integer)orgTask.getStatus()).getDesc()));
                throw new SysErrorException(resultCodeInfo, new Object[0]);
            }
        }
        List orgExpandList = this.inspectionTaskExpandMapper.selectExpandListByTaskId(orgTask.getId(), user.getGroupId());
        ArrayList<Integer> expandIds = new ArrayList<Integer>();
        HashSet<Integer> depIds = new HashSet<Integer>();
        for (InspectionTaskExpand inspectionTaskExpand : orgExpandList) {
            depIds.add(inspectionTaskExpand.getDeptId());
            expandIds.add(inspectionTaskExpand.getId());
        }
        ArrayList<Integer> finishExpandIds = new ArrayList<Integer>();
        Map orgExpandMap = orgExpandList.stream().filter(i -> i.getStatus() == 1).collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup, Collectors.groupingBy(InspectionTaskExpand::getDeptId, Collectors.toList())));
        Integer uuid = 0;
        List collect1 = req.getInspectionExpandList().stream().filter(i -> i.getExpandGroup() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect1)) {
            uuid = ((ExpandUpdateReq)collect1.stream().max((s1, s2) -> s1.getExpandGroup().compareTo(s2.getExpandGroup())).get()).getExpandGroup();
            uuid = uuid + 1;
        }
        Map<Integer, DetailDto> groupDetailMap = this.getGroupDetailMap(orgTask.getId());
        ArrayList<InspectionTaskExpand> targetExpandlist = new ArrayList<InspectionTaskExpand>();
        List inspectionExpandList = req.getInspectionExpandList();
        HashMap<Integer, MainAndDesc> expandGroupMap = new HashMap<Integer, MainAndDesc>();
        if (CollectionUtils.isNotEmpty((Collection)inspectionExpandList)) {
            int group = uuid - 1 < 0 ? 0 : uuid - 1;
            for (ExpandUpdateReq expandUpdateReq : inspectionExpandList) {
                Integer expandGroup = expandUpdateReq.getExpandGroup() != null ? expandUpdateReq.getExpandGroup() : group;
                expandGroupMap.putIfAbsent(expandGroup, MainAndDesc.builder().description(expandUpdateReq.getDescription()).mainType(expandUpdateReq.getMainType()).templateVoList(expandUpdateReq.getTemplateVos()).build());
                for (ExpandDetailDto deptModel : expandUpdateReq.getDeptModels()) {
                    depIds.add(deptModel.getDeptId());
                    ArrayList<ExplandExpectTime> expectTimeStrs = new ArrayList<ExplandExpectTime>();
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptModel.getExpectTimeStrs())) {
                        for (ExplandExpectTime expectTimeStr : deptModel.getExpectTimeStrs()) {
                            if (expectTimeStr.isCanotDel() && expectTimeStr.getExplanId() != null) {
                                finishExpandIds.add(expectTimeStr.getExplanId());
                            }
                            InspectionTaskExpand expandReq = new InspectionTaskExpand();
                            expandReq.setExpandGroup(expandGroup);
                            expandReq.setDeptId(deptModel.getDeptId());
                            expandReq.setExpectTime(DateUtil.parse((String)expectTimeStr.getExpectTimeStr()));
                            targetExpandlist.add(expandReq);
                        }
                        continue;
                    }
                    ExplandExpectTime expectTimeStr = new ExplandExpectTime();
                    if (orgExpandMap.get(expandGroup) != null && orgExpandMap.get(expandGroup).get(deptModel.getDeptId()) != null && orgExpandMap.get(expandGroup).keySet().contains(deptModel.getDeptId())) {
                        expectTimeStr.setStatus(Integer.valueOf(1));
                        expectTimeStr.setExplanId(((InspectionTaskExpand)orgExpandMap.get(expandGroup).get(deptModel.getDeptId()).get(0)).getId());
                        expectTimeStr.setCanotDel(true);
                        expectTimeStrs.add(expectTimeStr);
                        finishExpandIds.add(expectTimeStr.getExplanId());
                    }
                    deptModel.setExpectTimeStrs(expectTimeStrs);
                    InspectionTaskExpand expandReq = new InspectionTaskExpand();
                    expandReq.setExpandGroup(expandGroup);
                    expandReq.setDeptId(deptModel.getDeptId());
                    expandReq.setExpectTime(StringUtils.isNotBlank((String)expectTimeStr.getExpectTimeStr()) ? DateUtil.parse((String)expectTimeStr.getExpectTimeStr()) : null);
                    targetExpandlist.add(expandReq);
                }
                ++group;
            }
        }
        Map<Integer, String> departmentsMap = this.departProxy.getDepartmentsMap(new ArrayList<Integer>(depIds));
        log.info("inspectionExpandList:{}", (Object)JSON.toJSONString((Object)inspectionExpandList));
        req.setRetainList(finishExpandIds);
        List deleteExpandIds = (List)CollectionUtils.subtract(expandIds, finishExpandIds);
        ArrayList<InspectionDeptTag> targetTagList = new ArrayList<InspectionDeptTag>();
        LambdaQueryWrapper deptTemplateLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getTaskId, (Object)orgTask.getId())).eq(IsInspectionDeptTemplate::getIsRead, (Object)0);
        LambdaQueryWrapper deptTagLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionDeptTag::getTaskId, (Object)orgTask.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deleteExpandIds)) {
            LambdaQueryWrapper expandLambdaQueryWrapper = new LambdaQueryWrapper();
            collect = new HashSet();
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)orgTask.getId())).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
                collect = list.stream().map(IsInspectionDeptTemplate::getExpandId).collect(Collectors.toSet());
                expandLambdaQueryWrapper.notIn(InspectionTaskExpand::getId, collect);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getRetainList())) {
                if (!org.springframework.util.CollectionUtils.isEmpty(collect)) {
                    Set<Object> finalCollect = collect;
                    ((LambdaQueryWrapper)expandLambdaQueryWrapper.and(i -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(InspectionTaskExpand::getId, (Collection)req.getRetainList())).ne(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).notIn(InspectionTaskExpand::getId, (Collection)finalCollect);
                    })).or(i -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.notIn(InspectionTaskExpand::getId, (Collection)req.getRetainList())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).notIn(InspectionTaskExpand::getId, (Collection)finalCollect);
                    });
                } else {
                    ((LambdaQueryWrapper)expandLambdaQueryWrapper.and(i -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(InspectionTaskExpand::getId, (Collection)req.getRetainList())).ne(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId());
                    })).or(i -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.notIn(InspectionTaskExpand::getId, (Collection)req.getRetainList())).eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId());
                    });
                }
            } else if (!org.springframework.util.CollectionUtils.isEmpty(collect)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)expandLambdaQueryWrapper.eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).in(InspectionTaskExpand::getId, (Collection)deleteExpandIds)).notIn(InspectionTaskExpand::getId, collect);
            } else {
                ((LambdaQueryWrapper)expandLambdaQueryWrapper.eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).in(InspectionTaskExpand::getId, (Collection)deleteExpandIds);
            }
            this.inspectionTaskExpandService.remove((Wrapper)expandLambdaQueryWrapper);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getRetainList())) {
            deptTemplateLambdaQueryWrapper.notIn(IsInspectionDeptTemplate::getExpandId, (Collection)req.getRetainList());
            deptTagLambdaQueryWrapper.notIn(InspectionDeptTag::getExpandId, (Collection)req.getRetainList());
        }
        this.inspectionDeptTemplateService.remove((Wrapper)deptTemplateLambdaQueryWrapper);
        this.inspectionDeptTagService.remove((Wrapper)deptTagLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)req.getCcUserIds())) {
            this.inspectionTaskCcService.remove((Wrapper)new LambdaQueryWrapper().eq(InspectionTaskCcModel::getTaskId, (Object)req.getId()));
            this.saveTaskCopy(req.getCcUserIds(), user, new Date(), orgTask);
        }
        for (ExpandUpdateReq expandReq : inspectionExpandList) {
            uuid = expandReq.getExpandGroup() != null ? expandReq.getExpandGroup() : uuid;
            this.assembleUpdateInspectionTaskExpand(expandReq, orgTask, user, targetTagList, uuid, req.getStartTime(), req.getEndTime());
            uuid = uuid + 1;
        }
        List<ExpandCountDto> expandCountDtoList = this.inspectionDeptTemplateService.haveNoFinish(orgTask.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty(expandCountDtoList) && !org.springframework.util.CollectionUtils.isEmpty(collect = expandCountDtoList.stream().filter(expandCountDto -> expandCountDto.getFinishNum().equals(expandCountDto.getTotalNum())).collect(Collectors.toList()))) {
            Set integers = collect.stream().map(ExpandCountDto::getExpandId).collect(Collectors.toSet());
            this.inspectionTaskExpandService.update(new InspectionTaskExpand().setStatus(InspectionTaskExpandStatusEnum.PASS.getCode()), (Wrapper)new LambdaQueryWrapper().in(InspectionTaskExpand::getId, integers));
        }
        if (orgTask.getStatus() != 0 && !orgTask.getEndTime().equals(req.getEndTime())) {
            this.xxlJobProxy.stopJob(orgTask.getJobId());
            this.assemblerEndTimeAndDelayedQueue(req.getEndTime(), orgTask.getId());
        }
        if (req.getStatus() == 1 && orgTask.getStatus() == 0) {
            this.xxlJobProxy.stopJob(orgTask.getJobId());
            this.assemblerEndTimeAndDelayedQueue(req.getEndTime(), orgTask.getId());
        }
        Integer completeExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getStatus, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).eq(InspectionTaskExpand::getExecuteExpire, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).count();
        Integer totalExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).count();
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)totalExpandCount, (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        orgTask.setUpdateTimes(Integer.valueOf(orgTask.getStatus() == 0 ? orgTask.getUpdateTimes() : orgTask.getUpdateTimes() + 1)).setName(req.getName()).setAuditId(req.getAuditId()).setAuditName(req.getAuditName()).setTotalExpandCount(totalExpandCount).setCompletePercent(percent).setCompleteExpandCount(completeExpandCount).setStartTime(req.getStartTime()).setEndTime(req.getEndTime()).setRemark(req.getRemark()).setStatus(req.getStatus());
        EntityBase.setUpdateParams((Object)orgTask, (Users)user);
        int isOk = this.inspectionTaskMapper.updateByPrimaryId(orgTask);
        if (oldStatus != 0 && req.getStatus() != 0) {
            DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getOperatorId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.DELETED.getCode()).build();
            this.messageProxy.deleteMessagesByObject(build);
            DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(oldAuditId).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.DELETED.getCode()).build();
            this.messageProxy.deleteMessagesByObject(audit);
            this.messageProxy.sendWebSocketAndJpush(orgTask.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.UPDATE_MESSAGE, user.getShowName(), orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), req.getEndTime());
        }
        if (oldStatus == 0 && req.getStatus() == 1) {
            this.messageProxy.sendWebSocketAndJpush(orgTask.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.ADD_MESSAGE, user.getShowName(), orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), req.getEndTime());
        }
        OperatorActionEnum operatorAction = OperatorActionEnum.AUDIT;
        if (oldStatus == 0 && req.getStatus() == 0) {
            operatorAction = OperatorActionEnum.UPDATE_DRAFT;
        }
        this.logOperation(OperatorTypeEnum.OPERTOR.getCode(), operatorAction.getCode(), user, orgTask, oldStatus, req.getStatus(), groupDetailMap, operatorAction.isAudit() && oldStatus == 0 ? new ArrayList() : orgExpandList, targetExpandlist, expandGroupMap, departmentsMap, req.getStatus() == 1 ? (req.getRemark().equals(oldRemark) ? "" : req.getRemark()) : "", changeTime);
        if (orgTask.getStatus() == 1 && Objects.nonNull(vo = this.auditConfigService.getDetail(user, req.getAuditConfigId())) && Objects.nonNull(limitAuditConfigReq = vo.getLimitAuditConfigReq()) && Boolean.TRUE.equals(limitAuditConfigReq.getLimitAuditDisabled())) {
            Date calculatedDate = this.getDateBasedOnTimePeriodAndType(limitAuditConfigReq.getTimePeriod(), limitAuditConfigReq.getAutoAuditTimeType());
            TaskAndAuditDto taskAndAuditDto = new TaskAndAuditDto();
            taskAndAuditDto.setTaskId(orgTask.getId());
            taskAndAuditDto.setTaskName(orgTask.getName());
            taskAndAuditDto.setTokenType(req.getTokenType());
            taskAndAuditDto.setEndTime(orgTask.getEndTime());
            taskAndAuditDto.setNewAuditId(limitAuditConfigReq.getChooseAuditor());
            taskAndAuditDto.setOldAuditId(orgTask.getAuditId());
            taskAndAuditDto.setNewAuditName(limitAuditConfigReq.getChooseAuditName());
            Users oldAuditor = new Users();
            oldAuditor.setId(orgTask.getAuditId());
            oldAuditor.setShowName(orgTask.getAuditName());
            oldAuditor.setGroupId(user.getGroupId());
            taskAndAuditDto.setOldAuditor(oldAuditor);
            taskAndAuditDto.setUser(user);
            taskAndAuditDto.setVersion(Integer.valueOf(orgTask.getVersion() + 1));
            taskAndAuditDto.setTriggerTime(calculatedDate);
            taskAndAuditDto.setLastNow(new Date());
            if (limitAuditConfigReq.getAutoPass().booleanValue()) {
                taskAndAuditDto.setNewAuditId(null);
                this.distributedDelayedQueue.addDelayedTask(JSON.toJSONString((Object)taskAndAuditDto), calculatedDate, RemindsTaskListener.class);
                this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.LIMIT_AUDIT_NO_IMPORTANT.getCode(), taskAndAuditDto.getUser(), taskAndAuditDto.getTaskId(), LogConstant.AUTO_PASS_EDIT, null, taskAndAuditDto.getTaskId().toString(), this.calculateTimeDifference(calculatedDate), req.getAuditName(), taskAndAuditDto.getVersion().toString());
            } else {
                if (Objects.equals(orgTask.getAuditId(), limitAuditConfigReq.getChooseAuditor())) {
                    return JsonNewResult.success();
                }
                taskAndAuditDto.setNewAuditId(limitAuditConfigReq.getChooseAuditor());
                this.distributedDelayedQueue.addDelayedTask(JSON.toJSONString((Object)taskAndAuditDto), calculatedDate, RemindsTaskListener.class);
                this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.LIMIT_AUDIT_NO_IMPORTANT.getCode(), taskAndAuditDto.getUser(), taskAndAuditDto.getTaskId(), LogConstant.AUTO_DISTRIBUTE_EDIT, null, taskAndAuditDto.getTaskId().toString(), this.calculateTimeDifference(calculatedDate), taskAndAuditDto.getNewAuditName(), req.getAuditName(), taskAndAuditDto.getVersion().toString());
            }
        }
        return JsonNewResult.success();
    }

    public void assemblerEndTimeAndDelayedQueue(Date time, Integer taskId) {
        if (Objects.isNull(time) || Objects.isNull(taskId)) {
            return;
        }
        TaskEndEvent event = new TaskEndEvent();
        event.setTaskId(taskId);
        this.distributedDelayedQueue.removeDelayedTask(JSON.toJSONString((Object)event), TaskEndLister.class);
        this.distributedDelayedQueue.addDelayedTask(JSON.toJSONString((Object)event), time, TaskEndLister.class);
    }

    private Map<Integer, DetailDto> getGroupDetailMap(Integer taskId) {
        Map<Integer, List<InspectionTaskExpand>> collect = this.inspectionTaskExpandMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)taskId)).stream().collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup));
        Map expandTemplateMap = ((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).list().stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.mapping(IsInspectionDeptTemplate::getTemplateId, Collectors.toList())));
        if (collect.isEmpty()) {
            return new HashMap<Integer, DetailDto>();
        }
        ArrayList<DetailDto> detailDtos = new ArrayList<DetailDto>();
        for (Map.Entry<Integer, List<InspectionTaskExpand>> entry : collect.entrySet()) {
            List<InspectionTaskExpand> value = entry.getValue();
            DetailDto detailDto = new DetailDto();
            detailDto.setExpandGroup(entry.getKey());
            detailDto.setMainType(value.get(0).getMainType());
            detailDto.setDescription(entry.getValue().get(0).getDescription());
            detailDto.setTemplateIds(expandTemplateMap.get(entry.getValue().get(0).getId()));
            detailDtos.add(detailDto);
        }
        return detailDtos.stream().collect(Collectors.toMap(DetailDto::getExpandGroup, Function.identity()));
    }

    private static String assemblerLog(List<InspectionTaskExpand> orgExpandList, List<InspectionTaskExpand> targetExpandlist, InspectionTask orgTask, Map<Integer, MainAndDesc> expandGroupMap, Map<Integer, String> departmentsMap, Map<Integer, DetailDto> groupDetailMap, Integer type, boolean changeTime) {
        Map deleteList;
        DiffUtil.DiffResult result = DiffUtil.diffList(orgExpandList, targetExpandlist, item -> item, (s1, s2) -> s1.equals(s2) ? 0 : 1);
        log.info("result:{}", (Object)JSON.toJSONString((Object)result));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageFormat.format(LogConstant.CREATE_TITLE, DateUtil.format((Date)orgTask.getStartTime(), (String)DateUtil.FORMAT_SHORT_CN), DateUtil.format((Date)orgTask.getEndTime(), (String)DateUtil.FORMAT_SHORT_CN)));
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)result.getAddedList())) {
            Map addList = result.getAddedList().stream().collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup, Collectors.groupingBy(InspectionTaskExpand::getDeptId, Collectors.mapping(InspectionTaskExpand::getExpectTime, Collectors.toList()))));
            addList.forEach((k, v) -> {
                MainAndDesc model = (MainAndDesc)expandGroupMap.get(k);
                DetailDto detailDto = (DetailDto)groupDetailMap.get(k);
                ArrayList details = new ArrayList();
                v.forEach((k1, v1) -> {
                    String deptName = (String)departmentsMap.get(k1);
                    String expectTime = v1.stream().map(DateUtil::formatShort).collect(Collectors.joining(","));
                    String s = deptName + "," + expectTime;
                    details.add(s);
                });
                String content = MessageFormat.format(LogConstant.DETAIL, type == 1 ? "\u65b0\u589e" : model.getDetail(), details.stream().collect(Collectors.joining(";")), type == 1 && detailDto != null ? model.getDescAndTemDetail(detailDto, 0) : model.getDescAndTemDetail());
                map.computeIfAbsent(k, ArrayList::new).add(content);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getDeletedList())) {
            deleteList = result.getDeletedList().stream().collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup, Collectors.groupingBy(InspectionTaskExpand::getDeptId, Collectors.mapping(InspectionTaskExpand::getExpectTime, Collectors.toList()))));
            deleteList.forEach((k, v) -> {
                MainAndDesc model = (MainAndDesc)expandGroupMap.get(k);
                ArrayList details = new ArrayList();
                v.forEach((k1, v1) -> {
                    String deptName = (String)departmentsMap.get(k1);
                    String expectTime = v1.stream().map(DateUtil::formatShort).collect(Collectors.joining(","));
                    String s = deptName + "," + expectTime;
                    details.add(s);
                });
                String content = MessageFormat.format(LogConstant.DETAIL, "\u5220\u9664", details.stream().collect(Collectors.joining(";")) + ";", "");
                map.computeIfAbsent(k, ArrayList::new).add(content);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getSameList())) {
            deleteList = result.getSameList().stream().collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup, Collectors.groupingBy(InspectionTaskExpand::getDeptId, Collectors.mapping(InspectionTaskExpand::getExpectTime, Collectors.toList()))));
            deleteList.forEach((k, v) -> {
                DetailDto detailDto;
                MainAndDesc model = (MainAndDesc)expandGroupMap.get(k);
                if (StringUtils.isBlank((String)model.getDescAndTemDetail(detailDto = (DetailDto)groupDetailMap.get(k), 1))) {
                    return;
                }
                String content = MessageFormat.format(LogConstant.DETAIL, "\u4fee\u6539", model.getDescAndTemDetail(detailDto, 1), "");
                map.computeIfAbsent(k, ArrayList::new).add(content);
            });
        }
        if (map.isEmpty()) {
            return changeTime ? stringBuffer.toString() : "";
        }
        int i = 1;
        for (Map.Entry entry : map.entrySet()) {
            stringBuffer.append(MessageFormat.format(LogConstant.CREATE_DETAIL, i, ((List)entry.getValue()).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("\n"))));
            ++i;
        }
        return stringBuffer.toString();
    }

    private void logOperation(Integer opertorType, Integer opertorAction, Users user, InspectionTask task, Integer oldStatus, Integer newStatus, Map<Integer, DetailDto> groupDetailMap, List<InspectionTaskExpand> orgExpandList, List<InspectionTaskExpand> targetExpandlist, Map<Integer, MainAndDesc> expandGroupMap, Map<Integer, String> departmentsMap, String remark, boolean changeTime) {
        if (OperatorActionEnum.UPDATE_DRAFT.getCode().equals(opertorAction)) {
            return;
        }
        String logType = oldStatus == 0 ? (newStatus == 1 ? InspectionTaskServiceImpl.assemblerLog(orgExpandList, targetExpandlist, task, expandGroupMap, departmentsMap, groupDetailMap, 0, changeTime) : null) : InspectionTaskServiceImpl.assemblerLog(orgExpandList, targetExpandlist, task, expandGroupMap, departmentsMap, groupDetailMap, 1, changeTime);
        this.insertLog(opertorType, opertorAction, user, task.getId(), logType, remark);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> audit(InspectionPlanTaskAuditReq req, Users user) {
        InspectionTask inspectionTask;
        DeleteMessagesByObject build;
        InspectionAuditReason inspectionAuditReason;
        InspectionTask orgTask = this.inspectionTaskMapper.selectbyPrimaryId(req.getId());
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        if (!InspectionTaskStatusEnum.AUDIT.getCode().equals(orgTask.getStatus())) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_WAIT_STATUS, new Object[0]);
        }
        Date audtiTime = new Date();
        Integer status = req.getStatus();
        if (orgTask.getCompleteExpandCount() != orgTask.getTotalExpandCount()) {
            this.inspectionTaskMapper.updateStatusById(status, req.getId(), audtiTime);
            inspectionAuditReason = new InspectionAuditReason(user.getGroupId(), orgTask.getId(), status, req.getReason());
            EntityBase.setCreateParams((Object)inspectionAuditReason, (Users)user);
            this.inspectionAuditReasonMapper.insert(inspectionAuditReason);
        } else {
            this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.FINISH.getCode(), req.getId(), audtiTime);
            inspectionAuditReason = new InspectionAuditReason(user.getGroupId(), orgTask.getId(), InspectionTaskStatusEnum.FINISH.getCode(), req.getReason());
            EntityBase.setCreateParams((Object)inspectionAuditReason, (Users)user);
            this.inspectionAuditReasonMapper.insert(inspectionAuditReason);
        }
        if (InspectionTaskStatusEnum.PASS.getCode().equals(status)) {
            this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.AUDIT_PASS.getCode(), user, orgTask.getId(), "", req.getReason(), user.getShowName());
            build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).objectId(JumpTypeEnum.AUDIT.getCode()).build();
            this.messageProxy.deleteMessagesByObjectForPlan(build);
            int count = this.inspectionTaskExpandService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getOperatorId, (Object)orgTask.getOperatorId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.WAIT.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
            this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.PASS_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.DETAIL.getCode(), count > 0 ? IsExecutorEnum.EXECUTOR.getCode() : null, count > 0 ? IsTodoMessageEnum.IS_TODO_MESSAGE.getCode() : null, count > 0 ? orgTask.getEndTime() : null);
        } else if (InspectionTaskStatusEnum.REFUSE.getCode().equals(status)) {
            this.insertLogNew(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.AUDIT_REFUSE.getCode(), user, orgTask.getId(), "", req.getReason(), user.getShowName());
            build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(orgTask.getAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).objectId(JumpTypeEnum.AUDIT.getCode()).build();
            this.messageProxy.deleteMessagesByObjectForPlan(build);
            this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.REFUSE_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.DETAIL.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), orgTask.getEndTime());
        }
        Integer expireCompleteExpandCount = 0;
        log.info("\u4efb\u52a1\u8fc7\u671f\u6267\u884c\uff0c\u67e5\u8be2\u5b8c\u6210\u60c5\u51b5");
        expireCompleteExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).count();
        log.info("\u4efb\u52a1\u5b8c\u6210\uff1a" + expireCompleteExpandCount);
        if (expireCompleteExpandCount.equals(orgTask.getTotalExpandCount())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)orgTask.getId())).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode())).update();
        }
        if ((inspectionTask = this.inspectionTaskMapper.selectbyPrimaryId(orgTask.getId())).getStatus().equals(InspectionTaskStatusEnum.FINISH.getCode())) {
            this.xxlJobProxy.stopJob(orgTask.getJobId());
        }
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> expire(InspectionPlanTaskExpireReq req) {
        if (req.getId() != null) {
            List expireExecutes;
            BaseResult result;
            Integer id = req.getId();
            InspectionTask inspectionTask = Optional.ofNullable(this.inspectionTaskMapper.selectbyPrimaryId(id)).orElseThrow(() -> new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]));
            if (inspectionTask != null && inspectionTask.getStatus() != 5) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)req.getId())).set(InspectionTask::getExpireStatus, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).update();
            }
            if ((result = this.enterpriseGroupsApi.getEnterpriseConfig(inspectionTask.getGroupId())).getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute()) && (expireExecutes = ListUtils.stringToList((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute())).contains(MainTypeEnum.INSPECTION.getCode())) {
                return JsonNewResult.success();
            }
            DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(req.getId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.DELETED.getCode()).build();
            this.messageProxy.deleteMessagesByObject(build);
        }
        return JsonNewResult.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> callBack(InspectionPlanTaskCallBackReq req, Users users) {
        Date now = new Date();
        log.info("\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)req.toString());
        Integer taskId = req.getTaskId();
        InspectionTask orgTask = (InspectionTask)this.getById(taskId);
        if (Objects.isNull(orgTask)) {
            return JsonNewResult.success();
        }
        InspectionTaskExpand one = (InspectionTaskExpand)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getId, (Object)req.getExpandId())).one();
        Integer expandId = req.getExpandId();
        int i = this.isInspectionDeptTemplateMapper.planeFinish(req.getTemplateId(), taskId, one.getDeptId(), one.getGroupId(), req.getExpandId());
        Integer executeExpire = ExpandExecuteExpireEnum.NOT.getCode();
        if (orgTask.getEndTime().before(now)) {
            executeExpire = ExpandExecuteExpireEnum.YES.getCode();
        }
        if (i > 0) {
            boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.inspectionTaskExpandService.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)expandId)).eq(InspectionTaskExpand::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).update();
            Integer templates = this.isInspectionDeptTemplateMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getIsRead, (Object)0)).eq(IsInspectionDeptTemplate::getExpandId, (Object)req.getExpandId())).eq(IsInspectionDeptTemplate::getDeptId, (Object)one.getDeptId())).eq(IsInspectionDeptTemplate::getGroupId, (Object)orgTask.getGroupId())).eq(IsInspectionDeptTemplate::getTaskId, (Object)req.getTaskId()));
            log.info("\u672a\u8bfb\u6a21\u7248\u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)templates);
            if (templates > 0) {
                this.inspectionTaskMapper.updateByPrimaryId(orgTask);
                return JsonNewResult.success();
            }
        }
        log.info("\u6ca1\u6709\u672a\u8bfb\u6a21\u7248\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
        Integer expireCompleteExpandCount = 0;
        boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.inspectionTaskExpandService.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)expandId)).isNull(InspectionTaskExpand::getFinishTime)).eq(InspectionTaskExpand::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).set(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).set(InspectionTaskExpand::getFinishTime, (Object)now)).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).update();
        Integer completeExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)taskId)).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).eq(InspectionTaskExpand::getExecuteExpire, (Object)ExpandExecuteExpireEnum.NOT.getCode())).count();
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)orgTask.getTotalExpandCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        log.info("\u5b8c\u6210\u6570\u91cf\uff1a{}\uff0c\u603b\u6570\u91cf\uff1a{}\uff0c\u767e\u5206\u6bd4\uff1a{}", new Object[]{completeExpandCount, orgTask.getTotalExpandCount(), percent});
        this.inspectionTaskMapper.updateCompleteExpandCount(taskId, completeExpandCount > orgTask.getTotalExpandCount() ? orgTask.getTotalExpandCount() : completeExpandCount, percent);
        Users user = this.usersRemoteService.getById(orgTask.getOperatorId());
        DepartmentPojo department = this.departProxy.getDepartment(one.getDeptId());
        this.insertLog(OperatorTypeEnum.OPERTOR.getCode(), MainTypeEnum.isLivePatrol((Integer)one.getMainType()) ? OperatorActionEnum.LIVE.getCode() : OperatorActionEnum.REMOTE.getCode(), user, taskId, department.getName(), null);
        if (completeExpandCount.equals(orgTask.getTotalExpandCount())) {
            int isFinish = this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.FINISH.getCode(), taskId, null);
            DeleteMessagesByObject build = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(taskId).objectType(MessageObjectEnum.DEFAULT.getDesc()).objectId(Integer.valueOf(3)).build();
            this.messageProxy.deleteMessagesByObjectForPlan(build);
            this.messageProxy.sendWebSocketAndJpush(orgTask.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.COMPELETE_MESSAGE, orgTask.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.APP.getCode(), null, null, null);
        } else if (completeExpandCount < orgTask.getTotalExpandCount()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)taskId)).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.INSPECT.getCode())).update();
        }
        if (executeExpire.equals(ExpandExecuteExpireEnum.YES.getCode())) {
            log.info("\u4efb\u52a1\u8fc7\u671f\u6267\u884c\uff0c\u67e5\u8be2\u5b8c\u6210\u60c5\u51b5");
            expireCompleteExpandCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().eq(InspectionTaskExpand::getTaskId, (Object)taskId)).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).count();
            log.info("\u4efb\u52a1\u5b8c\u6210\uff1a" + expireCompleteExpandCount);
            if (expireCompleteExpandCount.equals(orgTask.getTotalExpandCount())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTask::getId, (Object)taskId)).set(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode())).update();
            }
        }
        this.inspectionTaskMapper.updateVersion(orgTask.getId());
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<com.ovopark.model.page.Page<InspectionPlanTaskExpandListResp>> expandList(InspectionPlanAppExpandReq req, Users user) throws IOException {
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List<Object> depIds = new ArrayList();
        if (StringUtils.isNotBlank((String)req.getDepName())) {
            List<Integer> result = this.departProxy.findDeptListByGroupIdAndName(user.getGroupId(), req.getDepName());
            if (CollectionUtils.isNotEmpty(result)) {
                depIds = result;
            } else {
                com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
                BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
                return JsonNewResult.success((Object)pageResult);
            }
        }
        List<Integer> deletedDepIds = this.departProxy.getDeletedDepIds(user.getGroupId());
        if (req.getExpandGroup() != null) {
            req.setStatus(null);
        }
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        List list = this.inspectionTaskExpandMapper.queryExpandListByTaskIdByPage(pageTemp, req.getId(), req.getStatus(), req.getExpandGroup(), depIds, Objects.nonNull(req.getStatus()) && req.getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode()) ? deletedDepIds : null);
        Map<Object, Object> deptNameMap = new HashMap();
        HashMap tagMap = new HashMap();
        Map<Object, Object> taskIdTomap = new HashMap();
        Map<Object, Object> collect = new HashMap();
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        List<Object> result = new ArrayList();
        ArrayList<Integer> deptIdList = new ArrayList();
        Map<Object, Object> lastInspectTimes = Collections.emptyMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskExpandListResp.class);
            deptIdList = result.stream().map(InspectionPlanTaskExpandListResp::getDeptId).collect(Collectors.toList());
            deptNameMap = this.departProxy.getDeptNameMap(deptIdList);
            List inspectionDeptTemplateModels = this.isInspectionDeptTemplateMapper.listByDeptIds(deptIdList, user.getGroupId(), req.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionDeptTemplateModels)) {
                taskIdTomap = inspectionDeptTemplateModels.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId));
                List<Integer> templateIds = inspectionDeptTemplateModels.stream().map(IsInspectionDeptTemplate::getTemplateId).distinct().collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(templateIds)) {
                    collect = this.isCheckTemplateService.getListByIds(templateIds).stream().collect(Collectors.toMap(IsCheckTemplate::getId, IsCheckTemplate::getName));
                    InspectionLastTimeReq lastTimeReq = new InspectionLastTimeReq();
                    List dateAndDepIds = InspectionUtils.convertDepIdsToDateAndDepIds(deptIdList);
                    lastTimeReq.setDateAndDepIds(dateAndDepIds);
                    lastTimeReq.setTemplateIds(templateIds.stream().map(Long::valueOf).collect(Collectors.toList()));
                    lastInspectTimes = this.getLastInspectTimes(lastTimeReq);
                }
            }
        } else {
            return JsonNewResult.success((Object)pageResult);
        }
        Boolean canExpire = this.enterpriseConfigService.checkExpireExecute(user.getGroupId(), Arrays.asList(MainTypeEnum.INSPECTION.getCode()));
        Map<Integer, DepartmentPojo> map = this.departProxy.getDepartments(deptIdList);
        for (InspectionPlanTaskExpandListResp resp3 : result) {
            resp3.setLatitude(map.get(resp3.getDeptId()).getLatitude());
            resp3.setLongitude(map.get(resp3.getDeptId()).getLongitude());
            resp3.setExpectTimeStr(DateUtil.format((Date)resp3.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            resp3.setDeptName((String)deptNameMap.get(resp3.getDeptId()));
            resp3.setExpireStatus(task.getExpireStatus());
            List templateModels = (List)taskIdTomap.get(resp3.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)templateModels)) {
                List<Object> templateDetails = new ArrayList<InspectionPlanTemplateDetailResp>();
                for (IsInspectionDeptTemplate model : templateModels) {
                    if (model.getIsRead() == 0) {
                        resp3.setStatus(Integer.valueOf(0));
                    }
                    InspectionPlanTemplateDetailResp detailResp = new InspectionPlanTemplateDetailResp(model.getId(), model.getTemplateId(), (String)collect.get(model.getTemplateId()), model.getIsRead(), model.getDeptId());
                    if (lastInspectTimes.containsKey(resp3.getDeptId().longValue())) {
                        List inspectionInfos = (List)lastInspectTimes.get(resp3.getDeptId().longValue());
                        for (ShopInspectionInfo info : inspectionInfos) {
                            if (!info.getTemplateId().equals(model.getTemplateId().longValue())) continue;
                            detailResp.setNum(info.getNum());
                            detailResp.setDate(info.getDate());
                            break;
                        }
                    }
                    templateDetails.add(detailResp);
                    templateDetails = templateDetails.stream().sorted(Comparator.comparing(InspectionPlanTemplateDetailResp::getIsRead)).collect(Collectors.toList());
                }
                resp3.setTemplateDetails(templateDetails);
            }
            resp3.setShowToCheck(task.getStartTime().before(new Date()), task.getStatus(), task.getExpireStatus(), user.getId(), canExpire.booleanValue());
        }
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        result = result.stream().sorted((resp1, resp2) -> {
            boolean hasEmptyNum1 = resp1.getTemplateDetails().stream().anyMatch(detail -> detail.getNum() == null || detail.getNum().isEmpty());
            boolean hasEmptyNum2 = resp2.getTemplateDetails().stream().anyMatch(detail -> detail.getNum() == null || detail.getNum().isEmpty());
            if (hasEmptyNum1 && !hasEmptyNum2) {
                return -1;
            }
            if (!hasEmptyNum1 && hasEmptyNum2) {
                return 1;
            }
            String maxNum1 = resp1.getTemplateDetails().stream().filter(detail -> detail.getNum() != null && !detail.getNum().isEmpty()).map(InspectionPlanTemplateDetailResp::getNum).max(Comparator.comparingInt(Integer::parseInt)).orElse("0");
            String maxNum2 = resp2.getTemplateDetails().stream().filter(detail -> detail.getNum() != null && !detail.getNum().isEmpty()).map(InspectionPlanTemplateDetailResp::getNum).max(Comparator.comparingInt(Integer::parseInt)).orElse("0");
            int numComparison = Integer.compare(Integer.parseInt(maxNum2), Integer.parseInt(maxNum1));
            if (numComparison != 0) {
                return numComparison;
            }
            return resp1.getDeptId().compareTo(resp2.getDeptId());
        }).map(resp -> {
            List sortedTemplateDetails = resp.getTemplateDetails().stream().sorted((detail1, detail2) -> {
                boolean num2IsEmpty;
                if (detail1.getIsRead() == 1 && detail2.getIsRead() != 1) {
                    return 1;
                }
                if (detail1.getIsRead() != 1 && detail2.getIsRead() == 1) {
                    return -1;
                }
                boolean num1IsEmpty = detail1.getNum() == null || detail1.getNum().isEmpty();
                boolean bl = num2IsEmpty = detail2.getNum() == null || detail2.getNum().isEmpty();
                if (num1IsEmpty && !num2IsEmpty) {
                    return -1;
                }
                if (!num1IsEmpty && num2IsEmpty) {
                    return 1;
                }
                if (!num1IsEmpty && !num2IsEmpty) {
                    return Integer.compare(Integer.parseInt(detail2.getNum()), Integer.parseInt(detail1.getNum()));
                }
                return 0;
            }).collect(Collectors.toList());
            resp.setTemplateDetails(sortedTemplateDetails);
            return resp;
        }).collect(Collectors.toList());
        pageResult.setContent(result);
        return JsonNewResult.success((Object)pageResult);
    }

    @Override
    public JsonNewResult<InspectionPlanTaskExpandListCountResp> expandCountList(InspectionPlanAppExpandReq req, Users user) {
        List<Integer> deletedDepIds = this.departProxy.getDeletedDepIds(user.getGroupId());
        Integer waitCount = this.inspectionTaskExpandMapper.queryExpandListCountByTaskId(req.getId(), InspectionTaskExpandStatusEnum.WAIT.getCode(), deletedDepIds);
        Integer passCount = this.inspectionTaskExpandMapper.queryExpandListCountByTaskId(req.getId(), InspectionTaskExpandStatusEnum.PASS.getCode(), null);
        return JsonNewResult.success((Object)new InspectionPlanTaskExpandListCountResp(waitCount, passCount));
    }

    public void assembleInspectionTaskExpand(ExpandAddReq req, InspectionTask task, Users user, List<InspectionTaskExpand> list, List<InspectionDeptTag> targetTagList, Integer uuid, Date startTime, Date endTime) {
        if (CollectionUtils.isNotEmpty((Collection)req.getDeptModels())) {
            req.getDeptModels().forEach(model -> {
                if (CollectionUtils.isNotEmpty((Collection)model.getExpectTimeStrs())) {
                    for (String expectTimeStr : model.getExpectTimeStrs()) {
                        this.createAndSaveInspectionTaskExpand(req.getMainType(), req.getDescription(), req.getTemplateVos(), req.getTagList(), user, task, uuid, expectTimeStr, null, model.getDeptId(), startTime, endTime, targetTagList, InspectionTaskExpandStatusEnum.WAIT.getCode());
                    }
                } else {
                    this.createAndSaveInspectionTaskExpand(req.getMainType(), req.getDescription(), req.getTemplateVos(), req.getTagList(), user, task, uuid, null, null, model.getDeptId(), startTime, endTime, targetTagList, InspectionTaskExpandStatusEnum.WAIT.getCode());
                }
            });
        }
    }

    public void assembleUpdateInspectionTaskExpand(ExpandUpdateReq req, InspectionTask task, Users user, List<InspectionDeptTag> targetTagList, Integer uuid, Date startTime, Date endTime) {
        if (CollectionUtils.isNotEmpty((Collection)req.getDeptModels())) {
            req.getDeptModels().forEach(model -> {
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)model.getExpectTimeStrs())) {
                    for (ExplandExpectTime explandExpectTime : model.getExpectTimeStrs()) {
                        this.createAndSaveInspectionTaskExpand(req.getMainType(), req.getDescription(), req.getTemplateVos(), req.getTagList(), user, task, uuid, explandExpectTime.getExpectTimeStr(), explandExpectTime.getExplanId(), model.getDeptId(), startTime, endTime, targetTagList, explandExpectTime.getStatus());
                    }
                } else {
                    this.createAndSaveInspectionTaskExpand(req.getMainType(), req.getDescription(), req.getTemplateVos(), req.getTagList(), user, task, uuid, null, null, model.getDeptId(), startTime, endTime, targetTagList, InspectionTaskExpandStatusEnum.WAIT.getCode());
                }
            });
        }
    }

    private void createAndSaveInspectionTaskExpand(Integer mainType, String description, List<CheckTemplateVoReq> templateVos, Set<InspectionPlanTagAddReq> tagList, Users user, InspectionTask task, Integer uuid, String expectTimeStr, Integer explanId, Integer deptId, Date startTime, Date endTime, List<InspectionDeptTag> targetTagList, Integer status) {
        InspectionTaskExpand expand = (InspectionTaskExpand)Optional.ofNullable(this.inspectionTaskExpandService.getById(explanId)).orElse(new InspectionTaskExpand());
        expand.setExpandGroup(uuid);
        expand.setGroupId(user.getGroupId());
        expand.setTaskId(task.getId());
        expand.setDeptId(deptId);
        expand.setDescription(description);
        expand.setOperatorId(user.getId());
        expand.setStatus(status);
        EntityBase.setCreateParams((Object)expand, (Users)user);
        expand.setMainType(mainType);
        if (expectTimeStr != null) {
            expectTimeStr = expectTimeStr.split(" ")[0] + " 23:59:59";
            expand.setExpectTime(DateUtil.parse((String)expectTimeStr, (String)DateUtil.FORMAT_LONG));
            if (startTime != null && endTime != null && (expand.getExpectTime().before(startTime) || expand.getExpectTime().after(endTime))) {
                throw new SysErrorException(ResultCode.EXPECTTIME_OUT_START_END, new Object[0]);
            }
        }
        this.inspectionTaskExpandService.saveOrUpdate(expand);
        this.assembleInspectionDeptTagAndTemplate(targetTagList, tagList, task.getId(), deptId, user, templateVos, expand.getId());
    }

    public void assembleInspectionDeptTagAndTemplate(List<InspectionDeptTag> targetTagList, Set<InspectionPlanTagAddReq> sourceTagList, Integer taskId, Integer depId, Users user, List<CheckTemplateVoReq> vos, Integer expandId) {
        if (CollectionUtils.isNotEmpty(sourceTagList)) {
            Map<Integer, InspectionDeptTag> tagMap = ((List)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTagService.lambdaQuery().eq(InspectionDeptTag::getTaskId, (Object)taskId)).eq(InspectionDeptTag::getGroupId, (Object)user.getGroupId())).eq(InspectionDeptTag::getDeptId, (Object)depId)).eq(InspectionDeptTag::getIsDeleted, (Object)0)).eq(InspectionDeptTag::getExpandId, (Object)expandId)).list()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(InspectionDeptTag::getTagId, Collectors.collectingAndThen(Collectors.toList(), list -> (InspectionDeptTag)list.get(0))));
            for (InspectionPlanTagAddReq tagAddReq : sourceTagList) {
                InspectionDeptTag inspectionDeptTag = new InspectionDeptTag();
                if (expandId != null) {
                    inspectionDeptTag.setExpandId(expandId);
                }
                if (tagMap.containsKey(tagAddReq.getTagId())) {
                    inspectionDeptTag.setId(tagMap.get(tagAddReq.getTagId()).getId());
                }
                inspectionDeptTag.setGroupId(user.getGroupId());
                inspectionDeptTag.setTaskId(taskId);
                inspectionDeptTag.setDeptId(depId);
                inspectionDeptTag.setTagId(tagAddReq.getTagId());
                EntityBase.setCreateParams((Object)inspectionDeptTag, (Users)user);
                this.inspectionDeptTagService.saveOrUpdate(inspectionDeptTag);
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(vos)) {
            List<Object> finishTemplateId = new ArrayList();
            if (expandId != null) {
                List list2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.isInspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
                this.isInspectionDeptTemplateService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
                if (CollectionUtils.isNotEmpty((Collection)list2)) {
                    finishTemplateId = list2.stream().map(IsInspectionDeptTemplate::getTemplateId).collect(Collectors.toList());
                }
            }
            for (CheckTemplateVoReq templateVoReq : vos) {
                if (finishTemplateId.contains(templateVoReq.getTemplateId())) continue;
                IsInspectionDeptTemplate checkTemplateVoReq = new IsInspectionDeptTemplate();
                checkTemplateVoReq.setGroupId(user.getGroupId());
                checkTemplateVoReq.setExpandId(expandId);
                checkTemplateVoReq.setTaskId(taskId);
                checkTemplateVoReq.setDeptId(depId);
                checkTemplateVoReq.setTemplateId(templateVoReq.getTemplateId());
                EntityBase.setCreateParams((Object)checkTemplateVoReq, (Users)user);
                this.inspectionDeptTemplateService.saveOrUpdate(checkTemplateVoReq);
            }
            if (expandId != null) {
                log.info("\u95e8\u5e97\u6a21\u7248\u903b\u8f91\uff0cexpandId\uff1a{}", (Object)expandId);
                Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.isInspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)0)).count();
                if (count == 0) {
                    log.info("\u95e8\u5e97\u6a21\u7248\u903b\u8f91\uff0cexpandId\uff1a{}\uff0ccount\uff1a{}", (Object)expandId, (Object)count);
                    IsInspectionDeptTemplate max = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.isInspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)1)).list().stream().max(Comparator.comparing(IsInspectionDeptTemplate::getUpdateTime)).get();
                    log.info("\u95e8\u5e97\u6a21\u7248\u903b\u8f91\uff0cexpandId\uff1a{}\uff0cmax\uff1a{}", (Object)expandId, (Object)max);
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.inspectionTaskExpandService.lambdaUpdate().set(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.PASS.getCode())).set(max != null, InspectionTaskExpand::getFinishTime, (Object)max.getUpdateTime()).eq(InspectionTaskExpand::getId, (Object)expandId)).update();
                }
            }
        }
    }

    @Override
    public com.ovopark.model.page.Page<InspectionPlanTaskAppListResp> appList(InspectionPlanTaskAppListReq req, Users user) {
        List ccModels;
        this.menusPrivilegesService.checkPrivilege(user, MainTypeEnum.INSPECTION.getCode());
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List<Integer> taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return new com.ovopark.model.page.Page();
        }
        EnterpriseConfigPojo configPojo = new EnterpriseConfigPojo();
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        if (baseResult.getData() != null) {
            configPojo = (EnterpriseConfigPojo)baseResult.getData();
        }
        List list = new ArrayList();
        if (req.getReleateType() != null && req.getReleateType().equals(ReleateTypeEnum.THREE.getCode()) && CollectionUtils.isNotEmpty((Collection)(ccModels = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getCcId, (Object)user.getId())).eq(InspectionTaskCcModel::getGroupId, (Object)user.getGroupId())).list()))) {
            List collect = ccModels.stream().map(InspectionTaskCcModel::getTaskId).collect(Collectors.toList());
            list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, ReleateTypeEnum.THREE.getCode(), null, groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), collect, req.getEffectiveTime(), req.getCreateId());
        }
        if (req.getReleateType() != null && !req.getReleateType().equals(ReleateTypeEnum.THREE.getCode())) {
            list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
        }
        if (req.getReleateType() == null) {
            if (configPojo.getAddCopy().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
                List<Integer> collect = this.inspectionTaskCcService.getTaskIdsByCcId(user.getId(), groupId);
                if (CollectionUtils.isNotEmpty(collect)) {
                    taskIdList.addAll(collect);
                    taskIdList.addAll(this.inspectionTaskMapper.queryAppList(req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), null, req.getEffectiveTime(), req.getCreateId()));
                    list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, Integer.valueOf(4), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
                } else {
                    list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
                }
            } else {
                list = this.inspectionTaskMapper.queryAppListByRelateTypeByPage(pageTemp, req.getReleateType(), user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), taskIdList, req.getEffectiveTime(), req.getCreateId());
            }
        }
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return pageResult;
        }
        InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
        List collect = list.stream().map(InspectionTask::getId).collect(Collectors.toList());
        List result = ClazzConverterUtils.converterClass(list, InspectionPlanTaskAppListResp.class);
        List inspectionDeptTagsList = new ArrayList();
        if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, collect);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            pageResult.setContent(result);
        }
        Map<Object, Object> tagMap = new HashMap();
        HashMap taskTagMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
                Set<Integer> tagIdSet;
                Integer taskId = inspectionDeptTag.getTaskId();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                    tagIdSet = new HashSet<Integer>();
                    ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                    taskTagMap.put(taskId, tagIdSet);
                    continue;
                }
                tagIdSet = (Set)taskTagMap.get(taskId);
                tagIdSet.add(inspectionDeptTag.getTagId());
            }
            Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
            ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
            List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
                tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
            }
        }
        for (InspectionPlanTaskAppListResp inspectionPlanTaskAppListResp : result) {
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = inspectionPlanTaskAppListResp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            inspectionPlanTaskAppListResp.setTagList(eachTaskTagList);
            inspectionPlanTaskAppListResp.setStartTimeStr(DateUtil.format((Date)inspectionPlanTaskAppListResp.getStartTime(), (String)DateUtil.FORMAT_SHORT));
            inspectionPlanTaskAppListResp.setEndTimeStr(DateUtil.format((Date)inspectionPlanTaskAppListResp.getEndTime(), (String)DateUtil.FORMAT_SHORT));
        }
        pageResult.setContent(result);
        return pageResult;
    }

    @Override
    public Integer appCount(InspectionPlanTaskAppListReq req, Users user) {
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        pageResult.setPageNumber(req.getPageNo().intValue());
        pageResult.setPageSize(req.getPageSize().intValue());
        Set<Integer> userPrivileges = this.menusPrivilegesService.getUserPrivileges(user);
        if (!userPrivileges.contains(MainTypeEnum.INSPECTION.getCode())) {
            return 0;
        }
        return this.inspectionTaskMapper.queryAppListByRelateTypeCount(pageResult, null, user.getId(), groupId, req.getName(), req.getStatus(), req.getStartTime(), req.getEndTime(), null, req.getEffectiveTime());
    }

    @Override
    public JsonNewResult<com.ovopark.model.page.Page<InspectionPlanTaskWebListResp>> webList(InspectionPlanTaskWebListReq req, Users user) {
        List distinctTagIdList;
        List tagList;
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return JsonNewResult.success((Object)new com.ovopark.model.page.Page());
        }
        StringBuilder sqlDescBuilder = new StringBuilder();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrderList())) {
            List orderList = req.getOrderList();
            for (int i = 0; i < orderList.size(); ++i) {
                StorePlanDescReq descOrder = (StorePlanDescReq)orderList.get(i);
                if (descOrder.getDescColumn() == null || descOrder.getDescOrder() == null) continue;
                String columnExpression = StorePlanOrderWebColumnEnum.format((Integer)descOrder.getDescColumn()).getExpression();
                String orderExpression = StorePlanOrderDescEnum.format((Integer)descOrder.getDescOrder()).getDesc();
                sqlDescBuilder.append(columnExpression).append(orderExpression).append(",");
            }
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.ID.getExpression()).append(StorePlanOrderDescEnum.DESC.getDesc());
        } else {
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.WEB_DEFAULT.getExpression());
        }
        String sqlOrderExpression = sqlDescBuilder.toString();
        ArrayList organizeUserList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            ArrayList departmentMoList = new ArrayList();
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(req.getOrganizeIdList());
            mo.setUserId(user.getId());
            BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                    List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                    departmentMoList.addAll(departmentMoList1);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentAndOrganizeAndUserMo.getUserList())) {
                        organizeUserList.addAll(departmentAndOrganizeAndUserMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                    }
                });
                if (!org.springframework.util.CollectionUtils.isEmpty(departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            organizeUserList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
            organizeUserList.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
        }
        List list = this.inspectionTaskMapper.queryWebListByPage(pageTemp, groupId, req.getName(), req.getOperatorName(), req.getStatus(), req.getAuditName(), req.getStartTime(), req.getEndTime(), InspectionPlanExpressionEnum.formatOrNull((String)req.getCompletePercentExpression()).getExpression(), req.getCompletePercent(), taskIdList, organizeUserList, sqlOrderExpression);
        com.ovopark.model.page.Page pageResult = new com.ovopark.model.page.Page();
        BeanUtils.copyProperties((Object)pageTemp, (Object)pageResult);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return JsonNewResult.success((Object)pageResult);
        }
        List collect = list.stream().map(InspectionTask::getId).collect(Collectors.toList());
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        List inspectionDeptTagsList = new ArrayList();
        InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
        if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, collect);
        }
        HashMap taskTagMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(inspectionDeptTagsList)) {
            for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
                Set<Integer> tagIdSet;
                Integer taskId = inspectionDeptTag.getTaskId();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                    tagIdSet = new HashSet<Integer>();
                    ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                    taskTagMap.put(taskId, tagIdSet);
                    continue;
                }
                tagIdSet = (Set)taskTagMap.get(taskId);
                tagIdSet.add(inspectionDeptTag.getTagId());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).distinct().collect(Collectors.toList()))))) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        String config = this.commonConfigService.getEnterpriseConfig(user.getGroupId(), CommonConfigEnum.UPDATE_TIME.getKey());
        EnterpriseConfigPojo enterpriseConfigPojo = this.enterpriseConfigService.selectOne(user.getGroupId());
        for (InspectionPlanTaskWebListResp resp : result) {
            List taskExpandList;
            log.info("\u6b21\u6570\u6821\u9a8c\uff1a{}", (Object)(Integer.valueOf(config) > resp.getUpdateTimes() ? 1 : 0));
            log.info("\u72b6\u6001\u6821\u9a8c\uff1a{}", (Object)InspectionTaskStatusEnum.showEdit((Integer)resp.getStatus()));
            log.info("\u72b6\u6001\u6821\u9a8c\uff1a{}", (Object)InspectionTaskStatusEnum.configShowEdit((Integer)resp.getStatus()));
            resp.setCanEdit((InspectionTaskStatusEnum.showEdit((Integer)resp.getStatus()) || InspectionTaskStatusEnum.configShowEdit((Integer)resp.getStatus()) && enterpriseConfigPojo.getAllowEditingApproval() == 1) && resp.getExpireStatus() != 1 && Integer.valueOf(config) > resp.getUpdateTimes() && resp.getOperatorId().equals(user.getId()));
            if (resp.getEndTime() != null) {
                resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_TIME));
            }
            if (resp.getStartTime() != null) {
                resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_TIME));
            }
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)(taskExpandList = (List)expandMap.get(resp.getId()))) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        pageResult.setContent(result);
        return JsonNewResult.success((Object)pageResult);
    }

    @Override
    public JsonNewResult<List<InspectionPlanTaskWebListResp>> allList(InspectionPlanTaskWebListReq req, Users user) {
        List list;
        Integer groupId = user.getGroupId();
        com.ovopark.model.page.Page pageTemp = new com.ovopark.model.page.Page();
        pageTemp.setPageNumber(req.getPageNo().intValue());
        pageTemp.setPageSize(req.getPageSize().intValue());
        List taskIdList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getTagIdList()) && org.springframework.util.CollectionUtils.isEmpty(taskIdList = this.inspectionDeptTagMapper.selectTaskIdByGroupIdAndTagIdList(groupId, req.getTagIdList()))) {
            return JsonNewResult.success(new ArrayList());
        }
        StringBuilder sqlDescBuilder = new StringBuilder();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrderList())) {
            List orderList = req.getOrderList();
            for (int i = 0; i < orderList.size(); ++i) {
                StorePlanDescReq descOrder = (StorePlanDescReq)orderList.get(i);
                if (descOrder.getDescColumn() == null || descOrder.getDescOrder() == null) continue;
                String columnExpression = StorePlanOrderWebColumnEnum.format((Integer)descOrder.getDescColumn()).getExpression();
                String orderExpression = StorePlanOrderDescEnum.format((Integer)descOrder.getDescOrder()).getDesc();
                sqlDescBuilder.append(columnExpression).append(orderExpression).append(",");
            }
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.ID.getExpression()).append(StorePlanOrderDescEnum.DESC.getDesc());
        } else {
            sqlDescBuilder.append(StorePlanOrderWebColumnEnum.WEB_DEFAULT.getExpression());
        }
        String sqlOrderExpression = sqlDescBuilder.toString();
        ArrayList organizeUserList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            ArrayList departmentMoList = new ArrayList();
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(req.getOrganizeIdList());
            mo.setUserId(user.getId());
            BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                    List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                    departmentMoList.addAll(departmentMoList1);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentAndOrganizeAndUserMo.getUserList())) {
                        organizeUserList.addAll(departmentAndOrganizeAndUserMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                    }
                });
                if (!org.springframework.util.CollectionUtils.isEmpty(departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            organizeUserList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
            organizeUserList.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(list = this.inspectionTaskMapper.queryWebList(groupId, req.getName(), req.getOperatorName(), req.getStatus(), req.getAuditName(), req.getStartTime(), req.getEndTime(), InspectionPlanExpressionEnum.formatOrNull((String)req.getCompletePercentExpression()).getExpression(), req.getCompletePercent(), taskIdList, organizeUserList, sqlOrderExpression)))) {
            return JsonNewResult.success(new ArrayList());
        }
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        List inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, null);
        HashMap taskTagMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionDeptTagsList)) {
            for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
                Set<Integer> tagIdSet;
                Integer taskId = inspectionDeptTag.getTaskId();
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                    tagIdSet = new HashSet<Integer>();
                    ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                    taskTagMap.put(taskId, tagIdSet);
                    continue;
                }
                tagIdSet = (Set)taskTagMap.get(taskId);
                tagIdSet.add(inspectionDeptTag.getTagId());
            }
        }
        Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
        ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
        Map<Object, Object> tagMap = new HashMap();
        List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        for (InspectionPlanTaskWebListResp resp : result) {
            List taskExpandList;
            if (resp.getEndTime() != null) {
                resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_LONG));
            }
            if (resp.getStartTime() != null) {
                resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_LONG));
            }
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)(taskExpandList = (List)expandMap.get(resp.getId()))) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, null));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        return JsonNewResult.success((Object)result);
    }

    @Override
    public JsonNewResult<List<InspectionPlanTaskWebListResp>> partionList(InspectionPlanTaskPartionWebListReq req, Users user) {
        List inspectionDeptTagsList;
        List ids;
        Integer groupId = user.getGroupId();
        List list = this.inspectionTaskMapper.partionList(groupId, ids = req.getIds());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return JsonNewResult.success(new ArrayList());
        }
        List result = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskWebListResp.class);
        List resultTaskIdList = result.stream().map(InspectionPlanTaskWebListResp::getId).collect(Collectors.toList());
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(resultTaskIdList, user.getGroupId());
        Map<Object, Object> expandMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            expandMap = expandList.stream().collect(Collectors.toMap(InspectionTaskExpand::getTaskId, value -> Lists.newArrayList((Object[])new InspectionTaskExpand[]{value}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(inspectionDeptTagsList = this.inspectionDeptTagMapper.selectTagIdListByTaskList(groupId, null)))) {
            return JsonNewResult.success((Object)result);
        }
        HashMap taskTagMap = new HashMap();
        for (InspectionDeptTag inspectionDeptTag : inspectionDeptTagsList) {
            Set<Integer> tagIdSet;
            Integer taskId = inspectionDeptTag.getTaskId();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)taskTagMap.get(taskId)))) {
                tagIdSet = new HashSet<Integer>();
                ((HashSet)tagIdSet).add(inspectionDeptTag.getTagId());
                taskTagMap.put(taskId, tagIdSet);
                continue;
            }
            tagIdSet = (Set)taskTagMap.get(taskId);
            tagIdSet.add(inspectionDeptTag.getTagId());
        }
        Set distinctTagIdSet = inspectionDeptTagsList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toSet());
        ArrayList distinctTagIdList = new ArrayList(distinctTagIdSet);
        Map<Object, Object> tagMap = new HashMap();
        List tagList = this.inspectionTagMapper.queryTagByTagIdList(groupId, distinctTagIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagList)) {
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        for (InspectionPlanTaskWebListResp resp : result) {
            resp.setEndTimeStr(DateUtil.getDateStr((Date)resp.getEndTime(), (String)DateUtil.FORMAT_LONG));
            resp.setStartTimeStr(DateUtil.getDateStr((Date)resp.getStartTime(), (String)DateUtil.FORMAT_LONG));
            List taskExpandList = (List)expandMap.get(resp.getId());
            resp.setDeptNum(Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)taskExpandList) ? 0 : taskExpandList.size()));
            ArrayList<InspectionPlanTagDetailResp> eachTaskTagList = new ArrayList<InspectionPlanTagDetailResp>();
            Integer taskId = resp.getId();
            Set tagSet = (Set)taskTagMap.get(taskId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagSet)) {
                for (Integer tagId : tagSet) {
                    String tagName = (String)tagMap.get(tagId);
                    eachTaskTagList.add(new InspectionPlanTagDetailResp(tagId, tagName, resp.getId()));
                }
            }
            resp.setTagList(eachTaskTagList);
        }
        return JsonNewResult.success((Object)result);
    }

    @Override
    public InspectionPlanPersonlyResp personly(Users user) {
        InspectionPlanPersonlyResp resp;
        List task;
        Integer groiupTotalTask = 0;
        Integer groiupFinishTask = 0;
        double groupPer = 0.0;
        Map<Object, Object> personlyRespMap = new HashMap();
        List<Integer> userIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).distinct().collect(Collectors.toList());
        Map<Object, Object> nameMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(userIds)) {
            nameMap = this.usersRemoteService.getCoreUserNameMapByIds(userIds);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(task = this.inspectionTaskMapper.getTaskByGroupIdAndOperatorId(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), null, null, userIds)))) {
            personlyRespMap = task.stream().collect(Collectors.toMap(InspectionPlanPersonlyResp::getUserId, Function.identity()));
            groiupTotalTask = task.stream().collect(Collectors.summingInt(InspectionPlanPersonlyResp::getTaskNum));
            groiupFinishTask = task.stream().collect(Collectors.summingInt(InspectionPlanPersonlyResp::getFinishTaskNum));
            groupPer = (double)groiupFinishTask.intValue() / (double)groiupTotalTask.intValue();
        }
        if ((resp = (InspectionPlanPersonlyResp)personlyRespMap.get(user.getId())) != null) {
            double personFinishPer = (double)resp.getFinishTaskNum().intValue() / (double)resp.getTaskNum().intValue();
            resp.setPersonFinishPer(Double.valueOf(new BigDecimal(personFinishPer * 100.0).setScale(2, 4).doubleValue()));
            resp.setPersonFinishPerInGroup(Double.valueOf(new BigDecimal((personFinishPer - groupPer) * 100.0).setScale(2, 4).doubleValue()));
            InspectionPlanPersonlyResp personPosition = this.personPosition(user);
            resp.setUserTop(personPosition.getRank());
            resp.setTopSize(personPosition.getTopSize());
        }
        return resp;
    }

    @Override
    public InspectionPlanPersonlyResp personPosition(Users user) {
        DecimalFormat df1 = new DecimalFormat("#0.00%");
        Map<Object, Object> topMap = new HashMap();
        Date date = new Date();
        Date startTimeOfDay = DateUtil.getStartTimeOfDay((Date)date);
        Set userIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).collect(Collectors.toSet());
        List task = this.inspectionTaskMapper.getTaskByGroupIdAndTime(user.getGroupId(), DeleteEnum.NOT_DELETED, DateUtil.format((Date)date, (String)DateUtil.FORMAT_LONG), userIds);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)task)) {
            task.forEach(resp -> resp.setTopSize(Integer.valueOf(task.size())).setRank(resp.getUserTop()));
            topMap = task.stream().collect(Collectors.toMap(InspectionPlanPersonlyResp::getUserId, Function.identity()));
        }
        return (InspectionPlanPersonlyResp)topMap.get(user.getId());
    }

    @Override
    public InspectionTaskCountResp taskCount(InspectionTaskCountReq req, Users user) {
        InspectionTaskCountResp resp = new InspectionTaskCountResp();
        List<Integer> userIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).distinct().collect(Collectors.toList());
        Map<Object, Object> nameMap = new HashMap();
        if (org.springframework.util.CollectionUtils.isEmpty(userIds)) {
            return resp;
        }
        nameMap = this.usersRemoteService.getCoreUserNameMapByIds(userIds);
        InspectionTaskCountResp taskCountResp = this.inspectionTaskMapper.taskCount(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), req.getStartTime(), req.getEndTime(), req.getDataType(), user.getId(), userIds);
        if (taskCountResp != null) {
            resp.setOutTime(taskCountResp.getOutTime());
            resp.setFinish(taskCountResp.getFinish());
            resp.setDoing(taskCountResp.getDoing());
        }
        return resp;
    }

    @Override
    public List<InspectionPlanPersonlyResp> finishTop(Users user, InspectionTashFinishPerTop req) {
        List task;
        Integer groiupTotalTask = 0;
        Integer groiupFinishTask = 0;
        double groupPer = 0.0;
        HashMap personlyRespMap = new HashMap();
        List<Integer> userIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).collect(Collectors.toList());
        Map<Object, Object> nameMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(userIds)) {
            nameMap = this.usersRemoteService.getCoreUserNameMapByIds(userIds);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(task = this.inspectionTaskMapper.getTaskByGroupIdAndOperatorId(user.getGroupId(), DeleteEnum.NOT_DELETED.getCode(), req.getStartTime(), req.getEndTime(), userIds)))) {
            for (InspectionPlanPersonlyResp resp : task) {
                resp.setUserName((String)nameMap.get(resp.getUserId())).setTopSize(Integer.valueOf(task.size())).setRank(resp.getUserTop());
            }
        }
        return task;
    }

    @Override
    public List<InspectionTaskWillOutTimeResp> willOutTime(InspectionTaskWillOutTimeReq req, Users user) {
        ArrayList<InspectionTaskWillOutTimeResp> list = new ArrayList<InspectionTaskWillOutTimeResp>();
        Date date = new Date();
        Date endTime = DateUtil.getEndTimeOfDay((Date)DateUtil.addDay((Date)date, (int)2));
        Date startTime = DateUtil.getStartTimeOfDay((Date)date);
        Map<Object, Object> taskTagMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        List expands = new ArrayList();
        Map<Object, Object> expandMap = new HashMap();
        List inspectionTasks = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getOperatorId, (Object)user.getId())).between(InspectionTask::getEndTime, (Object)startTime, (Object)endTime)).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.FINISH.getCode()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionTasks)) {
            List deptTags = this.inspectionDeptTagMapper.selectTagIdListByTaskList(user.getGroupId(), inspectionTasks.stream().map(InspectionTask::getId).collect(Collectors.toList()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTags)) {
                taskTagMap = deptTags.stream().collect(Collectors.groupingBy(InspectionDeptTag::getTaskId));
                List tags = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), deptTags.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList()));
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tags)) {
                    tagMap = tags.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
                }
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(expands = this.inspectionTaskExpandMapper.selectExpandListByTaskIdList(inspectionTasks.stream().map(InspectionTask::getId).collect(Collectors.toList()), user.getGroupId()))) {
                expandMap = expands.stream().collect(Collectors.groupingBy(InspectionTaskExpand::getTaskId, Collectors.groupingBy(InspectionTaskExpand::getStatus)));
            }
        }
        for (InspectionTask task : inspectionTasks) {
            InspectionTaskWillOutTimeResp resp = new InspectionTaskWillOutTimeResp();
            List deptTags = (List)taskTagMap.get(task.getId());
            HashSet<String> tagNames = new HashSet<String>();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTags)) {
                for (InspectionDeptTag deptTag : deptTags) {
                    String tagName = (String)tagMap.get(deptTag.getTagId());
                    if (tagName == null) continue;
                    tagNames.add(tagName);
                }
                resp.setInspectionTagName(tagNames);
            }
            if (expandMap.get(task.getId()) != null) {
                int finishNum = 0;
                List inspectionTaskExpands = (List)((Map)expandMap.get(task.getId())).get(InspectionTaskExpandStatusEnum.PASS.getCode());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)inspectionTaskExpands)) {
                    finishNum = inspectionTaskExpands.size();
                }
                int allSize = ((Map)expandMap.get(task.getId())).size();
                resp.setFinishNum(Integer.valueOf(finishNum));
                resp.setTaskNum(Integer.valueOf(allSize));
            }
            resp.setStartTime(task.getStartTime());
            resp.setEndTime(task.getEndTime());
            resp.setInspectionTaskId(task.getId());
            resp.setInspectionTaskName(task.getName());
            resp.setStatus(task.getStatus());
            list.add(resp);
        }
        list.sort(Comparator.comparing(InspectionTaskWillOutTimeResp::getEndTime));
        return list;
    }

    @Override
    public InspectionTaskByGroupResp getTaskByGroupId(InspectionTaskCountReq req, Users user) {
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)DateUtil.parse((String)req.getStartTime(), (String)DateUtil.FORMAT_LONG));
        String startTime = DateUtil.format((Date)firstDayOfMonth, (String)DateUtil.FORMAT_LONG);
        InspectionTaskByGroupResp resp = this.inspectionTaskMapper.getTaskByGroupId(user.getGroupId(), startTime, req.getEndTime());
        if (resp.getTaskNum() > 1) {
            double per = (double)resp.getFinishTaskNum().intValue() / (double)resp.getTaskNum().intValue();
            resp.setFinishPer(Double.valueOf(new BigDecimal(per * 100.0).setScale(2, 4).doubleValue()));
        }
        return resp;
    }

    @Override
    public List<InspectionTaskPerByGroupId> getFinishPerByGroupId(InspectionTaskCountReq req, Users user) {
        ArrayList<InspectionTaskPerByGroupId> result = new ArrayList<InspectionTaskPerByGroupId>();
        List resps = new ArrayList();
        String name = GroupBy.getName((Integer)req.getDataType());
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)DateUtil.parse((String)req.getStartTime(), (String)DateUtil.FORMAT_LONG));
        String startTime = DateUtil.format((Date)firstDayOfMonth, (String)DateUtil.FORMAT_LONG);
        DaoUtils daoUtils = new DaoUtils();
        Map mapMonth = new HashMap();
        switch (req.getDataType()) {
            case 1: {
                mapMonth = daoUtils.setMapMonth(req.getStartTime(), req.getEndTime(), Integer.valueOf(1));
                resps = this.inspectionTaskMapper.getFinishPerByGroupId(user.getGroupId(), startTime, req.getEndTime());
                break;
            }
            case 2: {
                mapMonth = daoUtils.setMapQuarter(req.getStartTime(), req.getEndTime(), Integer.valueOf(3));
                resps = this.inspectionTaskMapper.getFinishPerByGroupIdQuarter(user.getGroupId(), startTime, req.getEndTime());
                break;
            }
            case 3: {
                mapMonth = daoUtils.setMapYear(req.getStartTime(), req.getEndTime(), Integer.valueOf(1));
                resps = this.inspectionTaskMapper.getFinishPerByGroupIdYear(user.getGroupId(), startTime, req.getEndTime());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(resps)) {
            Map listMap = resps.stream().collect(Collectors.toMap(InspectionTaskPerByGroupId::getDateTime, Function.identity()));
            for (String s : mapMonth.keySet()) {
                InspectionTaskPerByGroupId resp = new InspectionTaskPerByGroupId();
                resp.setDateTime(s);
                if (listMap.containsKey(s) && listMap.get(s) != null) {
                    int totalNum = ((InspectionTaskPerByGroupId)listMap.get(s)).getTaskNum();
                    int finishNum = ((InspectionTaskPerByGroupId)listMap.get(s)).getFinishTaskNum();
                    double l = (double)finishNum / (double)totalNum;
                    resp.setFinishPer(Double.valueOf(new BigDecimal(l * 100.0).setScale(2, 4).doubleValue()));
                }
                result.add(resp);
            }
        }
        return result;
    }

    @Override
    public List<GetFinishPerByOrganizeIdsResp> getFinishPerByOrganizeIds(GetFinishPerByOrganizeIdsReq req, Users user) {
        ArrayList respList = new ArrayList();
        List<Object> collect = new ArrayList<GetFinishPerByOrganizeIdsResp>();
        ArrayList departmentMoList = new ArrayList();
        ArrayList orgUserIdList = new ArrayList();
        ArrayList userIds = new ArrayList();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setOrganizeIds(req.getOrganizeId());
        mo.setUserId(user.getId());
        BaseResult result = this.userDepartmentApi.getUserAndDepByUserAndOrgId(mo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            ((List)result.getData()).forEach(departmentAndOrganizeAndUserMo -> {
                List departmentMoList1 = departmentAndOrganizeAndUserMo.getDepartmentMoList();
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentAndOrganizeAndUserMo.getUserList())) {
                    orgUserIdList.addAll(departmentAndOrganizeAndUserMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                }
                departmentMoList.addAll(departmentMoList1);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)departmentMoList)) {
                    departmentMoList.forEach(simpleDepartmentMo -> {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)simpleDepartmentMo.getUserList())) {
                            orgUserIdList.addAll(simpleDepartmentMo.getUserList().stream().map(SimpleUserMo::getId).collect(Collectors.toList()));
                        }
                    });
                }
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgUserIdList)) {
                    List opUserIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).collect(Collectors.toList());
                    InspectionPlanPersonlyResp personlyResp = this.inspectionTaskMapper.getFinishPerByOrganizeIds(user.getGroupId(), orgUserIdList, req.getStartTime(), req.getEndTime(), opUserIds);
                    if (personlyResp != null) {
                        GetFinishPerByOrganizeIdsResp resp = new GetFinishPerByOrganizeIdsResp();
                        resp.setId(departmentAndOrganizeAndUserMo.getOrganizeId());
                        resp.setName(departmentAndOrganizeAndUserMo.getOrganizeName());
                        resp.setTaskNum(personlyResp.getTaskNum());
                        resp.setFinishTaskNum(personlyResp.getFinishTaskNum());
                        resp.setPersonFinishPer(personlyResp.getPersonFinishPer());
                        respList.add(resp);
                    }
                }
            });
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)req.getUserIds())) {
                userIds.addAll(req.getUserIds().stream().map(s -> Integer.valueOf(s.split("_")[1])).collect(Collectors.toList()));
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(userIds)) {
                List opUserIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).list().stream().map(InspectionTask::getOperatorId).collect(Collectors.toList());
                List resps = this.inspectionTaskMapper.getFinishPerByUserIds(user.getGroupId(), userIds, req.getStartTime(), req.getEndTime(), opUserIds);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)resps)) {
                    resps.forEach(inspectionPlanPersonlyResp -> {
                        GetFinishPerByOrganizeIdsResp resp = new GetFinishPerByOrganizeIdsResp();
                        resp.setId(inspectionPlanPersonlyResp.getUserId());
                        resp.setName(inspectionPlanPersonlyResp.getUserName());
                        resp.setTaskNum(inspectionPlanPersonlyResp.getTaskNum());
                        resp.setFinishTaskNum(inspectionPlanPersonlyResp.getFinishTaskNum());
                        resp.setPersonFinishPer(inspectionPlanPersonlyResp.getPersonFinishPer());
                        respList.add(resp);
                    });
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(respList)) {
            collect = respList.stream().filter(resp -> resp.getPersonFinishPer() != null).collect(Collectors.toList());
            String[] sortNameArr = new String[]{"personFinishPer", "id"};
            boolean[] isAscArr = new boolean[]{req.getOrderType().equals(0), true};
            ListUtils.sort(collect, (String[])sortNameArr, (boolean[])isAscArr);
        }
        return collect;
    }

    @Override
    public JsonNewResult<InspectionPlanTaskDetailResp> detail(InspectionPlanTaskDetailReq req, Users user) throws IOException {
        com.ovopark.pojo.BaseResult result;
        Integer taskId = req.getId();
        InspectionTask task = Optional.ofNullable(this.inspectionTaskMapper.selectbyPrimaryId(taskId)).orElseThrow(() -> new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]));
        Map<Object, Object> tempMap = new HashMap();
        HashSet<Integer> havaFinishTemplateExpandIds = new HashSet<Integer>();
        HashMap<Integer, List> expandIdTemplateMap = new HashMap<Integer, List>();
        List templates = this.isInspectionDeptTemplateMapper.getTemplateByTaskId(taskId);
        if (CollectionUtils.isNotEmpty((Collection)templates)) {
            ArrayList<Integer> tempIds = new ArrayList<Integer>();
            for (InspectionPlanTemplateDetailResp template : templates) {
                tempIds.add(template.getTemplateId());
                if (template.getIsRead() == 1) {
                    havaFinishTemplateExpandIds.add(template.getExpandId());
                }
                expandIdTemplateMap.computeIfAbsent(template.getExpandId(), k -> new ArrayList()).add(template.getTemplateId());
            }
            List<IsCheckTemplate> checkTemplates = this.isCheckTemplateService.getListByIds(tempIds);
            if (CollectionUtils.isNotEmpty(checkTemplates)) {
                tempMap = checkTemplates.stream().collect(Collectors.toMap(IsCheckTemplate::getId, IsCheckTemplate::getName));
            }
        }
        this.menusPrivilegesService.checkPrivilege(user, MainTypeEnum.INSPECTION.getCode());
        Set notDeleteExpandIds = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)taskId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).eq(IsInspectionDeptTemplate::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).list().stream().map(IsInspectionDeptTemplate::getExpandId).collect(Collectors.toSet());
        InspectionPlanTaskDetailResp resp = (InspectionPlanTaskDetailResp)ClazzConverterUtils.converterClass((Object)task, InspectionPlanTaskDetailResp.class);
        Integer auditConfigId = this.auditConfigService.checkAudit(user, user.getId());
        resp.setAuditConfigId(auditConfigId);
        Date now = new Date();
        if (resp.getEndTime() != null) {
            resp.setIsExpire(resp.getEndTime().before(now) ? DefaultEnum.DEFAULT_TRUE.getCode() : DefaultEnum.DEFAULT_FALSE.getCode());
        }
        if (task.getOperatorId().equals(user.getId()) && Arrays.asList(InspectionTaskStatusEnum.PASS.getCode(), InspectionTaskStatusEnum.INSPECT.getCode()).contains(task.getStatus()) && now.after(task.getStartTime())) {
            resp.setIsOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId())) {
            resp.setIsExecuter(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId()) && InspectionTaskStatusEnum.AUDIT.getCode().equals(task.getStatus())) {
            boolean contains;
            EnterpriseConfigPojo pojo;
            if (!resp.getIsExpire().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
                resp.setIsUrged(DefaultEnum.DEFAULT_TRUE.getCode());
            }
            if ((pojo = (EnterpriseConfigPojo)this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId()).getData()) != null && StringUtils.isNotBlank((String)pojo.getExpireExecute()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)Stream.of(pojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())) && (contains = Stream.of(pojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode()))) {
                resp.setIsUrged(DefaultEnum.DEFAULT_TRUE.getCode());
            }
            resp.setIsOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getAuditId().equals(user.getId()) && InspectionTaskStatusEnum.AUDIT.getCode().equals(task.getStatus())) {
            resp.setIsAudit(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        if (task.getOperatorId().equals(user.getId())) {
            resp.setSameWithOperator(DefaultEnum.DEFAULT_TRUE.getCode());
        }
        ArrayList expandRespList = new ArrayList();
        Map<Object, Object> deptNameMap = new HashMap();
        Map<Object, Object> tagMap = new HashMap();
        Map<Object, Object> groupByDeptIdTagMap = new HashMap();
        List expandList = this.inspectionTaskExpandMapper.selectExpandListByTaskId(taskId, user.getGroupId());
        ArrayList<Integer> deptIdList = new ArrayList<Integer>();
        ArrayList<ExpandDetailDto> detailDtos = new ArrayList<ExpandDetailDto>();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expandList)) {
            Object deptTagList;
            Map<Integer, Map<Integer, List<InspectionTaskExpand>>> groupMap = expandList.stream().collect(Collectors.groupingBy(InspectionTaskExpand::getExpandGroup, Collectors.groupingBy(InspectionTaskExpand::getDeptId)));
            for (Map.Entry<Integer, Map<Integer, List<InspectionTaskExpand>>> groupEnty : groupMap.entrySet()) {
                for (Map.Entry<Integer, List<InspectionTaskExpand>> expandMap : groupEnty.getValue().entrySet()) {
                    ExpandDetailDto detailDto = new ExpandDetailDto();
                    detailDto.setExpandGroup(groupEnty.getKey());
                    detailDto.setMainType(expandMap.getValue().get(0).getMainType());
                    detailDto.setDescription(expandMap.getValue().get(0).getDescription());
                    detailDto.setDeptId(expandMap.getKey());
                    deptIdList.add(expandMap.getKey());
                    ArrayList<ExplandExpectTime> expectTimes = new ArrayList<ExplandExpectTime>();
                    for (InspectionTaskExpand expand : expandMap.getValue()) {
                        ExplandExpectTime expectTime = new ExplandExpectTime();
                        expectTime.setExpectTimeStr(expand.getExpectTime() == null ? null : DateUtil.format((Date)expand.getExpectTime(), (String)DateUtil.FORMAT_LONG));
                        expectTime.setExplanId(expand.getId());
                        expectTime.setStatus(expand.getStatus());
                        expectTime.setCanotDel(havaFinishTemplateExpandIds.contains(expand.getId()) || expand.getStatus() == 1);
                        expectTime.setCanotChange(expand.getStatus() == 1);
                        expectTimes.add(expectTime);
                    }
                    detailDto.setExpectTimeStrs(expectTimes);
                    detailDtos.add(detailDto);
                }
            }
            deptNameMap = this.departProxy.getDeptNameMap(deptIdList);
            List<Integer> deletedDepIds = this.departProxy.getDeletedDepIds(user.getGroupId());
            InspectionConfigReq inspectionConfig = this.inspectionConfigService.getInspectionConfig(user);
            if (inspectionConfig.getQuestionTag().equals(OpenEnum.OPEN.getCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(deptTagList = this.inspectionDeptTagMapper.selectTagIdListByTaskAndDeptList(taskId, user.getGroupId(), deptIdList)))) {
                List tagIdList = deptTagList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList());
                groupByDeptIdTagMap = deptTagList.stream().collect(Collectors.groupingBy(InspectionDeptTag::getExpandId));
                List tagList = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), tagIdList);
                tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
            }
            for (ExpandDetailDto dto : detailDtos) {
                Integer deptId = dto.getDeptId();
                boolean b = dto.getExpectTimeStrs().stream().anyMatch(ExplandExpectTime::isCanotDel);
                dto.setNotDeleted(b ? DefaultEnum.DEFAULT_TRUE.getCode() : DefaultEnum.DEFAULT_FALSE.getCode());
                dto.setDeptName((String)deptNameMap.get(deptId));
            }
        }
        Map<Integer, List<ExpandDetailDto>> expandMap = detailDtos.stream().collect(Collectors.groupingBy(ExpandDetailDto::getExpandGroup));
        ArrayList<GroupExpandDetailDto> mos = new ArrayList<GroupExpandDetailDto>();
        for (Map.Entry<Integer, List<ExpandDetailDto>> entry : expandMap.entrySet()) {
            GroupExpandDetailDto mo = new GroupExpandDetailDto();
            mo.setCanotChange(entry.getValue().stream().map(ExpandDetailDto::getExpectTimeStrs).flatMap(Collection::stream).anyMatch(ExplandExpectTime::isCanotChange));
            mo.setDeptModels(entry.getValue());
            mo.setMainType(entry.getValue().get(0).getMainType());
            List<Integer> expandIds = entry.getValue().stream().map(ExpandDetailDto::getExpectTimeStrs).flatMap(Collection::stream).map(ExplandExpectTime::getExplanId).collect(Collectors.toList());
            List<InspectionPlanTemplateDetailResp> templateVos = this.isInspectionDeptTemplateService.getByExpandId(expandIds);
            if (CollectionUtils.isNotEmpty(templateVos)) {
                for (InspectionPlanTemplateDetailResp vo : templateVos) {
                    vo.setTemplateName((String)tempMap.get(vo.getTemplateId()));
                }
                mo.setTemplateVos(templateVos);
            }
            ExpandDetailDto dto = entry.getValue().get(0);
            Set tagList = mo.getTagList();
            mo.setExpandGroup(dto.getExpandGroup());
            for (ExplandExpectTime expectTimeStr : dto.getExpectTimeStrs()) {
                List tags = (List)groupByDeptIdTagMap.get(expectTimeStr.getExplanId());
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)tags)) continue;
                for (InspectionDeptTag tag : tags) {
                    InspectionPlanTagDetailResp tagResp = new InspectionPlanTagDetailResp(tag.getTagId(), (String)tagMap.get(tag.getTagId()), null);
                    tagList.add(tagResp);
                }
            }
            boolean canotDel = entry.getValue().stream().map(ExpandDetailDto::getExpectTimeStrs).flatMap(Collection::stream).anyMatch(ExplandExpectTime::isCanotDel);
            mo.setCanotDel(canotDel);
            mo.setDescription(dto.getDescription());
            mos.add(mo);
        }
        resp.setInspectionExpandList(mos);
        List list = this.inspectionAuditReasonMapper.selectAudiReasonListByTaskId(taskId);
        List reasonList = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            reasonList = ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTaskAuditReasonResp.class);
        }
        resp.setReason(reasonList);
        List uIds = ((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getTaskId, (Object)task.getId())).list().stream().map(InspectionTaskCcModel::getCcId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(uIds) && !org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)(result = this.userApi.getUserPojosByIdList(uIds)).getData()))) {
            resp.setCcUsers((List)result.getData());
        }
        ArrayList<Object> templateIds = new ArrayList<Object>(tempMap.keySet());
        if (!deptIdList.isEmpty() && !templateIds.isEmpty()) {
            InspectionLastTimeReq lastTimeReq = new InspectionLastTimeReq();
            List dateAndDepIds = deptIdList.stream().map(depId -> {
                InspectionLastTimeReq.DateAndDepId dateAndDepId = new InspectionLastTimeReq.DateAndDepId();
                dateAndDepId.setDepId(Long.valueOf(depId.intValue()));
                dateAndDepId.setDate(null);
                return dateAndDepId;
            }).collect(Collectors.toMap(InspectionLastTimeReq.DateAndDepId::getDepId, dateAndDepId -> dateAndDepId, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
            lastTimeReq.setDateAndDepIds(dateAndDepIds);
            lastTimeReq.setTemplateIds(templateIds.stream().map(Long::valueOf).collect(Collectors.toList()));
            log.info("DepIds: {}", deptIdList);
            log.info("TemplateIds: {}", templateIds);
            Map<Long, List<ShopInspectionInfo>> lastInspectTimes = this.getLastInspectTimes(lastTimeReq);
            if (lastInspectTimes != null) {
                resp.setDepLastTimeMap(lastInspectTimes);
                log.info("Successfully set depLastTimeMap for taskId: {}", (Object)req.getId());
            } else {
                log.warn("lastInspectTimes is null, could not set depLastTimeMap for taskId: {}", (Object)req.getId());
            }
        } else {
            log.warn("DepIds or TemplateIds are empty, skipping getLastInspectTimes for taskId: {}", (Object)req.getId());
        }
        return JsonNewResult.success((Object)resp);
    }

    @Override
    public InspectionPlanTaskWebExpandListResp webExpandList(InspectionPlanWebExpandReq req, Users user) {
        Integer taskId = req.getTaskId();
        InspectionTask orgTask = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (orgTask == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        List list = this.inspectionTaskExpandMapper.selectExpandListByTaskIdNew(taskId, user.getGroupId());
        Map<Object, Object> tagMap = new HashMap();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return new InspectionPlanTaskWebExpandListResp();
        }
        List deptIdList = list.stream().map(InspectionTaskExpand::getDeptId).collect(Collectors.toList());
        Map<Object, Object> groupByDeptIdTagMap = new HashMap();
        List deptTagList = this.inspectionDeptTagMapper.selectTagIdListByTaskAndDeptListNew(taskId, user.getGroupId(), deptIdList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)deptTagList)) {
            List tagIdList = deptTagList.stream().map(InspectionDeptTag::getTagId).collect(Collectors.toList());
            groupByDeptIdTagMap = deptTagList.stream().collect(Collectors.groupingBy(InspectionDeptTag::getExpandId));
            List tagList = this.inspectionTagMapper.queryTagByTagIdList(user.getGroupId(), tagIdList);
            tagMap = tagList.stream().collect(Collectors.toMap(InspectionTag::getId, InspectionTag::getName));
        }
        HashMap<Integer, InspectionPlanTaskWebExpandListInnerResp> resultMap = new HashMap<Integer, InspectionPlanTaskWebExpandListInnerResp>();
        for (InspectionTaskExpand expand : list) {
            InspectionTaskExpandStatusEnum expandStatusEnum = InspectionTaskExpandStatusEnum.formatOrNull((Integer)expand.getStatus());
            InspectionPlanTaskWebExpandListInnerResp innerResp = new InspectionPlanTaskWebExpandListInnerResp(expand.getStatus(), expandStatusEnum == null ? "" : expandStatusEnum.getDesc(), expand.getDescription());
            Integer deptId = expand.getDeptId();
            List eachDeptTagList = (List)groupByDeptIdTagMap.get(expand.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)eachDeptTagList)) {
                for (InspectionDeptTag inspectionDeptTag : eachDeptTagList) {
                    Set tagNameList = innerResp.getTagNameList();
                    Integer tagId = inspectionDeptTag.getTagId();
                    String tagName = (String)tagMap.get(tagId);
                    tagNameList.add(tagName);
                }
            }
            resultMap.put(expand.getId(), innerResp);
        }
        return new InspectionPlanTaskWebExpandListResp(resultMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JsonNewResult<Void> delete(InspectionPlanTaskDeleteReq req, Users user) {
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (task == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        this.inspectionTaskMapper.deleteByPrimaryId(taskId);
        this.inspectionTaskExpandMapper.deleteByTaskIdWithOutExpandList(taskId, new ArrayList());
        this.inspectionDeptTagMapper.deleteByTaskIdWithOutDeptIdList(taskId, new ArrayList());
        this.inspectionAuditReasonMapper.deleteByTaskId(taskId);
        Date now = new Date();
        if (task.getJobId() != null && task.getEndTime() != null) {
            Integer jobId = task.getJobId();
            if (now.before(task.getEndTime())) {
                this.xxlJobProxy.stopJob(jobId);
            }
        }
        if (task.getStatus() != 0) {
            DeleteMessagesByObjectBuilder builder = new DeleteMessagesByObjectBuilder();
            this.messageProxy.deleteMessagesByObject(builder.objectType(InspectionPlanMainTypeEnum.INSPECTION.getDesc()).subId(task.getId()).isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).isComplete(YesEnum.DELETED.getCode()).build());
            this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.DELETE_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.LIST.getCode(), null, null, null);
            this.messageProxy.sendWebSocketAndJpush(task.getOperatorId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.DELETE_MESSAGE, user.getShowName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.LIST.getCode(), null, null, null);
        }
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> batchDelete(InspectionPlanTaskDeleteReq req, Users user) {
        List taskIdList = req.getIdList();
        List taskList = this.inspectionTaskMapper.selectTaskByIdList(taskIdList, user.getGroupId());
        Date now = new Date();
        this.inspectionTaskMapper.deleteByIdList(taskIdList, user.getGroupId());
        this.inspectionTaskExpandMapper.deleteByTaskIdListWithOutExpandList(taskIdList, new ArrayList(), user.getGroupId());
        this.inspectionDeptTagMapper.deleteByTaskIdListWithOutDeptIdList(taskIdList, new ArrayList(), user.getGroupId());
        List jobIdList = taskList.stream().filter(t1 -> t1.getEndTime() != null && now.before(t1.getEndTime())).map(InspectionTask::getJobId).collect(Collectors.toList());
        for (Integer jobId : jobIdList) {
            this.xxlJobProxy.stopJob(jobId);
        }
        for (Integer integer : taskIdList) {
            DeleteMessagesByObjectBuilder builder = new DeleteMessagesByObjectBuilder();
            this.messageProxy.deleteMessagesByObject(builder.objectType(InspectionPlanMainTypeEnum.INSPECTION.getDesc()).subId(integer).isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).build());
        }
        return JsonNewResult.success();
    }

    @Override
    public List<InspectionPlanTaskAppLogListResp> appLogList(InspectionPlanTaskAppLogListReq req, Users user) {
        Integer groupId = user.getGroupId();
        Integer taskId = req.getTaskId();
        List<Integer> taskIdList = Arrays.asList(taskId);
        ArrayList<InspectionPlanTaskAppLogListResp> result = new ArrayList<InspectionPlanTaskAppLogListResp>();
        List logList = this.inspectionOperatorLogMapper.selectLogListByGroupAndTaskIdList(taskIdList, groupId);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)logList)) {
            return result;
        }
        for (InspectionOperatorLog model : logList) {
            InspectionPlanTaskAppLogListResp resp = (InspectionPlanTaskAppLogListResp)ClazzConverterUtils.converterClass((Object)model, InspectionPlanTaskAppLogListResp.class);
            resp.setCreateTime(DateUtil.format((Date)model.getCreateTime(), (String)DateUtil.FORMAT_NO_SECNOD));
            if (Objects.nonNull(model.getOperatorAction())) {
                resp.setOperatorAction(OperatorActionEnum.getEnum((Integer)model.getOperatorAction()).getDesc());
            }
            if (Objects.nonNull(model.getOperatorType())) {
                resp.setOperatorType(OperatorTypeEnum.getEnum((Integer)model.getOperatorType()).getDesc());
            }
            result.add(resp);
        }
        return result;
    }

    @Override
    public JsonNewResult<Void> urged(InspectionPlanTaskUrgedReq req, Users user) {
        Integer taskId = req.getId();
        InspectionTask task = this.inspectionTaskMapper.selectbyPrimaryId(taskId);
        if (task == null) {
            throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
        }
        this.insertLogNew(OperatorTypeEnum.OPERTOR.getCode(), OperatorActionEnum.URGED.getCode(), user, task.getId(), LogConstant.URGED, null, user.getShowName());
        this.messageProxy.sendWebSocketAndJpush(task.getAuditId(), user.getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.URGED_AUDIT, task.getOperatorName(), task.getName()), user.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, req.getTokenType(), JumpTypeEnum.AUDIT.getCode(), null, null, null);
        return JsonNewResult.success();
    }

    @Override
    public void insertLogNew(Integer operatorType, Integer operatorAction, Users user, Integer taskId, String content, String remark, String ... param) {
        if (StringUtils.isNotBlank((String)content)) {
            content = String.format(content, param);
        }
        InspectionOperatorLog log = new InspectionOperatorLog(user.getGroupId(), taskId, user.getId(), user.getShowName(), content, operatorType, operatorAction, remark);
        EntityBase.setCreateParams((Object)log, (Users)user);
        this.inspectionOperatorLogMapper.insert((Object)log);
    }

    @Override
    public void insertLog(Integer operatorType, Integer operatorAction, Users user, Integer taskId, String content, String remark) {
        InspectionOperatorLog log = new InspectionOperatorLog(user.getGroupId(), taskId, user.getId(), user.getShowName(), content, operatorType, operatorAction, remark);
        EntityBase.setCreateParams((Object)log, (Users)user);
        this.inspectionOperatorLogMapper.insert((Object)log);
    }

    @Override
    public void insertLogOfRemark(Integer operatorType, Integer operatorAction, Users user, Integer taskId, String content, String remark, String ... param) {
        remark = String.format(remark, param);
        InspectionOperatorLog log = new InspectionOperatorLog(user.getGroupId(), taskId, user.getId(), user.getShowName(), content, operatorType, operatorAction, remark);
        EntityBase.setCreateParams((Object)log, (Users)user);
        this.inspectionOperatorLogMapper.insert((Object)log);
    }

    @Override
    public IPage<InspectionPlanDtoResp> secondWebList(InspectionPlanTaskSecondReq req, Users user) throws IOException {
        IPage page;
        InspectionPlanDtoResp planDto = null;
        List respList = new ArrayList();
        InspectionTask task = (InspectionTask)this.getById(req.getTaskId());
        Optional.ofNullable(task).orElseThrow(() -> new SysErrorException(ResultCode.NO_CORRESPONDING_ENTITY, new Object[0]));
        List<Object> depIds = new ArrayList();
        Map<Object, Object> deptNameMap = new HashMap();
        if (StringUtils.isNotBlank((String)req.getDepName())) {
            List<Integer> baseResult = this.departProxy.findDeptListByGroupIdAndName(user.getGroupId(), req.getDepName());
            if (!org.springframework.util.CollectionUtils.isEmpty(baseResult)) {
                depIds = baseResult;
            }
            if (org.springframework.util.CollectionUtils.isEmpty(depIds)) {
                return new Page();
            }
        }
        List<Object> expandIds = new ArrayList();
        Map<Object, Object> expandMap = new HashMap();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(Optional.ofNullable(req.getExpectStartTime()).isPresent() && Optional.ofNullable(req.getExpectEndTime()).isPresent(), InspectionTaskExpand::getExpectTime, (Object)req.getExpectStartTime(), (Object)req.getExpectEndTime())).eq(InspectionTaskExpand::getTaskId, (Object)req.getTaskId())).eq(req.getMainType() != null, InspectionTaskExpand::getMainType, (Object)req.getMainType())).in(!org.springframework.util.CollectionUtils.isEmpty(depIds), InspectionTaskExpand::getDeptId, depIds)).eq(req.getStatus() != null, InspectionTaskExpand::getStatus, (Object)req.getStatus())).between(Optional.ofNullable(req.getStartTime()).isPresent() && Optional.ofNullable(req.getEndTime()).isPresent(), InspectionTaskExpand::getFinishTime, (Object)req.getStartTime(), (Object)req.getEndTime());
        if (Optional.ofNullable(req.getExpireExcute()).isPresent()) {
            wrapper.eq(InspectionTaskExpand::getExecuteExpire, (Object)req.getExpireExcute());
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(page = this.inspectionTaskExpandService.page((IPage)new Page((long)req.getPageNumber().intValue(), (long)req.getPageSize().intValue()), (Wrapper)wrapper)).getRecords())) {
            return new Page();
        }
        respList = ClazzConverterUtils.converterClass((Collection)page.getRecords(), InspectionPlanDtoResp.class);
        expandMap = page.getRecords().stream().collect(Collectors.toMap(InspectionTaskExpand::getId, Function.identity()));
        List<Integer> collect = page.getRecords().stream().map(InspectionTaskExpand::getDeptId).distinct().collect(Collectors.toList());
        deptNameMap = this.departProxy.getDeptNameMap(collect);
        expandIds = expandMap.keySet().stream().collect(Collectors.toList());
        Map<Object, Object> tagMap = new HashMap();
        List tagDtos = this.inspectionTagMapper.getListByTaskId(req.getTaskId(), user.getGroupId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagDtos)) {
            tagMap = tagDtos.stream().collect(Collectors.groupingBy(InspectionTagDto::getExpandId));
        }
        Map<Object, Object> expandTempMap = new HashMap();
        Map<Object, Object> templateNameMap = new HashMap();
        List list1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTaskId, (Object)req.getTaskId())).eq(IsInspectionDeptTemplate::getGroupId, (Object)user.getGroupId())).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list1)) {
            List<Integer> templateIds = list1.stream().map(IsInspectionDeptTemplate::getTemplateId).distinct().collect(Collectors.toList());
            templateNameMap = this.isCheckTemplateService.getIdAndName(templateIds);
            expandTempMap = list1.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.toMap(IsInspectionDeptTemplate::getTemplateId, Function.identity())));
        }
        InspectionPlanTaskSecondOpenReq secondOpenReq = new InspectionPlanTaskSecondOpenReq();
        secondOpenReq.setDetailIds(expandIds);
        secondOpenReq.setPageSize(null);
        secondOpenReq.setPageNumber(null);
        Map<Object, Object> liveSecondsTotal = new HashMap();
        ArrayList<InspectionPlanDto> dtos = new ArrayList<InspectionPlanDto>();
        for (Object inspectionPlanDtoResp : respList) {
            Map deptTemplateMap = Optional.ofNullable(expandTempMap.get(inspectionPlanDtoResp.getId())).orElse(new HashMap());
            if (MapUtils.isNotEmpty((Map)deptTemplateMap)) {
                for (Map.Entry entry : deptTemplateMap.entrySet()) {
                    InspectionPlanDto dto = new InspectionPlanDto();
                    dto.setDeptId(inspectionPlanDtoResp.getDeptId().intValue());
                    dto.setDeptName((String)deptNameMap.get(inspectionPlanDtoResp.getDeptId()));
                    dto.setDetailId(inspectionPlanDtoResp.getId());
                    dto.setTemplateId((Integer)entry.getKey());
                    dto.setTemplateName(templateNameMap.get(entry.getKey()) != null ? (String)templateNameMap.get(entry.getKey()) : "--");
                    dto.setStatus(((IsInspectionDeptTemplate)((Map)expandTempMap.get(inspectionPlanDtoResp.getId())).get(dto.getTemplateId())).getIsRead());
                    dto.setReason(((IsInspectionDeptTemplate)((Map)expandTempMap.get(inspectionPlanDtoResp.getId())).get(dto.getTemplateId())).getReason());
                    dto.setReason(((IsInspectionDeptTemplate)entry.getValue()).getReason());
                    dto.setExpectTimeStr(DateUtil.format((Date)inspectionPlanDtoResp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
                    dtos.add(dto);
                }
                continue;
            }
            InspectionPlanDto dto = new InspectionPlanDto();
            dto.setDeptId(inspectionPlanDtoResp.getDeptId().intValue());
            dto.setDeptName((String)deptNameMap.get(inspectionPlanDtoResp.getDeptId()));
            dto.setTemplateName("--");
            dto.setDetailId(inspectionPlanDtoResp.getId());
            dto.setReason(inspectionPlanDtoResp.getReason());
            dto.setStatus(inspectionPlanDtoResp.getStatus());
            dto.setExpectTimeStr(DateUtil.format((Date)inspectionPlanDtoResp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            dtos.add(dto);
        }
        Map<Integer, List<InspectionPlanDto>> expandDtoMap = dtos.stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId));
        planDto = this.inspectionPlanProxyService.secondWebList(secondOpenReq);
        if (planDto != null) {
            for (InspectionPlanDto dto : planDto.getData()) {
                InspectionPlanDto d;
                int i;
                List<InspectionPlanDto> inspectionPlanDtos;
                InspectionTaskExpand expand = (InspectionTaskExpand)expandMap.get((int)dto.getDetailId());
                if (expandTempMap.get(expand.getId()) != null && ((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId()) != null) {
                    inspectionPlanDtos = expandDtoMap.get(dto.getDetailId());
                    for (i = 0; i < inspectionPlanDtos.size(); ++i) {
                        d = inspectionPlanDtos.get(i);
                        if (!dto.getTemplateId().equals(d.getTemplateId())) continue;
                        d.setDeptId(dto.getDeptId());
                        d.setDeptName(dto.getDeptName());
                        d.setProblemNum(dto.getProblemNum());
                        d.setLiveSeconds(dto.getLiveSeconds());
                        d.setTotalProblemNum(dto.getTotalProblemNum());
                        d.setInvalidProblemNum(dto.getInvalidProblemNum());
                        d.setFinishTime(dto.getFinishTime());
                        d.setStartTime(dto.getStartTime());
                        d.setTaskId(dto.getTaskId());
                        d.setExecuteExpire(dto.getFinishTime() != null ? (dto.getFinishTime().after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode()) : null);
                        d.setStatus(((IsInspectionDeptTemplate)((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId())).getIsRead());
                        d.setReason(((IsInspectionDeptTemplate)((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId())).getReason());
                        inspectionPlanDtos.set(i, d);
                    }
                    continue;
                }
                inspectionPlanDtos = expandDtoMap.get(dto.getDetailId());
                for (i = 0; i < inspectionPlanDtos.size(); ++i) {
                    d = inspectionPlanDtos.get(i);
                    if (!dto.getDetailId().equals(d.getDetailId())) continue;
                    d.setDeptId(dto.getDeptId());
                    d.setDeptName(dto.getDeptName());
                    d.setProblemNum(dto.getProblemNum());
                    d.setLiveSeconds(dto.getLiveSeconds());
                    d.setTotalProblemNum(dto.getTotalProblemNum());
                    d.setInvalidProblemNum(dto.getInvalidProblemNum());
                    d.setFinishTime(dto.getFinishTime());
                    d.setStartTime(dto.getStartTime());
                    d.setTaskId(dto.getTaskId());
                    d.setExecuteExpire(dto.getFinishTime() != null ? (dto.getFinishTime().after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode()) : null);
                    d.setTemplateName(dto.getTemplateName());
                    inspectionPlanDtos.set(i, d);
                }
            }
            liveSecondsTotal = planDto.getData().stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId, Collectors.summingLong(InspectionPlanDto::getLiveSeconds)));
        }
        for (InspectionPlanDtoResp resp : respList) {
            resp.setData(expandDtoMap.get(resp.getId()));
            resp.setOperator(task.getOperatorName());
            resp.setLiveSeconds(liveSecondsTotal.get(resp.getId()) != null ? ((Long)liveSecondsTotal.get(resp.getId())).intValue() : 0);
            resp.setTags((List)tagMap.get(resp.getId()));
            resp.setDeptName((String)deptNameMap.get(resp.getDeptId()));
            resp.setStatusDesc(InspectionTaskExpandStatusEnum.formatOrNull((Integer)resp.getStatus()).getDesc());
            resp.setExecuteExpire(resp.getLiveSeconds() > 0 ? resp.getExecuteExpire() : null);
            resp.setExpectTimeStr(DateUtil.format((Date)resp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
        }
        Page respIPage = new Page();
        BeanUtils.copyProperties((Object)page, (Object)respIPage);
        respIPage.setRecords(respList);
        return respIPage;
    }

    @Override
    public Object getPlanList(Users user, PageReq req) {
        Map<Object, Object> tagNames = new HashMap();
        Boolean flag = false;
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        if (result.getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute())) {
            List collect = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList());
            flag = collect.contains(MainTypeEnum.INSPECTION.getCode());
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getOperatorId, (Object)user.getId())).lt(InspectionTask::getStartTime, (Object)new Date())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).in(InspectionTask::getStatus, Arrays.asList(InspectionTaskStatusEnum.PASS.getCode(), InspectionTaskStatusEnum.INSPECT.getCode()))).orderByDesc(InspectionTask::getEndTime);
        if (!flag.booleanValue()) {
            wrapper.eq(InspectionTask::getExpireStatus, (Object)ExpandExecuteExpireEnum.NOT.getCode());
        }
        IPage taskIPage = this.page((IPage)new Page((long)req.getPage().intValue(), (long)req.getPageSize().intValue()), (Wrapper)wrapper);
        Map<Object, Object> finishMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)taskIPage.getRecords())) {
            List<Integer> taskIds = taskIPage.getRecords().stream().map(InspectionTask::getId).collect(Collectors.toList());
            tagNames = this.inspectionTagService.getNameMapByTaskIds(taskIds, user.getGroupId());
            List<ExpandCountDto> dtos = this.inspectionTaskExpandService.countFinish(taskIds);
            finishMap = dtos.stream().collect(Collectors.toMap(ExpandCountDto::getExpandId, ExpandCountDto::getFinishNum));
        }
        CheckGetPlanResp resp = null;
        ArrayList<CheckGetPlanResp> resps = new ArrayList<CheckGetPlanResp>();
        for (InspectionTask record : taskIPage.getRecords()) {
            resp = new CheckGetPlanResp();
            resp.setStatus(record.getStatus());
            resp.setEndTime(record.getEndTime());
            resp.setId(record.getId());
            resp.setName(record.getName());
            resp.setStartTime(record.getStartTime());
            resp.setDepTotal(record.getTotalExpandCount());
            resp.setFinishDepTotal((Integer)finishMap.get(record.getId()));
            resp.setUnFinishDepTotal(Integer.valueOf(record.getTotalExpandCount() - resp.getFinishDepTotal()));
            resp.setTagName(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)tagNames.get(record.getId()))) ? (String)tagNames.get(record.getId()) : "");
            resps.add(resp);
        }
        Page page = new Page();
        page.setRecords(resps);
        page.setTotal(taskIPage.getTotal());
        page.setSize(taskIPage.getSize());
        page.setCurrent(taskIPage.getCurrent());
        page.setPages(taskIPage.getTotal());
        return page;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void check(List<DepartmentsExpect> list, Users user, Integer mainType) {
        log.info("\u5bfc\u5165\u95e8\u5e97\u6a21\u7248\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(list));
        Map<Integer, String> map = this.departProxy.getDepartmentByGroupId(user.getGroupId());
        Set<Object> depDeviceCount = new HashSet();
        if (mainType == 9) {
            depDeviceCount = this.deviceService.havaDeviceDep(user.getGroupId());
        }
        for (DepartmentsExpect expect : list) {
            ResultCodeInfo depError;
            if (StringUtils.isBlank((String)expect.getDepName()) || expect.getDepId() == null) {
                throw new SysErrorException(ResultCode.DATA_ERROR, new Object[0]);
            }
            log.info("\u5bfc\u5165\u95e8\u5e97\u6a21\u7248\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)expect));
            if (!map.containsKey(expect.getDepId()) || !map.containsValue(StringUtils.trim((String)expect.getDepName()))) {
                log.info("\u5bfc\u5165\u95e8\u5e97\u6a21\u7248\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)map.get(expect.getDepId())));
                depError = new ResultCodeInfo();
                depError.setCode(ResultCode.DEP_ERROR.getCode());
                depError.setDesc(String.format(ResultCode.DEP_ERROR.getDesc(), expect.getDepName()));
                throw new SysErrorException(depError, new Object[0]);
            }
            if (mainType == 9 && !depDeviceCount.contains(expect.getDepId())) {
                depError = new ResultCodeInfo();
                depError.setCode(ResultCode.DEP_ERROR.getCode());
                depError.setDesc(String.format(ResultCode.DEP_ERROR.getDesc(), expect.getDepName()));
                throw new SysErrorException(depError, new Object[0]);
            }
            if (expect.getExpectTime() == null) continue;
            HashSet<String> expectTimeStrs = new HashSet<String>();
            for (String time : expect.getExpectTime().split(",")) {
                boolean validDate = DateUtil.isLegalDate((int)(time = time.replace("-", "/")).length(), (String)time, (String)DateUtil.FORMAT_LONG_SECNOD);
                if (!validDate) {
                    ResultCodeInfo depError2 = new ResultCodeInfo();
                    depError2.setCode(ResultCode.EXPECT_TIME_ERROR.getCode());
                    depError2.setDesc(String.format(ResultCode.EXPECT_TIME_ERROR.getDesc(), expect.getDepName()));
                    throw new SysErrorException(depError2, new Object[0]);
                }
                expectTimeStrs.add(time);
            }
            expect.setExpectTimes(expectTimeStrs);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ImportDepartResp checkDepart(List<DepartmentsExport> list, Users user, Integer mainType) {
        log.info("\u5bfc\u5165\u95e8\u5e97\u6a21\u7248\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(list));
        EnterpriseConfigPojo enterpriseConfigPojo = this.enterpriseConfigService.selectOne(user.getGroupId());
        boolean checkPlanTime = enterpriseConfigPojo != null && OpenStatusEnum.NORMAL.getCode().equals(enterpriseConfigPojo.getIsStoreInspectionDate());
        ArrayList<DepartmentsExport> resultList = new ArrayList<DepartmentsExport>();
        ImportDepartResp resp = new ImportDepartResp();
        Map<Object, Object> map = new HashMap();
        if (this.usersRemoteService.isSupAdmin(user.getId(), user.getGroupId()).booleanValue()) {
            map = this.departProxy.getDepartmentByGroupId(user.getGroupId());
        } else {
            List<Integer> userDeptId = this.departProxy.getUserDeptId(user.getId(), user.getGroupId());
            map = this.departProxy.getDepartmentsMap(userDeptId);
        }
        if (map.isEmpty()) {
            throw new SysErrorException(ResultCode.DEP_NOT_FOUND, new Object[0]);
        }
        Set<Object> haveDeviceDepIds = new HashSet();
        if (mainType == 9) {
            haveDeviceDepIds = this.deviceService.havaDeviceDep(user.getGroupId());
        }
        List<String> shopIds = list.stream().map(DepartmentsExport::getShopId).distinct().collect(Collectors.toList());
        Map<String, Integer> depByShopIds = this.departProxy.getDepByShopIds(shopIds, user.getGroupId());
        HashSet<Integer> numList = new HashSet<Integer>();
        Integer num = 2;
        for (DepartmentsExport expect : list) {
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            if (!depByShopIds.containsKey(expect.getShopId()) || !map.containsKey(depByShopIds.get(expect.getShopId())) || StringUtils.isBlank((String)expect.getShopId()) || expect.getShopId() == null) {
                numList.add(num);
                continue;
            }
            if (mainType == 9 && !haveDeviceDepIds.contains(depByShopIds.get(expect.getShopId()))) {
                numList.add(num);
                continue;
            }
            if (checkPlanTime && expect.getExpectTime() == null) {
                numList.add(num);
                continue;
            }
            if (expect.getExpectTime() != null) {
                HashSet<String> expectTimeStrs = new HashSet<String>();
                boolean pass = false;
                for (String time : expect.getExpectTime().split(",")) {
                    boolean validDate = DateUtil.isLegalDate((int)time.length(), (String)time, (String)DateUtil.FORMAT_LONG_SECNOD);
                    if (!validDate) {
                        pass = true;
                        numList.add(num);
                        continue;
                    }
                    expectTimeStrs.add(time);
                }
                if (pass) continue;
                expect.setExpectTime(null);
                expect.setExpectTimes(expectTimeStrs);
            }
            expect.setDepName((String)map.get(depByShopIds.get(expect.getShopId())));
            expect.setDepId(depByShopIds.get(expect.getShopId()));
            resultList.add(expect);
        }
        if (CollectionUtils.isNotEmpty(numList)) {
            resp.setHasErrorDept(Boolean.valueOf(true));
            resp.setErrorDesc("\u6587\u6863\u4e2d\u7b2c" + numList.stream().map(String::valueOf).collect(Collectors.joining(",")) + "\u884c\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        resp.setList(resultList.stream().distinct().collect(Collectors.toList()));
        return resp;
    }

    @Override
    public List<CalendarResp> calendar(String startTime, String endTime, Users user) {
        ExpandDepTemplateDto dto;
        Set<Integer> haveNoTemplateExpandIds;
        Object task;
        List ccList;
        Date sTime = DateUtil.parse((String)startTime, (String)DateUtil.FORMAT_LONG);
        Date eTime = DateUtil.parse((String)endTime, (String)DateUtil.FORMAT_LONG);
        Date startime = DateUtils.addMonth((Date)eTime, (int)-3);
        Boolean supAdmin = this.usersRemoteService.isSupAdmin(user.getId(), user.getGroupId());
        Set<Integer> usersPojoMap = this.usersRemoteService.getUserIdsByPrivilegeUserId(user.getGroupId(), user.getId());
        List<InspectionTask> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getGroupId, (Object)user.getGroupId())).and(supAdmin == false, wrapper -> {
            Consumer<LambdaQueryWrapper> commonConditions = b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.eq(InspectionTask::getAuditId, (Object)user.getId())).or()).eq(InspectionTask::getCreateId, (Object)user.getId())).or()).eq(InspectionTask::getOperatorId, (Object)user.getId());
            };
            if (!usersPojoMap.isEmpty()) {
                ((LambdaQueryWrapper)wrapper.in(InspectionTask::getCreateId, (Collection)usersPojoMap)).or(commonConditions);
            } else {
                wrapper.and(commonConditions);
            }
        })).between(InspectionTask::getCreateTime, (Object)DateUtil.getStartTimeOfDay((Date)startime), (Object)eTime)).eq(InspectionTask::getIsDeleted, (Object)0)).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.DEFAULT.getCode())).list();
        ArrayList taskIds = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            List allTaskIds = list.stream().map(InspectionTask::getId).collect(Collectors.toList());
            taskIds.addAll(allTaskIds);
        }
        if (!supAdmin.booleanValue() && !org.springframework.util.CollectionUtils.isEmpty(ccList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskCcService.lambdaQuery().eq(InspectionTaskCcModel::getCcId, (Object)user.getId())).eq(InspectionTaskCcModel::getGroupId, (Object)user.getGroupId())).eq(InspectionTaskCcModel::getIsDeleted, (Object)0)).between(InspectionTaskCcModel::getCreateTime, (Object)startime, (Object)endTime)).list().stream().map(InspectionTaskCcModel::getTaskId).collect(Collectors.toList()))) {
            list.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTask::getId, ccList)).list());
            list = list.stream().distinct().collect(Collectors.toList());
            taskIds.addAll(ccList);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(taskIds)) {
            return new ArrayList<CalendarResp>();
        }
        ArrayList ids = new ArrayList();
        HashMap userAndTaskIdMap = new HashMap();
        HashMap taskEndTimeMap = new HashMap();
        HashMap taskMap = new HashMap();
        HashMap loginUserTaskMap = new HashMap();
        list.forEach(e -> {
            taskEndTimeMap.put(e.getId(), e.getEndTime());
            taskMap.put(e.getId(), e);
            if (taskIds.contains(e.getId())) {
                List taskList = userAndTaskIdMap.computeIfAbsent(e.getOperatorId(), k -> new ArrayList());
                taskList.add(e.getId());
            }
        });
        if (org.springframework.util.CollectionUtils.isEmpty(taskIds)) {
            return new ArrayList<CalendarResp>();
        }
        List expands = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionTaskExpandService.lambdaQuery().in(InspectionTaskExpand::getTaskId, taskIds)).eq(InspectionTaskExpand::getIsDeleted, (Object)0)).list();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)expands)) {
            return new ArrayList<CalendarResp>();
        }
        HashSet<Integer> expandIdList = new HashSet<Integer>();
        HashMap<Integer, Set> taskAndExpandMap = new HashMap<Integer, Set>();
        HashMap<Integer, InspectionTaskExpand> expandMap = new HashMap<Integer, InspectionTaskExpand>();
        ArrayList<Integer> depIds = new ArrayList<Integer>();
        HashSet<Integer> operatorIds = new HashSet<Integer>();
        ArrayList<Integer> templateIds = new ArrayList<Integer>();
        for (InspectionTaskExpand expand : expands) {
            Date date;
            operatorIds.add(expand.getOperatorId());
            if (expand.getFinishTime() != null && expand.getFinishTime().after(sTime) && expand.getFinishTime().before(eTime)) {
                expandIdList.add(expand.getId());
                depIds.add(expand.getDeptId());
                taskAndExpandMap.computeIfAbsent(expand.getTaskId(), k -> new HashSet()).add(expand.getId());
                expandMap.put(expand.getId(), expand);
            }
            if (expand.getFinishTime() == null && expand.getExpectTime() != null && expand.getExpectTime().getTime() >= sTime.getTime() && expand.getExpectTime().getTime() <= eTime.getTime()) {
                expandIdList.add(expand.getId());
                depIds.add(expand.getDeptId());
                taskAndExpandMap.computeIfAbsent(expand.getTaskId(), k -> new HashSet()).add(expand.getId());
                expandMap.put(expand.getId(), expand);
            }
            if (expand.getFinishTime() != null || expand.getExpectTime() != null || (date = (Date)taskEndTimeMap.get(expand.getTaskId())).getTime() < sTime.getTime() || date.getTime() > eTime.getTime()) continue;
            expandIdList.add(expand.getId());
            depIds.add(expand.getDeptId());
            taskAndExpandMap.computeIfAbsent(expand.getTaskId(), k -> new HashSet()).add(expand.getId());
            expandMap.put(expand.getId(), expand);
        }
        Map<UsersDeptTime, Integer> stayTimeSumMap = this.checkService.getUsersDeptTimeSummary(new ArrayList<Integer>(operatorIds), depIds, startTime, endTime, user.getGroupId());
        Map<Integer, String> departmentsMap = this.departProxy.getDepNameMap(depIds);
        Map<Object, Object> templateMap = new HashMap();
        HashMap<Integer, List> groupedDepTemplates = new HashMap<Integer, List>();
        HashSet<Integer> haveTemplateExpandIds = new HashSet<Integer>();
        if (org.springframework.util.CollectionUtils.isEmpty(expandIdList)) {
            return new ArrayList<CalendarResp>();
        }
        List depTemplates = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.inspectionDeptTemplateService.lambdaQuery().in(IsInspectionDeptTemplate::getExpandId, expandIdList)).eq(IsInspectionDeptTemplate::getIsDeleted, (Object)0)).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)depTemplates)) {
            for (IsInspectionDeptTemplate depTemplate : depTemplates) {
                templateIds.add(depTemplate.getTemplateId());
                haveTemplateExpandIds.add(depTemplate.getExpandId());
                groupedDepTemplates.computeIfAbsent(depTemplate.getExpandId(), k -> new ArrayList()).add(DepTemplateDto.builder().templateId(depTemplate.getTemplateId()).isRead(depTemplate.getIsRead()).build());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(haveTemplateExpandIds) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(task = this.inspectionPlanProxyService.getCheckTaskByExpandIds(haveNoTemplateExpandIds = expandIdList.stream().filter(e -> !haveTemplateExpandIds.contains(e)).collect(Collectors.toSet()))))) {
            Iterator iterator = task.iterator();
            while (iterator.hasNext()) {
                dto = (InspectionPlanDto)iterator.next();
                templateIds.add(dto.getTemplateId());
                templateMap.computeIfAbsent(dto.getTemplateId(), arg_0 -> InspectionTaskServiceImpl.lambda$calendar$64((InspectionPlanDto)dto, arg_0));
                groupedDepTemplates.computeIfAbsent(dto.getDetailId(), k -> new ArrayList()).add(DepTemplateDto.builder().isRead(Integer.valueOf(1)).templateId(dto.getTemplateId()).templateName(dto.getTemplateName()).build());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(templateIds)) {
            templateMap = this.isCheckTemplateService.getIdAndName(templateIds);
        }
        HashMap<Integer, ExpandDepTemplateDto> map = new HashMap<Integer, ExpandDepTemplateDto>();
        for (Integer detailId : expandIdList) {
            dto = new ExpandDepTemplateDto();
            dto.setDeptId(((InspectionTaskExpand)expandMap.get(detailId)).getDeptId());
            dto.setDeptName(departmentsMap.get(dto.getDeptId()));
            dto.setInspectionTaskId(((InspectionTaskExpand)expandMap.get(detailId)).getTaskId());
            dto.setStatus(((InspectionTask)taskMap.get(dto.getInspectionTaskId())).getStatus());
            dto.setExpireStatus(((InspectionTask)taskMap.get(dto.getInspectionTaskId())).getExpireStatus());
            dto.setName(((InspectionTask)taskMap.get(dto.getInspectionTaskId())).getName());
            dto.setDetailId(detailId);
            dto.setExpandStatus(((InspectionTaskExpand)expandMap.get(detailId)).getStatus());
            dto.setMainType(((InspectionTaskExpand)expandMap.get(detailId)).getMainType());
            dto.setFinishTime(((InspectionTaskExpand)expandMap.get(detailId)).getFinishTime() != null ? ((InspectionTaskExpand)expandMap.get(detailId)).getFinishTime() : (((InspectionTaskExpand)expandMap.get(detailId)).getExpectTime() != null ? ((InspectionTaskExpand)expandMap.get(detailId)).getExpectTime() : (Date)taskEndTimeMap.get(dto.getInspectionTaskId())));
            List depTemplateDtos = (List)groupedDepTemplates.get(detailId);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)depTemplateDtos)) {
                for (DepTemplateDto depTemplateDto : depTemplateDtos) {
                    depTemplateDto.setTemplateName((String)templateMap.get(depTemplateDto.getTemplateId()));
                }
            }
            if (MainTypeEnum.LIVE_PATROL.getCode().equals(dto.getMainType())) {
                dto.setStayTime(DateUtil.secondsConvertToDateStr((Integer)stayTimeSumMap.get(UsersDeptTime.builder().deptId(dto.getDeptId()).userId(((InspectionTaskExpand)expandMap.get(detailId)).getOperatorId()).date(DateUtil.format((Date)dto.getFinishTime(), (String)DateUtil.FORMAT_SHORT)).build()), (int)1));
            }
            dto.setTemplateDtos(depTemplateDtos);
            map.computeIfAbsent(detailId, k -> dto);
        }
        Map<Integer, UsersPojo> userMap = this.usersRemoteService.getCoreUserMapByIds(userAndTaskIdMap.keySet().stream().collect(Collectors.toList()));
        ArrayList<CalendarResp> resps = new ArrayList<CalendarResp>();
        for (Map.Entry entry : userAndTaskIdMap.entrySet()) {
            CalendarResp resp = new CalendarResp();
            resp.setUserId((Integer)entry.getKey());
            resp.setUserName(userMap.get(entry.getKey()).getShowName());
            resp.setThumbUrl(userMap.get(entry.getKey()).getThumbUrl());
            resp.setStaffImageUrl(userMap.get(entry.getKey()).getStaffImageUrl());
            ArrayList dtos = new ArrayList();
            List taskList = (List)entry.getValue();
            if (taskList == null) continue;
            taskList.forEach(itask -> {
                Set expandIds = (Set)taskAndExpandMap.get(itask);
                if (expandIds == null) {
                    return;
                }
                map.forEach((k, v) -> {
                    if (expandIds.contains(k)) {
                        dtos.add(v);
                    }
                });
            });
            if (org.springframework.util.CollectionUtils.isEmpty(dtos)) continue;
            resp.setMap(dtos.stream().collect(Collectors.groupingBy(e -> DateUtil.format((Date)e.getFinishTime(), (String)DateUtil.FORMAT_LONG_SECNOD))));
            resps.add(resp);
        }
        return resps;
    }

    @Override
    public Page<IdAndName> taskName(TaskNameReq req, Users user) {
        return (Page)this.inspectionTaskMapper.selectJoinPage((IPage)new Page((long)req.getPage().intValue(), (long)req.getPageSize().intValue()), IdAndName.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAs(InspectionTask::getId, IdAndName::getId)).selectAs(InspectionTask::getName, IdAndName::getName)).eq(InspectionTask::getGroupId, (Object)user.getGroupId())).like(StringUtils.isNotBlank((String)req.getStorePlanName()), InspectionTask::getName, (Object)req.getStorePlanName())).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.DEFAULT.getCode())).eq(InspectionTask::getIsDeleted, (Object)DeleteEnum.NOT_DELETED.getCode())).orderByDesc(InspectionTask::getCreateTime));
    }

    @Override
    public void fixCommonConfig() {
        List<EnterpriseConfigPojo> list = this.enterpriseConfigService.list();
        log.info("\u5de1\u68c0\u8ba1\u5212\u7684\u4f01\u4e1a\uff1a{}", list);
        ConfigStrategyFactory factory = new ConfigStrategyFactory();
        if (CollectionUtils.isNotEmpty(list)) {
            ConfigStrategy strategy = factory.getStrategy(CommonConfigEnum.UPDATE_TIME.getKey());
            for (EnterpriseConfigPojo dto : list) {
                CommonConfig config = (CommonConfig)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.commonConfigService.lambdaQuery().eq(CommonConfig::getGroupId, (Object)dto.getGroupId())).eq(CommonConfig::getConfigKey, (Object)CommonConfigEnum.UPDATE_TIME.getKey())).one()).orElse(new CommonConfig());
                config.setGroupId(dto.getGroupId());
                config.setConfigKey(CommonConfigEnum.UPDATE_TIME.getKey());
                config.setConfigValue(dto.getAllowEditingApproval() == 1 ? JSON.toJSONString((Object)UpdateTimesDto.builder().canUpdate(1).updateTimes(3).build()) : JSON.toJSONString((Object)UpdateTimesDto.builder().canUpdate(0).updateTimes(0).build()));
                this.commonConfigService.saveOrUpdate(config);
            }
        }
    }

    private Map<Long, List<ShopInspectionInfo>> packageLastInspectTimes(InspectionLastTimeReq req) {
        Map<Long, List<ShopInspectionInfo>> lastTimeMap = this.getLastInspectTimes(req);
        HashSet<Long> missingTemplateIds = new HashSet<Long>();
        HashSet<Long> missingStoreIds = new HashSet<Long>();
        for (Map.Entry<Long, List<ShopInspectionInfo>> entry : lastTimeMap.entrySet()) {
            Long storeId = entry.getKey();
            List<ShopInspectionInfo> shopInspectionInfos = entry.getValue();
            for (ShopInspectionInfo info : shopInspectionInfos) {
                info.setDepId(storeId);
                if (info.getTemplateName() == null || info.getTemplateName().isEmpty()) {
                    missingTemplateIds.add(info.getTemplateId());
                }
                if (info.getDepName() != null && !info.getDepName().isEmpty()) continue;
                missingStoreIds.add(storeId);
            }
        }
        Map<Object, Object> tempNameMap = new HashMap();
        Map<Object, Object> deptNameMap = new HashMap();
        if (!missingStoreIds.isEmpty()) {
            deptNameMap = this.departProxy.getDeptNameMap(missingStoreIds.stream().map(Long::intValue).collect(Collectors.toList()));
        }
        if (!missingTemplateIds.isEmpty()) {
            try {
                tempNameMap = this.isCheckTemplateService.getListByIds(missingTemplateIds.stream().map(Long::intValue).collect(Collectors.toList())).stream().collect(Collectors.toMap(IsCheckTemplate::getId, IsCheckTemplate::getName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry<Long, List<ShopInspectionInfo>> entry : lastTimeMap.entrySet()) {
            List<ShopInspectionInfo> shopInspectionInfos = entry.getValue();
            for (ShopInspectionInfo info : shopInspectionInfos) {
                if (info.getTemplateName() == null || info.getTemplateName().isEmpty()) {
                    info.setTemplateName((String)tempNameMap.get(info.getTemplateId().intValue()));
                }
                if (info.getDepName() != null && !info.getDepName().isEmpty()) continue;
                info.setDepName((String)deptNameMap.get(info.getDepId().intValue()));
            }
        }
        return lastTimeMap;
    }

    @Override
    public ShopInspectionInfoForMobile getLastInspectTimesPackageForMobile(InspectionLastTimeReq req) {
        Map<Long, List<ShopInspectionInfo>> lastTimeMap = this.packageLastInspectTimes(req);
        ShopInspectionInfoForMobile mobileResponse = new ShopInspectionInfoForMobile();
        ArrayList<ShopInspectionInfoForMobile.StoreInspectionData> storeInspectionDataList = new ArrayList<ShopInspectionInfoForMobile.StoreInspectionData>();
        Integer taskType = req.getTaskType();
        for (Map.Entry<Long, List<ShopInspectionInfo>> entry : lastTimeMap.entrySet()) {
            Long storeId = entry.getKey();
            List<ShopInspectionInfo> shopInspectionInfos = entry.getValue();
            List dateList = shopInspectionInfos.stream().map(ShopInspectionInfo::getDate).distinct().collect(Collectors.toList());
            for (String date : dateList) {
                ShopInspectionInfoForMobile.StoreInspectionData storeData = new ShopInspectionInfoForMobile.StoreInspectionData();
                storeData.setDepId(storeId);
                storeData.setTaskType(taskType);
                if (!shopInspectionInfos.isEmpty()) {
                    ShopInspectionInfo firstInfo = shopInspectionInfos.get(0);
                    storeData.setDepName(firstInfo.getDepName());
                    storeData.setNextInspectionDate(date);
                }
                ArrayList<ShopInspectionInfoForMobile.StoreInspectionData.TemplateData> templateDataList = new ArrayList<ShopInspectionInfoForMobile.StoreInspectionData.TemplateData>();
                for (ShopInspectionInfo shopInspectionInfo : shopInspectionInfos) {
                    if (shopInspectionInfo.getDate() != null && !storeData.getNextInspectionDate().equals(shopInspectionInfo.getDate())) continue;
                    ShopInspectionInfoForMobile.StoreInspectionData.TemplateData templateData = new ShopInspectionInfoForMobile.StoreInspectionData.TemplateData();
                    templateData.setTemplateId(shopInspectionInfo.getTemplateId());
                    templateData.setTemplateName(shopInspectionInfo.getTemplateName());
                    templateData.setLastInspectionDate(shopInspectionInfo.getDate());
                    templateData.setNum(shopInspectionInfo.getNum());
                    templateDataList.add(templateData);
                }
                templateDataList.sort(Comparator.comparing(t -> t.getNum().isEmpty()).thenComparing(t -> {
                    if (t.getNum().isEmpty()) {
                        return Long.MIN_VALUE;
                    }
                    return Long.parseLong(t.getNum());
                }).reversed());
                storeData.setTemplates(templateDataList);
                storeInspectionDataList.add(storeData);
            }
        }
        storeInspectionDataList.sort(Comparator.comparing(s -> {
            String firstNum = s.getTemplates().isEmpty() ? "" : ((ShopInspectionInfoForMobile.StoreInspectionData.TemplateData)s.getTemplates().get(0)).getNum();
            return firstNum.isEmpty();
        }).thenComparing(s -> {
            if (s.getTemplates().isEmpty() || ((ShopInspectionInfoForMobile.StoreInspectionData.TemplateData)s.getTemplates().get(0)).getNum().isEmpty()) {
                return Long.MIN_VALUE;
            }
            return Long.parseLong(((ShopInspectionInfoForMobile.StoreInspectionData.TemplateData)s.getTemplates().get(0)).getNum());
        }).reversed().thenComparing(ShopInspectionInfoForMobile.StoreInspectionData::getDepId));
        mobileResponse.setStores(storeInspectionDataList);
        return mobileResponse;
    }

    @Override
    public Map<Integer, StorePlanNameAndId> getPlanByDepIds(String depIds, Integer userId, Integer groupId, Integer mainType) {
        Map<Integer, StorePlanNameAndId> map = new HashMap<Integer, StorePlanNameAndId>();
        if (StringUtils.isBlank((String)depIds) || userId == null || groupId == null || mainType == null) {
            return map;
        }
        Date nowTime = DateUtils.getEndTimeOfDay((Date)new Date());
        Date sTime = DateUtils.addMonth((Date)nowTime, (int)-3);
        Boolean canExpireExecute = this.enterpriseConfigService.checkExpireExecute(groupId, Arrays.asList(11));
        List dtos = this.inspectionTaskMapper.selectPlanNameByDepIdsAndUserIdLimit(groupId, ListUtils.stringToList((String)depIds), userId, canExpireExecute, sTime, mainType);
        if (CollectionUtils.isNotEmpty((Collection)dtos)) {
            map = dtos.stream().collect(Collectors.groupingBy(StorePlanNameAndIdDto::getDepId, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(StorePlanNameAndId::getEndTime)), e -> {
                StorePlanNameAndId storePlanNameAndId = new StorePlanNameAndId();
                storePlanNameAndId.setId(((StorePlanNameAndIdDto)e.get()).getId());
                storePlanNameAndId.setName(((StorePlanNameAndIdDto)e.get()).getName());
                storePlanNameAndId.setEndTime(((StorePlanNameAndIdDto)e.get()).getEndTime());
                return storePlanNameAndId;
            })));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeBusinessLogic(Integer taskKey, TaskAndAuditDto taskAndAuditDto) {
        log.info("Task {} executed successfully with data: {}", (Object)taskKey, (Object)taskAndAuditDto);
        MDC.put((String)"TRACE_ID", (String)IdWorker.get32UUID());
        try {
            if (taskAndAuditDto == null || taskAndAuditDto.getUser() == null) {
                log.error("Invalid input: TaskAndAuditDto, User, or OrgTask is null. Skipping execution. Task ID: {}", (Object)taskAndAuditDto.getTaskId());
                return;
            }
            log.info("DelayedTaskListener invoked at {}, data: {}", (Object)DateUtils.format((Date)new Date(), (String)DateUtils.FORMAT_LONG), (Object)JSON.toJSONString((Object)taskAndAuditDto));
            InspectionTask orgTask = (InspectionTask)this.inspectionTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getId, (Object)taskAndAuditDto.getTaskId())).eq(InspectionTask::getVersion, (Object)taskAndAuditDto.getVersion())).eq(InspectionTask::getIsDeleted, (Object)0));
            if (orgTask == null) {
                throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
            }
            if (orgTask.getStatus() != InspectionTaskStatusEnum.AUDIT.getCode()) {
                log.warn("Task status is not AUDIT, skipping. Task ID: {}, Status: {}", (Object)orgTask.getId(), (Object)orgTask.getStatus());
                return;
            }
            Boolean canExpire = this.enterpriseConfigService.checkExpireExecute(taskAndAuditDto.getUser().getGroupId(), Arrays.asList(MainTypeEnum.INSPECTION.getCode()));
            if (ExpireStatusEnum.DEFAULT_TRUE.getCode() == orgTask.getExpireStatus() && !canExpire.booleanValue()) {
                log.info("Task ID: {} is expired and canExpire is false, skipping.", (Object)orgTask.getId());
                return;
            }
            if (Objects.nonNull(taskAndAuditDto) && Objects.nonNull(taskAndAuditDto.getNewAuditId())) {
                log.info("Forwarding audit to new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                Users users1 = this.usersRemoteService.getById(taskAndAuditDto.getNewAuditId());
                String auditName = Optional.ofNullable(users1).map(Users::getShowName).orElse("");
                this.inspectionTaskMapper.updateAuditIdById(taskAndAuditDto.getNewAuditId(), auditName, taskAndAuditDto.getTaskId());
                this.insertLogOfRemark(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.TRANSFER.getCode(), taskAndAuditDto.getOldAuditor(), taskAndAuditDto.getTaskId(), null, LogConstant.AUTO_DISTRIBUTE, this.calculateTimeDifference(taskAndAuditDto.getTriggerTime(), taskAndAuditDto.getLastNow()), taskAndAuditDto.getNewAuditName());
                InspectionAuditConfigFirstVersionModel updateModel = new InspectionAuditConfigFirstVersionModel();
                updateModel.setFirstTriggerFlag(Boolean.valueOf(true));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(InspectionAuditConfigFirstVersionModel::getTaskId, (Object)taskAndAuditDto.getTaskId());
                log.info("Removing previous auditor's pending task. Task ID: {}, Old Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getOldAuditId());
                DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(taskAndAuditDto.getOldAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.DELETED.getCode()).build();
                this.messageProxy.deleteMessagesByObject(audit);
                log.info("Sending notification to the new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                this.messageProxy.sendWebSocketAndJpush(taskAndAuditDto.getNewAuditId(), taskAndAuditDto.getUser().getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.ADD_MESSAGE, taskAndAuditDto.getUser().getShowName(), taskAndAuditDto.getTaskName()), taskAndAuditDto.getUser().getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, taskAndAuditDto.getTaskId(), InspectionPlanMainTypeEnum.INSPECTION, taskAndAuditDto.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), taskAndAuditDto.getEndTime());
            } else {
                log.info("Automatically approving audit. Task ID: {}", (Object)taskAndAuditDto.getTaskId());
                this.insertLogOfRemark(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.AUDIT_PASS.getCode(), taskAndAuditDto.getOldAuditor(), taskAndAuditDto.getTaskId(), null, LogConstant.AUTO_PASS, this.calculateTimeDifference(taskAndAuditDto.getTriggerTime(), taskAndAuditDto.getLastNow()));
                this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.PASS.getCode(), taskAndAuditDto.getTaskId(), new Date());
                log.info("Completing previous auditor's pending task. Task ID: {}, Old Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getOldAuditId());
                DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(taskAndAuditDto.getOldAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.NOT_DELETED.getCode()).build();
                this.messageProxy.deleteMessagesByObject(audit);
                log.info("Sending notification to the new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                int count = this.inspectionTaskExpandService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getOperatorId, (Object)orgTask.getOperatorId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.WAIT.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
                log.info("Sending notification to the executor. Task ID: {}, Executor ID: {},count:{}", new Object[]{taskAndAuditDto.getTaskId(), orgTask.getOperatorId(), count});
                this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), taskAndAuditDto.getUser().getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.PASS_MESSAGE, orgTask.getName()), taskAndAuditDto.getUser().getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, taskAndAuditDto.getTokenType(), JumpTypeEnum.DETAIL.getCode(), count > 0 ? IsExecutorEnum.EXECUTOR.getCode() : null, count > 0 ? IsTodoMessageEnum.IS_TODO_MESSAGE.getCode() : null, count > 0 ? orgTask.getEndTime() : null);
            }
        }
        catch (Exception e) {
            log.error("DelayedTaskListener error\uff0c{},taskId:{}", (Object)e.getMessage(), (Object)taskAndAuditDto.getTaskId());
        }
        finally {
            MDC.remove((String)"TRACE_ID");
        }
    }

    @Override
    public Map<Integer, String> getPlanNameByRelatedIds(List<Integer> ids) {
        HashMap<Integer, String> respMap = new HashMap<Integer, String>();
        Map<Integer, Integer> map = this.inspectionTaskExpandService.getPlanNameByRelatedIds(ids);
        if (map.isEmpty()) {
            return new HashMap<Integer, String>();
        }
        List planIds = map.values().stream().distinct().collect(Collectors.toList());
        Map<Integer, String> nameMap = ((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTask::getId, planIds)).list().stream().collect(Collectors.toMap(InspectionTask::getId, InspectionTask::getName));
        map.forEach((k, v) -> respMap.put((Integer)k, (String)nameMap.get(v)));
        return respMap;
    }

    private String calculateTimeDifference(Date calculatedDate, Date now) {
        long differenceInMillis = calculatedDate.getTime() - now.getTime();
        if (differenceInMillis <= 0L) {
            return "\u5df2\u8d85\u65f6";
        }
        long totalMinutes = Math.round((double)differenceInMillis / 60000.0);
        long days = totalMinutes / 1440L;
        long hours = totalMinutes % 1440L / 60L;
        long minutes = totalMinutes % 60L;
        StringBuilder timeDiff = new StringBuilder();
        if (days > 0L) {
            timeDiff.append(days).append("\u5929");
        }
        if (hours > 0L) {
            timeDiff.append(hours).append("\u5c0f\u65f6");
        }
        if (minutes > 0L || timeDiff.length() == 0) {
            timeDiff.append(minutes).append("\u5206\u949f");
        }
        return timeDiff.toString();
    }

    @Override
    public List<ShopInspectionInfo> getLastInspectTimesPackage(InspectionLastTimeReq req) {
        long startTime = System.nanoTime();
        Map<Long, List<ShopInspectionInfo>> lastTimeMap = this.packageLastInspectTimes(req);
        long endTime = System.nanoTime();
        long duration = (endTime - startTime) / 1000000L;
        log.info("Query took {} ms", (Object)duration);
        List<ShopInspectionInfo> lastTimeList = lastTimeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        lastTimeList.sort(Comparator.comparing(info -> info.getNum() == null || info.getNum().isEmpty()).reversed().thenComparing(info -> {
            if (info.getNum() != null && !info.getNum().isEmpty()) {
                return Integer.parseInt(info.getNum());
            }
            return Integer.MIN_VALUE;
        }, Comparator.reverseOrder()).thenComparing(ShopInspectionInfo::getDepId));
        return lastTimeList;
    }

    @Override
    public Map<Long, List<ShopInspectionInfo>> getLastInspectTimes(InspectionLastTimeReq req) {
        Set storeIds = req.getDateAndDepIds().stream().map(InspectionLastTimeReq.DateAndDepId::getDepId).collect(Collectors.toSet());
        HashSet templateIds = new HashSet(req.getTemplateIds());
        HashMap<Long, List<ShopInspectionInfo>> lastTimeMap = new HashMap<Long, List<ShopInspectionInfo>>();
        Map<Long, List> depIdDateMap = req.getDateAndDepIds().stream().collect(Collectors.toMap(InspectionLastTimeReq.DateAndDepId::getDepId, dateAndDepId -> dateAndDepId.getDate() != null ? dateAndDepId.getDate() : new ArrayList()));
        HashMap<Long, Set> missingDataMap = new HashMap<Long, Set>();
        log.info("Start processing the getLastInspectTimes request, there are {} storeIds and {} templateIds to be processed", (Object)storeIds.size(), (Object)templateIds.size());
        for (Long storeId : storeIds) {
            for (Long templateId : templateIds) {
                String cacheKey = storeId + "_" + templateId;
                CachedInspectionInfo cachedInfo = this.cacheService.getFromCache(cacheKey);
                if (cachedInfo != null) {
                    List expectTime = depIdDateMap.get(storeId);
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)expectTime)) {
                        Iterator iterator = expectTime.iterator();
                        while (iterator.hasNext()) {
                            String time = (String)iterator.next();
                            log.info("Retrieving data from cache: storeId={}, templateId={}, date={}, difference in days={}", new Object[]{storeId, templateId, cachedInfo.getDate(), cachedInfo.getNum()});
                            ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                            shopInspectionInfo.setTemplateId(templateId);
                            shopInspectionInfo.setDate(time.split(" ")[0]);
                            shopInspectionInfo.setNum(String.valueOf(cachedInfo.getNum()));
                            lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList()).add(shopInspectionInfo);
                        }
                        continue;
                    }
                    ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                    shopInspectionInfo.setTemplateId(templateId);
                    shopInspectionInfo.setDate(null);
                    shopInspectionInfo.setNum(String.valueOf(cachedInfo.getNum()));
                    lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList()).add(shopInspectionInfo);
                    continue;
                }
                log.info("Cache miss: storeId={}, templateId={}", (Object)storeId, (Object)templateId);
                missingDataMap.computeIfAbsent(storeId, k -> new HashSet()).add(templateId);
            }
        }
        Map resultData = new HashMap();
        if (!missingDataMap.isEmpty()) {
            log.info("Preparing to call the third-party interface to get missing data, missing {} storeId data, missing template ID: {}", (Object)missingDataMap.size(), missingDataMap);
            Set missingStoreIds = missingDataMap.keySet();
            Set missingTemplateIds = missingDataMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            DepLastInspDateQry depLastInspDateQry = new DepLastInspDateQry();
            depLastInspDateQry.setDepIds(new ArrayList(missingStoreIds));
            depLastInspDateQry.setTemplateIds(new ArrayList(missingTemplateIds));
            String taskType = InspectionPlanMainTypeEnum.getMsgDescByCode((Integer)req.getTaskType());
            depLastInspDateQry.setTaskType(taskType);
            log.info("Calling third-party interface parameters: storeIds={}, templateIds={}, taskType={}", new Object[]{missingStoreIds, missingTemplateIds, taskType});
            try {
                R result = this.shopInspectionApi.depLastInspTime(INSPECTION_PLAN, depLastInspDateQry);
                if (result != null && result.getData() != null) {
                    resultData = (Map)result.getData();
                    log.info("Third-party interface returns data, processes and updates the cache, the data returned by the third-party: {}", (Object)JSON.toJSONString((Object)result.getData()));
                    for (Map.Entry templateEntry : resultData.entrySet()) {
                        Long templateId = (Long)templateEntry.getKey();
                        Map storeDataMap = (Map)templateEntry.getValue();
                        for (Map.Entry storeEntry : storeDataMap.entrySet()) {
                            Long storeId = (Long)storeEntry.getKey();
                            String date = (String)storeEntry.getValue();
                            if (date != null && !date.isEmpty()) {
                                LocalDate inspectionDate = LocalDate.parse(date.substring(0, 10));
                                long daysDifference = ChronoUnit.DAYS.between(inspectionDate, LocalDate.now());
                                log.info("Third-party data: storeId={}, templateId={}, date={}, days difference={}", new Object[]{storeId, templateId, date, daysDifference});
                                List times = depIdDateMap.get(storeId);
                                if (CollectionUtils.isNotEmpty((Collection)times)) {
                                    for (String time : times) {
                                        ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                                        shopInspectionInfo.setTemplateId(templateId);
                                        shopInspectionInfo.setDate(time.split(" ")[0]);
                                        shopInspectionInfo.setNum(String.valueOf(daysDifference));
                                        List shopInspectionInfoList = lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList());
                                        shopInspectionInfoList.add(shopInspectionInfo);
                                    }
                                } else {
                                    ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                                    shopInspectionInfo.setTemplateId(templateId);
                                    shopInspectionInfo.setDate(null);
                                    shopInspectionInfo.setNum(String.valueOf(daysDifference));
                                    List shopInspectionInfoList = lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList());
                                    shopInspectionInfoList.add(shopInspectionInfo);
                                }
                                this.cacheService.updateCache(String.valueOf(storeId), String.valueOf(templateId), new CachedInspectionInfo(date, String.valueOf(daysDifference)));
                                continue;
                            }
                            log.info("The third-party interface did not return a valid date, storeId={}, templateId={}, no caching is performed", (Object)storeId, (Object)templateId);
                        }
                    }
                } else {
                    log.warn("The third-party interface did not return valid data, the return value is empty. Interface response: {}", (Object)result);
                }
            }
            catch (Exception e) {
                log.error("Failed to call the third-party interface: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        for (Long storeId : missingDataMap.keySet()) {
            for (Long templateId : (Set)missingDataMap.get(storeId)) {
                if (resultData.containsKey(templateId) && ((Map)resultData.get(templateId)).containsKey(storeId)) continue;
                log.info("Processing the combination not returned by the third party: storeId={}, templateId={}", (Object)storeId, (Object)templateId);
                List times = depIdDateMap.get(storeId);
                if (CollectionUtils.isNotEmpty((Collection)times)) {
                    for (String time : times) {
                        ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                        shopInspectionInfo.setTemplateId(templateId);
                        shopInspectionInfo.setDate(time.split(" ")[0]);
                        shopInspectionInfo.setNum("");
                        lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList()).add(shopInspectionInfo);
                    }
                } else {
                    ShopInspectionInfo shopInspectionInfo = new ShopInspectionInfo();
                    shopInspectionInfo.setTemplateId(templateId);
                    shopInspectionInfo.setDate(null);
                    shopInspectionInfo.setNum("");
                    lastTimeMap.computeIfAbsent(storeId, k -> new ArrayList()).add(shopInspectionInfo);
                }
                this.cacheService.updateCache(String.valueOf(storeId), String.valueOf(templateId), new CachedInspectionInfo("", ""));
            }
        }
        log.info("Processing completed, a total of {} data returned", (Object)lastTimeMap.size());
        return lastTimeMap;
    }

    @Override
    public GetInspectionPlanByRelatedIdResp getPlanByRelatedId(GetPlanByRelatedIdReq req) {
        InspectionTaskExpand expand = null;
        if (Objects.nonNull(req.getExpandId())) {
            expand = (InspectionTaskExpand)this.inspectionTaskExpandMapper.selectById((Serializable)req.getExpandId());
        }
        GetInspectionPlanByRelatedIdResp resp = new GetInspectionPlanByRelatedIdResp();
        if (Objects.isNull(expand)) {
            resp.setAlowToDo(DefaultEnum.DEFAULT_FALSE.getCode());
            return resp;
        }
        InspectionTask inspectionTask = (InspectionTask)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InspectionTask::getId, (Object)expand.getTaskId())).one();
        if (Objects.isNull(inspectionTask)) {
            resp.setAlowToDo(DefaultEnum.DEFAULT_FALSE.getCode());
            return resp;
        }
        resp.setAlowToDo(this.isAllowToDo(inspectionTask));
        resp.setInspectionPlanName(inspectionTask.getName());
        return resp;
    }

    private Integer isAllowToDo(InspectionTask inspectionTask) {
        EnterpriseConfigPojo pojo = this.enterpriseConfigService.selectOne(inspectionTask.getGroupId());
        if (Objects.nonNull(pojo) && StringUtils.isNotBlank((String)pojo.getExpireExecute())) {
            return !ListUtils.stringToList((String)pojo.getExpireExecute()).contains(11) && inspectionTask.getEndTime().before(new Date()) ? DefaultEnum.DEFAULT_FALSE.getCode() : DefaultEnum.DEFAULT_TRUE.getCode();
        }
        return inspectionTask.getEndTime().before(new Date()) ? DefaultEnum.DEFAULT_FALSE.getCode() : DefaultEnum.DEFAULT_TRUE.getCode();
    }

    private static /* synthetic */ String lambda$calendar$64(InspectionPlanDto dto, Integer k) {
        return dto.getTemplateName();
    }
}

