/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.mapper.InspectionOperatorLogMapper;
import com.ovopark.model.enums.OperatorActionEnum;
import com.ovopark.model.enums.OperatorTypeEnum;
import com.ovopark.po.InspectionOperatorLog;
import com.ovopark.service.OperatorLogService;
import com.ovopark.utils.ListUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OperatorLogServiceImpl
extends ServiceImpl<InspectionOperatorLogMapper, InspectionOperatorLog>
implements OperatorLogService {
    private static final Logger log = LoggerFactory.getLogger(OperatorLogServiceImpl.class);

    @Override
    public void fixOperatorLog(String startTime, String endTime) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().between(InspectionOperatorLog::getCreateTime, (Object)startTime, (Object)endTime)).eq(InspectionOperatorLog::getIsDelete, (Object)0)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List lists = ListUtils.splitList((List)list, (int)500);
            int i = 0;
            for (List logList : lists) {
                log.info("\u6b63\u5728\u5904\u7406\u7b2c{}\u7ec4\u6570\u636e,\u603b\u5171{}\u7ec4", (Object)(++i), (Object)lists.size());
                for (InspectionOperatorLog operatorLog : logList) {
                    if (StringUtils.isBlank((CharSequence)operatorLog.getContent())) continue;
                    if (operatorLog.getContent().contains("\u5ba1\u6838\u901a\u8fc7")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.AUDITOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.AUDIT_PASS.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u9a73\u56de\u4e86\u4efb\u52a1")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.AUDITOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.AUDIT_REFUSE.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u50ac\u529e\u4e86\u5ba1\u6838\u4eba")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.URGED.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u53d1\u5e03\u4e86\u4efb\u52a1") || operatorLog.getContent().contains("\u521b\u5efa\u4e86\u4efb\u52a1")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.AUDIT.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u5c06\u4efb\u52a1\u4fdd\u5b58\u4e3a\u8349\u7a3f ")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.SAVE_DRAFT.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u66f4\u65b0\u4e86\u8349\u7a3f")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.UPDATE_DRAFT.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u66f4\u65b0\u4e86\u4efb\u52a1")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.AUDIT.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains(",\u5df2\u5b8c\u6210")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.FINISH.getCode());
                        continue;
                    }
                    if (operatorLog.getContent().contains("\u73b0\u573a\u5de1\u5e97")) {
                        operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                        operatorLog.setOperatorAction(OperatorActionEnum.LIVE.getCode());
                        continue;
                    }
                    if (!operatorLog.getContent().contains("\u8fdc\u7a0b\u5de1\u5e97")) continue;
                    operatorLog.setOperatorType(OperatorTypeEnum.OPERTOR.getCode());
                    operatorLog.setOperatorAction(OperatorActionEnum.REMOTE.getCode());
                }
                this.saveOrUpdateBatch(list);
            }
        }
    }
}

