/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.ThirdMessageDTO;
import com.ovopark.model.pojo.MsgToUserPojo;
import com.ovopark.service.Impl.AbstractNotificationSender;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdMessageNotificationSenderImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(ThirdMessageNotificationSenderImpl.class);

    protected ThirdMessageNotificationSenderImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected <T> MessageRequest buildMessage(T t) {
        log.info("Start building MessageRequest of third for object: {}", t);
        ThirdMessageDTO thirdMessageDTO = (ThirdMessageDTO)t;
        MsgToUserPojo msgToUserPojo = thirdMessageDTO.getMsgToUserPojo();
        MessageRequest messageRequest = ((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)SubsBuilders.third((String)msgToUserPojo.getObjectType()).from(thirdMessageDTO.getUserId().toString())).toUserIdList(Collections.singletonList(thirdMessageDTO.getTargetUserId()))).group(String.valueOf(msgToUserPojo.getGroupId()))).thirdMessage(thirdMessageDTO.getThirdMessage()).mcTitle(new ParamContext().plainText(msgToUserPojo.getTitle()))).mcContent(new ParamContext().plainText(msgToUserPojo.getMessage()))).mcHidden(true)).build();
        log.info("MessageRequest of third built successfully: {}", (Object)JSON.toJSONString((Object)messageRequest));
        return messageRequest;
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.THIRD;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
        log.info("Start sending notification for message by third: {}", (Object)JSON.toJSONString((Object)baseMessageDTO));
        try {
            this.validate(baseMessageDTO);
            MessageRequest message = this.buildMessage(baseMessageDTO);
            log.info("Third MessageRequest built successfully : {}", (Object)JSON.toJSONString((Object)message));
            super.doSend(message);
            log.info("Third Message sent successfully for message DTO:{} with MessageRequest: {}", (Object)JSON.toJSONString((Object)baseMessageDTO), (Object)JSON.toJSONString((Object)message));
        }
        catch (Exception e) {
            log.error("Error sending notification", (Throwable)e);
        }
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (!(request instanceof ThirdMessageDTO)) {
            throw new IllegalArgumentException("Invalid request type, expected ThirdMessageDTO");
        }
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
        log.info("Handling result for Third request: {}", (Object)JSON.toJSONString((Object)request));
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return baseMessageDTO instanceof ThirdMessageDTO;
    }
}

