/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.login.Users;
import com.ovopark.organize.common.model.mo.SimpleSuperUserMo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.UsersRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userRemoteServiceImpl")
public class UsersRemoteServiceImpl
implements UsersRemoteService {
    private static final Logger log = LoggerFactory.getLogger(UsersRemoteServiceImpl.class);
    @Resource
    private com.ovopark.privilege.api.UserApi userApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserApi userServiceApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi userPrivilegeApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @Override
    public Boolean isSupAdmin(Integer userId, Integer groupId) {
        return (Boolean)this.userPrivilegeApi.isSuperAdmin(userId, groupId).getData();
    }

    @Override
    public Users getById(Integer userId) {
        Users user = new Users();
        BaseResult baseResult = this.userApi.getUsersById(userId);
        if (!Objects.nonNull(baseResult.getData())) {
            return null;
        }
        log.info("\u7528\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)baseResult.getData()));
        UsersPojo users = (UsersPojo)baseResult.getData();
        user.setId(users.getId());
        user.setGroupId(users.getGroupId());
        user.setUserName(users.getUserName());
        user.setShowName(users.getShowName());
        user.setpId(users.getpId());
        return user;
    }

    @Override
    public List<Users> getByIds(String userIds) {
        ArrayList<Users> userList = new ArrayList<Users>();
        BaseResult result = this.userApi.getUsersListByIds(userIds);
        if (!CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return userList;
        }
        List users = (List)result.getData();
        Users user = null;
        for (UsersPojo usersPojo : users) {
            user = new Users();
            user.setId(usersPojo.getId());
            user.setGroupId(usersPojo.getGroupId());
            user.setShowName(usersPojo.getShowName());
            userList.add(user);
        }
        return userList;
    }

    @Override
    public List<RolePojo> getRoleIds(List<Integer> roles) {
        BaseResult result = this.roleApi.getRolePojoByIdList(roles);
        return (List)result.getData();
    }

    @Override
    public List<Integer> getUserIdsByRole(String roleIds, Integer groupId) {
        List<Integer> userIds = new ArrayList<Integer>();
        BaseResult result = this.userApi.getUserByRoleIds(roleIds, groupId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            userIds = ((List)result.getData()).stream().map(UsersPojo::getId).collect(Collectors.toList());
        }
        return userIds;
    }

    @Override
    public List<Users> getUserByRole(String roleIds, Integer groupId) {
        ArrayList<Users> usersPojos = new ArrayList<Users>();
        Users usersPojo = null;
        BaseResult result = this.userApi.getUserByRoleIds(roleIds, groupId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            for (UsersPojo pojo : (List)result.getData()) {
                usersPojo = new Users();
                usersPojo.setId(pojo.getId());
                usersPojo.setShowName(pojo.getShowName());
                usersPojos.add(usersPojo);
            }
        }
        return usersPojos;
    }

    @Override
    public Map<Integer, String> getCoreUserNameMapByIds(List<Integer> userIds) {
        Map<Integer, String> userName = new HashMap<Integer, String>();
        log.info("getCoreUserNameMapByIds---\u7528\u6237id\u83b7\u53d6\u5bf9\u5e94\u7528\u6237\u540d:" + userIds.toString());
        BaseResult baseResult = this.userPrivilegeApi.getUsersListPostByIds(userIds);
        log.info("\u63a5\u53e3\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)baseResult));
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            userName = ((List)baseResult.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, UsersPojo::getShowName));
        }
        return userName;
    }

    @Override
    public Map<Integer, UsersPojo> getCoreUserMapByIds(List<Integer> userIds) {
        Map<Integer, Object> usersPojoMap = new HashMap<Integer, UsersPojo>();
        log.info("getCoreUserNameMapByIds---\u7528\u6237id\u83b7\u53d6\u5bf9\u5e94\u7528\u6237\u540d:" + userIds.toString());
        BaseResult baseResult = this.userPrivilegeApi.getUsersListPostByIds(userIds);
        log.info("\u63a5\u53e3\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)baseResult));
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            usersPojoMap = ((List)baseResult.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
        }
        return usersPojoMap;
    }

    @Override
    public Map<Integer, String> getParentUsersByUserIds(List<Integer> userIds, Integer groupId) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        SimpleSuperUserMo usersSimpleMo = new SimpleSuperUserMo();
        usersSimpleMo.setUserList(userIds);
        usersSimpleMo.setGroupId(groupId);
        log.info("\u5bf9\u5e94\u6267\u884c\u4eba\u7684\u76f4\u5c5e\u4e0a\u7ea7\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)usersSimpleMo));
        com.ovopark.organize.common.base.BaseResult baseResult = this.userServiceApi.getParentUsersByUserIds(usersSimpleMo);
        if (!((List)baseResult.getData()).isEmpty()) {
            for (Map datum : (List)baseResult.getData()) {
                Integer id = (Integer)datum.get("id");
                String parentShovName = (String)datum.get("parentShowName");
                hashMap.put(id, parentShovName);
            }
        }
        return hashMap;
    }

    @Override
    public Map<Integer, String> getIdAndNameByRoleId(List<Integer> operatorIds, Integer groupId) {
        HashMap<Integer, String> userIdAndRoleName = new HashMap<Integer, String>();
        HashMap map = new HashMap();
        operatorIds.forEach(userId -> {
            BaseResult roles = this.roleApi.getRolesByUser(userId, groupId);
            map.put(userId, roles.getData());
        });
        for (Map.Entry entry : map.entrySet()) {
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            userIdAndRoleName.put((Integer)entry.getKey(), ((List)entry.getValue()).stream().map(RolePojo::getRoleName).distinct().collect(Collectors.joining(",")));
        }
        return userIdAndRoleName;
    }

    @Override
    public Set<Integer> getUserIdsByPrivilegeUserId(Integer groupId, Integer userId) {
        HashSet<Integer> userIdAndRoleName = new HashSet<Integer>();
        HashMap map = new HashMap();
        com.ovopark.organize.common.base.BaseResult baseresult = this.userOrganizeApi.getUserIdsByPrivilegeUserId(groupId, userId);
        if (baseresult.getIsError().booleanValue()) {
            log.error("getIdAndNameByGroupId return\uff1a{},{}", (Object)baseresult.getIsError(), (Object)baseresult.getRequestId());
            throw new SysErrorException(ResultCode.SYS_ERROR, new Object[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)baseresult.getData()))) {
            userIdAndRoleName.addAll((Collection)baseresult.getData());
            userIdAndRoleName.add(userId);
        }
        userIdAndRoleName.add(userId);
        return userIdAndRoleName;
    }
}

