/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.ovopark.annotation.AutoCache;
import com.ovopark.annotation.CacheType;
import com.ovopark.utils.RedisUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.PropertyPlaceholderHelper;

@Aspect
@Component
public class AutoCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(AutoCacheAspect.class);
    @Autowired
    private RedisUtil redisUtil;
    private static PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ".", false);

    @Pointcut(value="@annotation(com.ovopark.annotation.AutoCache)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] methodArgNames = signature.getParameterNames();
        Object[] methodArgs = point.getArgs();
        Properties methodArgNameMap = new Properties();
        if (!ArrayUtils.isEmpty((Object[])methodArgNames)) {
            for (int index = 0; index < methodArgNames.length; ++index) {
                methodArgNameMap.put(methodArgNames[index], String.valueOf(methodArgs[index]));
            }
        }
        AutoCache autoCache = method.getAnnotation(AutoCache.class);
        String cacheKey = autoCache.value();
        String hashKey = autoCache.hashKey();
        long expire = autoCache.expire();
        long expireShakeRange = autoCache.expire();
        if (expire > 0L && expireShakeRange > 0L && expireShakeRange < expire) {
            expire -= (long)(Math.random() * (double)expireShakeRange);
        }
        CacheType cacheType = autoCache.type();
        cacheKey = helper.replacePlaceholders(cacheKey, methodArgNameMap);
        log.info("AutoCache \u83b7\u53d6\u5230key {}", (Object)cacheKey);
        switch (cacheType) {
            case STRING: {
                return this.handleStringCache(point, method, cacheKey, expire);
            }
            case HASH: {
                if (StringUtils.isEmpty((String)hashKey)) break;
                hashKey = helper.replacePlaceholders(hashKey, methodArgNameMap);
                return this.handleHashCache(point, method, cacheKey, hashKey, expire);
            }
        }
        return point.proceed();
    }

    public Object handleStringCache(ProceedingJoinPoint point, Method method, String cacheKey, long expire) throws Throwable {
        String cacheValue = (String)this.redisUtil.getString(cacheKey);
        Object result = null;
        if (StringUtils.isBlank((String)cacheValue)) {
            result = point.proceed();
            if (result != null) {
                cacheValue = JSON.toJSONString((Object)result);
                boolean suc = this.redisUtil.setString(cacheKey, cacheValue);
                if (expire > 0L) {
                    this.redisUtil.expire(cacheKey, expire);
                }
                log.info("\u5199\u7f13\u5b58 key {}, value {} \u7684\u72b6\u6001\u4e3a{}", new Object[]{cacheKey, cacheValue, suc});
            } else {
                log.info("\u4e3a\u7a7a\u4e0d\u5199\u7f13\u5b58 key {}, value {}", (Object)cacheKey, (Object)cacheValue);
            }
        } else if (!cacheValue.equalsIgnoreCase("NULL")) {
            result = JSON.parseObject((String)cacheValue, (Type)method.getGenericReturnType(), (Feature[])new Feature[0]);
        }
        return result;
    }

    public Object handleHashCache(ProceedingJoinPoint point, Method method, String cacheKey, String hashKey, long expire) throws Throwable {
        String cacheValue = (String)this.redisUtil.hget(cacheKey, hashKey);
        Object result = null;
        if (StringUtils.isBlank((String)cacheValue)) {
            result = point.proceed();
            if (result != null) {
                cacheValue = JSON.toJSONString((Object)result);
                boolean suc = this.redisUtil.hset(cacheKey, hashKey, (Object)cacheValue);
                log.info("\u5199\u7f13\u5b58 key {}, value {} \u7684\u72b6\u6001\u4e3a{}", new Object[]{cacheKey, cacheValue, suc});
            } else {
                log.info("\u4e3a\u7a7a\u4e0d\u5199\u7f13\u5b58 key {}, value {}", (Object)cacheKey, (Object)cacheValue);
            }
        } else if (!cacheValue.equalsIgnoreCase("NULL")) {
            result = JSON.parseObject((String)cacheValue, (Type)method.getGenericReturnType(), (Feature[])new Feature[0]);
        }
        return result;
    }
}

