/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.aspect;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.ovopark.constants.ConfigurationConstants;
import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.ResultCodeInfo;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.login.TokenInfo;
import com.ovopark.model.login.Users;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.sso.TokenValueResp;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.CommonUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class ServiceRequestAspect {
    private static final Logger log = LoggerFactory.getLogger(ServiceRequestAspect.class);
    private static final Logger logger = LoggerFactory.getLogger(ServiceRequestAspect.class);
    private static final Logger defaultLogger = LoggerFactory.getLogger((String)"R-R-LOG");
    @Value(value="${ovopark.sso.server.url}")
    private String ssoServerUrl;
    @Autowired
    private UsersRemoteService usersService;
    @Autowired
    private InspectionTaskService inspectionTaskService;
    @Autowired
    ConfigurationConstants configurationConstants;
    static List<String> excludePath = Lists.newArrayList();
    private static Random random;

    @Pointcut(value="execution(public * com.ovopark.web.controller..*(..))")
    private void allMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="allMethod()")
    public Object doAround(ProceedingJoinPoint call) throws Throwable {
        long runTime;
        Object object;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        if (excludePath.contains(request.getServletPath())) {
            return call.proceed();
        }
        HttpContext.start((HttpServletRequest)request, (HttpServletResponse)response);
        boolean vaildTokenResult = this.vaildToken(request, response);
        if (!vaildTokenResult) {
            return JsonNewResult.error((ResultCodeInfo)ResultCode.RESULT_INVALID_TOKEN);
        }
        String reqParams = "";
        if (call.getArgs().length > 0) {
            for (Object o : call.getArgs()) {
                if (o instanceof MultipartFile) {
                    MultipartFile file = (MultipartFile)o;
                    continue;
                }
                if (o instanceof MultipartFile[]) {
                    MultipartFile[] files = (MultipartFile[])o;
                    continue;
                }
                if (o instanceof HttpServletRequest || o instanceof HttpServletResponse) continue;
                logger.info("\u63a5\u53e3\uff1a" + String.format("%s.%s", call.getSignature().getDeclaringTypeName(), call.getSignature().getName()) + "\uff0c\u8bf7\u6c42\u53c2\u6570 : " + JSON.toJSONString((Object)o));
                reqParams = reqParams + JSON.toJSONString((Object)o);
            }
        }
        String api = request.getRequestURI();
        String reqId = ServiceRequestAspect.getRandom(10);
        String ip = ServiceRequestAspect.getIpAddress(request);
        defaultLogger.info("[" + reqId + ",REQUEST]" + api + "," + ip + "[" + reqParams + "]");
        Date startDate = new Date();
        boolean requestResult = false;
        try {
            Object object2 = call.proceed();
            log.info("[" + reqId + ",RESPONSE]" + JSONObject.toJSONString((Object)object2));
            requestResult = true;
            object = object2;
            Date endDate = new Date();
            runTime = endDate.getTime() - startDate.getTime();
        }
        catch (Exception e) {
            block12: {
                long runTime2;
                JsonNewResult jsonNewResult;
                try {
                    log.info("\u7f51\u5173\u5176\u5b83\u5904\u7406\u5f02\u5e38", (Throwable)e);
                    if (!(e instanceof SysErrorException)) break block12;
                    ResultCodeInfo resultCodeInfo = null;
                    String cause = null;
                    SysErrorException de = (SysErrorException)e;
                    cause = de.getMessage();
                    resultCodeInfo = de.getResultCodeInfo();
                    if (null == resultCodeInfo) {
                        resultCodeInfo = ResultCode.FAILURE;
                    }
                    jsonNewResult = JsonNewResult.error((ResultCodeInfo)resultCodeInfo);
                    Date endDate = new Date();
                    runTime2 = endDate.getTime() - startDate.getTime();
                }
                catch (Throwable throwable) {
                    Date endDate = new Date();
                    long runTime3 = endDate.getTime() - startDate.getTime();
                    String logs = String.format("[%s]PERFORMANCE:%s,%s,%sms", reqId, api, requestResult, runTime3);
                    log.info(logs);
                    throw throwable;
                }
                String logs = String.format("[%s]PERFORMANCE:%s,%s,%sms", reqId, api, requestResult, runTime2);
                log.info(logs);
                return jsonNewResult;
            }
            log.info("[" + reqId + "RESPONSE_ERROR]" + ResultCode.SYS_ERROR.getDesc());
            JsonNewResult jsonNewResult = JsonNewResult.error((ResultCodeInfo)ResultCode.SYS_ERROR, (String)e.getMessage());
            Date endDate = new Date();
            long runTime4 = endDate.getTime() - startDate.getTime();
            String logs = String.format("[%s]PERFORMANCE:%s,%s,%sms", reqId, api, requestResult, runTime4);
            log.info(logs);
            return jsonNewResult;
        }
        String logs = String.format("[%s]PERFORMANCE:%s,%s,%sms", reqId, api, requestResult, runTime);
        log.info(logs);
        return object;
    }

    private <T extends Annotation> T getAnnotation(ProceedingJoinPoint jp, Class<T> clazz) {
        MethodSignature joinPointObject = (MethodSignature)jp.getSignature();
        Method method = joinPointObject.getMethod();
        return method.getAnnotation(clazz);
    }

    private static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private static String getRandom(int length) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            boolean isChar;
            boolean bl = isChar = random.nextInt(2) % 2 == 0;
            if (isChar) {
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;
                ret.append((char)(choice + random.nextInt(26)));
                continue;
            }
            ret.append(Integer.toString(random.nextInt(10)));
        }
        return ret.toString();
    }

    private boolean vaildToken(HttpServletRequest request, HttpServletResponse response) {
        String url = request.getRequestURL().toString();
        List whiteList = this.configurationConstants.getWhiteList();
        if (!CollectionUtils.isEmpty((Collection)whiteList)) {
            for (String whiteUrl : whiteList) {
                if (!url.contains(whiteUrl)) continue;
                return true;
            }
        }
        boolean isNewLogin = false;
        String token = request.getParameter("token");
        String authorization = request.getHeader("Ovo-Authorization");
        if (StringUtils.isEmpty((Object)authorization)) {
            authorization = request.getHeader("authorization");
        }
        if (StringUtils.isEmpty((Object)authorization)) {
            authorization = request.getParameter("ticket");
        }
        if (!StringUtils.isEmpty((Object)authorization)) {
            isNewLogin = true;
        }
        if (isNewLogin) {
            String[] auths = authorization.split(" ");
            token = this.assemblyClientInfo(auths, token);
            HttpResponse ovoResult = HttpUtil.createGet((String)(this.ssoServerUrl + "/ovopark-sso/token/parseToken" + "?token=" + token)).timeout(3000).execute();
            if (ovoResult == null || ovoResult.getStatus() != 200 || StringUtils.isEmpty((Object)ovoResult.body())) {
                logger.info("\u8c03\u7528sso\u5931\u8d25");
                throw new SysErrorException(ResultCode.RESULT_INVALID_TOKEN, new Object[0]);
            }
            BaseResult tokenValueBaseResult = null;
            try {
                tokenValueBaseResult = (BaseResult)JSON.parseObject((String)ovoResult.body(), (TypeReference)new TypeReference<BaseResult<TokenValueResp>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                logger.info("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                throw new SysErrorException(ResultCode.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            if (!tokenValueBaseResult.getIsError().booleanValue()) {
                TokenValueResp resp = (TokenValueResp)tokenValueBaseResult.getData();
                Users user = this.usersService.getById(resp.getUserId());
                HttpContext.setContextInfoUser((Users)user);
                return true;
            }
            throw new SysErrorException(tokenValueBaseResult.getCode());
        }
        String authenticator = request.getHeader("authenticator");
        if (authenticator != null) {
            String[] auths = authenticator.split(" ");
            token = this.assemblyClientInfo(auths, token);
        }
        if (!StringUtils.isEmpty((Object)token)) {
            TokenInfo tokenBo = CommonUtil.decodeToken((String)token);
            Integer kUserId = tokenBo.getUserId();
            if (kUserId != null) {
                Users user = this.usersService.getById(kUserId);
                if (user != null) {
                    String tokenPassword = tokenBo.getPassword();
                    String dbPassword = user.getPassword();
                    Date date = new Date();
                    Date tokenDate = tokenBo.getDate();
                    Date expiredDate = null;
                    if (tokenDate != null) {
                        if (tokenBo.getExpires() != null) {
                            expiredDate = new Date(tokenDate.getTime() + tokenBo.getExpires());
                        } else {
                            Long expiredTime = this.configurationConstants.getExpiredTime();
                            expiredDate = new Date(tokenDate.getTime() + expiredTime);
                        }
                    }
                    if (tokenBo.getUserName() != null && !user.getUserName().equals(tokenBo.getUserName())) {
                        return false;
                    }
                    if (!StringUtils.isEmpty((Object)tokenPassword) && !tokenPassword.equals(dbPassword)) {
                        return false;
                    }
                    if (expiredDate != null && date.after(expiredDate)) {
                        return false;
                    }
                } else {
                    return false;
                }
                HttpContext.setContextInfoUser((Users)user);
                return true;
            }
            return false;
        }
        return false;
    }

    private String assemblyClientInfo(String[] auths, String token) {
        if (auths.length > 0 && StringUtils.isEmpty((Object)token)) {
            token = auths[0];
        }
        HttpContext.setContextInfoToken((String)token);
        return token;
    }

    public String getSsoServerUrl() {
        return this.ssoServerUrl;
    }

    public void setSsoServerUrl(String ssoServerUrl) {
        this.ssoServerUrl = ssoServerUrl;
    }

    static {
        excludePath.add("/task/test");
        excludePath.add("/task/getInspectionPlanRelatedUserCount");
        excludePath.add("/test/delete");
        excludePath.add("/test/fix");
        excludePath.add("/task/export");
        excludePath.add("/open/getPlanByRelatedId");
        random = new Random();
    }
}

