/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.kafka;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.model.enums.KafkaEventEnum;
import com.ovopark.model.enums.KafkaSourceEnum;
import com.ovopark.model.enums.KafkaStatusEnum;
import com.ovopark.model.req.InspectionPlanTaskCallBackReq;
import com.ovopark.model.req.KafkaDeleteReq;
import com.ovopark.model.req.KafkaExtraDeleteReq;
import com.ovopark.service.CheckTaskRelateService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import java.io.IOException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class CheckKafka {
    private static final Logger log = LoggerFactory.getLogger(CheckKafka.class);
    @Autowired
    private InspectionTaskExpandService expandService;
    @Autowired
    private InspectionTaskService inspectionTaskService;
    @Autowired
    private CheckTaskRelateService checkTaskRelateService;

    @KafkaListener(topics={"check-task"})
    public void handleIposWarningData(ConsumerRecord<String, String> record) throws IOException {
        String value = (String)record.value();
        KafkaDeleteReq req = (KafkaDeleteReq)JSONObject.parseObject((String)value, KafkaDeleteReq.class);
        if (req.getSource().equals(KafkaSourceEnum.TASK.getDesc())) {
            log.info("kafka\u6570\u636e\uff1a" + record.offset() + "\u5185\u5bb9\uff1a" + value + "");
            KafkaExtraDeleteReq deleteReq = (KafkaExtraDeleteReq)JSONObject.parseObject((String)req.getExtra(), KafkaExtraDeleteReq.class);
            KafkaEventEnum anEnum = KafkaEventEnum.formatOrNull((String)req.getEvent());
            KafkaStatusEnum statusEnum = KafkaStatusEnum.formatOrNull((String)req.getStatus());
            switch (anEnum) {
                case DELETED: {
                    this.expandService.returnExpand(deleteReq.getStorePlanDetailId(), deleteReq.getTemplateId(), req.getOperatorId(), req.getTemplateName());
                    break;
                }
                case COMMITTED: {
                    InspectionPlanTaskCallBackReq callBackReq = null;
                    switch (statusEnum) {
                        case DONE: 
                        case WAIT_REVIEW: {
                            callBackReq = new InspectionPlanTaskCallBackReq();
                            callBackReq.setExpandId(deleteReq.getStorePlanDetailId());
                            callBackReq.setTaskId(deleteReq.getCheckTaskId());
                            callBackReq.setTemplateId(deleteReq.getTemplateId() != null ? deleteReq.getTemplateId() : null);
                            this.inspectionTaskService.callBack(callBackReq, null);
                        }
                    }
                }
            }
        }
    }
}

