/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.aspect;

import com.ovopark.annotation.CacheType;
import com.ovopark.annotation.DelCache;
import com.ovopark.utils.RedisUtil;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.PropertyPlaceholderHelper;

@Aspect
@Component
public class DelCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(DelCacheAspect.class);
    @Autowired
    private RedisUtil redisUtil;
    private static PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ".", false);

    @Pointcut(value="@annotation(com.ovopark.annotation.DelCache)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] methodArgNames = signature.getParameterNames();
        Object[] methodArgs = point.getArgs();
        Properties methodArgNameMap = new Properties();
        if (!ArrayUtils.isEmpty((Object[])methodArgNames)) {
            for (int index = 0; index < methodArgNames.length; ++index) {
                methodArgNameMap.put(methodArgNames[index], String.valueOf(methodArgs[index]));
            }
        }
        DelCache autoCache = method.getAnnotation(DelCache.class);
        String cacheKey = autoCache.value();
        String hashKey = autoCache.hashKey();
        CacheType cacheType = autoCache.type();
        cacheKey = helper.replacePlaceholders(cacheKey, methodArgNameMap);
        log.info("DelCache \u83b7\u53d6\u5230key {}", (Object)cacheKey);
        switch (cacheType) {
            case STRING: {
                return this.handleStringCache(point, method, cacheKey);
            }
            case HASH: {
                if (StringUtils.isEmpty((String)hashKey)) break;
                hashKey = helper.replacePlaceholders(hashKey, methodArgNameMap);
                return this.handleHashCache(point, method, cacheKey, hashKey);
            }
        }
        return point.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStringCache(ProceedingJoinPoint point, Method method, String cacheKey) throws Throwable {
        Object object;
        try {
            object = point.proceed();
        }
        catch (Throwable throwable) {
            this.redisUtil.del(new String[]{cacheKey});
            throw throwable;
        }
        this.redisUtil.del(new String[]{cacheKey});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleHashCache(ProceedingJoinPoint point, Method method, String cacheKey, String hashKey) throws Throwable {
        Object object;
        try {
            object = point.proceed();
        }
        catch (Throwable throwable) {
            this.redisUtil.hdel(cacheKey, new Object[]{hashKey});
            throw throwable;
        }
        this.redisUtil.hdel(cacheKey, new Object[]{hashKey});
        return object;
    }
}

