/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.alibaba.fastjson.JSON;
import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.page.Page;
import com.ovopark.model.req.ExportReq;
import com.ovopark.model.req.InsertReasonReq;
import com.ovopark.model.req.InspectionPlanAppExpandReq;
import com.ovopark.model.req.InspectionPlanTaskAddReq;
import com.ovopark.model.req.InspectionPlanTaskAppListReq;
import com.ovopark.model.req.InspectionPlanTaskAppLogListReq;
import com.ovopark.model.req.InspectionPlanTaskAuditReq;
import com.ovopark.model.req.InspectionPlanTaskCallBackReq;
import com.ovopark.model.req.InspectionPlanTaskDeleteReq;
import com.ovopark.model.req.InspectionPlanTaskDetailReq;
import com.ovopark.model.req.InspectionPlanTaskExpireReq;
import com.ovopark.model.req.InspectionPlanTaskSecondReq;
import com.ovopark.model.req.InspectionPlanTaskUpdateReq;
import com.ovopark.model.req.InspectionPlanTaskUrgedReq;
import com.ovopark.model.req.InspectionPlanTaskWebListReq;
import com.ovopark.model.req.InspectionPlanWebExpandReq;
import com.ovopark.model.req.PageReq;
import com.ovopark.model.resp.InspectionPlanTaskAppListResp;
import com.ovopark.model.resp.InspectionPlanTaskAppLogListResp;
import com.ovopark.model.resp.InspectionPlanTaskDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListCountResp;
import com.ovopark.model.resp.InspectionPlanTaskExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListResp;
import com.ovopark.model.resp.InspectionPlanTaskWebListResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.model.resp.JsonResult;
import com.ovopark.model.resp.RelatedUserCountResp;
import com.ovopark.model.utilsModel.DepartmentsExpect;
import com.ovopark.service.ExportService;
import com.ovopark.service.InspectionConfigService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/task"})
public class InspectionTaskController {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskController.class);
    private static Logger logger = LoggerFactory.getLogger(InspectionTaskController.class);
    @Autowired
    InspectionTaskService inspectionTaskService;
    @Autowired
    private InspectionConfigService inspectionConfigService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private IsInspectionDeptTemplateService deptTemplateService;

    @RequestMapping(value={"/app/list"})
    @ResponseBody
    public JsonNewResult<Page<InspectionPlanTaskAppListResp>> appList(@RequestBody InspectionPlanTaskAppListReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.success((Object)this.inspectionTaskService.appList(req, user));
    }

    @RequestMapping(value={"/app/log/list"})
    @ResponseBody
    public JsonNewResult<List<InspectionPlanTaskAppLogListResp>> appLog(@RequestBody InspectionPlanTaskAppLogListReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return this.inspectionTaskService.appLogList(req, user);
    }

    @RequestMapping(value={"/web/list"})
    @ResponseBody
    public JsonNewResult<Page<InspectionPlanTaskWebListResp>> webList(@RequestBody InspectionPlanTaskWebListReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return this.inspectionTaskService.webList(req, user);
    }

    @RequestMapping(value={"/web/export/list"})
    public JsonNewResult exportWebList(HttpServletResponse response, @RequestBody InspectionPlanTaskWebListReq req) {
        try {
            Users user = HttpContext.getContextInfoUser();
            Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
            JsonNewResult allResult = this.inspectionTaskService.allList(req, user);
            List list = (List)allResult.getData().get("data");
            this.exportService.webList(response, list, user);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
            throw new SysErrorException("EXCEPTION");
        }
        return JsonNewResult.jrSuccess();
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public JsonNewResult<Void> add(@RequestBody InspectionPlanTaskAddReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getAuditId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"auditId"}).addError(Boolean.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)req.getInspectionExpandList())), ResultCode.PARAM_ERROR_NAME, new Object[]{"inspectionExpandList"}).isValidThrowException();
        return this.inspectionTaskService.add(req, user);
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    public JsonNewResult<InspectionPlanTaskDetailResp> detail(@RequestBody InspectionPlanTaskDetailReq req) throws IOException {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.detail(req, user);
    }

    @RequestMapping(value={"/expandList"})
    @ResponseBody
    public JsonNewResult<Page<InspectionPlanTaskExpandListResp>> expandList(@RequestBody InspectionPlanAppExpandReq req) throws IOException {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.expandList(req, user);
    }

    @RequestMapping(value={"/expandList/count"})
    @ResponseBody
    public JsonNewResult<InspectionPlanTaskExpandListCountResp> expandCountList(@RequestBody InspectionPlanAppExpandReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.expandCountList(req, user);
    }

    @RequestMapping(value={"/udpate"})
    @ResponseBody
    public JsonNewResult<Void> udpate(@RequestBody InspectionPlanTaskUpdateReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.udpate(req, user);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public JsonNewResult<Void> delete(@RequestBody InspectionPlanTaskDeleteReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.delete(req, user);
    }

    @RequestMapping(value={"/batchDelete"})
    @ResponseBody
    public JsonNewResult<Void> batchDelete(@RequestBody InspectionPlanTaskDeleteReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)req.getIdList())), ResultCode.PARAM_ERROR_NAME, new Object[]{"idList"}).isValidThrowException();
        return this.inspectionTaskService.batchDelete(req, user);
    }

    @RequestMapping(value={"/urged"})
    @ResponseBody
    public JsonNewResult<Void> urged(@RequestBody InspectionPlanTaskUrgedReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.urged(req, user);
    }

    @RequestMapping(value={"/audit"})
    @ResponseBody
    public JsonNewResult<Void> audit(@RequestBody InspectionPlanTaskAuditReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.audit(req, user);
    }

    @RequestMapping(value={"/expire"})
    @ResponseBody
    public JsonNewResult<Void> expire(@RequestBody InspectionPlanTaskExpireReq req) {
        Users user = HttpContext.getContextInfoUser();
        logger.info("\u5b9a\u65f6\u4efb\u52a1\uff08\u4efb\u52a1\u8fc7\u671f\uff09\u5f00\u59cb\u5904\u7406");
        Validation.newValidation().addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTaskService.expire(req, user);
    }

    @RequestMapping(value={"/callBack"})
    @ResponseBody
    public JsonNewResult<Void> callBack(@RequestBody InspectionPlanTaskCallBackReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getTaskId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"taskId"}).addError(Boolean.valueOf(req.getExpandId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"expandId"}).isValidThrowException();
        return this.inspectionTaskService.callBack(req, user);
    }

    @RequestMapping(value={"/web/expandList"})
    @ResponseBody
    public JsonNewResult<InspectionPlanTaskWebExpandListResp> webExpandList(@RequestBody InspectionPlanWebExpandReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getTaskId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"taskId"}).isValidThrowException();
        return this.inspectionTaskService.webExpandList(req, user);
    }

    @RequestMapping(value={"getTotal"})
    @ResponseBody
    public String getTotal() {
        Users user = HttpContext.getContextInfoUser();
        if (user == null) {
            return JsonResult.invalidToken();
        }
        InspectionPlanTaskAppListReq req = new InspectionPlanTaskAppListReq();
        req.setPageNo(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(10));
        req.setReleateType(Integer.valueOf(1));
        Page page = this.inspectionTaskService.appList(req, user);
        page.getTotalCount();
        req.setReleateType(Integer.valueOf(2));
        Page page2 = this.inspectionTaskService.appList(req, user);
        return JsonResult.success((Object)(page2.getTotalCount() + page.getTotalCount()));
    }

    @RequestMapping(value={"/getInspectionPlanRelatedUserCount"})
    @ResponseBody
    public JsonNewResult<RelatedUserCountResp> getStorePlanRelatedUserCount(@RequestParam(value="groupId") Integer groupId, @RequestParam(value="userId") Integer userId) {
        Users user = new Users();
        user.setGroupId(groupId);
        user.setId(userId);
        InspectionPlanTaskAppListReq req = new InspectionPlanTaskAppListReq();
        req.setPageNo(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(10));
        req.setEffectiveTime(DateUtils.format((Date)new Date(), (String)DateUtil.FORMAT_LONG));
        Integer integer = this.inspectionTaskService.appCount(req, user);
        return JsonNewResult.success((Object)new RelatedUserCountResp(integer));
    }

    @PostMapping(value={"/web/second/list"})
    @ResponseBody
    public JsonNewResult secondWebList(@RequestBody InspectionPlanTaskSecondReq req) throws IOException {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.success((Object)this.inspectionTaskService.secondWebList(req, user));
    }

    @PostMapping(value={"/export/web/second/list"})
    public JsonNewResult exportSecondWebList(@RequestBody InspectionPlanTaskSecondReq req, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/binary;charset=UTF-8");
            response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode("\u5de1\u68c0\u8ba1\u5212\u8be6\u60c5\u8868.xlsx", "utf-8"));
            Users user = HttpContext.getContextInfoUser();
            Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
            req.setPageNumber(Integer.valueOf(1));
            req.setPageSize(Integer.valueOf(100000));
            List data = this.inspectionTaskService.secondWebList(req, user).getRecords();
            this.exportService.exportSecondWebList(response, data, user);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
            throw new SysErrorException(ResultCode.DOWNLOAD_FILE_ERROR, new Object[0]);
        }
        return JsonNewResult.jrSuccess();
    }

    @PostMapping(value={"/export"}, produces={"application/octet-stream"})
    public JsonNewResult exportDepartmentsExpect(HttpServletResponse response, @RequestBody ExportReq req) {
        ExportParams params = new ExportParams("\u95e8\u5e97\u9884\u8ba1\u5de1\u68c0\u65f6\u95f4", "\u95e8\u5e97\u9884\u8ba1\u5de1\u68c0\u65f6\u95f4", ExcelType.HSSF);
        Workbook workbook = null;
        workbook = org.springframework.util.CollectionUtils.isEmpty((Collection)req.getExpectList()) ? ExcelExportUtil.exportExcel((ExportParams)params, DepartmentsExpect.class, new ArrayList()) : ExcelExportUtil.exportExcel((ExportParams)params, DepartmentsExpect.class, (Collection)req.getExpectList());
        ServletOutputStream out = null;
        try {
            response.setHeader("content-type", "application/octet-stream");
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u95e8\u5e97\u9884\u8ba1\u5de1\u68c0\u65f6\u95f4.xlsx", "UTF-8"));
            out = response.getOutputStream();
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
            throw new SysErrorException(ResultCode.DOWNLOAD_FILE_ERROR, new Object[0]);
        }
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return JsonNewResult.jrSuccess();
    }

    @PostMapping(value={"/import"})
    public JsonNewResult importDepartmentsExpect(MultipartFile file) throws Exception {
        Users user = HttpContext.getContextInfoUser();
        ImportParams params = new ImportParams();
        params.setTitleRows(1);
        List<Object> list = new ArrayList();
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), DepartmentsExpect.class, (ImportParams)params);
        }
        catch (Exception e2) {
            throw new SysErrorException(ResultCode.DATA_ERROR, new Object[0]);
        }
        if (!CollectionUtils.isEmpty(list)) {
            list = list.stream().filter(e -> Objects.nonNull(e.getDepName()) && Objects.nonNull(e.getDepId())).collect(Collectors.toList());
            this.inspectionTaskService.check(list, user);
        }
        return JsonNewResult.success(list);
    }

    @PostMapping(value={"/insertReason"})
    @ResponseBody
    public JsonNewResult insertReason(@RequestBody InsertReasonReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(Objects.isNull(user)), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        Boolean o = this.deptTemplateService.insertReason(req);
        if (o.booleanValue()) {
            return JsonNewResult.success();
        }
        return JsonNewResult.error();
    }

    @PostMapping(value={"/getPlanList"})
    @ResponseBody
    public JsonNewResult getPlanList(@RequestBody PageReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(Objects.isNull(user)), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.success((Object)this.inspectionTaskService.getPlanList(user, req));
    }
}

