/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.annotation.PassToken;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.GetPlanByRelatedIdReq;
import com.ovopark.model.req.InspectionPlanWebExpandReq;
import com.ovopark.model.resp.GetInspectionPlanByRelatedIdResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListResp;
import com.ovopark.pojo.BaseResult;
import com.ovopark.service.InspectionTaskService;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open"})
public class OpenController {
    @Autowired
    private InspectionTaskService inspectionTaskService;

    @RequestMapping(value={"/getPlanByRelatedId"})
    public BaseResult<GetInspectionPlanByRelatedIdResp> getPlanByRelatedId(@RequestBody GetPlanByRelatedIdReq req) throws IOException {
        Validation.newValidation().addError(Boolean.valueOf(Objects.isNull(req.getRelatedId()) && Objects.isNull(req.getExpandId()) && Objects.isNull(req.getTaskId())), ResultCode.PARAM_ERROR_NAME, new Object[0]).isValidThrowException();
        GetInspectionPlanByRelatedIdResp resp = this.inspectionTaskService.getPlanByRelatedId(req);
        return BaseResult.success((Object)resp);
    }

    @PassToken
    @PostMapping(value={"/web/expandList"})
    public BaseResult<InspectionPlanTaskWebExpandListResp> webExpandList(@RequestBody InspectionPlanWebExpandReq req) {
        Users user = new Users();
        Validation.newValidation().addError(Boolean.valueOf(req.getGroupId() == null), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getTaskId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"taskId"}).isValidThrowException();
        user.setGroupId(req.getGroupId());
        return BaseResult.success((Object)this.inspectionTaskService.webExpandList(req, user));
    }
}

