/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.context.HttpContext;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.AddAuditConfigReq;
import com.ovopark.model.req.AuditConfigReq;
import com.ovopark.model.req.GetAuditReq;
import com.ovopark.model.req.UpdateAuditConfigReq;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.InspectionAuditConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auditConfig"})
public class AuditConfigController {
    @Autowired
    private InspectionAuditConfigService auditConfigService;

    @PostMapping(value={"/add"})
    public JsonNewResult add(@RequestBody AddAuditConfigReq req) {
        Users user = HttpContext.getContextInfoUser();
        this.auditConfigService.add(user, req);
        return JsonNewResult.success();
    }

    @PostMapping(value={"/update"})
    public JsonNewResult update(@RequestBody UpdateAuditConfigReq req) {
        Users user = HttpContext.getContextInfoUser();
        this.auditConfigService.update(user, req);
        return JsonNewResult.success();
    }

    @PostMapping(value={"/delete"})
    public JsonNewResult delete(@RequestBody AuditConfigReq req) {
        return JsonNewResult.success((Object)this.auditConfigService.delete(req.getId()));
    }

    @PostMapping(value={"/list"})
    public JsonNewResult list() {
        Users user = HttpContext.getContextInfoUser();
        return JsonNewResult.success((Object)this.auditConfigService.get(user));
    }

    @GetMapping(value={"/getDetail/{id}"})
    public JsonNewResult getDetail(@PathVariable Integer id) {
        Users user = HttpContext.getContextInfoUser();
        return JsonNewResult.success((Object)this.auditConfigService.getDetail(user, id));
    }

    @GetMapping(value={"/checkAudit/{operatorId}"})
    public JsonNewResult checkAudit(@PathVariable Integer operatorId) {
        Users user = HttpContext.getContextInfoUser();
        return JsonNewResult.success((Object)this.auditConfigService.checkAudit(user, operatorId));
    }

    @PostMapping(value={"/getAudit"})
    public JsonNewResult getAudit(@RequestBody GetAuditReq req) {
        Users user = HttpContext.getContextInfoUser();
        return JsonNewResult.success((Object)this.auditConfigService.getAudit(user, req));
    }
}

