/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.constants.CommonConstants;
import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.expection.Validation;
import com.ovopark.model.enums.ExportTaskStatusEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionPlanTaskSecondReq;
import com.ovopark.model.req.InspectionPlanTaskWebListReq;
import com.ovopark.model.req.WebDetailReq;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.ExportTaskApi;
import com.ovopark.pojo.BaseResult;
import com.ovopark.service.ExportService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExportController {
    private static final Logger log = LoggerFactory.getLogger(ExportController.class);
    @Autowired
    private ExportService exportService;
    @Autowired
    private ExportTaskApi exportTaskApi;
    @Autowired
    InspectionTaskService inspectionTaskService;
    @Autowired
    private InspectionTaskExpandService expandService;

    @PostMapping(value={"/retryExport"})
    public BaseResult retryExport(@RequestBody ExportTaskPojo pojo) throws Exception {
        Users user = HttpContext.getContextInfoUser();
        String fileName = pojo.getName();
        Integer exportTaskId = pojo.getId();
        log.info("\u4e0b\u8f7d\u91cd\u65b0\u91cd\u8bd5\u63a5\u53e3\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)pojo));
        CompletableFuture.runAsync(() -> {
            try {
                this.assemExportTask(exportTaskId);
                switch (pojo.getTaskType()) {
                    case 0: {
                        InspectionPlanTaskSecondReq req = (InspectionPlanTaskSecondReq)JSONObject.parseObject((String)pojo.getParams(), InspectionPlanTaskSecondReq.class);
                        List data = this.inspectionTaskService.secondWebList(req, user).getRecords();
                        this.exportService.exportSecondWebList(data, user, fileName, exportTaskId);
                        break;
                    }
                    case 1: {
                        InspectionPlanTaskWebListReq inspectionPlanTaskWebListReq = (InspectionPlanTaskWebListReq)JSONObject.parseObject((String)pojo.getParams(), InspectionPlanTaskWebListReq.class);
                        JsonNewResult allResult = this.inspectionTaskService.allList(inspectionPlanTaskWebListReq, user);
                        List list = (List)allResult.getData().get("data");
                        this.exportService.webList(list, user, fileName, exportTaskId);
                    }
                }
            }
            catch (Exception e) {
                this.assemFailExportTask(exportTaskId);
                log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                throw new SysErrorException(ResultCode.DOWNLOAD_FILE_ERROR, new Object[0]);
            }
        });
        return BaseResult.success();
    }

    @PostMapping(value={"/task/export/web/second/list"})
    public JsonNewResult exportSecondWebList(@RequestBody InspectionPlanTaskSecondReq req) throws Exception {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        Date date = new Date();
        String fileName = CommonConstants.TASK_SECOND_EXCEL_FILE_NAME + DateUtils.format((Date)date, (String)DateUtils.FORMAT_LONG);
        Integer exportTaskId = this.assemExportTask(fileName, user, req.toString(), 0);
        log.info("user:{}", (Object)JSON.toJSONString((Object)user));
        CompletableFuture.runAsync(() -> {
            try {
                req.setPageNumber(Integer.valueOf(1));
                req.setPageSize(Integer.valueOf(100000));
                List data = this.inspectionTaskService.secondWebList(req, user).getRecords();
                this.exportService.exportSecondWebList(data, user, fileName, exportTaskId);
            }
            catch (Exception e) {
                this.assemFailExportTask(exportTaskId);
                log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                throw new SysErrorException(ResultCode.DOWNLOAD_FILE_ERROR, new Object[0]);
            }
        });
        return JsonNewResult.jrSuccess((Object)this.exportService.getTaskById(exportTaskId));
    }

    @RequestMapping(value={"/task/web/export/list"})
    public JsonNewResult exportWebList(@RequestBody InspectionPlanTaskWebListReq req) throws Exception {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        Date date = new Date();
        String fileName = CommonConstants.TASK_EXCEL_FILE_NAME + DateUtils.format((Date)date, (String)DateUtils.FORMAT_LONG);
        Integer exportTaskId = this.assemExportTask(fileName, user, JSON.toJSONString((Object)req), 1);
        log.info("user:{}", (Object)JSON.toJSONString((Object)user));
        CompletableFuture.runAsync(() -> {
            try {
                JsonNewResult allResult = this.inspectionTaskService.allList(req, user);
                List list = (List)allResult.getData().get("data");
                this.exportService.webList(list, user, fileName, exportTaskId);
            }
            catch (Exception e) {
                this.assemFailExportTask(exportTaskId);
                log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                throw new SysErrorException("EXCEPTION");
            }
        });
        return JsonNewResult.jrSuccess((Object)this.exportService.getTaskById(exportTaskId));
    }

    private void assemFailExportTask(Integer exportTaskId) {
        ExportTaskPojo exportTaskPojo = new ExportTaskPojo();
        exportTaskPojo.setId(exportTaskId);
        exportTaskPojo.setStatus(ExportTaskStatusEnum.FAIL.getCode());
        this.exportTaskApi.saveExportTask(exportTaskPojo);
    }

    private Integer assemExportTask(String fileName, Users user, String params, Integer taskType) {
        ExportTaskPojo exportTaskPojo = new ExportTaskPojo();
        exportTaskPojo.setCreatorId(user.getId());
        exportTaskPojo.setParams(params);
        exportTaskPojo.setEnterpriseId(user.getGroupId());
        exportTaskPojo.setModuleType(Integer.valueOf(6));
        exportTaskPojo.setName(fileName);
        exportTaskPojo.setTaskType(taskType);
        exportTaskPojo.setStatus(ExportTaskStatusEnum.ING.getCode());
        return (Integer)this.exportTaskApi.saveExportTask(exportTaskPojo).getData();
    }

    private void assemExportTask(Integer exportTaskId) {
        ExportTaskPojo exportTaskPojo = new ExportTaskPojo();
        exportTaskPojo.setId(exportTaskId);
        exportTaskPojo.setStatus(ExportTaskStatusEnum.ING.getCode());
        this.exportTaskApi.saveExportTask(exportTaskPojo).getData();
    }

    @RequestMapping(value={"/exportWebDetails"})
    public JsonNewResult exportWebDetails(@RequestBody WebDetailReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        Date date = new Date();
        String fileName = CommonConstants.TASK_DETAIL_EXCEL_FILE_NAME + DateUtils.format((Date)date, (String)DateUtils.FORMAT_LONG);
        req.setPage(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(99999));
        Integer exportTaskId = this.assemExportTask(fileName, user, JSON.toJSONString((Object)req), 1);
        log.info("user:{}", (Object)JSON.toJSONString((Object)user));
        CompletableFuture.runAsync(() -> {
            try {
                Page page = this.expandService.webDetails(req, user);
                this.exportService.exportWebDetails(page.getRecords(), user, fileName, exportTaskId);
            }
            catch (Exception e) {
                this.assemFailExportTask(exportTaskId);
                log.error("\u4e0b\u8f7d\u5931\u8d25\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                throw new SysErrorException("EXCEPTION");
            }
        });
        return JsonNewResult.jrSuccess((Object)this.exportService.getTaskById(exportTaskId));
    }
}

