/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.context.HttpContext;
import com.ovopark.model.dto.CommonConfigDto;
import com.ovopark.model.login.Users;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.CommonConfigService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commonConfig"})
public class CommomConfigController {
    @Autowired
    private CommonConfigService commonConfigService;

    @PostMapping(value={"/add"})
    public JsonNewResult add(@RequestBody List<CommonConfigDto> req) {
        Users user = HttpContext.getContextInfoUser();
        this.commonConfigService.addCommonConfigReq(user, req);
        return JsonNewResult.success();
    }

    @GetMapping(value={"/getAllCommonConfig"})
    public JsonNewResult<Map<String, String>> getAllCommonConfig() {
        Users user = HttpContext.getContextInfoUser();
        if (user == null || user.getGroupId() == null) {
            return JsonNewResult.invalidToken();
        }
        Map map = this.commonConfigService.getAllCommonConfig(user.getGroupId());
        return JsonNewResult.success((Object)map);
    }

    @GetMapping(value={"/getEnterpriseConfig/{configKey}"})
    public JsonNewResult<String> getEnterpriseConfig(@PathVariable(value="configKey") String configKey) {
        Users user = HttpContext.getContextInfoUser();
        if (user == null || user.getGroupId() == null) {
            return JsonNewResult.invalidToken();
        }
        String config = this.commonConfigService.getEnterpriseConfig(user.getGroupId(), configKey);
        return JsonNewResult.success((Object)config);
    }
}

