/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.ovopark.utils.RedisCacheUtil;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfig
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(RedisConfig.class);

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer serializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        serializer.setObjectMapper(objectMapper);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)serializer);
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)serializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        Jackson2JsonRedisSerializer serializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        serializer.setObjectMapper(objectMapper);
        RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)serializer)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer()));
        return new DynamicTTLRedisCacheManager(RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), cacheConfiguration);
    }

    public static class DynamicTTLRedisCache
    extends RedisCache {
        private final RedisCacheWriter cacheWriter;
        private final RedisCacheConfiguration cacheConfig;

        public DynamicTTLRedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
            super(name, cacheWriter, cacheConfig);
            this.cacheWriter = cacheWriter;
            this.cacheConfig = cacheConfig;
        }

        public void put(Object key, Object value) {
            Duration ttl = RedisCacheUtil.calculateTTLForNext2PM();
            log.info("Setting dynamic TTL for cache key '{}', TTL: {} seconds", key, (Object)ttl.getSeconds());
            String cacheKey = "inspectionCache::" + key;
            this.cacheWriter.put(this.getName(), this.serializeCacheKey(cacheKey), this.serializeCacheValue(value), ttl);
        }

        protected byte[] serializeCacheKey(Object key) {
            StringRedisSerializer keySerializer = new StringRedisSerializer();
            return keySerializer.serialize((Object)((String)key));
        }

        protected byte[] serializeCacheValue(Object value) {
            Jackson2JsonRedisSerializer valueSerializer = new Jackson2JsonRedisSerializer(Object.class);
            return valueSerializer.serialize(value);
        }
    }

    public static class DynamicTTLRedisCacheManager
    extends RedisCacheManager {
        private final RedisCacheWriter cacheWriter;
        private final RedisCacheConfiguration cacheConfig;

        public DynamicTTLRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
            super(cacheWriter, cacheConfig);
            this.cacheWriter = cacheWriter;
            this.cacheConfig = cacheConfig;
        }

        protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
            return new DynamicTTLRedisCache(name, this.cacheWriter, cacheConfig);
        }
    }
}

