/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionCategoryAddReq;
import com.ovopark.model.req.InspectionCategoryDeleteReq;
import com.ovopark.model.req.InspectionCategoryUpdateReq;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.InspectionCategoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/category"})
public class InspectionCategoryController {
    private static Logger logger = LoggerFactory.getLogger(InspectionCategoryController.class);
    @Autowired
    InspectionCategoryService inspectionCategoryService;

    @RequestMapping(value={"/add"})
    @ResponseBody
    public JsonNewResult<Void> add(@RequestBody InspectionCategoryAddReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(StringUtils.isEmpty((Object)req.getName())), ResultCode.PARAM_ERROR_NAME, new Object[]{"name"}).isValidThrowException();
        return this.inspectionCategoryService.add(req, user);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public JsonNewResult<Void> update(@RequestBody InspectionCategoryUpdateReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(StringUtils.isEmpty((Object)req.getName())), ResultCode.PARAM_ERROR_NAME, new Object[]{"name"}).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionCategoryService.update(req, user);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public JsonNewResult<Void> delete(@RequestBody InspectionCategoryDeleteReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionCategoryService.delete(req, user);
    }
}

