/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionTagAddReq;
import com.ovopark.model.req.InspectionTagDeleteReq;
import com.ovopark.model.req.InspectionTagListReq;
import com.ovopark.model.req.InspectionTagUpdateReq;
import com.ovopark.model.resp.InspectionTagCategoryListResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.InspectionTagService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tag"})
public class InspectionTagController {
    @Autowired
    InspectionTagService inspectionTagService;

    @RequestMapping(value={"/add"})
    @ResponseBody
    public JsonNewResult<Void> add(@RequestBody InspectionTagAddReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getCategoryId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"categoryId"}).addError(Boolean.valueOf(StringUtils.isEmpty((Object)req.getName())), ResultCode.PARAM_ERROR_NAME, new Object[]{"name"}).isValidThrowException();
        return this.inspectionTagService.add(req, user);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public JsonNewResult<Void> update(@RequestBody InspectionTagUpdateReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getCategoryId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"categoryId"}).addError(Boolean.valueOf(StringUtils.isEmpty((Object)req.getName())), ResultCode.PARAM_ERROR_NAME, new Object[]{"name"}).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTagService.update(req, user);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public JsonNewResult<Void> delete(@RequestBody InspectionTagDeleteReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"id"}).isValidThrowException();
        return this.inspectionTagService.delete(req, user);
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public JsonNewResult<List<InspectionTagCategoryListResp>> list(@RequestBody InspectionTagListReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return this.inspectionTagService.list(req, user);
    }
}

