/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.GetFinishPerByOrganizeIdsReq;
import com.ovopark.model.req.InspectionTashFinishPerTop;
import com.ovopark.model.req.InspectionTaskCountReq;
import com.ovopark.model.req.InspectionTaskWillOutTimeReq;
import com.ovopark.model.resp.InspectionTaskCountResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.InspectionTaskService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/task/data"})
@RestController
public class InspectionTaskDataController {
    @Autowired
    private InspectionTaskService inspectionTaskService;

    @RequestMapping(value={"/personly"})
    public JsonNewResult personly() {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.jrSuccess((Object)this.inspectionTaskService.personly(user));
    }

    @RequestMapping(value={"/taskCount"})
    public JsonNewResult taskCount(@RequestBody InspectionTaskCountReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        InspectionTaskCountResp resp = this.inspectionTaskService.taskCount(req, user);
        return JsonNewResult.jrSuccess((Object)resp);
    }

    @RequestMapping(value={"/finishTop"})
    public JsonNewResult finishTop(@RequestBody InspectionTashFinishPerTop req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.jrSuccess((Object)this.inspectionTaskService.finishTop(user, req));
    }

    @RequestMapping(value={"/willOutTime"})
    public JsonNewResult willOutTime(@RequestBody InspectionTaskWillOutTimeReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.jrSuccess((Object)this.inspectionTaskService.willOutTime(req, user));
    }

    @RequestMapping(value={"getTaskByGroupId"})
    public JsonNewResult getTaskByGroupId(@RequestBody InspectionTaskCountReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.success((Object)this.inspectionTaskService.getTaskByGroupId(req, user));
    }

    @RequestMapping(value={"/getFinishPerByGroupId"})
    public JsonNewResult getFinishPerByGroupId(@RequestBody InspectionTaskCountReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        return JsonNewResult.success((Object)this.inspectionTaskService.getFinishPerByGroupId(req, user));
    }

    @RequestMapping(value={"/getFinishPerByOrganizeIds"})
    public JsonNewResult getFinishPerByOrganizeIds(@RequestBody GetFinishPerByOrganizeIdsReq req) {
        Users user = HttpContext.getContextInfoUser();
        Validation.newValidation().addError(Boolean.valueOf(null == user), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).isValidThrowException();
        List resps = this.inspectionTaskService.getFinishPerByOrganizeIds(req, user);
        return JsonNewResult.success((Object)resps);
    }
}

