/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.aspect;

import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.ResultCodeInfo;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.resp.JsonNewResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class SystemExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SystemExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object defaultErrorHandler(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        log.error("\u62e6\u622a\u5230\u9519\u8bef", (Throwable)e);
        resp.setStatus(HttpStatus.OK.value());
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-cache, must-revalidate");
        ResultCodeInfo resultCodeInfo = null;
        if (e instanceof SysErrorException) {
            SysErrorException de = (SysErrorException)e;
            log.info("_trace_id:" + HttpContext.getTraceId() + ";SysErrorException Error reason!" + de.getMessage(), (Throwable)de);
            resultCodeInfo = de.getResultCodeInfo();
        }
        if (null == resultCodeInfo) {
            resultCodeInfo = ResultCode.SYS_ERROR_MSG;
        }
        return JsonNewResult.error((ResultCodeInfo)resultCodeInfo);
    }
}

