/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.ovopark.annotation.PassToken;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.Validation;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.GetPlanByRelatedIdReq;
import com.ovopark.model.req.GetPlanParam;
import com.ovopark.model.req.GetPlansResp;
import com.ovopark.model.req.InspectionPlanTaskAppListReq;
import com.ovopark.model.req.InspectionPlanWebExpandReq;
import com.ovopark.model.req.PlanByDepIdsReq;
import com.ovopark.model.resp.GetInspectionPlanByRelatedIdResp;
import com.ovopark.model.resp.InspectionPlanTaskWebExpandListResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.model.resp.RelatedUserCountResp;
import com.ovopark.model.resp.StorePlanNameAndId;
import com.ovopark.pojo.BaseResult;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open"})
public class OpenController {
    @Autowired
    private InspectionTaskService inspectionTaskService;
    @Autowired
    private InspectionTaskExpandService expandService;

    @RequestMapping(value={"/getPlanByRelatedId"})
    public BaseResult<GetInspectionPlanByRelatedIdResp> getPlanByRelatedId(@RequestBody GetPlanByRelatedIdReq req) throws IOException {
        Validation.newValidation().addError(Boolean.valueOf(Objects.isNull(req.getRelatedId()) && Objects.isNull(req.getExpandId()) && Objects.isNull(req.getTaskId())), ResultCode.PARAM_ERROR_NAME, new Object[0]).isValidThrowException();
        GetInspectionPlanByRelatedIdResp resp = this.inspectionTaskService.getPlanByRelatedId(req);
        return BaseResult.success((Object)resp);
    }

    @PassToken
    @PostMapping(value={"/web/expandList"})
    public BaseResult<InspectionPlanTaskWebExpandListResp> webExpandList(@RequestBody InspectionPlanWebExpandReq req) {
        Users user = new Users();
        Validation.newValidation().addError(Boolean.valueOf(req.getGroupId() == null), ResultCode.RESULT_INVALID_TOKEN, new Object[0]).addError(Boolean.valueOf(req.getTaskId() == null), ResultCode.PARAM_ERROR_NAME, new Object[]{"taskId"}).isValidThrowException();
        user.setGroupId(req.getGroupId());
        return BaseResult.success((Object)this.inspectionTaskService.webExpandList(req, user));
    }

    @RequestMapping(value={"/getInspectionPlanRelatedUserCount"})
    @ResponseBody
    public BaseResult<RelatedUserCountResp> getStorePlanRelatedUserCount(@RequestParam(value="groupId") Integer groupId, @RequestParam(value="userId") Integer userId) {
        Users user = new Users();
        user.setGroupId(groupId);
        user.setId(userId);
        InspectionPlanTaskAppListReq req = new InspectionPlanTaskAppListReq();
        req.setPageNo(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(10));
        req.setEffectiveTime(DateUtils.format((Date)new Date(), (String)DateUtil.FORMAT_LONG));
        Integer integer = this.inspectionTaskService.appCount(req, user);
        return BaseResult.success((Object)new RelatedUserCountResp(integer));
    }

    @PassToken
    @PostMapping(value={"/getPlanByDepIds"})
    @ResponseBody
    public BaseResult<Map<Integer, StorePlanNameAndId>> getPlanByDepIds(@RequestBody PlanByDepIdsReq req) {
        try {
            Map map = this.inspectionTaskService.getPlanByDepIds(req.getDepIds(), req.getUserId(), req.getGroupId(), req.getMainType());
            return BaseResult.success((Object)map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResult.error();
        }
    }

    @PassToken
    @PostMapping(value={"/getPlans"})
    public JsonNewResult<List<GetPlansResp>> getPlans(@RequestBody GetPlanParam req) throws IOException {
        return JsonNewResult.success((Object)this.expandService.getPlans(req));
    }
}

