/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.controller;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.ovopark.annotation.PassToken;
import com.ovopark.model.resp.JsonNewResult;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
public class SysController {
    private static final Logger log = LoggerFactory.getLogger(SysController.class);
    @Resource
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    private KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry;
    @Value(value="${DEREGISTER_TOKEN:fv}")
    private String deregisterToken;

    @GetMapping(value={"/deregister"})
    @PassToken
    public JsonNewResult<?> stop(String token) throws NacosException {
        if (StringUtils.isBlank((CharSequence)token)) {
            return JsonNewResult.success();
        }
        if (!Objects.equals(token, this.deregisterToken)) {
            return JsonNewResult.success();
        }
        String ip = this.nacosDiscoveryProperties.getIp();
        int port = this.nacosDiscoveryProperties.getPort();
        String serviceName = this.nacosDiscoveryProperties.getService();
        this.nacosServiceManager.getNamingService(null).deregisterInstance(serviceName, ip, port);
        this.kafkaListenerEndpointRegistry.stop();
        return JsonNewResult.success();
    }
}

