/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.web.kafka;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.model.enums.KafkaEventEnum;
import com.ovopark.model.enums.KafkaSourceEnum;
import com.ovopark.model.enums.KafkaStatusEnum;
import com.ovopark.model.req.InspectionPlanTaskCallBackReq;
import com.ovopark.model.req.KafkaDeleteReq;
import com.ovopark.model.req.KafkaExtraDeleteReq;
import com.ovopark.service.CheckTaskRelateService;
import com.ovopark.service.InspectionLastTimeCacheService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import java.io.IOException;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"enableJob"}, havingValue="true")
public class CheckKafka {
    private static final Logger log = LoggerFactory.getLogger(CheckKafka.class);
    @Autowired
    private InspectionTaskExpandService expandService;
    @Autowired
    private InspectionTaskService inspectionTaskService;
    @Autowired
    private CheckTaskRelateService checkTaskRelateService;
    @Autowired
    private InspectionLastTimeCacheService inspectionLastTimeCacheService;

    @KafkaListener(topics={"${KafkaTopic.EXPAND}"})
    public void handleIposWarningData(ConsumerRecord<String, String> record) throws IOException {
        String value = (String)record.value();
        KafkaDeleteReq req = (KafkaDeleteReq)JSONObject.parseObject((String)value, KafkaDeleteReq.class);
        log.info("kafka data\uff1a" + record.offset() + "content\uff1a" + value + "");
        this.handleInspectionCompletion(req);
        if (req.getSource().equals(KafkaSourceEnum.TASK.getDesc())) {
            KafkaExtraDeleteReq deleteReq = (KafkaExtraDeleteReq)JSONObject.parseObject((String)req.getExtra(), KafkaExtraDeleteReq.class);
            KafkaEventEnum anEnum = KafkaEventEnum.formatOrNull((String)req.getEvent());
            KafkaStatusEnum statusEnum = KafkaStatusEnum.formatOrNull((String)req.getStatus());
            switch (anEnum) {
                case DELETED: {
                    this.expandService.returnExpand(deleteReq.getStorePlanDetailId(), deleteReq.getTemplateId(), req.getOperatorId(), req.getTemplateName());
                    break;
                }
                case COMMITTED: {
                    InspectionPlanTaskCallBackReq callBackReq = null;
                    switch (statusEnum) {
                        case DONE: 
                        case WAIT_REVIEW: {
                            callBackReq = new InspectionPlanTaskCallBackReq();
                            callBackReq.setExpandId(deleteReq.getStorePlanDetailId());
                            callBackReq.setTaskId(deleteReq.getCheckTaskId());
                            callBackReq.setTemplateId(deleteReq.getTemplateId() != null ? deleteReq.getTemplateId() : null);
                            this.inspectionTaskService.callBack(callBackReq, null);
                        }
                    }
                }
            }
        }
    }

    private void clearCacheIfNeeded(KafkaDeleteReq req) {
        if (Objects.nonNull(req.getTemplateId()) && Objects.nonNull(req.getDepartmentId())) {
            log.info("Preparing to clear cache, storeId: {}, templateId: {}", (Object)req.getDepartmentId(), (Object)req.getTemplateId());
            this.inspectionLastTimeCacheService.clearCache(String.valueOf(req.getDepartmentId()), String.valueOf(req.getTemplateId()));
            log.info("Cache cleared successfully, storeId: {}, templateId: {}", (Object)req.getDepartmentId(), (Object)req.getTemplateId());
        }
    }

    private void handleInspectionCompletion(KafkaDeleteReq req) {
        log.info("The inspection has been completed, the next step is to clear the cache");
        this.clearCacheIfNeeded(req);
        log.info("The inspection has been completed, the cache has been cleared");
    }
}

