package com.ovopark.iohub.sdk.model.proto.internal;

import lombok.Data;

import java.util.concurrent.atomic.AtomicLong;

@Data
public class SegmentRuntimeStatImpl implements SegmentRuntimeStat {

    private int completedRenderRowCount;

    private long startMs;

    private long endMs;

    private boolean rangeMerge;

    private int lastRowNum;

    private AtomicLong rangeMergeCount=new AtomicLong(0);

    private long fileByteSize;

    @Override
    public void completedRenderRowCount(int completedRenderRowCount) {
        setCompletedRenderRowCount(completedRenderRowCount);
    }

    @Override
    public int completedRenderRowCount() {
        return getCompletedRenderRowCount();
    }

    @Override
    public void startMs(long startMs) {
        setStartMs(startMs);
    }

    @Override
    public long startMs() {
        return getStartMs();
    }

    @Override
    public void endMs(long endMs) {
        setEndMs(endMs);
    }

    @Override
    public long endMs() {
        return getEndMs();
    }

    @Override
    public boolean rangeMerge() {
        return isRangeMerge();
    }

    @Override
    public void rangeMerge(boolean rangeMerge) {
        setRangeMerge(rangeMerge);
    }

    @Override
    public void lastRowNum(int lastRowNum) {
        setLastRowNum(lastRowNum);
    }

    @Override
    public int lastRowNum() {
        return getLastRowNum();
    }

    @Override
    public long incrementRangeMergeCount() {
        return rangeMergeCount.incrementAndGet();
    }

    @Override
    public long rangeMergeCount() {
        return rangeMergeCount.get();
    }

    @Override
    public long fileByteSize() {
        return fileByteSize;
    }

    @Override
    public void fileByteSize(long fileByteSize) {
        this.fileByteSize=fileByteSize;
    }
}
