package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.module.shared.Session;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public interface JobOutTaskFlow<T extends RequestParamBody> {


    default void prepared(){};

    /**
     * <PRE>
     * provide request parameter for exporting again ,
     * the param is also stored in export hub of organize
     *
     * throw {@link NoPrivilegeException} if the report is rejected , does not match some condition
     *
     * @param requestBody http post request body / json object data format
     * @param session authentication
     * @return T
     * @throws NoPrivilegeException no privilege
     */
    T requestParamBody(String requestBody, Session session) throws NoPrivilegeException;

    default ExportTaskInfoProvider exportTaskInfoProvider(T requestParamBody, Session session){return null;}

    void execute(T requestParamBody, OutStore outStore);

    default void close(){};

    default Class<T> paramType(){
        Type superClass = this.getClass().getGenericInterfaces()[0];
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        } else {
            return (Class<T>) ((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }
    }

    interface ExportTaskInfoProvider {

        String name();

    }

}
