package com.ovopark.iohub.sdk.client.instream;

import java.util.ArrayList;
import java.util.List;

/**
 * @since 4.6
 */
final public class ReadJobManager {

    final static private List<ReadJobFactoryProxy> readJobFactoryProxyList =new ArrayList<>();

    public static ReadJob newJob(){
        return newJob(false);
    }

    public static ReadJob newJob(boolean nfs){
        return nfs? newJob("/iohub-read-job/import/defaultNfsReadJob"): newJob("/iohub-read-job/import/defaultMemoryReadJob");
    }

    public static ReadJob newJob(String uri){
        for (ReadJobFactoryProxy renderJobFactory : readJobFactoryProxyList) {
            ReadJob renderJob = renderJobFactory.newJob(uri);
            if (renderJob!=null) {
                return renderJob;
            }
        }
        return null;
    }



    public static ReadJobFactoryProxy use(ReadJobFactory renderJobFactory){
        return new ReadJobFactoryProxyImpl(renderJobFactory);
    }

    public synchronized static void register(ReadJobFactory readJobFactory){
        readJobFactoryProxyList.add(new ReadJobFactoryProxyImpl(readJobFactory));
    }


    public interface ReadJobFactory{

        ReadJob factory(String uri);

    }


    static private class ReadJobFactoryProxyImpl implements ReadJobFactoryProxy {

        final private ReadJobFactory readJobFactory;

        public ReadJobFactoryProxyImpl(ReadJobFactory readJobFactory) {
            this.readJobFactory = readJobFactory;
        }

        public ReadJob newJob(String uri){
            return readJobFactory.factory(uri);
        }

    }

    public interface ReadJobFactoryProxy{

        default ReadJob newJob(){
            return newJob(false);
        }

        default ReadJob newJob(boolean nfs){
            return nfs? newJob("/iohub-read-job/import/defaultNfsReadJob"): newJob("/iohub-read-job/import/defaultMemoryReadJob");
        }

        ReadJob newJob(String uri);
    }
}
