package com.ovopark.iohub.sdk.model.proto;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <PRE>
 * 单元格垂直合并特性
 * - 只支持平铺的简单行数据结构，不支持数据行是TREE的数据结构
 *
 * 如果需要复杂的单元格合并，使用TREE数据结构 并配置范围合并特性
 * {@link com.ovopark.iohub.sdk.model.proto.OutStore.FeatureOperation#supportRangeMerge(boolean)}
 * {@link com.ovopark.iohub.sdk.model.proto.OutStore.SegmentWriter.FeatureOperation#supportRangeMerge(boolean)}
 *
 * @since 4.1
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MergeDef {

    boolean verticalMerge() default true;

}
