package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.ModuleUri;
import com.ovopark.iohub.sdk.model.proto.TaskCreatedRequest;
import com.ovopark.iohub.sdk.model.proto.Watermark;
import com.ovopark.kernel.shared.JSONAccessor;
import lombok.Data;

@Data
public class WatermarkImpl implements Watermark {


    @Override
    public WatermarkWriter open() {
        return new WatermarkWriterImpl();
    }

    @Data
    public static class WatermarkWriterImpl implements WatermarkWriter{

        final private WatermarkModelImpl watermarkModel=new WatermarkModelImpl();

        final TaskCreatedRequestImpl taskCreatedRequest=new TaskCreatedRequestImpl();

        @Override
        public WatermarkWriter moduleUri(ModuleUri moduleUri) {
            taskCreatedRequest.setUri(moduleUri.getUri());
            return this;
        }

        @Override
        public WatermarkWriter file(String url, String fileType) {
            FileImpl file=new FileImpl();
            file.setUrl(url);
            file.setFileType(fileType);
            watermarkModel.getFileList().add(file);
            return this;
        }

        @Override
        public WatermarkWriter sessionToken(String sessionToken) {
            taskCreatedRequest.setSessionToken(sessionToken);
            return this;
        }

        @Override
        public WatermarkWriter groupId(Integer groupId) {
            taskCreatedRequest.setGroupId(groupId);
            return this;
        }

        @Override
        public WatermarkWriter userId(Integer userId) {
            taskCreatedRequest.setUserId(userId);
            return this;
        }

        @Override
        public WatermarkWriter waterConfigRef(String waterConfigRef) {
            watermarkModel.setWaterConfigRef(waterConfigRef);
            return this;
        }

        @Override
        public WatermarkWriter exportName(String exportName) {
            watermarkModel.setExportName(exportName);
            return this;
        }

        @Override
        public TaskCreatedRequest build() {
            if (watermarkModel.getGroupId()==null) {
                watermarkModel.setGroupId(taskCreatedRequest.getGroupId());
            }
            if (watermarkModel.getUserId()==null) {
                watermarkModel.setUserId(taskCreatedRequest.getUserId());
            }
            taskCreatedRequest.setParamMap(JSONAccessor.impl().read(JSONAccessor.impl().format(watermarkModel)));
            return taskCreatedRequest;
        }
    }


}
