/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.InMemoryOutStore;
import com.ovopark.iohub.sdk.client.JobClient2WorkTransport;
import com.ovopark.iohub.sdk.client.OutStore;
import com.ovopark.iohub.sdk.client.Writer;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.PushCommitRequest;
import com.ovopark.iohub.sdk.model.PushCommitResponse;
import com.ovopark.iohub.sdk.model.PushDataRequest;
import com.ovopark.iohub.sdk.model.PushDataResponse;
import com.ovopark.iohub.sdk.model.proto.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.NFSSegmentModel;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.SegmentImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(HttpWriter.class);
    private final JobClient2WorkTransport jobClient2WorkTransport;

    public HttpWriter(JobClient2WorkTransport jobClient2WorkTransport) {
        this.jobClient2WorkTransport = jobClient2WorkTransport;
    }

    @Override
    public void writeAndCommit(List<Segment.SD> sdList, OutStore outStore, long taskId, ClientNode clientNode, AppNode worker) {
        if (outStore instanceof InMemoryOutStore) {
            ArrayList<SegmentImpl> list = new ArrayList<SegmentImpl>();
            for (Segment.SD sd : sdList) {
                Segment segment = outStore.segment(sd);
                list.add((SegmentImpl)segment);
            }
            PushDataRequest pushDataRequest = new PushDataRequest();
            pushDataRequest.setSegmentList(list);
            pushDataRequest.setTaskId(taskId);
            pushDataRequest.setApp(clientNode.app());
            pushDataRequest.setNode(clientNode.node());
            pushDataRequest.setWorkApp(worker.getApp());
            pushDataRequest.setWorkNode(worker.getNode());
            PushDataResponse pushDataResponse = this.jobClient2WorkTransport.push(pushDataRequest);
            if (pushDataResponse == null || !pushDataResponse.isSuccess()) {
                throw new IllegalStateException("cannot push data to worker:");
            }
            PushCommitRequest pushCommitRequest = new PushCommitRequest();
            pushCommitRequest.setTaskId(taskId);
            pushCommitRequest.setApp(clientNode.app());
            pushCommitRequest.setNode(clientNode.node());
            pushCommitRequest.setWorkApp(worker.getApp());
            pushCommitRequest.setWorkNode(worker.getNode());
            PushCommitResponse pushCommitResponse = this.jobClient2WorkTransport.commit(pushCommitRequest);
            if (pushCommitResponse == null || !pushCommitResponse.isSuccess()) {
                throw new IllegalStateException("cannot commit data to worker:");
            }
        } else {
            ArrayList<NFSSegmentModel> nfsSegmentModelList = new ArrayList<NFSSegmentModel>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel = new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setHeader((HeaderImpl)segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModelList.add(nfsSegmentModel);
            }
            PushCommitRequest pushCommitRequest = new PushCommitRequest();
            pushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);
            pushCommitRequest.setTaskId(taskId);
            pushCommitRequest.setApp(clientNode.app());
            pushCommitRequest.setNode(clientNode.node());
            pushCommitRequest.setWorkApp(worker.getApp());
            pushCommitRequest.setWorkNode(worker.getNode());
            PushCommitResponse pushCommitResponse = this.jobClient2WorkTransport.commit(pushCommitRequest);
            if (pushCommitResponse == null || !pushCommitResponse.isSuccess()) {
                log.error("cannot commit data to worker:" + JSONAccessor.impl().format((Object)pushCommitResponse));
                throw new IllegalStateException("cannot commit data to worker:");
            }
        }
    }
}

