/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.JobClient2ControlTransport;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.JobLogImpl;
import com.ovopark.iohub.sdk.client.JobTaskExecutor;
import com.ovopark.iohub.sdk.model.TaskLockRequest;
import com.ovopark.iohub.sdk.model.TaskLockResponse;
import com.ovopark.iohub.sdk.model.TaskModel;
import com.ovopark.iohub.sdk.model.TaskSubmitRequest;
import com.ovopark.iohub.sdk.model.TaskSubmitResponse;
import com.ovopark.kernel.shared.CachedExecutors;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.module.shared.BaseResult;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@JobClientActive
@RestController(value="com.ovopark.messagehub.sdk.job.JobEndpoint")
@RequestMapping(value={"/feign/iohub-job/processing"})
public class JobEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JobEndpoint.class);
    @Autowired
    private JobClient2ControlTransport jobClient2ControlTransport;
    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 64), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_IO", "0"))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 1024), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_IO", "0"))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"messagehub-job-io"), new ThreadPoolExecutor.AbortPolicy());
    private static final CacheService<String, TaskSubmitRequest> C = new CacheService.MapCacheService(true, CachedExecutors.impl((String)"messagehub-job-io-c", (int)1, (int)1));
    @Autowired
    private JobTaskExecutor jobTaskExecutor;
    private final Set<Long> executingJobTaskIdSet = ConcurrentHashMap.newKeySet();
    final Map<String, SubmitTask> submitTaskMap = new ConcurrentHashMap<String, SubmitTask>();
    private static JobTaskManager instance;
    private final SimpleJobTaskManager simpleJobTaskManager = new SimpleJobTaskManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/submit"})
    @ResponseBody
    public BaseResult<TaskSubmitResponse> submit(final @RequestBody TaskSubmitRequest taskSubmitRequest) {
        final String taskKey = "task_" + taskSubmitRequest.getTaskId();
        MDC.put((String)"traceId", (String)taskKey);
        MDC.put((String)"requestId", (String)taskKey);
        log.info("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
        final TaskSubmitResponse taskSubmitResponse = new TaskSubmitResponse();
        taskSubmitResponse.setSubmitted(false);
        try {
            Util.lock((Comparable)((Object)taskKey), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    C.putIfAbsentAndGet((Comparable)((Object)taskKey), (Supplier)new Supplier<TaskSubmitRequest>(){

                        @Override
                        public TaskSubmitRequest get() {
                            if (JobEndpoint.this.executingJobTaskIdSet.contains(taskSubmitRequest.getTaskId())) {
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("Rejected,the previous task is executing");
                                throw new IllegalStateException("the previous task is executing, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                            }
                            TaskLockRequest taskLockRequest = new TaskLockRequest();
                            taskLockRequest.setTaskId(taskSubmitRequest.getTaskId());
                            taskLockRequest.setNode(ClientNode.UUID_STR);
                            TaskLockResponse taskLockResponse = JobEndpoint.this.jobClient2ControlTransport.lockClient(taskLockRequest);
                            if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                                throw new IllegalStateException("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest));
                            }
                            JobEndpoint.this.executingJobTaskIdSet.add(taskSubmitRequest.getTaskId());
                            try {
                                Future<?> future = jobExecutor.submit(Util.catchRunnable(() -> {
                                    final JobLogImpl jobLog = new JobLogImpl(JobEndpoint.this.jobClient2ControlTransport, 300, taskKey);
                                    try {
                                        JobEndpoint.this.jobTaskExecutor.execute(taskSubmitRequest.getTaskId(), taskSubmitRequest.getUri(), taskSubmitRequest.getArgs(), taskSubmitRequest.getSession(), taskSubmitRequest.isRetry(), taskSubmitRequest.getExportTaskId(), taskSubmitRequest.getJobMeta(), taskSubmitRequest.getWorker(), jobLog, new JobTaskManager(){

                                            @Override
                                            public void cancel(long taskId) {
                                                SubmitTask submitTask = JobEndpoint.this.submitTaskMap.get("task_" + taskId);
                                                submitTask.future.cancel(true);
                                                log.info("cancel the task");
                                                jobLog.log("cancel the task");
                                            }
                                        });
                                    }
                                    finally {
                                        try {
                                            JobEndpoint.this.submitTaskMap.remove(taskKey);
                                        }
                                        catch (Exception e) {
                                            log.error(e.getMessage(), (Throwable)e);
                                        }
                                        JobEndpoint.this.executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                        try {
                                            jobLog.log(taskKey + " > completed: " + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                                            jobLog.flush();
                                        }
                                        catch (Exception e) {
                                            log.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }));
                                SubmitTask submitTask = new SubmitTask();
                                submitTask.setTaskId(taskSubmitRequest.getTaskId());
                                submitTask.setFuture(future);
                                submitTask.setTaskModel(new TaskModel());
                                submitTask.getTaskModel().setJobTaskId(taskSubmitRequest.getTaskId());
                                submitTask.getTaskModel().setExportTaskId(taskSubmitRequest.getExportTaskId());
                                submitTask.getTaskModel().setWorkNode(taskSubmitRequest.getWorker().getNode());
                                submitTask.getTaskModel().setClientNode(ClientNode.UUID_STR);
                                submitTask.getTaskModel().setAcceptTime(System.currentTimeMillis());
                                submitTask.getTaskModel().setAcceptTimeStr(Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                                JobEndpoint.this.submitTaskMap.put(taskKey, submitTask);
                                log.info("OK, the task is scheduled: " + taskKey);
                                taskSubmitResponse.setSubmitted(true);
                            }
                            catch (RejectedExecutionException e) {
                                JobEndpoint.this.executingJobTaskIdSet.remove(taskLockRequest.getTaskId());
                                taskSubmitResponse.setSubmitted(false);
                                taskSubmitResponse.setDesc("Rejected, resource is unavailable ");
                                throw Util.convert2RuntimeException((Throwable)e);
                            }
                            return taskSubmitRequest;
                        }
                    }, 60L, TimeUnit.SECONDS);
                    return null;
                }
            }, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"traceId");
            MDC.remove((String)"requestId");
        }
        return BaseResult.success((Object)taskSubmitResponse);
    }

    @PostConstruct
    private void post() {
        instance = this.simpleJobTaskManager;
    }

    public static interface JobTaskManager {
        public void cancel(long var1);

        default public List<TaskModel> taskList() {
            throw new UnsupportedOperationException();
        }

        public static JobTaskManager getOrCreate() {
            return instance;
        }
    }

    private class SimpleJobTaskManager
    implements JobTaskManager {
        private SimpleJobTaskManager() {
        }

        @Override
        public void cancel(long taskId) {
            SubmitTask submitTask = JobEndpoint.this.submitTaskMap.get("task_" + taskId);
            if (submitTask == null) {
                return;
            }
            if (submitTask.future == null) {
                return;
            }
            submitTask.future.cancel(true);
            log.info("cancel the task");
        }

        @Override
        public List<TaskModel> taskList() {
            ArrayList<TaskModel> taskModelList = new ArrayList<TaskModel>(JobEndpoint.this.submitTaskMap.size());
            for (SubmitTask submitTask : JobEndpoint.this.submitTaskMap.values()) {
                taskModelList.add(submitTask.getTaskModel());
            }
            return taskModelList;
        }
    }

    public static class SubmitTask {
        private long taskId;
        private Future<?> future;
        private TaskModel taskModel;

        public long getTaskId() {
            return this.taskId;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public TaskModel getTaskModel() {
            return this.taskModel;
        }

        public void setTaskId(long taskId) {
            this.taskId = taskId;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void setTaskModel(TaskModel taskModel) {
            this.taskModel = taskModel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubmitTask)) {
                return false;
            }
            SubmitTask other = (SubmitTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTaskId() != other.getTaskId()) {
                return false;
            }
            Future<?> this$future = this.getFuture();
            Future<?> other$future = other.getFuture();
            if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
                return false;
            }
            TaskModel this$taskModel = this.getTaskModel();
            TaskModel other$taskModel = other.getTaskModel();
            return !(this$taskModel == null ? other$taskModel != null : !this$taskModel.equals(other$taskModel));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubmitTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $taskId = this.getTaskId();
            result = result * 59 + (int)($taskId >>> 32 ^ $taskId);
            Future<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            TaskModel $taskModel = this.getTaskModel();
            result = result * 59 + ($taskModel == null ? 43 : $taskModel.hashCode());
            return result;
        }

        public String toString() {
            return "JobEndpoint.SubmitTask(taskId=" + this.getTaskId() + ", future=" + this.getFuture() + ", taskModel=" + this.getTaskModel() + ")";
        }
    }
}

