/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.SegmentImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryOutStore
implements OutStore {
    private final List<Segment> segmentList;
    private boolean committed;

    public InMemoryOutStore(int size) {
        this.segmentList = new ArrayList<Segment>(size);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name) {
        return this.createSegment(name, 10);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize) {
        return this.createSegment(name, rowSize, "default");
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, String group) {
        return this.createSegment(name, 10, group);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize, String group) {
        this.check();
        return new SegmentWriterImpl(name, rowSize);
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void close() {
        for (Segment segment : this.segmentList) {
            segment.commit();
        }
    }

    @Override
    public Segment segment(Segment.SD sd) {
        for (Segment segment : this.segmentList) {
            if (!segment.name().equals(sd.getName())) continue;
            return segment;
        }
        return null;
    }

    @Override
    public List<Segment.SD> sdList() {
        ArrayList<Segment.SD> sdList = new ArrayList<Segment.SD>(this.segmentList.size());
        for (Segment segment : this.segmentList) {
            Segment.SD sd = new Segment.SD();
            sd.setMemory(true);
            sd.setName(segment.name());
            sdList.add(sd);
        }
        return sdList;
    }

    private void check() {
        if (this.committed) {
            throw new UnsupportedOperationException("all committed???");
        }
    }

    private class SegmentWriterImpl
    implements OutStore.SegmentWriter {
        private final SegmentImpl segment;
        private boolean committed;
        private final int maxRowCount = 10000;

        public SegmentWriterImpl(String name, int size) {
            this.segment = new SegmentImpl(name, size);
        }

        @Override
        public void append(Map<String, Object> data) {
            this.check();
            this.segment.append(data);
            if (this.segment.size() > 10000) {
                throw new IllegalStateException("too many row: " + this.segment.size() + ", max: " + 10000);
            }
        }

        @Override
        public void append(List<Map<String, Object>> data) {
            this.check();
            for (Map<String, Object> datum : data) {
                this.segment.append(datum);
            }
            if (this.segment.size() > 10000) {
                throw new IllegalStateException("too many row: " + this.segment.size() + ", max: " + 10000);
            }
        }

        @Override
        public void meta(Map<String, Object> meta) {
            this.segment.setMeta(meta);
        }

        @Override
        public void append(Model model) {
            this.append(JSONAccessor.impl().read(JSONAccessor.impl().format((Object)model)));
        }

        @Override
        public void commit() {
            this.committed = true;
            InMemoryOutStore.this.segmentList.add(this.segment);
            this.segment.header().commit();
            this.segment.commit();
        }

        private void check() {
            if (this.committed) {
                throw new UnsupportedOperationException("segment committed???");
            }
        }

        @Override
        public Segment.Header header() {
            return this.segment.header();
        }
    }
}

