/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.JobClient2WorkTransport;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterResponse;
import com.ovopark.iohub.sdk.model.CreateExportRecordRequest;
import com.ovopark.iohub.sdk.model.CreateExportRecordResponse;
import com.ovopark.iohub.sdk.model.PushCommitRequest;
import com.ovopark.iohub.sdk.model.PushCommitResponse;
import com.ovopark.iohub.sdk.model.PushDataRequest;
import com.ovopark.iohub.sdk.model.PushDataResponse;
import com.ovopark.iohub.sdk.model.PushStartRequest;
import com.ovopark.iohub.sdk.model.PushStartResponse;
import com.ovopark.iohub.sdk.model.TaskLogRequest;
import com.ovopark.iohub.sdk.model.TaskLogResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class JobClient2WorkRestClient
implements JobClient2WorkTransport {
    private static final Logger log = LoggerFactory.getLogger(JobClient2WorkRestClient.class);
    private final RestTemplate restTemplate;
    private final AppNode appNode;

    public JobClient2WorkRestClient(AppNode appNode, RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.appNode = appNode;
    }

    @Override
    public ClientNodeTaskRegisterResponse heartbeat(ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest) {
        return this.rpc(clientNodeTaskRegisterRequest, "/jobClient/task/heartbeat", ClientNodeTaskRegisterResponse.class);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return this.rpc(taskLogRequest, "/jobClient/task/log", TaskLogResponse.class);
    }

    @Override
    public PushStartResponse start(PushStartRequest pushStartRequest) {
        return this.rpc(pushStartRequest, "/jobClient/task/start", PushStartResponse.class);
    }

    @Override
    public CreateExportRecordResponse createExportRecord(CreateExportRecordRequest createExportRecordRequest) {
        return this.rpc(createExportRecordRequest, "/jobClient/task/createExportRecord", CreateExportRecordResponse.class);
    }

    @Override
    public PushDataResponse push(PushDataRequest pushDataRequest) {
        return this.rpc(pushDataRequest, "/jobClient/task/push", PushDataResponse.class);
    }

    @Override
    public PushCommitResponse commit(PushCommitRequest pushCommitRequest) {
        return this.rpc(pushCommitRequest, "/jobClient/task/commit", PushCommitResponse.class);
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.getIp() + ":" + this.appNode.getPort();
        url = url + (Util.isEmpty((CharSequence)this.appNode.getServletPath()) ? "" : (this.appNode.getServletPath().startsWith("/") ? this.appNode.getServletPath() : "/" + this.appNode.getServletPath()));
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            if (statusCode.value() == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

