/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.Client2WorkTransport;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeTaskRegisterResponse;
import com.ovopark.iohub.sdk.model.CreateExportRecordRequest;
import com.ovopark.iohub.sdk.model.CreateExportRecordResponse;
import com.ovopark.iohub.sdk.model.TaskLogRequest;
import com.ovopark.iohub.sdk.model.TaskLogResponse;
import com.ovopark.iohub.sdk.model.instream.ImportCommitRequest;
import com.ovopark.iohub.sdk.model.instream.ImportCommitResponse;
import com.ovopark.iohub.sdk.model.instream.ImportPushDataRequest;
import com.ovopark.iohub.sdk.model.instream.ImportReplyRequest;
import com.ovopark.iohub.sdk.model.instream.ImportReplyResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushStartResponse;
import com.ovopark.iohub.sdk.model.test.ReplyRenderResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class Client2WorkRestClient
implements Client2WorkTransport {
    private static final Logger log = LoggerFactory.getLogger(Client2WorkRestClient.class);
    private final RestTemplate restTemplate;
    private final AppNode appNode;

    public Client2WorkRestClient(AppNode appNode, RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.appNode = appNode;
    }

    @Override
    public ClientNodeTaskRegisterResponse exportHeartbeat(ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest) {
        return this.rpc(clientNodeTaskRegisterRequest, "/jobClient/task/export/heartbeat", ClientNodeTaskRegisterResponse.class);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return this.rpc(taskLogRequest, "/jobClient/task/log", TaskLogResponse.class);
    }

    @Override
    public ExportPushStartResponse start(ExportPushStartRequest exportPushStartRequest) {
        return this.rpc(exportPushStartRequest, "/jobClient/task/export/start", ExportPushStartResponse.class);
    }

    @Override
    public CreateExportRecordResponse createExportRecord(CreateExportRecordRequest createExportRecordRequest) {
        return this.rpc(createExportRecordRequest, "/jobClient/task/export/createExportRecord", CreateExportRecordResponse.class);
    }

    @Override
    public ExportPushDataResponse push(ExportPushDataRequest exportPushDataRequest) {
        return this.rpc(exportPushDataRequest, "/jobClient/task/export/push", ExportPushDataResponse.class);
    }

    @Override
    public ExportPushCommitResponse commit(ExportPushCommitRequest exportPushCommitRequest) {
        return this.rpc(exportPushCommitRequest, "/jobClient/task/export/commit", ExportPushCommitResponse.class);
    }

    @Override
    public ClientNodeTaskRegisterResponse importHeartbeat(ClientNodeTaskRegisterRequest clientNodeTaskRegisterRequest) {
        return this.rpc(clientNodeTaskRegisterRequest, "/jobClient/task/import/heartbeat", ClientNodeTaskRegisterResponse.class);
    }

    @Override
    public ImportReplyResponse importReply(ImportReplyRequest importReplyRequest) {
        return this.rpc(importReplyRequest, "/jobClient/task/import/reply", ImportReplyResponse.class);
    }

    @Override
    public ImportCommitResponse importCommit(ImportCommitRequest importCommitRequest) {
        return this.rpc(importCommitRequest, "/jobClient/task/import/commit", ImportCommitResponse.class);
    }

    @Override
    public ImportPushDataRequest parseOnlyForTest(String file, String uri) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uri", uri);
        return this.restWithFile(map, file, "/jobClient/task/import/test/parse", ImportPushDataRequest.class);
    }

    @Override
    public ReplyRenderResponse renderReplyOnlyForTest(ImportReplyRequest importReplyRequest) {
        return this.rpc(importReplyRequest, "/jobClient/task/import/test/renderReply", ReplyRenderResponse.class);
    }

    private <T> T restWithFile(Map<String, Object> params, String file, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.getIp() + ":" + this.appNode.getPort();
        url = url + (Util.isEmpty((CharSequence)this.appNode.getServletPath()) ? "" : (this.appNode.getServletPath().startsWith("/") ? this.appNode.getServletPath() : "/" + this.appNode.getServletPath()));
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "multipart/form-data");
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            multiValueMap.add((Object)entry.getKey(), entry.getValue());
        }
        multiValueMap.add((Object)"file", (Object)new FileSystemResource(file));
        HttpEntity formEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            if (statusCode.value() == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.getIp() + ":" + this.appNode.getPort();
        url = url + (Util.isEmpty((CharSequence)this.appNode.getServletPath()) ? "" : (this.appNode.getServletPath().startsWith("/") ? this.appNode.getServletPath() : "/" + this.appNode.getServletPath()));
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            if (statusCode.value() == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

