/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream.test;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlowProvider;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.client.outstream.test.ExportTaskVo;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.proto.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.InMemoryOutStore;
import com.ovopark.iohub.sdk.model.proto.NFSOutStore;
import com.ovopark.iohub.sdk.model.proto.NFSSegmentModel;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@JobClientActive
@RestController(value="com.ovopark.iohub.sdk.client.outstream.test.ExportLocalTestEndpoint")
@RequestMapping(value={"/feign/iohub-job/processing/only-test/export"})
public class ExportLocalTestEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ExportLocalTestEndpoint.class);
    @Autowired
    private Client2ControlTransport client2ControlTransport;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    @Autowired
    private JobOutTaskFlowProvider jobOutTaskFlowProvider;
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @RequestMapping(value={"/submit"})
    public BaseResult<Boolean> submit(@RequestBody ExportTaskVo exportTaskVo, @RequestHeader(value="nfs") boolean nfs) {
        String uri = exportTaskVo.getUri();
        log.info("uri: " + JSONAccessor.impl().format((Object)uri));
        JobOutTaskFlow<RequestParamBody> jobOutTaskFlow = this.jobOutTaskFlowProvider.find(uri);
        jobOutTaskFlow.prepared();
        Session si = Session.getOrCreate().get();
        RequestParamBody requestParamBody = Util.isEmpty(exportTaskVo.getParamMap()) ? null : jobOutTaskFlow.requestParamBody(JSONAccessor.impl().format(exportTaskVo.getParamMap()), si);
        JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider = jobOutTaskFlow.exportTaskInfoProvider(requestParamBody, si);
        log.info(" export record , name: " + (exportTaskInfoProvider == null ? null : exportTaskInfoProvider.name()));
        try (Object outStore = nfs ? new NFSOutStore("d:/iohub/client/client-" + ClientNode.UUID_STR, 1) : new InMemoryOutStore(Math.min(1, 10));){
            jobOutTaskFlow.execute(requestParamBody, (OutStore)outStore);
            outStore.commit();
        }
        log.info("execute completed , then we collect all data???");
        List sdList = outStore.sdList();
        if (outStore instanceof NFSOutStore) {
            ArrayList<NFSSegmentModel> nfsSegmentModelList = new ArrayList<NFSSegmentModel>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel = new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setHeader((HeaderImpl)segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModelList.add(nfsSegmentModel);
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((NFSOutStore)outStore).getFileName());
            exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);
            exportPushCommitRequest.setTaskId(0L);
            exportPushCommitRequest.setApp(null);
            exportPushCommitRequest.setNode(null);
            exportPushCommitRequest.setWorkApp(null);
            exportPushCommitRequest.setWorkNode(null);
            log.info(JSONAccessor.impl().format((Object)exportPushCommitRequest));
            String localFile = this.write2LocalFile(((NFSOutStore)outStore).getPath(), JSONAccessor.impl().format((Object)exportPushCommitRequest));
            log.info("local file: " + localFile);
        }
        log.info("end...");
        return BaseResult.success((Object)true);
    }

    private String write2LocalFile(String path, String nfsMeta) {
        String filePath = path + "/export-" + Util.uniqueFirstPart() + ".nfs";
        log.info("to write data to disk: " + filePath);
        try {
            Util.writeAtomic((File)new File(filePath), (byte[])Util.utf8((String)nfsMeta));
        }
        catch (IOException e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
        log.info("write data to disk (" + filePath + "), cost time ");
        return filePath;
    }
}

