/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.Work2ControlTransport;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@JobClientActive
@Component
public class Work2ControlRestClient
implements Work2ControlTransport {
    private static final Logger log = LoggerFactory.getLogger(Work2ControlRestClient.class);
    private final RestTemplate restTemplate;
    @Autowired
    private ControlNode appNode;

    public Work2ControlRestClient() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return this.rpc(clientNodeRegisterRequest, "/worker/heartbeat", ClientNodeRegisterResponse.class);
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://" + this.appNode.ip() + ":" + this.appNode.port() + "/iohub-control";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (RestClientException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

