/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.ControlTransport;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.ExportEndpoint;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class ClientNodeRegisterImpl
implements ClientNodeRegister,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ClientNodeRegisterImpl.class);
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Autowired
    ControlTransport controlTransport;

    @Override
    public void register() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ClientNode clientNode = this.clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest = new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setVersion(1);
            clientNodeRegisterRequest.setMinVersion(19);
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            clientNodeRegisterRequest.setTaskModelList(ExportEndpoint.JobTaskManager.getOrCreate().taskList());
            ClientNodeRegisterResponse clientNodeRegisterResponse = this.controlTransport.heartbeat(clientNodeRegisterRequest);
            log.debug(JSONAccessor.impl().format((Object)clientNodeRegisterResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.error(e.getMessage());
            return true;
        }, () -> true);
    }

    public void run(String ... args) throws Exception {
        this.register();
    }
}

